/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.potential.biz;

import com.yqbsoft.laser.service.potential.dao.MarginPolicySettingMapper;
import com.yqbsoft.laser.service.potential.domain.margin.MarginPolicySetting;
import com.yqbsoft.laser.service.potential.query.margin.MarginPolicySettingPageQuery;
import com.yqbsoft.laser.service.potential.result.page.PageResult;
import java.time.LocalDate;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MarginPolicySettingBiz {
    private static final Logger log = LoggerFactory.getLogger(MarginPolicySettingBiz.class);
    private final MarginPolicySettingMapper marginPolicySettingMapper;

    public PageResult<MarginPolicySetting> queryListByPage(MarginPolicySettingPageQuery query) {
        int offset = (query.getPage() - 1) * query.getRows();
        List<MarginPolicySetting> list = this.marginPolicySettingMapper.queryListByPage(query, offset, query.getRows());
        Long total = this.marginPolicySettingMapper.countByCondition(query);
        return PageResult.of(list, total);
    }

    public MarginPolicySetting saveMarginPolicySetting(MarginPolicySetting po) {
        this.marginPolicySettingMapper.insert(po);
        return po;
    }

    public MarginPolicySetting updateMarginPolicySetting(MarginPolicySetting po) {
        this.marginPolicySettingMapper.update(po);
        return po;
    }

    public int deleteMarginPolicySettingById(Long id) {
        return this.marginPolicySettingMapper.delete(id);
    }

    public MarginPolicySetting selectMarginPolicySettingById(Long id) {
        return this.marginPolicySettingMapper.selectById(id);
    }

    public int deleteMarginPolicySettingByIds(List<Long> ids) {
        log.info("=========MarginPolicySettingBiz==deleteMarginPolicySettingByIds=={}", ids);
        return this.marginPolicySettingMapper.deleteByIds(ids);
    }

    @Transactional
    public void updatePolicyStatusDaily() {
        String today = LocalDate.now().toString();
        log.info("[MarginPolicy] \u5f00\u59cb\u6267\u884c\u653f\u7b56\u4fdd\u8bc1\u91d1\u72b6\u6001\u81ea\u52a8\u66f4\u65b0\uff0ctoday={}", (Object)today);
        int running = this.marginPolicySettingMapper.updateStatusToRunning(today);
        int finished = this.marginPolicySettingMapper.updateStatusToFinished(today);
        log.info("[MarginPolicy] \u72b6\u6001\u66f4\u65b0\u5b8c\u6210\uff1a\u6539\u4e3a\u8fdb\u884c\u4e2d={}\uff0c\u6539\u4e3a\u5df2\u7ed3\u675f={}", (Object)running, (Object)finished);
    }

    public MarginPolicySettingBiz(MarginPolicySettingMapper marginPolicySettingMapper) {
        this.marginPolicySettingMapper = marginPolicySettingMapper;
    }
}

