/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.potential.parser;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.yqbsoft.laser.service.potential.Exception.ThirdPartyApiException;
import com.yqbsoft.laser.service.potential.parser.Hd82BalanceDTO;
import com.yqbsoft.laser.service.potential.parser.ThirdPartyResponse;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Hd82ApiResponseParser {
    private static final Logger log = LoggerFactory.getLogger(Hd82ApiResponseParser.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    private Hd82ApiResponseParser() {
    }

    public static List<Hd82BalanceDTO> parseBalanceResponse(String responseBody) {
        ThirdPartyResponse response;
        log.info("[Hd82Api] parse start");
        try {
            response = (ThirdPartyResponse)OBJECT_MAPPER.readValue(responseBody, (TypeReference)new TypeReference<ThirdPartyResponse<Hd82BalanceDTO>>(){});
        }
        catch (Exception e) {
            log.error("[Hd82Api] json parse error, body={}", (Object)responseBody, (Object)e);
            throw new ThirdPartyApiException("JSON_PARSE_ERROR", "\u4e09\u65b9\u63a5\u53e3\u8fd4\u56de\u89e3\u6790\u5931\u8d25");
        }
        if (response == null) {
            log.error("[Hd82Api] response is null, body={}", (Object)responseBody);
            throw new ThirdPartyApiException("EMPTY_RESPONSE", "\u4e09\u65b9\u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a");
        }
        if (!Boolean.TRUE.equals(response.getStatus()) || !"0".equals(response.getErrorCode())) {
            log.warn("[Hd82Api] response failed, status={}, errorCode={}, message={}", new Object[]{response.getStatus(), response.getErrorCode(), response.getMessage()});
            throw new ThirdPartyApiException(response.getErrorCode(), response.getMessage() != null ? response.getMessage() : "\u4e09\u65b9\u63a5\u53e3\u8c03\u7528\u5931\u8d25");
        }
        List<Hd82BalanceDTO> data = response.getData();
        if (data == null || data.isEmpty()) {
            log.info("[Hd82Api] response success but data empty");
            return Collections.emptyList();
        }
        long invalidCount = data.stream().filter(d -> d.getHd82CustomerNumber() == null || d.getPeriod() == null).count();
        if (invalidCount > 0L) {
            log.warn("[Hd82Api] response contains invalid records, count={}", (Object)invalidCount);
        }
        log.info("[Hd82Api] parse success, recordCount={}", (Object)data.size());
        return data;
    }
}

