/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.quest.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.quest.dao.QtQuestuserTickMapper;
import com.yqbsoft.laser.service.quest.domain.QtQuestuserTickDomain;
import com.yqbsoft.laser.service.quest.domain.QtQuestuserTickReDomain;
import com.yqbsoft.laser.service.quest.model.QtQuestuserTick;
import com.yqbsoft.laser.service.quest.service.QtQuestuserTickService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class QtQuestuserTickServiceImpl
extends BaseServiceImpl
implements QtQuestuserTickService {
    private static final String SYS_CODE = "qt.QtQuestuserTickServiceImpl";
    private QtQuestuserTickMapper qtQuestuserTickMapper;

    public void setQtQuestuserTickMapper(QtQuestuserTickMapper qtQuestuserTickMapper) {
        this.qtQuestuserTickMapper = qtQuestuserTickMapper;
    }

    private Date getSysDate() {
        try {
            return this.qtQuestuserTickMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("qt.QtQuestuserTickServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkQuestuserTick(QtQuestuserTickDomain qtQuestuserTickDomain) {
        if (null == qtQuestuserTickDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)qtQuestuserTickDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setQuestuserTickDefault(QtQuestuserTick qtQuestuserTick) {
        if (null == qtQuestuserTick) {
            return;
        }
        if (null == qtQuestuserTick.getDataState()) {
            qtQuestuserTick.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == qtQuestuserTick.getGmtCreate()) {
            qtQuestuserTick.setGmtCreate(date);
        }
        qtQuestuserTick.setGmtModified(date);
        if (StringUtils.isBlank((String)qtQuestuserTick.getQuestuserTickCode())) {
            qtQuestuserTick.setQuestuserTickCode(this.getNo(null, "QtQuestuserTick", "qtQuestuserTick", qtQuestuserTick.getTenantCode()));
        }
    }

    private int getQuestuserTickMaxCode() {
        int code = 0;
        try {
            return this.qtQuestuserTickMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("qt.QtQuestuserTickServiceImpl.getQuestuserTickMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setQuestuserTickUpdataDefault(QtQuestuserTick qtQuestuserTick) {
        if (null == qtQuestuserTick) {
            return;
        }
        qtQuestuserTick.setGmtModified(this.getSysDate());
    }

    private void saveQuestuserTickModel(QtQuestuserTick qtQuestuserTick) throws ApiException {
        if (null == qtQuestuserTick) {
            return;
        }
        try {
            this.qtQuestuserTickMapper.insert(qtQuestuserTick);
        }
        catch (Exception e) {
            throw new ApiException("qt.QtQuestuserTickServiceImpl.saveQuestuserTickModel.ex", (Throwable)e);
        }
    }

    private void saveQuestuserTickBatchModel(List<QtQuestuserTick> qtQuestuserTickList) throws ApiException {
        if (null == qtQuestuserTickList || qtQuestuserTickList.isEmpty()) {
            return;
        }
        try {
            this.qtQuestuserTickMapper.insertBatch(qtQuestuserTickList);
        }
        catch (Exception e) {
            throw new ApiException("qt.QtQuestuserTickServiceImpl.saveQuestuserTickBatchModel.ex", (Throwable)e);
        }
    }

    private QtQuestuserTick getQuestuserTickModelById(Integer questuserTickId) {
        if (null == questuserTickId) {
            return null;
        }
        try {
            return this.qtQuestuserTickMapper.selectByPrimaryKey(questuserTickId);
        }
        catch (Exception e) {
            this.logger.error("qt.QtQuestuserTickServiceImpl.getQuestuserTickModelById", (Throwable)e);
            return null;
        }
    }

    private QtQuestuserTick getQuestuserTickModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.qtQuestuserTickMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("qt.QtQuestuserTickServiceImpl.getQuestuserTickModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delQuestuserTickModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.qtQuestuserTickMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("qt.QtQuestuserTickServiceImpl.delQuestuserTickModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("qt.QtQuestuserTickServiceImpl.delQuestuserTickModelByCode.num");
        }
    }

    private void deleteQuestuserTickModel(Integer questuserTickId) throws ApiException {
        if (null == questuserTickId) {
            return;
        }
        int i = 0;
        try {
            i = this.qtQuestuserTickMapper.deleteByPrimaryKey(questuserTickId);
        }
        catch (Exception e) {
            throw new ApiException("qt.QtQuestuserTickServiceImpl.deleteQuestuserTickModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("qt.QtQuestuserTickServiceImpl.deleteQuestuserTickModel.num");
        }
    }

    private void updateQuestuserTickModel(QtQuestuserTick qtQuestuserTick) throws ApiException {
        if (null == qtQuestuserTick) {
            return;
        }
        int i = 0;
        try {
            i = this.qtQuestuserTickMapper.updateByPrimaryKey(qtQuestuserTick);
        }
        catch (Exception e) {
            throw new ApiException("qt.QtQuestuserTickServiceImpl.updateQuestuserTickModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("qt.QtQuestuserTickServiceImpl.updateQuestuserTickModel.num");
        }
    }

    private void updateStateQuestuserTickModel(Integer questuserTickId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == questuserTickId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("questuserTickId", questuserTickId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.qtQuestuserTickMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("qt.QtQuestuserTickServiceImpl.updateStateQuestuserTickModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("qt.QtQuestuserTickServiceImpl.updateStateQuestuserTickModel.null");
        }
    }

    private void updateStateQuestuserTickModelByCode(String tenantCode, String questuserTickCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)questuserTickCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("questuserTickCode", questuserTickCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.qtQuestuserTickMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("qt.QtQuestuserTickServiceImpl.updateStateQuestuserTickModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("qt.QtQuestuserTickServiceImpl.updateStateQuestuserTickModelByCode.null");
        }
    }

    private QtQuestuserTick makeQuestuserTick(QtQuestuserTickDomain qtQuestuserTickDomain, QtQuestuserTick qtQuestuserTick) {
        if (null == qtQuestuserTickDomain) {
            return null;
        }
        if (null == qtQuestuserTick) {
            qtQuestuserTick = new QtQuestuserTick();
        }
        try {
            BeanUtils.copyAllPropertys((Object)qtQuestuserTick, (Object)qtQuestuserTickDomain);
            return qtQuestuserTick;
        }
        catch (Exception e) {
            this.logger.error("qt.QtQuestuserTickServiceImpl.makeQuestuserTick", (Throwable)e);
            return null;
        }
    }

    private QtQuestuserTickReDomain makeQtQuestuserTickReDomain(QtQuestuserTick qtQuestuserTick) {
        if (null == qtQuestuserTick) {
            return null;
        }
        QtQuestuserTickReDomain qtQuestuserTickReDomain = new QtQuestuserTickReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)qtQuestuserTickReDomain, (Object)qtQuestuserTick);
            return qtQuestuserTickReDomain;
        }
        catch (Exception e) {
            this.logger.error("qt.QtQuestuserTickServiceImpl.makeQtQuestuserTickReDomain", (Throwable)e);
            return null;
        }
    }

    private List<QtQuestuserTick> queryQuestuserTickModelPage(Map<String, Object> parammap) {
        try {
            return this.qtQuestuserTickMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("qt.QtQuestuserTickServiceImpl.queryQuestuserTickModel", (Throwable)e);
            return null;
        }
    }

    private int countQuestuserTick(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.qtQuestuserTickMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("qt.QtQuestuserTickServiceImpl.countQuestuserTick", (Throwable)e);
        }
        return i;
    }

    private QtQuestuserTick createQtQuestuserTick(QtQuestuserTickDomain qtQuestuserTickDomain) {
        String msg = this.checkQuestuserTick(qtQuestuserTickDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("qt.QtQuestuserTickServiceImpl.saveQuestuserTick.checkQuestuserTick", msg);
        }
        QtQuestuserTick qtQuestuserTick = this.makeQuestuserTick(qtQuestuserTickDomain, null);
        this.setQuestuserTickDefault(qtQuestuserTick);
        return qtQuestuserTick;
    }

    @Override
    public String saveQuestuserTick(QtQuestuserTickDomain qtQuestuserTickDomain) throws ApiException {
        QtQuestuserTick qtQuestuserTick = this.createQtQuestuserTick(qtQuestuserTickDomain);
        this.saveQuestuserTickModel(qtQuestuserTick);
        return qtQuestuserTick.getQuestuserTickCode();
    }

    @Override
    public String saveQuestuserTickBatch(List<QtQuestuserTickDomain> qtQuestuserTickDomainList) throws ApiException {
        if (null == qtQuestuserTickDomainList || qtQuestuserTickDomainList.isEmpty()) {
            return null;
        }
        ArrayList<QtQuestuserTick> qtQuestuserTickList = new ArrayList<QtQuestuserTick>();
        String code = "";
        for (QtQuestuserTickDomain qtQuestuserTickDomain : qtQuestuserTickDomainList) {
            QtQuestuserTick qtQuestuserTick = this.createQtQuestuserTick(qtQuestuserTickDomain);
            code = qtQuestuserTick.getQuestuserTickCode();
            qtQuestuserTickList.add(qtQuestuserTick);
        }
        this.saveQuestuserTickBatchModel(qtQuestuserTickList);
        return code;
    }

    @Override
    public void updateQuestuserTickState(Integer questuserTickId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == questuserTickId) {
            return;
        }
        this.updateStateQuestuserTickModel(questuserTickId, dataState, oldDataState, map);
    }

    @Override
    public void updateQuestuserTickStateByCode(String tenantCode, String questuserTickCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)questuserTickCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateQuestuserTickModelByCode(tenantCode, questuserTickCode, dataState, oldDataState, map);
    }

    @Override
    public void updateQuestuserTick(QtQuestuserTickDomain qtQuestuserTickDomain) throws ApiException {
        String msg = this.checkQuestuserTick(qtQuestuserTickDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("qt.QtQuestuserTickServiceImpl.updateQuestuserTick.checkQuestuserTick", msg);
        }
        QtQuestuserTick oldQtQuestuserTick = this.getQuestuserTickModelById(qtQuestuserTickDomain.getQuestuserTickId());
        if (null == oldQtQuestuserTick) {
            throw new ApiException("qt.QtQuestuserTickServiceImpl.updateQuestuserTick.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        QtQuestuserTick qtQuestuserTick = this.makeQuestuserTick(qtQuestuserTickDomain, oldQtQuestuserTick);
        this.setQuestuserTickUpdataDefault(qtQuestuserTick);
        this.updateQuestuserTickModel(qtQuestuserTick);
    }

    @Override
    public QtQuestuserTick getQuestuserTick(Integer questuserTickId) {
        if (null == questuserTickId) {
            return null;
        }
        return this.getQuestuserTickModelById(questuserTickId);
    }

    @Override
    public void deleteQuestuserTick(Integer questuserTickId) throws ApiException {
        if (null == questuserTickId) {
            return;
        }
        this.deleteQuestuserTickModel(questuserTickId);
    }

    @Override
    public QueryResult<QtQuestuserTick> queryQuestuserTickPage(Map<String, Object> map) {
        List<QtQuestuserTick> qtQuestuserTickList = this.queryQuestuserTickModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countQuestuserTick(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(qtQuestuserTickList);
        return queryResult;
    }

    @Override
    public QtQuestuserTick getQuestuserTickByCode(String tenantCode, String questuserTickCode) throws ApiException {
        if (StringUtils.isBlank((String)questuserTickCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("questuserTickCode", questuserTickCode);
        return this.getQuestuserTickModelByCode(map);
    }

    @Override
    public void deleteQuestuserTickByCode(String tenantCode, String questuserTickCode) throws ApiException {
        if (StringUtils.isBlank((String)questuserTickCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("questuserTickCode", questuserTickCode);
        this.delQuestuserTickModelByCode(map);
    }
}

