/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.reb.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.reb.dao.RebUpointsListMapper;
import com.yqbsoft.laser.service.reb.dao.RebUpointsMapper;
import com.yqbsoft.laser.service.reb.domain.OcContractDomain;
import com.yqbsoft.laser.service.reb.domain.OcContractGoodsDomain;
import com.yqbsoft.laser.service.reb.domain.OcRefundDomain;
import com.yqbsoft.laser.service.reb.domain.OcRefundGoodsDomain;
import com.yqbsoft.laser.service.reb.domain.OcReorderDomain;
import com.yqbsoft.laser.service.reb.domain.RebUpointsClearDomain;
import com.yqbsoft.laser.service.reb.domain.RebUpointsDomain;
import com.yqbsoft.laser.service.reb.domain.RebUpointsListDomain;
import com.yqbsoft.laser.service.reb.domain.RebUpointsListReDomain;
import com.yqbsoft.laser.service.reb.domain.RebUpointsReDomain;
import com.yqbsoft.laser.service.reb.domain.TaTransferaBean;
import com.yqbsoft.laser.service.reb.domain.TaTransferaListBean;
import com.yqbsoft.laser.service.reb.model.PtePtfchannel;
import com.yqbsoft.laser.service.reb.model.RebPoints;
import com.yqbsoft.laser.service.reb.model.RebPointsRule;
import com.yqbsoft.laser.service.reb.model.RebUpoints;
import com.yqbsoft.laser.service.reb.model.RebUpointsList;
import com.yqbsoft.laser.service.reb.service.RebUpointsService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.EmptyUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.time.Instant;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RebUpointsServiceImpl
extends BaseServiceImpl
implements RebUpointsService {
    private static final String SYS_CODE = "reb.RebUpointsServiceImpl";
    private RebUpointsMapper rebUpointsMapper;
    private RebUpointsListMapper rebUpointsListMapper;

    public void setRebUpointsMapper(RebUpointsMapper rebUpointsMapper) {
        this.rebUpointsMapper = rebUpointsMapper;
    }

    public void setRebUpointsListMapper(RebUpointsListMapper rebUpointsListMapper) {
        this.rebUpointsListMapper = rebUpointsListMapper;
    }

    private Date getSysDate() {
        try {
            return this.rebUpointsMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("reb.RebUpointsServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkUpoints(RebUpointsDomain rebUpointsDomain) {
        if (null == rebUpointsDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)rebUpointsDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setUpointsDefault(RebUpoints rebUpoints) {
        if (null == rebUpoints) {
            return;
        }
        if (null == rebUpoints.getDataState()) {
            rebUpoints.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == rebUpoints.getGmtCreate()) {
            rebUpoints.setGmtCreate(date);
        }
        rebUpoints.setGmtModified(date);
        if (StringUtils.isBlank((String)rebUpoints.getUpointsCode())) {
            rebUpoints.setUpointsCode(this.getNo(null, "RebUpoints", "rebUpoints", rebUpoints.getTenantCode()));
        }
    }

    private int getUpointsMaxCode() {
        int code = 0;
        try {
            return this.rebUpointsMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("reb.RebUpointsServiceImpl.getUpointsMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setUpointsUpdataDefault(RebUpoints rebUpoints) {
        if (null == rebUpoints) {
            return;
        }
        rebUpoints.setGmtModified(this.getSysDate());
    }

    private void saveUpointsModel(RebUpoints rebUpoints) throws ApiException {
        if (null == rebUpoints) {
            return;
        }
        try {
            this.rebUpointsMapper.insert(rebUpoints);
        }
        catch (Exception e) {
            throw new ApiException("reb.RebUpointsServiceImpl.saveUpointsModel.ex", (Throwable)e);
        }
    }

    private void saveUpointsBatchModel(List<RebUpoints> rebUpointsList) throws ApiException {
        if (null == rebUpointsList || rebUpointsList.isEmpty()) {
            return;
        }
        try {
            this.rebUpointsMapper.insertBatch(rebUpointsList);
        }
        catch (Exception e) {
            throw new ApiException("reb.RebUpointsServiceImpl.saveUpointsBatchModel.ex", (Throwable)e);
        }
    }

    private RebUpoints getUpointsModelById(Integer upointsId) {
        if (null == upointsId) {
            return null;
        }
        try {
            return this.rebUpointsMapper.selectByPrimaryKey(upointsId);
        }
        catch (Exception e) {
            this.logger.error("reb.RebUpointsServiceImpl.getUpointsModelById", (Throwable)e);
            return null;
        }
    }

    private RebUpoints getUpointsModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.rebUpointsMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("reb.RebUpointsServiceImpl.getUpointsModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delUpointsModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.rebUpointsMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("reb.RebUpointsServiceImpl.delUpointsModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("reb.RebUpointsServiceImpl.delUpointsModelByCode.num");
        }
    }

    private void deleteUpointsModel(Integer upointsId) throws ApiException {
        if (null == upointsId) {
            return;
        }
        int i = 0;
        try {
            i = this.rebUpointsMapper.deleteByPrimaryKey(upointsId);
        }
        catch (Exception e) {
            throw new ApiException("reb.RebUpointsServiceImpl.deleteUpointsModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("reb.RebUpointsServiceImpl.deleteUpointsModel.num");
        }
    }

    private void updateUpointsModel(RebUpoints rebUpoints) throws ApiException {
        if (null == rebUpoints) {
            return;
        }
        int i = 0;
        try {
            i = this.rebUpointsMapper.updateByPrimaryKeySelective(rebUpoints);
        }
        catch (Exception e) {
            throw new ApiException("reb.RebUpointsServiceImpl.updateUpointsModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("reb.RebUpointsServiceImpl.updateUpointsModel.num");
        }
    }

    private void updateStateUpointsModel(Integer upointsId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == upointsId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("upointsId", upointsId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.rebUpointsMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("reb.RebUpointsServiceImpl.updateStateUpointsModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("reb.RebUpointsServiceImpl.updateStateUpointsModel.null");
        }
    }

    private void updateStateUpointsModelByCode(String tenantCode, String upointsCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)upointsCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("upointsCode", upointsCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.rebUpointsMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("reb.RebUpointsServiceImpl.updateStateUpointsModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("reb.RebUpointsServiceImpl.updateStateUpointsModelByCode.null");
        }
    }

    private RebUpoints makeUpoints(RebUpointsDomain rebUpointsDomain, RebUpoints rebUpoints) {
        if (null == rebUpointsDomain) {
            return null;
        }
        if (null == rebUpoints) {
            rebUpoints = new RebUpoints();
        }
        try {
            BeanUtils.copyAllPropertys((Object)rebUpoints, (Object)rebUpointsDomain);
            return rebUpoints;
        }
        catch (Exception e) {
            this.logger.error("reb.RebUpointsServiceImpl.makeUpoints", (Throwable)e);
            return null;
        }
    }

    private RebUpointsReDomain makeRebUpointsReDomain(RebUpoints rebUpoints) {
        if (null == rebUpoints) {
            return null;
        }
        RebUpointsReDomain rebUpointsReDomain = new RebUpointsReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)rebUpointsReDomain, (Object)rebUpoints);
            return rebUpointsReDomain;
        }
        catch (Exception e) {
            this.logger.error("reb.RebUpointsServiceImpl.makeRebUpointsReDomain", (Throwable)e);
            return null;
        }
    }

    private List<RebUpoints> queryUpointsModelPage(Map<String, Object> parammap) {
        try {
            return this.rebUpointsMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("reb.RebUpointsServiceImpl.queryUpointsModel", (Throwable)e);
            return null;
        }
    }

    private int countUpoints(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.rebUpointsMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("reb.RebUpointsServiceImpl.countUpoints", (Throwable)e);
        }
        return i;
    }

    private RebUpoints createRebUpoints(RebUpointsDomain rebUpointsDomain) {
        String msg = this.checkUpoints(rebUpointsDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("reb.RebUpointsServiceImpl.saveUpoints.checkUpoints", msg);
        }
        RebUpoints rebUpoints = this.makeUpoints(rebUpointsDomain, null);
        this.setUpointsDefault(rebUpoints);
        return rebUpoints;
    }

    private String checkUpointsList(RebUpointsListDomain rebUpointsListDomain) {
        if (null == rebUpointsListDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)rebUpointsListDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setUpointsListDefault(RebUpointsList rebUpointsList) {
        if (null == rebUpointsList) {
            return;
        }
        if (null == rebUpointsList.getDataState()) {
            rebUpointsList.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == rebUpointsList.getGmtCreate()) {
            rebUpointsList.setGmtCreate(date);
        }
        rebUpointsList.setGmtModified(date);
        if (StringUtils.isBlank((String)rebUpointsList.getUpointsListCode())) {
            rebUpointsList.setUpointsListCode(this.getNo(null, "RebUpointsList", "rebUpointsList", rebUpointsList.getTenantCode()));
        }
    }

    private int getUpointsListMaxCode() {
        int code = 0;
        try {
            return this.rebUpointsListMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("reb.RebUpointsServiceImpl.getUpointsListMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setUpointsListUpdataDefault(RebUpointsList rebUpointsList) {
        if (null == rebUpointsList) {
            return;
        }
        rebUpointsList.setGmtModified(this.getSysDate());
    }

    private void saveUpointsListModel(RebUpointsList rebUpointsList) throws ApiException {
        if (null == rebUpointsList) {
            return;
        }
        try {
            this.rebUpointsListMapper.insert(rebUpointsList);
        }
        catch (Exception e) {
            throw new ApiException("reb.RebUpointsServiceImpl.saveUpointsListModel.ex", (Throwable)e);
        }
    }

    private void saveUpointsListBatchModel(List<RebUpointsList> rebUpointsListList) throws ApiException {
        if (null == rebUpointsListList || rebUpointsListList.isEmpty()) {
            return;
        }
        try {
            this.rebUpointsListMapper.insertBatch(rebUpointsListList);
        }
        catch (Exception e) {
            throw new ApiException("reb.RebUpointsServiceImpl.saveUpointsListBatchModel.ex", (Throwable)e);
        }
    }

    private RebUpointsList getUpointsListModelById(Integer upointsListId) {
        if (null == upointsListId) {
            return null;
        }
        try {
            return this.rebUpointsListMapper.selectByPrimaryKey(upointsListId);
        }
        catch (Exception e) {
            this.logger.error("reb.RebUpointsServiceImpl.getUpointsListModelById", (Throwable)e);
            return null;
        }
    }

    private RebUpointsList getUpointsListModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.rebUpointsListMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("reb.RebUpointsServiceImpl.getUpointsListModelByCode", (Throwable)e);
            return null;
        }
    }

    private RebUpointsList getNumByDate(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.rebUpointsListMapper.getNumByDate(map);
        }
        catch (Exception e) {
            this.logger.error("reb.RebUpointsServiceImpl.getUpointsListModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delUpointsListModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.rebUpointsListMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("reb.RebUpointsServiceImpl.delUpointsListModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("reb.RebUpointsServiceImpl.delUpointsListModelByCode.num");
        }
    }

    private void deleteUpointsListModel(Integer upointsListId) throws ApiException {
        if (null == upointsListId) {
            return;
        }
        int i = 0;
        try {
            i = this.rebUpointsListMapper.deleteByPrimaryKey(upointsListId);
        }
        catch (Exception e) {
            throw new ApiException("reb.RebUpointsServiceImpl.deleteUpointsListModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("reb.RebUpointsServiceImpl.deleteUpointsListModel.num");
        }
    }

    private void updateUpointsListModel(RebUpointsList rebUpointsList) throws ApiException {
        if (null == rebUpointsList) {
            return;
        }
        int i = 0;
        try {
            i = this.rebUpointsListMapper.updateByPrimaryKey(rebUpointsList);
        }
        catch (Exception e) {
            throw new ApiException("reb.RebUpointsServiceImpl.updateUpointsListModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("reb.RebUpointsServiceImpl.updateUpointsListModel.num");
        }
    }

    private void updateStateUpointsListModel(Integer upointsListId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == upointsListId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("upointsListId", upointsListId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.rebUpointsListMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("reb.RebUpointsServiceImpl.updateStateUpointsListModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("reb.RebUpointsServiceImpl.updateStateUpointsListModel.null");
        }
    }

    private void updateStateUpointsListModelByCode(String tenantCode, String upointsListCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)upointsListCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("upointsListCode", upointsListCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.rebUpointsListMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("reb.RebUpointsServiceImpl.updateStateUpointsListModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("reb.RebUpointsServiceImpl.updateStateUpointsListModelByCode.null");
        }
    }

    private RebUpointsList makeUpointsList(RebUpointsListDomain rebUpointsListDomain, RebUpointsList rebUpointsList) {
        if (null == rebUpointsListDomain) {
            return null;
        }
        if (null == rebUpointsList) {
            rebUpointsList = new RebUpointsList();
        }
        try {
            BeanUtils.copyAllPropertys((Object)rebUpointsList, (Object)rebUpointsListDomain);
            return rebUpointsList;
        }
        catch (Exception e) {
            this.logger.error("reb.RebUpointsServiceImpl.makeUpointsList", (Throwable)e);
            return null;
        }
    }

    private RebUpointsListReDomain makeRebUpointsListReDomain(RebUpointsList rebUpointsList) {
        if (null == rebUpointsList) {
            return null;
        }
        RebUpointsListReDomain rebUpointsListReDomain = new RebUpointsListReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)rebUpointsListReDomain, (Object)rebUpointsList);
            return rebUpointsListReDomain;
        }
        catch (Exception e) {
            this.logger.error("reb.RebUpointsServiceImpl.makeRebUpointsListReDomain", (Throwable)e);
            return null;
        }
    }

    private List<RebUpointsList> queryUpointsListModelPage(Map<String, Object> parammap) {
        try {
            return this.rebUpointsListMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("reb.RebUpointsServiceImpl.queryUpointsListModel", (Throwable)e);
            return null;
        }
    }

    private int countUpointsList(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.rebUpointsListMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("reb.RebUpointsServiceImpl.countUpointsList", (Throwable)e);
        }
        return i;
    }

    private RebUpointsList createRebUpointsList(RebUpointsListDomain rebUpointsListDomain) {
        String msg = this.checkUpointsList(rebUpointsListDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("reb.RebUpointsServiceImpl.saveUpointsList.checkUpointsList", msg);
        }
        RebUpointsList rebUpointsList = this.makeUpointsList(rebUpointsListDomain, null);
        this.setUpointsListDefault(rebUpointsList);
        return rebUpointsList;
    }

    @Override
    public String saveUpoints(RebUpointsDomain rebUpointsDomain) throws ApiException {
        RebUpoints rebUpoints = this.createRebUpoints(rebUpointsDomain);
        this.saveUpointsModel(rebUpoints);
        return rebUpoints.getUpointsCode();
    }

    @Override
    public String saveUpointsBatch(List<RebUpointsDomain> rebUpointsDomainList) throws ApiException {
        if (null == rebUpointsDomainList || rebUpointsDomainList.isEmpty()) {
            return null;
        }
        ArrayList<RebUpoints> rebUpointsList = new ArrayList<RebUpoints>();
        String code = "";
        for (RebUpointsDomain rebUpointsDomain : rebUpointsDomainList) {
            RebUpoints rebUpoints = this.createRebUpoints(rebUpointsDomain);
            code = rebUpoints.getUpointsCode();
            rebUpointsList.add(rebUpoints);
        }
        this.saveUpointsBatchModel(rebUpointsList);
        return code;
    }

    @Override
    public void updateUpointsState(Integer upointsId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == upointsId) {
            return;
        }
        this.updateStateUpointsModel(upointsId, dataState, oldDataState, map);
    }

    @Override
    public void updateUpointsStateByCode(String tenantCode, String upointsCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)upointsCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateUpointsModelByCode(tenantCode, upointsCode, dataState, oldDataState, map);
    }

    @Override
    public void updateUpoints(RebUpointsDomain rebUpointsDomain) throws ApiException {
        String msg = this.checkUpoints(rebUpointsDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("reb.RebUpointsServiceImpl.updateUpoints.checkUpoints", msg);
        }
        RebUpoints oldRebUpoints = this.getUpointsModelById(rebUpointsDomain.getUpointsId());
        if (null == oldRebUpoints) {
            throw new ApiException("reb.RebUpointsServiceImpl.updateUpoints.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        RebUpoints rebUpoints = this.makeUpoints(rebUpointsDomain, oldRebUpoints);
        this.setUpointsUpdataDefault(rebUpoints);
        this.updateUpointsModel(rebUpoints);
    }

    @Override
    public RebUpoints getUpoints(Integer upointsId) {
        if (null == upointsId) {
            return null;
        }
        return this.getUpointsModelById(upointsId);
    }

    @Override
    public void deleteUpoints(Integer upointsId) throws ApiException {
        if (null == upointsId) {
            return;
        }
        this.deleteUpointsModel(upointsId);
    }

    @Override
    public QueryResult<RebUpoints> queryUpointsPage(Map<String, Object> map) {
        List<RebUpoints> rebUpointsList = this.queryUpointsModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countUpoints(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(rebUpointsList);
        return queryResult;
    }

    @Override
    public RebUpoints getUpointsByCode(String tenantCode, String upointsCode) throws ApiException {
        if (StringUtils.isBlank((String)upointsCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("upointsCode", upointsCode);
        return this.getUpointsModelByCode(map);
    }

    @Override
    public void deleteUpointsByCode(String tenantCode, String upointsCode) throws ApiException {
        if (StringUtils.isBlank((String)upointsCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("upointsCode", upointsCode);
        this.delUpointsModelByCode(map);
    }

    @Override
    public String saveUpointsList(RebUpointsListDomain rebUpointsListDomain) throws ApiException {
        RebUpointsList rebUpointsList = this.createRebUpointsList(rebUpointsListDomain);
        this.saveUpointsListModel(rebUpointsList);
        return rebUpointsList.getUpointsListCode();
    }

    private RebUpointsList saveUpointsListModel(RebUpointsListDomain rebUpointsListDomain) throws ApiException {
        RebUpointsList rebUpointsList = this.createRebUpointsList(rebUpointsListDomain);
        this.saveUpointsListModel(rebUpointsList);
        return rebUpointsList;
    }

    @Override
    public String saveUpointsListBatch(List<RebUpointsListDomain> rebUpointsListDomainList) throws ApiException {
        if (null == rebUpointsListDomainList || rebUpointsListDomainList.isEmpty()) {
            return null;
        }
        ArrayList<RebUpointsList> rebUpointsListList = new ArrayList<RebUpointsList>();
        String code = "";
        for (RebUpointsListDomain rebUpointsListDomain : rebUpointsListDomainList) {
            RebUpointsList rebUpointsList = this.createRebUpointsList(rebUpointsListDomain);
            code = rebUpointsList.getUpointsListCode();
            rebUpointsListList.add(rebUpointsList);
        }
        this.saveUpointsListBatchModel(rebUpointsListList);
        return code;
    }

    @Override
    public void updateUpointsListState(Integer upointsListId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == upointsListId) {
            return;
        }
        this.updateStateUpointsListModel(upointsListId, dataState, oldDataState, map);
    }

    @Override
    public void updateUpointsListStateByCode(String tenantCode, String upointsListCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)upointsListCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateUpointsListModelByCode(tenantCode, upointsListCode, dataState, oldDataState, map);
    }

    @Override
    public void updateUpointsList(RebUpointsListDomain rebUpointsListDomain) throws ApiException {
        String msg = this.checkUpointsList(rebUpointsListDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("reb.RebUpointsServiceImpl.updateUpointsList.checkUpointsList", msg);
        }
        RebUpointsList oldRebUpointsList = this.getUpointsListModelById(rebUpointsListDomain.getUpointsListId());
        if (null == oldRebUpointsList) {
            throw new ApiException("reb.RebUpointsServiceImpl.updateUpointsList.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        RebUpointsList rebUpointsList = this.makeUpointsList(rebUpointsListDomain, oldRebUpointsList);
        this.setUpointsListUpdataDefault(rebUpointsList);
        this.updateUpointsListModel(rebUpointsList);
    }

    @Override
    public RebUpointsList getUpointsList(Integer upointsListId) {
        if (null == upointsListId) {
            return null;
        }
        return this.getUpointsListModelById(upointsListId);
    }

    @Override
    public void deleteUpointsList(Integer upointsListId) throws ApiException {
        if (null == upointsListId) {
            return;
        }
        this.deleteUpointsListModel(upointsListId);
    }

    @Override
    public QueryResult<RebUpointsList> queryUpointsListPage(Map<String, Object> map) {
        List<RebUpointsList> rebUpointsListList = this.queryUpointsListModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countUpointsList(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(rebUpointsListList);
        return queryResult;
    }

    @Override
    public RebUpointsList getUpointsListByCode(String tenantCode, String upointsListCode) throws ApiException {
        if (StringUtils.isBlank((String)upointsListCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("upointsListCode", upointsListCode);
        return this.getUpointsListModelByCode(map);
    }

    @Override
    public void deleteUpointsListByCode(String tenantCode, String upointsListCode) throws ApiException {
        if (StringUtils.isBlank((String)upointsListCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("upointsListCode", upointsListCode);
        this.delUpointsListModelByCode(map);
    }

    @Override
    public RebUpointsList saveUpointsByList(RebUpointsListDomain rebUpointsListDomain) throws ApiException {
        String msg = this.checkUpointsList(rebUpointsListDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("reb.RebUpointsServiceImpl.saveUpointsByList.checkUpointsSave", msg);
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("upointsType", rebUpointsListDomain.getUpointsType());
        map.put("memberCode", rebUpointsListDomain.getMemberCode());
        map.put("tenantCode", rebUpointsListDomain.getTenantCode());
        map.put("pointsUserqua", rebUpointsListDomain.getPointsUserqua());
        map.put("memberMcode", rebUpointsListDomain.getMemberMcode());
        List<RebUpoints> rebUpointsList = this.queryUpointsModelPage(map);
        RebUpointsDomain rebUpointsDomain = null;
        RebUpoints rebUpoints = null;
        if (ListUtil.isEmpty(rebUpointsList)) {
            if (!"0".equals(rebUpointsListDomain.getUpointsListDirection()) && !"7".equals(rebUpointsListDomain.getUpointsListDirection())) {
                throw new ApiException("reb.RebUpointsServiceImpl.saveUpointsByList.rebUpoints");
            }
            rebUpointsDomain = this.makeUmUpointsDomain(rebUpointsListDomain);
        } else {
            rebUpoints = rebUpointsList.get(0);
            this.updateStateUpointsModel(rebUpoints.getUpointsId(), rebUpoints.getDataState(), rebUpoints.getDataState(), null);
        }
        RebUpointsListDomain upointsListDomain = this.makeUmUpointsListDomain(rebUpoints, rebUpointsListDomain);
        if (null == upointsListDomain) {
            throw new ApiException("reb.RebUpointsServiceImpl.saveUpointsByList.rebUpointsListDomain");
        }
        if (null != rebUpointsDomain) {
            this.saveUpoints(rebUpointsDomain);
        } else {
            rebUpoints.setUpointsLnum(upointsListDomain.getUpointsAflnum());
            rebUpoints.setUpointsNum(upointsListDomain.getUpointsAfnum());
            rebUpoints.setUpointsOnum(upointsListDomain.getUpointsAfonum());
            this.updateUpointsModel(rebUpoints);
        }
        return this.saveUpointsListModel(upointsListDomain);
    }

    private RebUpointsListDomain makeUmUpointsListDomain(RebUpoints rebUpoints, RebUpointsListDomain rebUpointsSaveDomain) {
        if (null == rebUpointsSaveDomain) {
            return null;
        }
        RebUpointsListDomain rebUpointsListDomain = new RebUpointsListDomain();
        try {
            BeanUtils.copyAllPropertys((Object)rebUpointsListDomain, (Object)rebUpointsSaveDomain);
        }
        catch (Exception e) {
            this.logger.error("reb.RebUpointsServiceImpl.makeUmUpointsListDomain.e", (Throwable)e);
            return null;
        }
        rebUpointsListDomain.setUpointsAflnum(BigDecimal.ZERO);
        rebUpointsListDomain.setUpointsAfnum(BigDecimal.ZERO);
        rebUpointsListDomain.setUpointsAfonum(BigDecimal.ZERO);
        rebUpointsListDomain.setUpointsBflnum(BigDecimal.ZERO);
        rebUpointsListDomain.setUpointsBfnum(BigDecimal.ZERO);
        rebUpointsListDomain.setUpointsBfonum(BigDecimal.ZERO);
        if (null != rebUpoints) {
            rebUpointsListDomain.setUpointsAflnum(rebUpoints.getUpointsLnum());
            rebUpointsListDomain.setUpointsAfnum(rebUpoints.getUpointsNum());
            rebUpointsListDomain.setUpointsAfonum(rebUpoints.getUpointsOnum());
            rebUpointsListDomain.setUpointsBflnum(rebUpoints.getUpointsLnum());
            rebUpointsListDomain.setUpointsBfnum(rebUpoints.getUpointsNum());
            rebUpointsListDomain.setUpointsBfonum(rebUpoints.getUpointsOnum());
        }
        if ("0".equals(rebUpointsListDomain.getUpointsListDirection())) {
            rebUpointsListDomain.setUpointsAfnum(rebUpointsListDomain.getUpointsBfnum().add(rebUpointsListDomain.getUpointsListNum()));
        } else if ("1".equals(rebUpointsListDomain.getUpointsListDirection())) {
            rebUpointsListDomain.setUpointsAfnum(rebUpointsListDomain.getUpointsBfnum().subtract(rebUpointsListDomain.getUpointsListNum()));
        } else if ("2".equals(rebUpointsListDomain.getUpointsListDirection())) {
            rebUpointsListDomain.setUpointsAfnum(rebUpointsListDomain.getUpointsBfnum().subtract(rebUpointsListDomain.getUpointsListNum()));
            rebUpointsListDomain.setUpointsAfonum(rebUpointsListDomain.getUpointsBfonum().add(rebUpointsListDomain.getUpointsListNum()));
        } else if ("3".equals(rebUpointsListDomain.getUpointsListDirection())) {
            rebUpointsListDomain.setUpointsAfnum(rebUpointsListDomain.getUpointsBfnum().subtract(rebUpointsListDomain.getUpointsListNum()));
            rebUpointsListDomain.setUpointsAflnum(rebUpointsListDomain.getUpointsBflnum().add(rebUpointsListDomain.getUpointsListNum()));
        } else if ("4".equals(rebUpointsListDomain.getUpointsListDirection())) {
            rebUpointsListDomain.setUpointsAfnum(rebUpointsListDomain.getUpointsBfnum().add(rebUpointsListDomain.getUpointsListNum()));
            rebUpointsListDomain.setUpointsAflnum(rebUpointsListDomain.getUpointsBflnum().subtract(rebUpointsListDomain.getUpointsListNum()));
        } else if ("5".equals(rebUpointsListDomain.getUpointsListDirection())) {
            rebUpointsListDomain.setUpointsAfonum(rebUpointsListDomain.getUpointsBfonum().add(rebUpointsListDomain.getUpointsListNum()));
            rebUpointsListDomain.setUpointsAflnum(rebUpointsListDomain.getUpointsBflnum().subtract(rebUpointsListDomain.getUpointsListNum()));
        } else if ("6".equals(rebUpointsListDomain.getUpointsListDirection())) {
            rebUpointsListDomain.setUpointsAfonum(rebUpointsListDomain.getUpointsBfonum().subtract(rebUpointsListDomain.getUpointsListNum()));
            rebUpointsListDomain.setUpointsAfnum(rebUpointsListDomain.getUpointsBfnum().add(rebUpointsListDomain.getUpointsListNum()));
        } else if ("7".equals(rebUpointsListDomain.getUpointsListDirection())) {
            rebUpointsListDomain.setUpointsAfnum(rebUpointsListDomain.getUpointsBfnum().add(rebUpointsListDomain.getUpointsListNum()));
        }
        if (rebUpointsListDomain.getUpointsAfnum().compareTo(BigDecimal.ZERO) == -1 || rebUpointsListDomain.getUpointsAflnum().compareTo(BigDecimal.ZERO) == -1 || rebUpointsListDomain.getUpointsAfonum().compareTo(BigDecimal.ZERO) == -1) {
            this.logger.error("reb.RebUpointsServiceImpl.makeUmUpointsListDomain.rebUpointsListDomain", (Object)JsonUtil.buildNormalBinder().toJson((Object)rebUpointsListDomain));
            throw new ApiException("reb.RebUpointsServiceImpl.makeUmUpointsListDomain.num");
        }
        return rebUpointsListDomain;
    }

    private RebUpointsDomain makeUmUpointsDomain(RebUpointsListDomain rebUpointsListDomain) {
        if (null == rebUpointsListDomain) {
            return null;
        }
        RebUpointsDomain rebUpointsDomain = new RebUpointsDomain();
        rebUpointsDomain.setUpointsLnum(BigDecimal.ZERO);
        rebUpointsDomain.setUpointsNum(rebUpointsListDomain.getUpointsListNum());
        rebUpointsDomain.setUpointsOnum(BigDecimal.ZERO);
        rebUpointsDomain.setMemberCode(rebUpointsListDomain.getMemberCode());
        rebUpointsDomain.setMemberName(rebUpointsListDomain.getMemberName());
        rebUpointsDomain.setTenantCode(rebUpointsListDomain.getTenantCode());
        rebUpointsDomain.setUpointsType(rebUpointsListDomain.getUpointsType());
        rebUpointsDomain.setMemberMcode(rebUpointsListDomain.getMemberMcode());
        return rebUpointsDomain;
    }

    @Override
    public String saveIntegralGrant(RebUpointsList rebUpointsList) {
        this.logger.error("reb.RebUpointsServiceImpl.saveIntegralGrant", (Object)JsonUtil.buildNormalBinder().toJson((Object)rebUpointsList));
        if (null == rebUpointsList) {
            this.logger.error("reb.RebUpointsServiceImpl.integralGrant", (Object)"rebUpointsList is null");
            return "error";
        }
        if (!(0 == rebUpointsList.getDataState() || "1".equals(rebUpointsList.getUpointsType()) || "7".equals(rebUpointsList.getUpointsListDirection()) || "0".equals(rebUpointsList.getUpointsListDirection()))) {
            return "success";
        }
        String key = rebUpointsList.getUpointsType() + "-" + rebUpointsList.getPointsRuleApi() + "-" + rebUpointsList.getTenantCode();
        RebPointsRule rebPointsRule = (RebPointsRule)DisUtil.getMapJson((String)"REBPointsRule-api", (String)key, RebPointsRule.class);
        if (null == rebPointsRule) {
            key = rebUpointsList.getUpointsType() + "-" + rebUpointsList.getPointsRuleApi() + "-" + "00000000";
            rebPointsRule = (RebPointsRule)DisUtil.getMapJson((String)"REBPointsRule-api", (String)key, RebPointsRule.class);
        }
        if (null == rebPointsRule) {
            this.logger.error("reb.RebUpointsServiceImpl.integralGrant.rebPointsRule", (Object)key);
            return null;
        }
        this.saveTo(rebUpointsList, rebPointsRule);
        return "success";
    }

    private void saveTo(RebUpointsList rebUpointsList, RebPointsRule rebPointsRule) {
        if (null == rebUpointsList || null == rebPointsRule) {
            return;
        }
        this.updateStateUpointsListModelByCode(rebUpointsList.getTenantCode(), rebUpointsList.getUpointsListCode(), 1, 0, null);
        TaTransferaBean taTransferaBean = new TaTransferaBean();
        taTransferaBean.setFundType(StringUtils.isBlank((String)rebPointsRule.getFundOuttype()) ? "01" : rebPointsRule.getFundOuttype());
        taTransferaBean.setTenantCode(rebUpointsList.getTenantCode());
        taTransferaBean.setTransferaMoney(rebUpointsList.getUpointsListNum());
        taTransferaBean.setTransferaName("\u53d1\u653e");
        taTransferaBean.setTransferaRemark((null == rebUpointsList.getUpointsListExname() ? "" : rebUpointsList.getUpointsListExname()) + (StringUtils.isBlank((String)rebUpointsList.getUpointsListOpmark()) ? " \u53d1\u653e" : rebUpointsList.getUpointsListOpmark()));
        taTransferaBean.setTransferaType("10");
        taTransferaBean.setTransferaOpcode(rebUpointsList.getUpointsListOpcode());
        taTransferaBean.setUserinfoCode(rebUpointsList.getUpointsListExcode());
        ArrayList<TaTransferaListBean> taTransferaListBeanList = new ArrayList<TaTransferaListBean>();
        taTransferaBean.setTaTransferaListBeanList(taTransferaListBeanList);
        TaTransferaListBean taTransferaListBean = new TaTransferaListBean();
        taTransferaListBean.setTransferaListUcode(rebUpointsList.getMemberCode());
        taTransferaListBean.setTransferaListMoney(rebUpointsList.getUpointsListNum());
        taTransferaListBean.setTransferaListRemark(rebUpointsList.getUpointsListExname() + (StringUtils.isBlank((String)rebUpointsList.getUpointsListOpmark()) ? " \u53d1\u653e" : rebUpointsList.getUpointsListOpmark()));
        taTransferaListBean.setTransferaListFtype(StringUtils.isBlank((String)rebPointsRule.getFundType()) ? "01" : rebPointsRule.getFundType());
        taTransferaListBeanList.add(taTransferaListBean);
        this.saveTaTransfera(taTransferaBean);
    }

    private void saveTaTransfera(TaTransferaBean taTransferaBean) {
        if (null == taTransferaBean) {
            return;
        }
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("taTransferaBean", JsonUtil.buildNormalBinder().toJson((Object)taTransferaBean));
        String str = this.internalInvoke("ta.taTransfera.saveTransferaBeanOne", pmap);
        OcReorderDomain ocReorderDomain = (OcReorderDomain)JsonUtil.buildNormalBinder().getJsonToObject(str, OcReorderDomain.class);
        if (null == ocReorderDomain || ocReorderDomain.isError()) {
            throw new ApiException("reb.RebUpointsServiceImpl.saveTaTransfera.str", str);
        }
    }

    @Override
    public Map<String, Object> deductible(BigDecimal goodsPmoney, String tenantCode, String userPcode, String upointsType) {
        BigDecimal pointsRatio;
        this.logger.error("reb.RebUpointsServiceImpl.deductible", (Object)("goodsPmoney:" + goodsPmoney + "|tenantCode:" + tenantCode + "|userPcode:" + userPcode + "|upointsType:" + upointsType));
        if (null == goodsPmoney || StringUtils.isBlank((String)userPcode) || StringUtils.isBlank((String)upointsType) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        BigDecimal integral = goodsPmoney;
        HashMap<String, Object> iamap = new HashMap<String, Object>();
        iamap.put("upointsNum", BigDecimal.ZERO);
        iamap.put("pointsRatio", BigDecimal.ZERO);
        iamap.put("disamount", BigDecimal.ZERO);
        String rebPointsKey = upointsType + "-" + tenantCode;
        RebPoints upmPoints = (RebPoints)DisUtil.getMapJson((String)"RebPoints-type", (String)rebPointsKey, RebPoints.class);
        if (null == upmPoints || upmPoints.getPointsUstart().equals("1") || null == upmPoints.getPointsRatio()) {
            iamap.put("upmDataState", "1");
            return iamap;
        }
        iamap.put("pointsRatio", upmPoints.getPointsRatio());
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("memberCode", userPcode);
        List<RebUpoints> rebUpointsList = this.queryUpointsModelPage(map);
        if (null == rebUpointsList || ListUtil.isEmpty(rebUpointsList)) {
            return iamap;
        }
        RebUpoints rebUpoints = rebUpointsList.get(0);
        BigDecimal upointsNum = rebUpoints.getUpointsNum();
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("order", true);
        param.put("fchannelCode", "03");
        param.put("dicActorCode", "BUY_B");
        param.put("tenantCode", tenantCode);
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("map", JsonUtil.buildNormalBinder().toJson(param));
        try {
            String json = (String)this.getInternalRouter().inInvoke("pte.ptfchannel.queryPtfchannelPage", paramMap);
            if (StringUtils.isBlank((String)json)) {
                this.logger.error("reb.RebUpointsServiceImpl.json is null ", (Object)JsonUtil.buildNormalBinder().toJson(paramMap));
                return iamap;
            }
            SupQueryResult supQueryResultStr = (SupQueryResult)JsonUtil.buildNormalBinder().getJsonToObject(json, SupQueryResult.class);
            if (null == supQueryResultStr || ListUtil.isEmpty((Collection)supQueryResultStr.getList())) {
                this.logger.error("reb.RebUpointsServiceImpl.supQueryResultStr is null ", (Object)json);
                return iamap;
            }
            List jsonToList = JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)supQueryResultStr.getList()), PtePtfchannel.class);
            if (ListUtil.isEmpty((Collection)jsonToList)) {
                this.logger.error("reb.RebUpointsServiceImpl.jsonToList" + json);
                return iamap;
            }
            PtePtfchannel ptePtfchannel = (PtePtfchannel)jsonToList.get(0);
            pointsRatio = ptePtfchannel.getFchannelPay();
        }
        catch (Exception e) {
            throw new ApiException("reb.RebUpointsServiceImpl.deleteAppmodelValueModel.ex", (Throwable)e);
        }
        if (null == pointsRatio || pointsRatio.compareTo(BigDecimal.ZERO) < 1) {
            this.logger.error("reb.RebUpointsServiceImpl.pointsRatio" + pointsRatio);
            return iamap;
        }
        BigDecimal divide = integral.multiply(pointsRatio).divide(new BigDecimal("100"), 2, 4);
        if (null == upointsNum || upointsNum.compareTo(BigDecimal.ZERO) < 1) {
            iamap.put("integral", divide);
            return iamap;
        }
        iamap.put("upointsNum", upointsNum);
        if (divide.compareTo(upointsNum) < 0) {
            iamap.put("upmDataState", "0");
            iamap.put("integral", divide);
            iamap.put("disamount", divide);
            return iamap;
        }
        iamap.put("upmDataState", "0");
        iamap.put("integral", divide);
        iamap.put("disamount", upointsNum);
        return iamap;
    }

    @Override
    public String saveUpointsListDemail(RebUpointsListDomain rebUpointsListDomain) throws ApiException {
        if (null == rebUpointsListDomain) {
            return null;
        }
        String code = this.saveUpointsList(rebUpointsListDomain);
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (StringUtils.isBlank((String)rebUpointsListDomain.getMemberCode())) {
            this.logger.error("reb.RebUpointsServiceImpl.saveUpointsListDemail", (Object)"memberCode is null");
            return null;
        }
        map.put("tenantCode", rebUpointsListDomain.getTenantCode());
        map.put("memberCode", rebUpointsListDomain.getMemberCode());
        QueryResult<RebUpoints> queryResult = this.queryUpointsPage(map);
        if (null == queryResult || ListUtil.isEmpty((Collection)queryResult.getList())) {
            this.logger.error("reb.RebUpointsServiceImpl.saveUpointsListDemail.map", map);
            return null;
        }
        RebUpoints rebUpoints = (RebUpoints)queryResult.getList().get(0);
        if (null == rebUpointsListDomain.getUpointsListNum()) {
            this.logger.error("reb.RebUpointsServiceImpl.saveUpointsListDemail.rebUpointsListDomain", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)rebUpointsListDomain));
            rebUpointsListDomain.setUpointsListNum(new BigDecimal(0));
        }
        if (null == rebUpoints.getUpointsNum()) {
            this.logger.error("reb.RebUpointsServiceImpl.saveUpointsListDemail.upointsNum", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)rebUpointsListDomain));
            rebUpoints.setUpointsNum(new BigDecimal(0));
        }
        BigDecimal monery = rebUpoints.getUpointsNum().add(rebUpointsListDomain.getUpointsListNum());
        rebUpoints.setUpointsNum(monery);
        this.updateUpointsModel(rebUpoints);
        return code;
    }

    @Override
    public String saveUpointsListToContract(RebUpointsClearDomain rebUpointsClearDomain) throws ApiException {
        if (null == rebUpointsClearDomain) {
            this.logger.error("reb.RebUpointsServiceImpl.saveUpointsListToContract", (Object)"rebUpointsClearDomain is null");
            return null;
        }
        BigDecimal num = rebUpointsClearDomain.getUpointsClearNum();
        HashMap<String, Object> userMap = new HashMap<String, Object>();
        userMap.put("tenantCode", rebUpointsClearDomain.getTenantCode());
        userMap.put("memberCode", rebUpointsClearDomain.getMemberCode());
        userMap.put("channelCode", rebUpointsClearDomain.getChannelCode());
        QueryResult<RebUpoints> upointsQueryResult = this.queryUpointsPage(userMap);
        if (null == upointsQueryResult || ListUtil.isEmpty((Collection)upointsQueryResult.getList())) {
            this.logger.error("reb.RebUpointsServiceImpl.saveUpointsListToContract", (Object)"upointsQueryResult is null");
            return null;
        }
        RebUpoints rebUpoints = (RebUpoints)upointsQueryResult.getList().get(0);
        String dir = rebUpointsClearDomain.getUpointsClearDirection();
        if ("8".equals(dir) && rebUpoints.getUpointsNum().compareTo(num) < 0) {
            this.logger.error("reb.RebUpointsServiceImpl.saveUpointsListToContract", (Object)(rebUpoints.getUpointsNum() + "," + num));
            return null;
        }
        RebUpointsListDomain rebUpointsListDomain = new RebUpointsListDomain();
        if ("8".equals(dir)) {
            num = num.multiply(new BigDecimal("-1"));
        }
        userMap.remove("memberCode");
        userMap.put("upointsCode", rebUpoints.getUpointsCode());
        userMap.put("upointsNum", num);
        userMap.put("type", "1");
        this.updateNumByCodeAndModified(userMap);
        try {
            BeanUtils.copyAllPropertys((Object)rebUpointsListDomain, (Object)rebUpointsClearDomain);
            rebUpointsListDomain.setMemberMname(rebUpointsClearDomain.getMemberMname());
            rebUpointsListDomain.setMemberMcode(rebUpointsClearDomain.getMemberMcode());
            rebUpointsListDomain.setChannelCode(rebUpoints.getChannelCode());
            rebUpointsListDomain.setChannelName(rebUpoints.getChannelName());
            rebUpointsListDomain.setUpointsBfnum(rebUpoints.getUpointsNum());
            rebUpointsListDomain.setUpointsAfnum(rebUpoints.getUpointsNum().add(num));
            rebUpointsListDomain.setUpointsListNum(num.abs());
            rebUpointsListDomain.setMemberName(rebUpoints.getMemberName());
            rebUpointsListDomain.setMemberCode(rebUpoints.getMemberCode());
            rebUpointsListDomain.setUpointsClearCode(rebUpoints.getUserinfoCode());
            rebUpointsListDomain.setUpointsListExname(rebUpoints.getUserinfoName());
            Date date = new Date();
            Instant instant = date.toInstant();
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMM").withZone(ZoneId.systemDefault());
            String formattedDate = formatter.format(instant);
            rebUpointsListDomain.setUpointsListOpcode1(formattedDate);
            rebUpointsListDomain.setUpointsListOpcode2(rebUpointsClearDomain.getUpointsClearOpcode2());
            rebUpointsListDomain.setUserinfoCode(rebUpoints.getUserinfoCode());
            rebUpointsListDomain.setUpointsListDirection(rebUpointsClearDomain.getUpointsClearDirection());
            rebUpointsListDomain.setUpointsListOpcode(rebUpointsClearDomain.getUpointsClearOpcode());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String code = this.saveUpointsList(rebUpointsListDomain);
        return code;
    }

    @Override
    public String saveUpointsListToOcode(RebUpointsClearDomain rebUpointsClearDomain) throws ApiException {
        if (null == rebUpointsClearDomain) {
            this.logger.error("reb.RebUpointsServiceImpl.saveUpointsListToOcode", (Object)"rebUpointsClearDomain is null");
            return null;
        }
        BigDecimal num = rebUpointsClearDomain.getUpointsClearNum();
        HashMap<String, Object> userMap = new HashMap<String, Object>();
        userMap.put("tenantCode", rebUpointsClearDomain.getTenantCode());
        userMap.put("memberCode", rebUpointsClearDomain.getMemberCode());
        QueryResult<RebUpoints> upointsQueryResult = this.queryUpointsPage(userMap);
        if (ListUtil.isEmpty((Collection)upointsQueryResult.getList())) {
            this.logger.error("reb.RebUpointsServiceImpl.saveUpointsListToContract", (Object)"upointsQueryResult is null");
            return null;
        }
        RebUpoints rebUpoints = (RebUpoints)upointsQueryResult.getList().get(0);
        if ("8".equals(rebUpointsClearDomain.getUpointsClearDirection())) {
            num = num.multiply(new BigDecimal("-1"));
        }
        userMap.remove("memberCode");
        userMap.put("upointsCode", rebUpoints.getUpointsCode());
        userMap.put("upointsNum", num);
        userMap.put("type", "1");
        this.updateNumByCodeAndModified(userMap);
        RebUpointsListDomain rebUpointsListDomain = new RebUpointsListDomain();
        try {
            BeanUtils.copyAllPropertys((Object)rebUpointsListDomain, (Object)rebUpointsClearDomain);
            rebUpointsListDomain.setUpointsBfnum(rebUpoints.getUpointsNum());
            rebUpointsListDomain.setUpointsAfnum(rebUpoints.getUpointsNum().add(num));
            rebUpointsListDomain.setUpointsListNum(num.abs());
            rebUpointsListDomain.setUpointsListDirection(rebUpointsClearDomain.getUpointsClearDirection());
            rebUpointsListDomain.setUpointsListOpcode(rebUpointsClearDomain.getUpointsClearOpcode());
            rebUpointsListDomain.setUpointsListOpmark(rebUpointsClearDomain.getUpointsClearOpmark());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String code = this.saveUpointsList(rebUpointsListDomain);
        return code;
    }

    private Integer updateNumByCodeAndModified(Map map) throws ApiException {
        if (null == map) {
            return null;
        }
        int i = 0;
        try {
            i = this.rebUpointsMapper.updateNumByCodeAndModified(map);
        }
        catch (Exception e) {
            throw new ApiException("reb.RebUpointsServiceImpl.updateNumByCodeAndModified.ex", (Throwable)e);
        }
        return i;
    }

    private Integer updateNumByAdjustment(Map map) throws ApiException {
        if (null == map) {
            return null;
        }
        int i = 0;
        try {
            i = this.rebUpointsMapper.updateNumByAdjustment(map);
        }
        catch (Exception e) {
            throw new ApiException("reb.RebUpointsServiceImpl.updateNumByAdjustment.ex", (Throwable)e);
        }
        return i;
    }

    @Override
    public String saveUpointsListToAdjustment(RebUpointsClearDomain rebUpointsClearDomain) throws ApiException {
        if (null == rebUpointsClearDomain) {
            this.logger.error("reb.RebUpointsServiceImpl.saveUpointsListToContract", (Object)"rebUpointsClearDomain is null");
            return null;
        }
        BigDecimal num = rebUpointsClearDomain.getUpointsClearNum();
        HashMap<String, Object> userMap = new HashMap<String, Object>();
        userMap.put("tenantCode", rebUpointsClearDomain.getTenantCode());
        userMap.put("memberCode", rebUpointsClearDomain.getMemberCode());
        userMap.put("channelCode", rebUpointsClearDomain.getChannelCode());
        QueryResult<RebUpoints> upointsQueryResult = this.queryUpointsPage(userMap);
        if (null == upointsQueryResult || ListUtil.isEmpty((Collection)upointsQueryResult.getList())) {
            this.logger.error("reb.RebUpointsServiceImpl.saveUpointsListToAdjustment", (Object)("upointsQueryResult is null" + userMap));
            return null;
        }
        RebUpoints rebUpoints = (RebUpoints)upointsQueryResult.getList().get(0);
        String dir = rebUpointsClearDomain.getUpointsClearDirection();
        if (EmptyUtil.isEmpty((Object)rebUpoints.getUpointsNum())) {
            rebUpoints.setUpointsNum(BigDecimal.ZERO);
        }
        if ("1".equals(dir) && rebUpoints.getUpointsNum().compareTo(num) < 0) {
            this.logger.error("reb.RebUpointsServiceImpl.saveUpointsListToContract", (Object)(rebUpoints.getUpointsNum() + "," + num));
            return null;
        }
        RebUpointsListDomain rebUpointsListDomain = new RebUpointsListDomain();
        if ("1".equals(dir) || "19".equals(dir)) {
            num = num.multiply(new BigDecimal("-1"));
        }
        userMap.remove("memberCode");
        userMap.put("upointsCode", rebUpoints.getUpointsCode());
        userMap.put("upointsNum", num);
        userMap.put("type", rebUpointsClearDomain.getUpointsClearDirection());
        this.updateNumByAdjustment(userMap);
        try {
            BeanUtils.copyAllPropertysNotNull((Object)rebUpointsListDomain, (Object)rebUpoints);
            BeanUtils.copyAllPropertysNotNull((Object)rebUpointsListDomain, (Object)rebUpointsClearDomain);
            rebUpointsListDomain.setUpointsBfnum(rebUpoints.getUpointsNum());
            rebUpointsListDomain.setUpointsAfnum(rebUpoints.getUpointsNum().add(num));
            rebUpointsListDomain.setUpointsListNum(num.abs());
            rebUpointsListDomain.setUpointsListOpcode(rebUpointsClearDomain.getUpointsClearOpcode());
            rebUpointsListDomain.setUpointsListOpcode1(rebUpointsClearDomain.getUpointsClearOpcode1());
            rebUpointsListDomain.setUpointsListOpcode2(rebUpointsClearDomain.getUpointsClearOpcode2());
            rebUpointsListDomain.setUpointsListOpcode3(rebUpointsClearDomain.getUpointsClearOpcode3());
            rebUpointsListDomain.setUpointsListOpcode4(rebUpointsClearDomain.getUpointsClearOpcode4());
            rebUpointsListDomain.setUpointsListDirection(rebUpointsClearDomain.getUpointsClearDirection());
            rebUpointsListDomain.setUpointsListRemark(rebUpointsClearDomain.getUpointsClearRemark());
        }
        catch (Exception exception) {
            // empty catch block
        }
        String code = this.saveUpointsList(rebUpointsListDomain);
        return code;
    }

    @Override
    public void saveUpointsListToReconciliation(RebUpoints rebUpoints) throws ApiException {
        BigDecimal listNum;
        if (null == rebUpoints) {
            this.logger.error("reb.RebUpointsServiceImpl.saveUpointsListToReconciliation", (Object)"rebUpoints is null");
            return;
        }
        YearMonth currentYearMonth = YearMonth.now();
        YearMonth previousYearMonth = currentYearMonth.minusMonths(1L);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("memberCode", rebUpoints.getMemberCode());
        map.put("channelCode", rebUpoints.getChannelCode());
        map.put("tenantCode", rebUpoints.getTenantCode());
        map.put("upointsListDirection", "18");
        RebUpointsList rebUpointsList = this.getNumByDate(map);
        BigDecimal accountEntryNum = BigDecimal.ZERO;
        if (rebUpointsList != null && !EmptyUtil.isEmpty((Object)rebUpointsList.getUpointsListNum())) {
            accountEntryNum = rebUpointsList.getUpointsListNum();
        }
        this.logger.info("reb.RebUpointsServiceImpl.accountEntryNum=", (Object)accountEntryNum);
        map.put("upointsListDirection", "8");
        RebUpointsList rebUpo = this.getNumByDate(map);
        BigDecimal consumeNum = BigDecimal.ZERO;
        if (rebUpo != null && !EmptyUtil.isEmpty((Object)rebUpo.getUpointsListNum())) {
            consumeNum = rebUpo.getUpointsListNum();
        }
        this.logger.info("reb.RebUpointsServiceImpl.consumeNum=8", (Object)consumeNum);
        map.put("upointsListDirection", "9");
        rebUpo = this.getNumByDate(map);
        if (rebUpo != null && !EmptyUtil.isEmpty((Object)rebUpo.getUpointsListNum())) {
            this.logger.info("reb.RebUpointsServiceImpl.consumeNum=9", (Object)rebUpo.getUpointsListNum());
            listNum = rebUpo.getUpointsListNum();
            consumeNum = consumeNum.subtract(listNum);
        }
        map.put("upointsListDirection", "10");
        rebUpo = this.getNumByDate(map);
        if (rebUpo != null && !EmptyUtil.isEmpty((Object)rebUpo.getUpointsListNum())) {
            this.logger.info("reb.RebUpointsServiceImpl.consumeNum=10", (Object)rebUpo.getUpointsListNum());
            listNum = rebUpo.getUpointsListNum();
            consumeNum = consumeNum.subtract(listNum);
        }
        this.logger.info("reb.RebUpointsServiceImpl.consumeNum=", (Object)consumeNum);
        map.put("upointsListDirection", "0");
        rebUpo = this.getNumByDate(map);
        BigDecimal addRebAmount = BigDecimal.ZERO;
        if (rebUpo != null && !EmptyUtil.isEmpty((Object)rebUpo.getUpointsListNum())) {
            addRebAmount = rebUpo.getUpointsListNum();
        }
        this.logger.info("reb.RebUpointsServiceImpl.addRebAmount=", (Object)addRebAmount);
        map.put("upointsListDirection", "1");
        rebUpo = this.getNumByDate(map);
        BigDecimal minusRebAmount = BigDecimal.ZERO;
        if (rebUpo != null && !EmptyUtil.isEmpty((Object)rebUpo.getUpointsListNum())) {
            minusRebAmount = rebUpo.getUpointsListNum();
        }
        this.logger.info("reb.RebUpointsServiceImpl.minusRebAmount=", (Object)minusRebAmount);
        if (EmptyUtil.isEmpty((Object)rebUpoints.getBeginUpointsNum())) {
            rebUpoints.setBeginUpointsNum(BigDecimal.ZERO);
        }
        if (EmptyUtil.isEmpty((Object)rebUpoints.getUpointsNum())) {
            rebUpoints.setUpointsNum(BigDecimal.ZERO);
        }
        RebUpointsListDomain rebUpointsListDomain = new RebUpointsListDomain();
        rebUpointsListDomain.setUpointsListNum(accountEntryNum);
        rebUpointsListDomain.setUpointsAfnum(rebUpoints.getBeginUpointsNum());
        rebUpointsListDomain.setUpointsAfonum(consumeNum);
        rebUpointsListDomain.setUpointsBfnum(rebUpoints.getUpointsNum());
        rebUpointsListDomain.setUpointsBfonum(addRebAmount);
        rebUpointsListDomain.setUpointsBflnum(minusRebAmount);
        rebUpointsListDomain.setMemberCode(rebUpoints.getMemberCode());
        rebUpointsListDomain.setMemberName(rebUpoints.getMemberName());
        rebUpointsListDomain.setMemberMname(rebUpoints.getMemberMname());
        rebUpointsListDomain.setMemberMcode(rebUpoints.getMemberMcode());
        rebUpointsListDomain.setChannelCode(rebUpoints.getChannelCode());
        rebUpointsListDomain.setChannelName(rebUpoints.getChannelName());
        rebUpointsListDomain.setUpointsListOpcode2(previousYearMonth.toString());
        rebUpointsListDomain.setTenantCode(rebUpoints.getTenantCode());
        rebUpointsListDomain.setUpointsListDirection("17");
        rebUpointsListDomain.setUpointsType("17");
        rebUpointsListDomain.setUserinfoCode(rebUpoints.getUserinfoCode());
        rebUpoints.setBeginUpointsNum(rebUpoints.getUpointsNum());
        this.updateUpointsModel(rebUpoints);
        this.saveUpointsList(rebUpointsListDomain);
    }

    @Override
    public String saveUpointsListToOcContractDomain(OcContractDomain ocContractDomain) throws ApiException {
        if (null == ocContractDomain || ListUtil.isEmpty(ocContractDomain.getGoodsList())) {
            this.logger.error("reb.RebUpointsServiceImpl.saveUpointsListToOcContractDomain", (Object)"ocContractDomain is null");
            return "error";
        }
        this.logger.error("ocContractDomain=================", (Object)JsonUtil.buildNormalBinder().toJson((Object)ocContractDomain));
        ArrayList<RebUpointsListDomain> rebUpointsListDomainList = new ArrayList<RebUpointsListDomain>();
        RebUpointsListDomain rebUpointsListDomain = null;
        for (OcContractGoodsDomain ocContractGoodsDomain : ocContractDomain.getGoodsList()) {
            if (!StringUtils.equals((CharSequence)"yes", (CharSequence)ocContractGoodsDomain.getContractGoodsValue())) continue;
            if (EmptyUtil.isEmpty((Object)ocContractGoodsDomain.getContractGoodsMoney())) {
                this.logger.error("reb.RebUpointsServiceImpl.saveUpointsListToOcContractDomain", (Object)"goodsAhnum is null");
                continue;
            }
            if (EmptyUtil.isEmpty((Object)ocContractGoodsDomain.getContractGoodsPefmoney())) {
                this.logger.error("reb.RebUpointsServiceImpl.saveUpointsListToOcContractDomain", (Object)"pricesetNprice is null");
                continue;
            }
            BigDecimal surMoney = ocContractGoodsDomain.getContractGoodsPefmoney().subtract(ocContractGoodsDomain.getContractGoodsMoney());
            if (surMoney.compareTo(BigDecimal.ZERO) != 1) {
                this.logger.error("reb.RebUpointsServiceImpl.saveUpointsListToOcContractDomain,goodsAhnum", (Object)("goodsAhnum:" + ocContractGoodsDomain.getGoodsAhnum() + "pricesetNprice:" + ocContractGoodsDomain.getPricesetNprice()));
                continue;
            }
            rebUpointsListDomain = new RebUpointsListDomain();
            rebUpointsListDomain.setTenantCode(ocContractGoodsDomain.getTenantCode());
            rebUpointsListDomain.setMemberCode(ocContractDomain.getMemberBcode());
            rebUpointsListDomain.setMemberName(ocContractDomain.getMemberBname());
            rebUpointsListDomain.setChannelName(ocContractDomain.getChannelName());
            rebUpointsListDomain.setChannelCode(ocContractDomain.getChannelCode());
            rebUpointsListDomain.setMemberMcode(ocContractDomain.getMemberGcode());
            rebUpointsListDomain.setMemberMname(ocContractDomain.getMemberGname());
            rebUpointsListDomain.setUpointsListDirection("3");
            rebUpointsListDomain.setUpointsListNum(surMoney);
            rebUpointsListDomain.setUpointsListOpcode3("oc");
            rebUpointsListDomain.setUpointsListOpcode(ocContractDomain.getContractBillcode());
            rebUpointsListDomain.setGoodsName(ocContractGoodsDomain.getGoodsName());
            rebUpointsListDomain.setSkuNo(ocContractGoodsDomain.getSkuNo());
            rebUpointsListDomain.setClasstreeShopcode(ocContractGoodsDomain.getClasstreeShopcode());
            rebUpointsListDomain.setClasstreeShopname(ocContractGoodsDomain.getClasstreeShopname());
            rebUpointsListDomain.setClasstreeCode(ocContractGoodsDomain.getClasstreeCode());
            rebUpointsListDomain.setClasstreeName(ocContractGoodsDomain.getClasstreeName());
            rebUpointsListDomain.setUpointsListOpcode2(ocContractDomain.getDepartCode());
            rebUpointsListDomain.setUpointsListOpcode3(ocContractDomain.getDepartShortname());
            rebUpointsListDomainList.add(rebUpointsListDomain);
        }
        if (rebUpointsListDomainList.size() > 0) {
            this.saveUpointsListBatch(rebUpointsListDomainList);
        }
        return "success";
    }

    @Override
    public String saveUpointsListToCannelOcContractDomain(OcContractDomain ocContractDomain) throws ApiException {
        if (null == ocContractDomain || ListUtil.isEmpty(ocContractDomain.getGoodsList())) {
            this.logger.error("reb.RebUpointsServiceImpl.saveUpointsListToCannelOcContractDomain", (Object)"ocContractDomain is null");
            return "error";
        }
        this.logger.error("ocContractDomain=================", (Object)JsonUtil.buildNormalBinder().toJson((Object)ocContractDomain));
        ArrayList<RebUpointsListDomain> rebUpointsListDomainList = new ArrayList<RebUpointsListDomain>();
        RebUpointsListDomain rebUpointsListDomain = null;
        for (OcContractGoodsDomain ocContractGoodsDomain : ocContractDomain.getGoodsList()) {
            if (!StringUtils.equals((CharSequence)"yes", (CharSequence)ocContractGoodsDomain.getContractGoodsValue())) continue;
            if (EmptyUtil.isEmpty((Object)ocContractGoodsDomain.getContractGoodsMoney())) {
                this.logger.error("reb.RebUpointsServiceImpl.saveUpointsListToCannelOcContractDomain", (Object)"goodsAhnum is null");
                continue;
            }
            if (EmptyUtil.isEmpty((Object)ocContractGoodsDomain.getContractGoodsPefmoney())) {
                this.logger.error("reb.RebUpointsServiceImpl.saveUpointsListToCannelOcContractDomain", (Object)"pricesetNprice is null");
                continue;
            }
            BigDecimal surMoney = ocContractGoodsDomain.getContractGoodsPefmoney().subtract(ocContractGoodsDomain.getContractGoodsMoney());
            if (surMoney.compareTo(BigDecimal.ZERO) != 1) {
                this.logger.error("reb.RebUpointsServiceImpl.saveUpointsListToCannelOcContractDomain,goodsAhnum", (Object)("goodsAhnum:" + ocContractGoodsDomain.getGoodsAhnum() + "pricesetNprice:" + ocContractGoodsDomain.getPricesetNprice()));
                continue;
            }
            rebUpointsListDomain = new RebUpointsListDomain();
            rebUpointsListDomain.setTenantCode(ocContractGoodsDomain.getTenantCode());
            rebUpointsListDomain.setMemberCode(ocContractDomain.getMemberBcode());
            rebUpointsListDomain.setMemberName(ocContractDomain.getMemberBname());
            rebUpointsListDomain.setChannelName(ocContractDomain.getChannelName());
            rebUpointsListDomain.setChannelCode(ocContractDomain.getChannelCode());
            rebUpointsListDomain.setMemberMcode(ocContractDomain.getMemberGcode());
            rebUpointsListDomain.setMemberMname(ocContractDomain.getMemberGname());
            rebUpointsListDomain.setUpointsListDirection("4");
            rebUpointsListDomain.setUpointsListNum(surMoney);
            rebUpointsListDomain.setUpointsListOpcode3("oc");
            rebUpointsListDomain.setUpointsListOpcode(ocContractDomain.getContractBillcode());
            rebUpointsListDomain.setGoodsName(ocContractGoodsDomain.getGoodsName());
            rebUpointsListDomain.setSkuNo(ocContractGoodsDomain.getSkuNo());
            rebUpointsListDomain.setClasstreeShopcode(ocContractGoodsDomain.getClasstreeShopcode());
            rebUpointsListDomain.setClasstreeShopname(ocContractGoodsDomain.getClasstreeShopname());
            rebUpointsListDomain.setClasstreeCode(ocContractGoodsDomain.getClasstreeCode());
            rebUpointsListDomain.setClasstreeName(ocContractGoodsDomain.getClasstreeName());
            rebUpointsListDomainList.add(rebUpointsListDomain);
        }
        if (rebUpointsListDomainList.size() > 0) {
            this.saveUpointsListBatch(rebUpointsListDomainList);
        }
        return "success";
    }

    @Override
    public String saveUpointsListToRefund(OcRefundDomain ocRefundDomain) throws ApiException {
        if (null == ocRefundDomain || ListUtil.isEmpty(ocRefundDomain.getOcRefundGoodsDomainList())) {
            this.logger.error("reb.RebUpointsServiceImpl.saveUpointsListToRefund", (Object)"ocContractDomain is null");
            return "error";
        }
        ArrayList<RebUpointsListDomain> rebUpointsListDomainList = new ArrayList<RebUpointsListDomain>();
        RebUpointsListDomain rebUpointsListDomain = null;
        for (OcRefundGoodsDomain ocContractGoodsDomain : ocRefundDomain.getOcRefundGoodsDomainList()) {
            if (!StringUtils.equals((CharSequence)"yes", (CharSequence)ocContractGoodsDomain.getContractGoodsValue())) continue;
            if (EmptyUtil.isEmpty((Object)ocContractGoodsDomain.getContractGoodsMoney())) {
                this.logger.error("reb.RebUpointsServiceImpl.saveUpointsListToRefund", (Object)"goodsAhnum is null");
                continue;
            }
            if (EmptyUtil.isEmpty((Object)ocContractGoodsDomain.getApplyRebmoney())) {
                ocContractGoodsDomain.setApplyRebmoney(BigDecimal.ZERO);
            }
            if (ocContractGoodsDomain.getApplyRebmoney().compareTo(BigDecimal.ZERO) != 1) {
                this.logger.error("reb.RebUpointsServiceImpl.saveUpointsListToRefund,goodsAhnum", (Object)("goodsAhnum:" + ocContractGoodsDomain.getGoodsAhnum() + "pricesetNprice:" + ocContractGoodsDomain.getPricesetNprice()));
                continue;
            }
            rebUpointsListDomain = new RebUpointsListDomain();
            rebUpointsListDomain.setTenantCode(ocContractGoodsDomain.getTenantCode());
            rebUpointsListDomain.setMemberCode(ocRefundDomain.getMemberBcode());
            rebUpointsListDomain.setMemberName(ocRefundDomain.getMemberBname());
            rebUpointsListDomain.setChannelName(ocRefundDomain.getChannelName());
            rebUpointsListDomain.setChannelCode(ocRefundDomain.getChannelCode());
            rebUpointsListDomain.setMemberMcode(ocRefundDomain.getMemberGcode());
            rebUpointsListDomain.setMemberMname(ocRefundDomain.getMemberGname());
            rebUpointsListDomain.setUpointsListDirection("5");
            rebUpointsListDomain.setUpointsListNum(ocContractGoodsDomain.getApplyRebmoney());
            rebUpointsListDomain.setUpointsListOpcode3("refund");
            rebUpointsListDomain.setUpointsListOpcode(ocRefundDomain.getRefundCode());
            rebUpointsListDomain.setGoodsName(ocContractGoodsDomain.getGoodsName());
            rebUpointsListDomain.setSkuNo(ocContractGoodsDomain.getSkuNo());
            rebUpointsListDomain.setClasstreeShopcode(ocContractGoodsDomain.getClasstreeShopcode());
            rebUpointsListDomain.setClasstreeShopname(ocContractGoodsDomain.getClasstreeShopname());
            rebUpointsListDomain.setClasstreeCode(ocContractGoodsDomain.getClasstreeCode());
            rebUpointsListDomain.setClasstreeName(ocContractGoodsDomain.getClasstreeName());
            rebUpointsListDomainList.add(rebUpointsListDomain);
        }
        if (rebUpointsListDomainList.size() > 0) {
            this.saveUpointsListBatch(rebUpointsListDomainList);
        }
        return "success";
    }
}

