/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.reb.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.reb.RebConstants;
import com.yqbsoft.laser.service.reb.dao.RebAdApplyMapper;
import com.yqbsoft.laser.service.reb.domain.RebAdApplyDomain;
import com.yqbsoft.laser.service.reb.domain.RebAdApplyReDomain;
import com.yqbsoft.laser.service.reb.domain.RebUpointsOpDomain;
import com.yqbsoft.laser.service.reb.model.RebAdApply;
import com.yqbsoft.laser.service.reb.service.RebAdApplyService;
import com.yqbsoft.laser.service.reb.service.RebUpointsOpBaseService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;

public class RebAdApplyServiceImpl
extends BaseServiceImpl
implements RebAdApplyService {
    private static final String SYS_CODE = "reb.RebAdApplyServiceImpl";
    private RebAdApplyMapper rebAdApplyMapper;
    @Autowired
    private RebUpointsOpBaseService rebUpointsOpBaseService;

    public void setRebAdApplyMapper(RebAdApplyMapper rebAdApplyMapper) {
        this.rebAdApplyMapper = rebAdApplyMapper;
    }

    private Date getSysDate() {
        try {
            return this.rebAdApplyMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("reb.RebAdApplyServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkAdApply(RebAdApplyDomain rebAdApplyDomain) {
        if (null == rebAdApplyDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)rebAdApplyDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setAdApplyDefault(RebAdApply rebAdApply) {
        if (null == rebAdApply) {
            return;
        }
        if (null == rebAdApply.getDataState()) {
            rebAdApply.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == rebAdApply.getGmtCreate()) {
            rebAdApply.setGmtCreate(date);
        }
        rebAdApply.setGmtModified(date);
        if (StringUtils.isBlank((String)rebAdApply.getAdApplyCode())) {
            rebAdApply.setAdApplyCode(this.getNo(null, "RebAdApply", "rebAdApply", rebAdApply.getTenantCode()));
        }
    }

    private int getAdApplyMaxCode() {
        int code = 0;
        try {
            return this.rebAdApplyMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("reb.RebAdApplyServiceImpl.getAdApplyMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setAdApplyUpdataDefault(RebAdApply rebAdApply) {
        if (null == rebAdApply) {
            return;
        }
        rebAdApply.setGmtModified(this.getSysDate());
    }

    private void saveRebAdApplyModel(RebAdApply rebAdApply) throws ApiException {
        if (null == rebAdApply) {
            return;
        }
        try {
            if (RebConstants.AD_APPLY_STATUS_TO_APPROVE.equals(rebAdApply.getDataState()) && "1".equals(rebAdApply.getAdOp6())) {
                RebUpointsOpDomain rebUpointsOpDomain = new RebUpointsOpDomain();
                rebUpointsOpDomain.setUpointsOpType("3");
                rebUpointsOpDomain.setUpointsType("1");
                rebUpointsOpDomain.setMemberCode(rebAdApply.getDealerCode());
                rebUpointsOpDomain.setUpointsOpNum(new BigDecimal(rebAdApply.getAdOp1()));
                rebUpointsOpDomain.setChannelCode(rebAdApply.getChannelCode());
                rebUpointsOpDomain.setTenantCode(rebAdApply.getTenantCode());
                this.rebUpointsOpBaseService.saveUpointsOp(rebUpointsOpDomain);
            } else if (RebConstants.AD_APPLY_STATUS_TO_APPROVE.equals(rebAdApply.getDataState()) && "2".equals(rebAdApply.getAdOp6())) {
                RebUpointsOpDomain rebUpointsOpDomain = new RebUpointsOpDomain();
                rebUpointsOpDomain.setUpointsOpType("10");
                rebUpointsOpDomain.setUpointsType("1");
                rebUpointsOpDomain.setMemberCode(rebAdApply.getDealerCode());
                rebUpointsOpDomain.setUpointsOpNum(new BigDecimal(rebAdApply.getAdOp1()));
                rebUpointsOpDomain.setChannelCode(rebAdApply.getChannelCode());
                rebUpointsOpDomain.setTenantCode(rebAdApply.getTenantCode());
                this.rebUpointsOpBaseService.saveUpointsOp(rebUpointsOpDomain);
                RebAdApplyDomain rebAdApplyDomain = new RebAdApplyDomain();
                RebAdApply oldAdApply = this.getAdApplyModelByCode(this.getQueryParamMap("adApplyCode", new Object[]{rebAdApply.getAdOp3()}));
                BeanUtils.copyAllPropertys((Object)rebAdApplyDomain, (Object)oldAdApply);
                rebAdApplyDomain.setToVerifyAmount(oldAdApply.getToVerifyAmount().multiply(new BigDecimal(rebAdApply.getAdOp1())));
                this.updateRebAdApply(rebAdApplyDomain);
                this.updateRebAdApplyState(oldAdApply.getAdApplyId(), RebConstants.AD_APPLY_STATUS_TO_WRITTEN_OFF, RebConstants.AD_APPLY_STATUS_APPROVED, new HashMap<String, Object>());
            }
            this.rebAdApplyMapper.insert(rebAdApply);
        }
        catch (Exception e) {
            throw new ApiException("reb.RebAdApplyServiceImpl.saveAdApplyModel.ex", (Throwable)e);
        }
    }

    private void saveAdApplyBatchModel(List<RebAdApply> rebAdApplyList) throws ApiException {
        if (null == rebAdApplyList || rebAdApplyList.isEmpty()) {
            return;
        }
        try {
            this.rebAdApplyMapper.insertBatch(rebAdApplyList);
        }
        catch (Exception e) {
            throw new ApiException("reb.RebAdApplyServiceImpl.saveAdApplyBatchModel.ex", (Throwable)e);
        }
    }

    private RebAdApply getAdApplyModelById(Long adApplyId) {
        if (null == adApplyId) {
            return null;
        }
        try {
            return this.rebAdApplyMapper.selectByPrimaryKey(adApplyId);
        }
        catch (Exception e) {
            this.logger.error("reb.RebAdApplyServiceImpl.getAdApplyModelById", (Throwable)e);
            return null;
        }
    }

    private RebAdApply getAdApplyModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.rebAdApplyMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("reb.RebAdApplyServiceImpl.getAdApplyModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delAdApplyModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.rebAdApplyMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("reb.RebAdApplyServiceImpl.delAdApplyModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("reb.RebAdApplyServiceImpl.delAdApplyModelByCode.num");
        }
    }

    private void deleteAdApplyModel(Long adApplyId) throws ApiException {
        if (null == adApplyId) {
            return;
        }
        int i = 0;
        try {
            i = this.rebAdApplyMapper.deleteByPrimaryKey(adApplyId);
        }
        catch (Exception e) {
            throw new ApiException("reb.RebAdApplyServiceImpl.deleteAdApplyModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("reb.RebAdApplyServiceImpl.deleteAdApplyModel.num");
        }
    }

    private void updateAdApplyModel(RebAdApply rebAdApply) throws ApiException {
        if (null == rebAdApply) {
            return;
        }
        int i = 0;
        try {
            i = this.rebAdApplyMapper.updateByPrimaryKey(rebAdApply);
        }
        catch (Exception e) {
            throw new ApiException("reb.RebAdApplyServiceImpl.updateAdApplyModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("reb.RebAdApplyServiceImpl.updateAdApplyModel.num");
        }
    }

    private void updateStateAdApplyModel(Long adApplyId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == adApplyId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("adApplyId", adApplyId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.rebAdApplyMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("reb.RebAdApplyServiceImpl.updateStateAdApplyModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("reb.RebAdApplyServiceImpl.updateStateAdApplyModel.null");
        }
    }

    private void updateStateAdApplyModelByCode(String tenantCode, String adApplyCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)adApplyCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("adApplyCode", adApplyCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            RebAdApply oldAdApply;
            RebAdApplyDomain rebAdApplyDomain;
            RebUpointsOpDomain rebUpointsOpDomain;
            if (Objects.equals(dataState, RebConstants.AD_APPLY_STATUS_TO_APPROVE) && map.containsKey("AdOp1") && map.get("AdOp6").equals("1")) {
                rebUpointsOpDomain = new RebUpointsOpDomain();
                rebUpointsOpDomain.setUpointsOpType("3");
                rebUpointsOpDomain.setUpointsType("1");
                rebUpointsOpDomain.setMemberCode(String.valueOf(map.get("dealerCode")));
                rebUpointsOpDomain.setUpointsOpNum(new BigDecimal(String.valueOf(map.get("AdOp1"))));
                rebUpointsOpDomain.setChannelCode(String.valueOf(map.get("channelCode")));
                rebUpointsOpDomain.setTenantCode(tenantCode);
                this.rebUpointsOpBaseService.saveUpointsOp(rebUpointsOpDomain);
            }
            if (Objects.equals(dataState, RebConstants.AD_APPLY_STATUS_REJECTED) && map.containsKey("AdOp1") && map.get("AdOp6").equals("1")) {
                rebUpointsOpDomain = new RebUpointsOpDomain();
                rebUpointsOpDomain.setUpointsOpType("4");
                rebUpointsOpDomain.setUpointsType("1");
                rebUpointsOpDomain.setMemberCode(String.valueOf(map.get("dealerCode")));
                rebUpointsOpDomain.setUpointsOpNum(new BigDecimal(String.valueOf(map.get("AdOp1"))));
                rebUpointsOpDomain.setChannelCode(String.valueOf(map.get("channelCode")));
                rebUpointsOpDomain.setTenantCode(tenantCode);
                this.rebUpointsOpBaseService.saveUpointsOp(rebUpointsOpDomain);
            }
            if (Objects.equals(dataState, RebConstants.AD_APPLY_STATUS_APPROVED) && map.containsKey("AdOp1") && map.get("AdOp6").equals("1")) {
                rebUpointsOpDomain = new RebUpointsOpDomain();
                rebUpointsOpDomain.setUpointsOpType("5");
                rebUpointsOpDomain.setUpointsType("1");
                rebUpointsOpDomain.setMemberCode(String.valueOf(map.get("dealerCode")));
                rebUpointsOpDomain.setUpointsOpNum(new BigDecimal(String.valueOf(map.get("AdOp1"))));
                rebUpointsOpDomain.setChannelCode(String.valueOf(map.get("channelCode")));
                rebUpointsOpDomain.setTenantCode(tenantCode);
                this.rebUpointsOpBaseService.saveUpointsOp(rebUpointsOpDomain);
            }
            if (Objects.equals(dataState, RebConstants.AD_APPLY_STATUS_TO_APPROVE) && map.containsKey("AdOp1") && map.get("AdOp6").equals("2")) {
                rebUpointsOpDomain = new RebUpointsOpDomain();
                rebUpointsOpDomain.setUpointsOpType("10");
                rebUpointsOpDomain.setUpointsType("1");
                rebUpointsOpDomain.setMemberCode(String.valueOf(map.get("dealerCode")));
                rebUpointsOpDomain.setUpointsOpNum(new BigDecimal(String.valueOf(map.get("AdOp1"))));
                rebUpointsOpDomain.setChannelCode(String.valueOf(map.get("channelCode")));
                rebUpointsOpDomain.setTenantCode(tenantCode);
                this.rebUpointsOpBaseService.saveUpointsOp(rebUpointsOpDomain);
                rebAdApplyDomain = new RebAdApplyDomain();
                oldAdApply = this.getAdApplyModelByCode(this.getQueryParamMap("adApplyCode", new Object[]{map.get("AdOp3")}));
                BeanUtils.copyAllPropertys((Object)rebAdApplyDomain, (Object)oldAdApply);
                rebAdApplyDomain.setToVerifyAmount(oldAdApply.getToVerifyAmount().subtract(new BigDecimal(String.valueOf(map.get("AdOp1")))));
                this.updateRebAdApply(rebAdApplyDomain);
                this.updateRebAdApplyState(oldAdApply.getAdApplyId(), RebConstants.AD_APPLY_STATUS_TO_WRITTEN_OFF, RebConstants.AD_APPLY_STATUS_APPROVED, new HashMap<String, Object>());
            }
            if (Objects.equals(dataState, RebConstants.AD_APPLY_STATUS_REJECTED) && map.containsKey("AdOp1") && map.get("AdOp6").equals("2")) {
                rebUpointsOpDomain = new RebUpointsOpDomain();
                rebUpointsOpDomain.setUpointsOpType("12");
                rebUpointsOpDomain.setUpointsType("1");
                rebUpointsOpDomain.setMemberCode(String.valueOf(map.get("dealerCode")));
                rebUpointsOpDomain.setUpointsOpNum(new BigDecimal(String.valueOf(map.get("AdOp1"))));
                rebUpointsOpDomain.setChannelCode(String.valueOf(map.get("channelCode")));
                rebUpointsOpDomain.setTenantCode(tenantCode);
                this.rebUpointsOpBaseService.saveUpointsOp(rebUpointsOpDomain);
                rebAdApplyDomain = new RebAdApplyDomain();
                oldAdApply = this.getAdApplyModelByCode(this.getQueryParamMap("adApplyCode", new Object[]{map.get("AdOp3")}));
                BeanUtils.copyAllPropertys((Object)rebAdApplyDomain, (Object)oldAdApply);
                rebAdApplyDomain.setToVerifyAmount(oldAdApply.getToVerifyAmount().add(new BigDecimal(String.valueOf(map.get("AdOp1")))));
                this.updateRebAdApply(rebAdApplyDomain);
                this.updateRebAdApplyState(oldAdApply.getAdApplyId(), RebConstants.AD_APPLY_STATUS_APPROVED, RebConstants.AD_APPLY_STATUS_TO_WRITTEN_OFF, new HashMap<String, Object>());
            }
            if (Objects.equals(dataState, RebConstants.AD_APPLY_STATUS_APPROVED) && map.containsKey("AdOp1") && map.get("AdOp6").equals("2")) {
                rebUpointsOpDomain = new RebUpointsOpDomain();
                rebUpointsOpDomain.setUpointsOpType("11");
                rebUpointsOpDomain.setUpointsType("1");
                rebUpointsOpDomain.setMemberCode(String.valueOf(map.get("dealerCode")));
                rebUpointsOpDomain.setUpointsOpNum(new BigDecimal(String.valueOf(map.get("AdOp1"))));
                rebUpointsOpDomain.setChannelCode(String.valueOf(map.get("channelCode")));
                rebUpointsOpDomain.setTenantCode(tenantCode);
                this.rebUpointsOpBaseService.saveUpointsOp(rebUpointsOpDomain);
                rebAdApplyDomain = new RebAdApplyDomain();
                oldAdApply = this.getAdApplyModelByCode(this.getQueryParamMap("adApplyCode", new Object[]{map.get("AdOp3")}));
                BeanUtils.copyAllPropertys((Object)rebAdApplyDomain, (Object)oldAdApply);
                rebAdApplyDomain.setVerifiedAmount(oldAdApply.getVerifiedAmount().add(new BigDecimal(String.valueOf(map.get("AdOp1")))));
                this.updateRebAdApply(rebAdApplyDomain);
                if (rebAdApplyDomain.getVerifiedAmount().compareTo(new BigDecimal(oldAdApply.getAdOp1())) == 0) {
                    Integer dataState1 = oldAdApply.getDataState();
                    if (RebConstants.AD_APPLY_STATUS_TO_WRITTEN_OFF.equals(dataState1) || RebConstants.AD_APPLY_STATUS_PARTIAL_WRITTEN_OFF.equals(dataState1)) {
                        this.updateRebAdApplyState(oldAdApply.getAdApplyId(), RebConstants.AD_APPLY_STATUS_COMPLETED, null, new HashMap<String, Object>());
                    }
                } else {
                    this.updateRebAdApplyState(oldAdApply.getAdApplyId(), RebConstants.AD_APPLY_STATUS_PARTIAL_WRITTEN_OFF, RebConstants.AD_APPLY_STATUS_TO_WRITTEN_OFF, new HashMap<String, Object>());
                }
            }
            i = this.rebAdApplyMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("reb.RebAdApplyServiceImpl.updateStateAdApplyModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("reb.RebAdApplyServiceImpl.updateStateAdApplyModelByCode.null");
        }
    }

    private RebAdApply makeAdApply(RebAdApplyDomain rebAdApplyDomain, RebAdApply rebAdApply) {
        if (null == rebAdApplyDomain) {
            return null;
        }
        if (null == rebAdApply) {
            rebAdApply = new RebAdApply();
        }
        try {
            BeanUtils.copyAllPropertys((Object)rebAdApply, (Object)rebAdApplyDomain);
            return rebAdApply;
        }
        catch (Exception e) {
            this.logger.error("reb.RebAdApplyServiceImpl.makeAdApply", (Throwable)e);
            return null;
        }
    }

    private RebAdApplyReDomain makeRebAdApplyReDomain(RebAdApply rebAdApply) {
        if (null == rebAdApply) {
            return null;
        }
        RebAdApplyReDomain rebAdApplyReDomain = new RebAdApplyReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)rebAdApplyReDomain, (Object)rebAdApply);
            return rebAdApplyReDomain;
        }
        catch (Exception e) {
            this.logger.error("reb.RebAdApplyServiceImpl.makeRebAdApplyReDomain", (Throwable)e);
            return null;
        }
    }

    private List<RebAdApply> queryAdApplyModelPage(Map<String, Object> parammap) {
        try {
            return this.rebAdApplyMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("reb.RebAdApplyServiceImpl.queryAdApplyModel", (Throwable)e);
            return null;
        }
    }

    private int countAdApply(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.rebAdApplyMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("reb.RebAdApplyServiceImpl.countAdApply", (Throwable)e);
        }
        return i;
    }

    private RebAdApply createRebAdApply(RebAdApplyDomain rebAdApplyDomain) {
        String msg = this.checkAdApply(rebAdApplyDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("reb.RebAdApplyServiceImpl.saveAdApply.checkAdApply", msg);
        }
        RebAdApply rebAdApply = this.makeAdApply(rebAdApplyDomain, null);
        this.setAdApplyDefault(rebAdApply);
        return rebAdApply;
    }

    @Override
    public String saveRebAdApply(RebAdApplyDomain rebAdApplyDomain) throws ApiException {
        RebAdApply rebAdApply = this.createRebAdApply(rebAdApplyDomain);
        this.saveRebAdApplyModel(rebAdApply);
        return rebAdApply.getAdApplyCode();
    }

    @Override
    public String saveRebAdApplyBatch(List<RebAdApplyDomain> rebAdApplyDomainList) throws ApiException {
        if (null == rebAdApplyDomainList || rebAdApplyDomainList.isEmpty()) {
            return null;
        }
        ArrayList<RebAdApply> rebAdApplyList = new ArrayList<RebAdApply>();
        String code = "";
        for (RebAdApplyDomain rebAdApplyDomain : rebAdApplyDomainList) {
            RebAdApply rebAdApply = this.createRebAdApply(rebAdApplyDomain);
            code = rebAdApply.getAdApplyCode();
            rebAdApplyList.add(rebAdApply);
        }
        this.saveAdApplyBatchModel(rebAdApplyList);
        return code;
    }

    @Override
    public void updateRebAdApplyState(Long adApplyId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == adApplyId) {
            return;
        }
        this.updateStateAdApplyModel(adApplyId, dataState, oldDataState, map);
    }

    @Override
    public void updateRebAdApplyStateByCode(String tenantCode, String adApplyCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)adApplyCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateAdApplyModelByCode(tenantCode, adApplyCode, dataState, oldDataState, map);
    }

    @Override
    public void updateRebAdApply(RebAdApplyDomain rebAdApplyDomain) throws ApiException {
        String msg = this.checkAdApply(rebAdApplyDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("reb.RebAdApplyServiceImpl.updateAdApply.checkAdApply", msg);
        }
        RebAdApply oldRebAdApply = null;
        if (rebAdApplyDomain.getAdApplyId() != null) {
            oldRebAdApply = this.getAdApplyModelById(rebAdApplyDomain.getAdApplyId());
        } else if (StringUtils.isNotBlank((String)rebAdApplyDomain.getAdApplyCode())) {
            oldRebAdApply = this.getAdApplyModelByCode(this.getQueryParamMap("adApplyCode", new Object[]{rebAdApplyDomain.getAdApplyCode()}));
        }
        if (null == oldRebAdApply) {
            throw new ApiException("reb.RebAdApplyServiceImpl.updateAdApply.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        RebAdApply rebAdApply = this.makeAdApply(rebAdApplyDomain, oldRebAdApply);
        this.setAdApplyUpdataDefault(rebAdApply);
        this.updateAdApplyModel(rebAdApply);
    }

    @Override
    public RebAdApply getRebAdApply(Long adApplyId) {
        if (null == adApplyId) {
            return null;
        }
        return this.getAdApplyModelById(adApplyId);
    }

    @Override
    public void deleteRebAdApply(Long adApplyId) throws ApiException {
        if (null == adApplyId) {
            return;
        }
        this.deleteAdApplyModel(adApplyId);
    }

    @Override
    public QueryResult<RebAdApply> queryRebAdApplyPage(Map<String, Object> map) {
        List<RebAdApply> rebAdApplyList = this.queryAdApplyModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countAdApply(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(rebAdApplyList);
        return queryResult;
    }

    @Override
    public RebAdApply getRebAdApplyByCode(String tenantCode, String adApplyCode) throws ApiException {
        if (StringUtils.isBlank((String)adApplyCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("adApplyCode", adApplyCode);
        return this.getAdApplyModelByCode(map);
    }

    @Override
    public void deleteRebAdApplyByCode(String tenantCode, String adApplyCode) throws ApiException {
        if (StringUtils.isBlank((String)adApplyCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("adApplyCode", adApplyCode);
        this.delAdApplyModelByCode(map);
    }
}

