/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.resources.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.resources.dao.RsUserSkunoMapper;
import com.yqbsoft.laser.service.resources.domain.RsUserSkunoDomain;
import com.yqbsoft.laser.service.resources.domain.RsUserSkunoReDomain;
import com.yqbsoft.laser.service.resources.model.RsUserSkuno;
import com.yqbsoft.laser.service.resources.service.RsUserSkunoService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RsUserSkunoServiceImpl
extends BaseServiceImpl
implements RsUserSkunoService {
    private static final String SYS_CODE = "rs.RsUserSkunoServiceImpl";
    private RsUserSkunoMapper rsUserSkunoMapper;

    public void setRsUserSkunoMapper(RsUserSkunoMapper rsUserSkunoMapper) {
        this.rsUserSkunoMapper = rsUserSkunoMapper;
    }

    private Date getSysDate() {
        try {
            return this.rsUserSkunoMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("rs.RsUserSkunoServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkUserSkuno(RsUserSkunoDomain rsUserSkunoDomain) {
        if (null == rsUserSkunoDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)rsUserSkunoDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setUserSkunoDefault(RsUserSkuno rsUserSkuno) {
        if (null == rsUserSkuno) {
            return;
        }
        if (null == rsUserSkuno.getDataState()) {
            rsUserSkuno.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == rsUserSkuno.getGmtCreate()) {
            rsUserSkuno.setGmtCreate(date);
        }
        rsUserSkuno.setGmtModified(date);
        if (StringUtils.isBlank((String)rsUserSkuno.getUserSkunoCode())) {
            rsUserSkuno.setUserSkunoCode(this.getNo(null, "RsUserSkuno", "rsUserSkuno", rsUserSkuno.getTenantCode()));
        }
    }

    private int getUserSkunoMaxCode() {
        int code = 0;
        try {
            return this.rsUserSkunoMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("rs.RsUserSkunoServiceImpl.getUserSkunoMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setUserSkunoUpdataDefault(RsUserSkuno rsUserSkuno) {
        if (null == rsUserSkuno) {
            return;
        }
        rsUserSkuno.setGmtModified(this.getSysDate());
    }

    private void saveUserSkunoModel(RsUserSkuno rsUserSkuno) throws ApiException {
        if (null == rsUserSkuno) {
            return;
        }
        try {
            this.rsUserSkunoMapper.insert(rsUserSkuno);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsUserSkunoServiceImpl.saveUserSkunoModel.ex", (Throwable)e);
        }
    }

    private void saveUserSkunoBatchModel(List<RsUserSkuno> rsUserSkunoList) throws ApiException {
        if (null == rsUserSkunoList || rsUserSkunoList.isEmpty()) {
            return;
        }
        try {
            this.rsUserSkunoMapper.insertBatch(rsUserSkunoList);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsUserSkunoServiceImpl.saveUserSkunoBatchModel.ex", (Throwable)e);
        }
    }

    private RsUserSkuno getUserSkunoModelById(Integer userSkunoId) {
        if (null == userSkunoId) {
            return null;
        }
        try {
            return this.rsUserSkunoMapper.selectByPrimaryKey(userSkunoId);
        }
        catch (Exception e) {
            this.logger.error("rs.RsUserSkunoServiceImpl.getUserSkunoModelById", (Throwable)e);
            return null;
        }
    }

    private RsUserSkuno getUserSkunoModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.rsUserSkunoMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RsUserSkunoServiceImpl.getUserSkunoModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delUserSkunoModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.rsUserSkunoMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsUserSkunoServiceImpl.delUserSkunoModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rs.RsUserSkunoServiceImpl.delUserSkunoModelByCode.num");
        }
    }

    private void deleteUserSkunoModel(Integer userSkunoId) throws ApiException {
        if (null == userSkunoId) {
            return;
        }
        int i = 0;
        try {
            i = this.rsUserSkunoMapper.deleteByPrimaryKey(userSkunoId);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsUserSkunoServiceImpl.deleteUserSkunoModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rs.RsUserSkunoServiceImpl.deleteUserSkunoModel.num");
        }
    }

    private void updateUserSkunoModel(RsUserSkuno rsUserSkuno) throws ApiException {
        if (null == rsUserSkuno) {
            return;
        }
        int i = 0;
        try {
            i = this.rsUserSkunoMapper.updateByPrimaryKey(rsUserSkuno);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsUserSkunoServiceImpl.updateUserSkunoModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rs.RsUserSkunoServiceImpl.updateUserSkunoModel.num");
        }
    }

    private void updateStateUserSkunoModel(Integer userSkunoId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == userSkunoId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("userSkunoId", userSkunoId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.rsUserSkunoMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsUserSkunoServiceImpl.updateStateUserSkunoModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("rs.RsUserSkunoServiceImpl.updateStateUserSkunoModel.null");
        }
    }

    private void updateStateUserSkunoModelByCode(String tenantCode, String userSkunoCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)userSkunoCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("userSkunoCode", userSkunoCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.rsUserSkunoMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsUserSkunoServiceImpl.updateStateUserSkunoModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("rs.RsUserSkunoServiceImpl.updateStateUserSkunoModelByCode.null");
        }
    }

    private RsUserSkuno makeUserSkuno(RsUserSkunoDomain rsUserSkunoDomain, RsUserSkuno rsUserSkuno) {
        if (null == rsUserSkunoDomain) {
            return null;
        }
        if (null == rsUserSkuno) {
            rsUserSkuno = new RsUserSkuno();
        }
        try {
            BeanUtils.copyAllPropertys((Object)rsUserSkuno, (Object)rsUserSkunoDomain);
            return rsUserSkuno;
        }
        catch (Exception e) {
            this.logger.error("rs.RsUserSkunoServiceImpl.makeUserSkuno", (Throwable)e);
            return null;
        }
    }

    private RsUserSkunoReDomain makeRsUserSkunoReDomain(RsUserSkuno rsUserSkuno) {
        if (null == rsUserSkuno) {
            return null;
        }
        RsUserSkunoReDomain rsUserSkunoReDomain = new RsUserSkunoReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)rsUserSkunoReDomain, (Object)rsUserSkuno);
            return rsUserSkunoReDomain;
        }
        catch (Exception e) {
            this.logger.error("rs.RsUserSkunoServiceImpl.makeRsUserSkunoReDomain", (Throwable)e);
            return null;
        }
    }

    private List<RsUserSkuno> queryUserSkunoModelPage(Map<String, Object> parammap) {
        try {
            return this.rsUserSkunoMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("rs.RsUserSkunoServiceImpl.queryUserSkunoModel", (Throwable)e);
            return null;
        }
    }

    private int countUserSkuno(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.rsUserSkunoMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RsUserSkunoServiceImpl.countUserSkuno", (Throwable)e);
        }
        return i;
    }

    private RsUserSkuno createRsUserSkuno(RsUserSkunoDomain rsUserSkunoDomain) {
        String msg = this.checkUserSkuno(rsUserSkunoDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("rs.RsUserSkunoServiceImpl.saveUserSkuno.checkUserSkuno", msg);
        }
        RsUserSkuno rsUserSkuno = this.makeUserSkuno(rsUserSkunoDomain, null);
        this.setUserSkunoDefault(rsUserSkuno);
        return rsUserSkuno;
    }

    @Override
    public String saveUserSkuno(RsUserSkunoDomain rsUserSkunoDomain) throws ApiException {
        RsUserSkuno rsUserSkuno = this.createRsUserSkuno(rsUserSkunoDomain);
        this.saveUserSkunoModel(rsUserSkuno);
        return rsUserSkuno.getUserSkunoCode();
    }

    @Override
    public String saveUserSkunoBatch(List<RsUserSkunoDomain> rsUserSkunoDomainList) throws ApiException {
        if (null == rsUserSkunoDomainList || rsUserSkunoDomainList.isEmpty()) {
            return null;
        }
        ArrayList<RsUserSkuno> rsUserSkunoList = new ArrayList<RsUserSkuno>();
        String code = "";
        for (RsUserSkunoDomain rsUserSkunoDomain : rsUserSkunoDomainList) {
            RsUserSkuno rsUserSkuno = this.createRsUserSkuno(rsUserSkunoDomain);
            code = rsUserSkuno.getUserSkunoCode();
            rsUserSkunoList.add(rsUserSkuno);
        }
        this.saveUserSkunoBatchModel(rsUserSkunoList);
        return code;
    }

    @Override
    public void updateUserSkunoState(Integer userSkunoId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == userSkunoId) {
            return;
        }
        this.updateStateUserSkunoModel(userSkunoId, dataState, oldDataState, map);
    }

    @Override
    public void updateUserSkunoStateByCode(String tenantCode, String userSkunoCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)userSkunoCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateUserSkunoModelByCode(tenantCode, userSkunoCode, dataState, oldDataState, map);
    }

    @Override
    public void updateUserSkuno(RsUserSkunoDomain rsUserSkunoDomain) throws ApiException {
        String msg = this.checkUserSkuno(rsUserSkunoDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("rs.RsUserSkunoServiceImpl.updateUserSkuno.checkUserSkuno", msg);
        }
        RsUserSkuno oldRsUserSkuno = this.getUserSkunoModelById(rsUserSkunoDomain.getUserSkunoId());
        if (null == oldRsUserSkuno) {
            throw new ApiException("rs.RsUserSkunoServiceImpl.updateUserSkuno.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        RsUserSkuno rsUserSkuno = this.makeUserSkuno(rsUserSkunoDomain, oldRsUserSkuno);
        this.setUserSkunoUpdataDefault(rsUserSkuno);
        this.updateUserSkunoModel(rsUserSkuno);
    }

    @Override
    public RsUserSkuno getUserSkuno(Integer userSkunoId) {
        if (null == userSkunoId) {
            return null;
        }
        return this.getUserSkunoModelById(userSkunoId);
    }

    @Override
    public void deleteUserSkuno(Integer userSkunoId) throws ApiException {
        if (null == userSkunoId) {
            return;
        }
        this.deleteUserSkunoModel(userSkunoId);
    }

    @Override
    public QueryResult<RsUserSkuno> queryUserSkunoPage(Map<String, Object> map) {
        List<RsUserSkuno> rsUserSkunoList = this.queryUserSkunoModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countUserSkuno(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(rsUserSkunoList);
        return queryResult;
    }

    @Override
    public RsUserSkuno getUserSkunoByCode(String tenantCode, String userSkunoCode) throws ApiException {
        if (StringUtils.isBlank((String)userSkunoCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("userSkunoCode", userSkunoCode);
        return this.getUserSkunoModelByCode(map);
    }

    @Override
    public void deleteUserSkunoByCode(String tenantCode, String userSkunoCode) throws ApiException {
        if (StringUtils.isBlank((String)userSkunoCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("userSkunoCode", userSkunoCode);
        this.delUserSkunoModelByCode(map);
    }
}

