/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.resources.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.resources.dao.RsDisListMapper;
import com.yqbsoft.laser.service.resources.domain.RsDisListDomain;
import com.yqbsoft.laser.service.resources.domain.RsDisListReDomain;
import com.yqbsoft.laser.service.resources.model.RsDisList;
import com.yqbsoft.laser.service.resources.service.RsDisListService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RsDisListServiceImpl
extends BaseServiceImpl
implements RsDisListService {
    private static final String SYS_CODE = "rs.RsDisListServiceImpl";
    private RsDisListMapper rsDisListMapper;

    public void setRsDisListMapper(RsDisListMapper rsDisListMapper) {
        this.rsDisListMapper = rsDisListMapper;
    }

    private Date getSysDate() {
        try {
            return this.rsDisListMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("rs.RsDisListServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkRsDisList(RsDisListDomain rsDisListDomain) {
        if (null == rsDisListDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)rsDisListDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setRsDisListDefault(RsDisList rsDisList) {
        if (null == rsDisList) {
            return;
        }
        if (null == rsDisList.getDataState()) {
            rsDisList.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == rsDisList.getGmtCreate()) {
            rsDisList.setGmtCreate(date);
        }
        rsDisList.setGmtModified(date);
        if (StringUtils.isBlank((String)rsDisList.getDisListCode())) {
            rsDisList.setDisListCode(this.getNo(null, "RsDisList", "rsDisList", rsDisList.getTenantCode()));
        }
    }

    private int getRsDisListMaxCode() {
        int code = 0;
        try {
            return this.rsDisListMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("rs.RsDisListServiceImpl.getRsDisListMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setRsDisListUpdataDefault(RsDisList rsDisList) {
        if (null == rsDisList) {
            return;
        }
        rsDisList.setGmtModified(this.getSysDate());
    }

    private void saveRsDisListModel(RsDisList rsDisList) throws ApiException {
        if (null == rsDisList) {
            return;
        }
        try {
            this.rsDisListMapper.insert(rsDisList);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsDisListServiceImpl.saveRsDisListModel.ex", (Throwable)e);
        }
    }

    private void saveRsDisListBatchModel(List<RsDisList> rsDisListList) throws ApiException {
        if (null == rsDisListList || rsDisListList.isEmpty()) {
            return;
        }
        try {
            this.rsDisListMapper.insertBatch(rsDisListList);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsDisListServiceImpl.saveRsDisListBatchModel.ex", (Throwable)e);
        }
    }

    private RsDisList getRsDisListModelById(Integer disListId) {
        if (null == disListId) {
            return null;
        }
        try {
            return this.rsDisListMapper.selectByPrimaryKey(disListId);
        }
        catch (Exception e) {
            this.logger.error("rs.RsDisListServiceImpl.getRsDisListModelById", (Throwable)e);
            return null;
        }
    }

    private RsDisList getRsDisListModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.rsDisListMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RsDisListServiceImpl.getRsDisListModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delRsDisListModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.rsDisListMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsDisListServiceImpl.delRsDisListModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rs.RsDisListServiceImpl.delRsDisListModelByCode.num");
        }
    }

    private void deleteRsDisListModel(Integer disListId) throws ApiException {
        if (null == disListId) {
            return;
        }
        int i = 0;
        try {
            i = this.rsDisListMapper.deleteByPrimaryKey(disListId);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsDisListServiceImpl.deleteRsDisListModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rs.RsDisListServiceImpl.deleteRsDisListModel.num");
        }
    }

    private void updateRsDisListModel(RsDisList rsDisList) throws ApiException {
        if (null == rsDisList) {
            return;
        }
        int i = 0;
        try {
            i = this.rsDisListMapper.updateByPrimaryKey(rsDisList);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsDisListServiceImpl.updateRsDisListModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rs.RsDisListServiceImpl.updateRsDisListModel.num");
        }
    }

    private void updateStateRsDisListModel(Integer disListId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == disListId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("disListId", disListId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.rsDisListMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsDisListServiceImpl.updateStateRsDisListModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("rs.RsDisListServiceImpl.updateStateRsDisListModel.null");
        }
    }

    private void updateStateRsDisListModelByCode(String tenantCode, String disListCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)disListCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("disListCode", disListCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.rsDisListMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsDisListServiceImpl.updateStateRsDisListModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("rs.RsDisListServiceImpl.updateStateRsDisListModelByCode.null");
        }
    }

    private RsDisList makeRsDisList(RsDisListDomain rsDisListDomain, RsDisList rsDisList) {
        if (null == rsDisListDomain) {
            return null;
        }
        if (null == rsDisList) {
            rsDisList = new RsDisList();
        }
        try {
            BeanUtils.copyAllPropertys((Object)rsDisList, (Object)rsDisListDomain);
            return rsDisList;
        }
        catch (Exception e) {
            this.logger.error("rs.RsDisListServiceImpl.makeRsDisList", (Throwable)e);
            return null;
        }
    }

    private RsDisListReDomain makeRsDisListReDomain(RsDisList rsDisList) {
        if (null == rsDisList) {
            return null;
        }
        RsDisListReDomain rsDisListReDomain = new RsDisListReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)rsDisListReDomain, (Object)rsDisList);
            return rsDisListReDomain;
        }
        catch (Exception e) {
            this.logger.error("rs.RsDisListServiceImpl.makeRsDisListReDomain", (Throwable)e);
            return null;
        }
    }

    private List<RsDisList> queryRsDisListModelPage(Map<String, Object> parammap) {
        try {
            return this.rsDisListMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("rs.RsDisListServiceImpl.queryRsDisListModel", (Throwable)e);
            return null;
        }
    }

    private int countRsDisList(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.rsDisListMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RsDisListServiceImpl.countRsDisList", (Throwable)e);
        }
        return i;
    }

    private RsDisList createRsDisList(RsDisListDomain rsDisListDomain) {
        String msg = this.checkRsDisList(rsDisListDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("rs.RsDisListServiceImpl.saveRsDisList.checkRsDisList", msg);
        }
        RsDisList rsDisList = this.makeRsDisList(rsDisListDomain, null);
        this.setRsDisListDefault(rsDisList);
        return rsDisList;
    }

    @Override
    public String saveRsDisList(RsDisListDomain rsDisListDomain) throws ApiException {
        RsDisList rsDisList = this.createRsDisList(rsDisListDomain);
        this.saveRsDisListModel(rsDisList);
        return rsDisList.getDisListCode();
    }

    @Override
    public String saveRsDisListBatch(List<RsDisListDomain> rsDisListDomainList) throws ApiException {
        if (null == rsDisListDomainList || rsDisListDomainList.isEmpty()) {
            return null;
        }
        ArrayList<RsDisList> rsDisListList = new ArrayList<RsDisList>();
        String code = "";
        for (RsDisListDomain rsDisListDomain : rsDisListDomainList) {
            RsDisList rsDisList = this.createRsDisList(rsDisListDomain);
            code = rsDisList.getDisListCode();
            rsDisListList.add(rsDisList);
        }
        this.saveRsDisListBatchModel(rsDisListList);
        return code;
    }

    @Override
    public void updateRsDisListState(Integer disListId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == disListId) {
            return;
        }
        this.updateStateRsDisListModel(disListId, dataState, oldDataState, map);
    }

    @Override
    public void updateRsDisListStateByCode(String tenantCode, String disListCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)disListCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateRsDisListModelByCode(tenantCode, disListCode, dataState, oldDataState, map);
    }

    @Override
    public void updateRsDisList(RsDisListDomain rsDisListDomain) throws ApiException {
        String msg = this.checkRsDisList(rsDisListDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("rs.RsDisListServiceImpl.updateRsDisList.checkRsDisList", msg);
        }
        RsDisList oldRsDisList = this.getRsDisListModelById(rsDisListDomain.getDisListId());
        if (null == oldRsDisList) {
            throw new ApiException("rs.RsDisListServiceImpl.updateRsDisList.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        RsDisList rsDisList = this.makeRsDisList(rsDisListDomain, oldRsDisList);
        this.setRsDisListUpdataDefault(rsDisList);
        this.updateRsDisListModel(rsDisList);
    }

    @Override
    public RsDisList getRsDisList(Integer disListId) {
        if (null == disListId) {
            return null;
        }
        return this.getRsDisListModelById(disListId);
    }

    @Override
    public void deleteRsDisList(Integer disListId) throws ApiException {
        if (null == disListId) {
            return;
        }
        this.deleteRsDisListModel(disListId);
    }

    @Override
    public QueryResult<RsDisList> queryRsDisListPage(Map<String, Object> map) {
        List<RsDisList> rsDisListList = this.queryRsDisListModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countRsDisList(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(rsDisListList);
        return queryResult;
    }

    @Override
    public RsDisList getRsDisListByCode(String tenantCode, String disListCode) throws ApiException {
        if (StringUtils.isBlank((String)disListCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("disListCode", disListCode);
        return this.getRsDisListModelByCode(map);
    }

    @Override
    public void deleteRsDisListByCode(String tenantCode, String disListCode) throws ApiException {
        if (StringUtils.isBlank((String)disListCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("disListCode", disListCode);
        this.delRsDisListModelByCode(map);
    }
}

