/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.resources.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.resources.dao.RsGoodsBuyMapper;
import com.yqbsoft.laser.service.resources.domain.RsGoodsBuyDomain;
import com.yqbsoft.laser.service.resources.domain.RsGoodsBuyReDomain;
import com.yqbsoft.laser.service.resources.model.RsGoodsBuy;
import com.yqbsoft.laser.service.resources.service.RsGoodsBuyService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RsGoodsBuyServiceImpl
extends BaseServiceImpl
implements RsGoodsBuyService {
    private static final String SYS_CODE = "rs.RsGoodsBuyServiceImpl";
    private RsGoodsBuyMapper rsGoodsBuyMapper;

    public void setRsGoodsBuyMapper(RsGoodsBuyMapper rsGoodsBuyMapper) {
        this.rsGoodsBuyMapper = rsGoodsBuyMapper;
    }

    private Date getSysDate() {
        try {
            return this.rsGoodsBuyMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("rs.RsGoodsBuyServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkGoodsBuy(RsGoodsBuyDomain rsGoodsBuyDomain) {
        if (null == rsGoodsBuyDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)rsGoodsBuyDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setGoodsBuyDefault(RsGoodsBuy rsGoodsBuy) {
        if (null == rsGoodsBuy) {
            return;
        }
        if (null == rsGoodsBuy.getDataState()) {
            rsGoodsBuy.setDataState(0);
        }
        if (null == rsGoodsBuy.getGoodsBuyCode()) {
            rsGoodsBuy.setGoodsBuyType("0");
        }
        Date date = this.getSysDate();
        if (null == rsGoodsBuy.getGmtCreate()) {
            rsGoodsBuy.setGmtCreate(date);
        }
        rsGoodsBuy.setGmtModified(date);
        if (StringUtils.isBlank((String)rsGoodsBuy.getGoodsBuyCode())) {
            rsGoodsBuy.setGoodsBuyCode(this.getNo(null, "RsGoodsBuy", "rsGoodsBuy", rsGoodsBuy.getTenantCode()));
        }
    }

    private int getGoodsBuyMaxCode() {
        int code = 0;
        try {
            return this.rsGoodsBuyMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("rs.RsGoodsBuyServiceImpl.getGoodsBuyMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setGoodsBuyUpdataDefault(RsGoodsBuy rsGoodsBuy) {
        if (null == rsGoodsBuy) {
            return;
        }
        rsGoodsBuy.setGmtModified(this.getSysDate());
    }

    private void saveGoodsBuyModel(RsGoodsBuy rsGoodsBuy) throws ApiException {
        if (null == rsGoodsBuy) {
            return;
        }
        try {
            this.rsGoodsBuyMapper.insert(rsGoodsBuy);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsGoodsBuyServiceImpl.saveGoodsBuyModel.ex", (Throwable)e);
        }
    }

    private void saveGoodsBuyBatchModel(List<RsGoodsBuy> rsGoodsBuyList) throws ApiException {
        if (null == rsGoodsBuyList || rsGoodsBuyList.isEmpty()) {
            return;
        }
        try {
            this.rsGoodsBuyMapper.insertBatch(rsGoodsBuyList);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsGoodsBuyServiceImpl.saveGoodsBuyBatchModel.ex", (Throwable)e);
        }
    }

    private RsGoodsBuy getGoodsBuyModelById(Integer goodsBuyId) {
        if (null == goodsBuyId) {
            return null;
        }
        try {
            return this.rsGoodsBuyMapper.selectByPrimaryKey(goodsBuyId);
        }
        catch (Exception e) {
            this.logger.error("rs.RsGoodsBuyServiceImpl.getGoodsBuyModelById", (Throwable)e);
            return null;
        }
    }

    private RsGoodsBuy getGoodsBuyModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.rsGoodsBuyMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RsGoodsBuyServiceImpl.getGoodsBuyModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delGoodsBuyModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.rsGoodsBuyMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsGoodsBuyServiceImpl.delGoodsBuyModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rs.RsGoodsBuyServiceImpl.delGoodsBuyModelByCode.num");
        }
    }

    private void deleteGoodsBuyModel(Integer goodsBuyId) throws ApiException {
        if (null == goodsBuyId) {
            return;
        }
        int i = 0;
        try {
            i = this.rsGoodsBuyMapper.deleteByPrimaryKey(goodsBuyId);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsGoodsBuyServiceImpl.deleteGoodsBuyModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rs.RsGoodsBuyServiceImpl.deleteGoodsBuyModel.num");
        }
    }

    private void updateGoodsBuyModel(RsGoodsBuy rsGoodsBuy) throws ApiException {
        if (null == rsGoodsBuy) {
            return;
        }
        int i = 0;
        try {
            i = this.rsGoodsBuyMapper.updateByPrimaryKey(rsGoodsBuy);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsGoodsBuyServiceImpl.updateGoodsBuyModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rs.RsGoodsBuyServiceImpl.updateGoodsBuyModel.num");
        }
    }

    private void updateStateGoodsBuyModel(Integer goodsBuyId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == goodsBuyId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("goodsBuyId", goodsBuyId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.rsGoodsBuyMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsGoodsBuyServiceImpl.updateStateGoodsBuyModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("rs.RsGoodsBuyServiceImpl.updateStateGoodsBuyModel.null");
        }
    }

    private void updateStateGoodsBuyModelByCode(String tenantCode, String goodsBuyCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)goodsBuyCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("goodsBuyCode", goodsBuyCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.rsGoodsBuyMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsGoodsBuyServiceImpl.updateStateGoodsBuyModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("rs.RsGoodsBuyServiceImpl.updateStateGoodsBuyModelByCode.null");
        }
    }

    private RsGoodsBuy makeGoodsBuy(RsGoodsBuyDomain rsGoodsBuyDomain, RsGoodsBuy rsGoodsBuy) {
        if (null == rsGoodsBuyDomain) {
            return null;
        }
        if (null == rsGoodsBuy) {
            rsGoodsBuy = new RsGoodsBuy();
        }
        try {
            BeanUtils.copyAllPropertys((Object)rsGoodsBuy, (Object)rsGoodsBuyDomain);
            return rsGoodsBuy;
        }
        catch (Exception e) {
            this.logger.error("rs.RsGoodsBuyServiceImpl.makeGoodsBuy", (Throwable)e);
            return null;
        }
    }

    private RsGoodsBuyReDomain makeRsGoodsBuyReDomain(RsGoodsBuy rsGoodsBuy) {
        if (null == rsGoodsBuy) {
            return null;
        }
        RsGoodsBuyReDomain rsGoodsBuyReDomain = new RsGoodsBuyReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)rsGoodsBuyReDomain, (Object)rsGoodsBuy);
            return rsGoodsBuyReDomain;
        }
        catch (Exception e) {
            this.logger.error("rs.RsGoodsBuyServiceImpl.makeRsGoodsBuyReDomain", (Throwable)e);
            return null;
        }
    }

    private List<RsGoodsBuy> queryGoodsBuyModelPage(Map<String, Object> parammap) {
        try {
            return this.rsGoodsBuyMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("rs.RsGoodsBuyServiceImpl.queryGoodsBuyModel", (Throwable)e);
            return null;
        }
    }

    private int countGoodsBuy(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.rsGoodsBuyMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RsGoodsBuyServiceImpl.countGoodsBuy", (Throwable)e);
        }
        return i;
    }

    private RsGoodsBuy createRsGoodsBuy(RsGoodsBuyDomain rsGoodsBuyDomain) {
        String msg = this.checkGoodsBuy(rsGoodsBuyDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("rs.RsGoodsBuyServiceImpl.saveGoodsBuy.checkGoodsBuy", msg);
        }
        RsGoodsBuy rsGoodsBuy = this.makeGoodsBuy(rsGoodsBuyDomain, null);
        this.setGoodsBuyDefault(rsGoodsBuy);
        return rsGoodsBuy;
    }

    @Override
    public String saveGoodsBuy(RsGoodsBuyDomain rsGoodsBuyDomain) throws ApiException {
        RsGoodsBuy rsGoodsBuy = this.createRsGoodsBuy(rsGoodsBuyDomain);
        this.saveGoodsBuyModel(rsGoodsBuy);
        return rsGoodsBuy.getGoodsBuyCode();
    }

    @Override
    public String saveGoodsBuyBatch(List<RsGoodsBuyDomain> rsGoodsBuyDomainList) throws ApiException {
        if (null == rsGoodsBuyDomainList || rsGoodsBuyDomainList.isEmpty()) {
            return null;
        }
        ArrayList<RsGoodsBuy> rsGoodsBuyList = new ArrayList<RsGoodsBuy>();
        String code = "";
        RsGoodsBuyDomain goodsDomain = rsGoodsBuyDomainList.get(0);
        Map paramMap = this.getQueryParamMap("goodsBuyType,goodsCode,tenantCode", new Object[]{"0", goodsDomain.getGoodsCode(), goodsDomain.getTenantCode()});
        this.rsGoodsBuyMapper.delByGoodsCode(paramMap);
        for (RsGoodsBuyDomain rsGoodsBuyDomain : rsGoodsBuyDomainList) {
            RsGoodsBuy rsGoodsBuy = this.createRsGoodsBuy(rsGoodsBuyDomain);
            code = rsGoodsBuy.getGoodsBuyCode();
            rsGoodsBuyList.add(rsGoodsBuy);
        }
        this.saveGoodsBuyBatchModel(rsGoodsBuyList);
        return code;
    }

    @Override
    public void updateGoodsBuyState(Integer goodsBuyId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == goodsBuyId) {
            return;
        }
        this.updateStateGoodsBuyModel(goodsBuyId, dataState, oldDataState, map);
    }

    @Override
    public void updateGoodsBuyStateByCode(String tenantCode, String goodsBuyCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)goodsBuyCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateGoodsBuyModelByCode(tenantCode, goodsBuyCode, dataState, oldDataState, map);
    }

    @Override
    public void updateGoodsBuy(RsGoodsBuyDomain rsGoodsBuyDomain) throws ApiException {
        String msg = this.checkGoodsBuy(rsGoodsBuyDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("rs.RsGoodsBuyServiceImpl.updateGoodsBuy.checkGoodsBuy", msg);
        }
        RsGoodsBuy oldRsGoodsBuy = this.getGoodsBuyModelById(rsGoodsBuyDomain.getGoodsBuyId());
        if (null == oldRsGoodsBuy) {
            throw new ApiException("rs.RsGoodsBuyServiceImpl.updateGoodsBuy.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        RsGoodsBuy rsGoodsBuy = this.makeGoodsBuy(rsGoodsBuyDomain, oldRsGoodsBuy);
        this.setGoodsBuyUpdataDefault(rsGoodsBuy);
        this.updateGoodsBuyModel(rsGoodsBuy);
    }

    @Override
    public RsGoodsBuy getGoodsBuy(Integer goodsBuyId) {
        if (null == goodsBuyId) {
            return null;
        }
        return this.getGoodsBuyModelById(goodsBuyId);
    }

    @Override
    public void deleteGoodsBuy(Integer goodsBuyId) throws ApiException {
        if (null == goodsBuyId) {
            return;
        }
        this.deleteGoodsBuyModel(goodsBuyId);
    }

    @Override
    public QueryResult<RsGoodsBuy> queryGoodsBuyPage(Map<String, Object> map) {
        List<RsGoodsBuy> rsGoodsBuyList = this.queryGoodsBuyModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countGoodsBuy(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(rsGoodsBuyList);
        return queryResult;
    }

    @Override
    public RsGoodsBuy getGoodsBuyByCode(String tenantCode, String goodsBuyCode) throws ApiException {
        if (StringUtils.isBlank((String)goodsBuyCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("goodsBuyCode", goodsBuyCode);
        return this.getGoodsBuyModelByCode(map);
    }

    @Override
    public void deleteGoodsBuyByCode(String tenantCode, String goodsBuyCode) throws ApiException {
        if (StringUtils.isBlank((String)goodsBuyCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("goodsBuyCode", goodsBuyCode);
        this.delGoodsBuyModelByCode(map);
    }

    @Override
    public void deleteGoodsBuyBySkuCode(Map<String, Object> map) throws ApiException {
        if (MapUtil.isEmpty(map)) {
            return;
        }
        List<RsGoodsBuy> buylist = this.queryGoodsBuyModelPage(map);
        if (ListUtil.isEmpty(buylist)) {
            return;
        }
        for (RsGoodsBuy rsGoodsBuy : buylist) {
            this.deleteGoodsBuy(rsGoodsBuy.getGoodsBuyId());
        }
    }
}

