/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.resources.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.resources.dao.RsClasstreeContrastMapper;
import com.yqbsoft.laser.service.resources.domain.RsClasstreeContrastDomain;
import com.yqbsoft.laser.service.resources.domain.RsClasstreeContrastReDomain;
import com.yqbsoft.laser.service.resources.model.RsClasstreeContrast;
import com.yqbsoft.laser.service.resources.service.RsClasstreeContrastService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RsClasstreeContrastServiceImpl
extends BaseServiceImpl
implements RsClasstreeContrastService {
    private static final String SYS_CODE = "rs.RsClasstreeContrastServiceImpl";
    private RsClasstreeContrastMapper rsClasstreeContrastMapper;

    public void setRsClasstreeContrastMapper(RsClasstreeContrastMapper rsClasstreeContrastMapper) {
        this.rsClasstreeContrastMapper = rsClasstreeContrastMapper;
    }

    private Date getSysDate() {
        try {
            return this.rsClasstreeContrastMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("rs.RsClasstreeContrastServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkRsClasstreeContrast(RsClasstreeContrastDomain rsClasstreeContrastDomain) {
        if (null == rsClasstreeContrastDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)rsClasstreeContrastDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setRsClasstreeContrastDefault(RsClasstreeContrast rsClasstreeContrast) {
        if (null == rsClasstreeContrast) {
            return;
        }
        if (null == rsClasstreeContrast.getDataState()) {
            rsClasstreeContrast.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == rsClasstreeContrast.getGmtCreate()) {
            rsClasstreeContrast.setGmtCreate(date);
        }
        rsClasstreeContrast.setGmtModified(date);
        if (StringUtils.isBlank((String)rsClasstreeContrast.getClasstreeContrastCode())) {
            rsClasstreeContrast.setClasstreeContrastCode(this.getNo(null, "RsClasstreeContrast", "rsClasstreeContrast", rsClasstreeContrast.getTenantCode()));
        }
    }

    private int getRsClasstreeContrastMaxCode() {
        int code = 0;
        try {
            return this.rsClasstreeContrastMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("rs.RsClasstreeContrastServiceImpl.getRsClasstreeContrastMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setRsClasstreeContrastUpdataDefault(RsClasstreeContrast rsClasstreeContrast) {
        if (null == rsClasstreeContrast) {
            return;
        }
        rsClasstreeContrast.setGmtModified(this.getSysDate());
    }

    private void saveRsClasstreeContrastModel(RsClasstreeContrast rsClasstreeContrast) throws ApiException {
        if (null == rsClasstreeContrast) {
            return;
        }
        try {
            this.rsClasstreeContrastMapper.insert(rsClasstreeContrast);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsClasstreeContrastServiceImpl.saveRsClasstreeContrastModel.ex", (Throwable)e);
        }
    }

    private void saveRsClasstreeContrastBatchModel(List<RsClasstreeContrast> rsClasstreeContrastList) throws ApiException {
        if (null == rsClasstreeContrastList || rsClasstreeContrastList.isEmpty()) {
            return;
        }
        try {
            this.rsClasstreeContrastMapper.insertBatch(rsClasstreeContrastList);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsClasstreeContrastServiceImpl.saveRsClasstreeContrastBatchModel.ex", (Throwable)e);
        }
    }

    private RsClasstreeContrast getRsClasstreeContrastModelById(Integer classtreeContrastId) {
        if (null == classtreeContrastId) {
            return null;
        }
        try {
            return this.rsClasstreeContrastMapper.selectByPrimaryKey(classtreeContrastId);
        }
        catch (Exception e) {
            this.logger.error("rs.RsClasstreeContrastServiceImpl.getRsClasstreeContrastModelById", (Throwable)e);
            return null;
        }
    }

    private RsClasstreeContrast getRsClasstreeContrastModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.rsClasstreeContrastMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RsClasstreeContrastServiceImpl.getRsClasstreeContrastModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delRsClasstreeContrastModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.rsClasstreeContrastMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsClasstreeContrastServiceImpl.delRsClasstreeContrastModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rs.RsClasstreeContrastServiceImpl.delRsClasstreeContrastModelByCode.num");
        }
    }

    private void deleteRsClasstreeContrastModel(Integer classtreeContrastId) throws ApiException {
        if (null == classtreeContrastId) {
            return;
        }
        int i = 0;
        try {
            i = this.rsClasstreeContrastMapper.deleteByPrimaryKey(classtreeContrastId);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsClasstreeContrastServiceImpl.deleteRsClasstreeContrastModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rs.RsClasstreeContrastServiceImpl.deleteRsClasstreeContrastModel.num");
        }
    }

    private void updateRsClasstreeContrastModel(RsClasstreeContrast rsClasstreeContrast) throws ApiException {
        if (null == rsClasstreeContrast) {
            return;
        }
        int i = 0;
        try {
            i = this.rsClasstreeContrastMapper.updateByPrimaryKey(rsClasstreeContrast);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsClasstreeContrastServiceImpl.updateRsClasstreeContrastModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rs.RsClasstreeContrastServiceImpl.updateRsClasstreeContrastModel.num");
        }
    }

    private void updateStateRsClasstreeContrastModel(Integer classtreeContrastId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == classtreeContrastId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("classtreeContrastId", classtreeContrastId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.rsClasstreeContrastMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsClasstreeContrastServiceImpl.updateStateRsClasstreeContrastModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("rs.RsClasstreeContrastServiceImpl.updateStateRsClasstreeContrastModel.null");
        }
    }

    private void updateStateRsClasstreeContrastModelByCode(String tenantCode, String classtreeContrastCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)classtreeContrastCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("classtreeContrastCode", classtreeContrastCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.rsClasstreeContrastMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsClasstreeContrastServiceImpl.updateStateRsClasstreeContrastModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("rs.RsClasstreeContrastServiceImpl.updateStateRsClasstreeContrastModelByCode.null");
        }
    }

    private RsClasstreeContrast makeRsClasstreeContrast(RsClasstreeContrastDomain rsClasstreeContrastDomain, RsClasstreeContrast rsClasstreeContrast) {
        if (null == rsClasstreeContrastDomain) {
            return null;
        }
        if (null == rsClasstreeContrast) {
            rsClasstreeContrast = new RsClasstreeContrast();
        }
        try {
            BeanUtils.copyAllPropertys((Object)rsClasstreeContrast, (Object)rsClasstreeContrastDomain);
            return rsClasstreeContrast;
        }
        catch (Exception e) {
            this.logger.error("rs.RsClasstreeContrastServiceImpl.makeRsClasstreeContrast", (Throwable)e);
            return null;
        }
    }

    private RsClasstreeContrastReDomain makeRsClasstreeContrastReDomain(RsClasstreeContrast rsClasstreeContrast) {
        if (null == rsClasstreeContrast) {
            return null;
        }
        RsClasstreeContrastReDomain rsClasstreeContrastReDomain = new RsClasstreeContrastReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)rsClasstreeContrastReDomain, (Object)rsClasstreeContrast);
            return rsClasstreeContrastReDomain;
        }
        catch (Exception e) {
            this.logger.error("rs.RsClasstreeContrastServiceImpl.makeRsClasstreeContrastReDomain", (Throwable)e);
            return null;
        }
    }

    private List<RsClasstreeContrast> queryRsClasstreeContrastModelPage(Map<String, Object> parammap) {
        try {
            return this.rsClasstreeContrastMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("rs.RsClasstreeContrastServiceImpl.queryRsClasstreeContrastModel", (Throwable)e);
            return null;
        }
    }

    private int countRsClasstreeContrast(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.rsClasstreeContrastMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RsClasstreeContrastServiceImpl.countRsClasstreeContrast", (Throwable)e);
        }
        return i;
    }

    private RsClasstreeContrast createRsClasstreeContrast(RsClasstreeContrastDomain rsClasstreeContrastDomain) {
        String msg = this.checkRsClasstreeContrast(rsClasstreeContrastDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("rs.RsClasstreeContrastServiceImpl.saveRsClasstreeContrast.checkRsClasstreeContrast", msg);
        }
        RsClasstreeContrast rsClasstreeContrast = this.makeRsClasstreeContrast(rsClasstreeContrastDomain, null);
        this.setRsClasstreeContrastDefault(rsClasstreeContrast);
        return rsClasstreeContrast;
    }

    @Override
    public String saveRsClasstreeContrast(RsClasstreeContrastDomain rsClasstreeContrastDomain) throws ApiException {
        RsClasstreeContrast rsClasstreeContrast = this.createRsClasstreeContrast(rsClasstreeContrastDomain);
        this.saveRsClasstreeContrastModel(rsClasstreeContrast);
        return rsClasstreeContrast.getClasstreeContrastCode();
    }

    @Override
    public String saveRsClasstreeContrastBatch(List<RsClasstreeContrastDomain> rsClasstreeContrastDomainList) throws ApiException {
        if (null == rsClasstreeContrastDomainList || rsClasstreeContrastDomainList.isEmpty()) {
            return null;
        }
        ArrayList<RsClasstreeContrast> rsClasstreeContrastList = new ArrayList<RsClasstreeContrast>();
        String code = "";
        for (RsClasstreeContrastDomain rsClasstreeContrastDomain : rsClasstreeContrastDomainList) {
            RsClasstreeContrast rsClasstreeContrast = this.createRsClasstreeContrast(rsClasstreeContrastDomain);
            code = rsClasstreeContrast.getClasstreeContrastCode();
            rsClasstreeContrastList.add(rsClasstreeContrast);
        }
        this.saveRsClasstreeContrastBatchModel(rsClasstreeContrastList);
        return code;
    }

    @Override
    public void updateRsClasstreeContrastState(Integer classtreeContrastId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == classtreeContrastId) {
            return;
        }
        this.updateStateRsClasstreeContrastModel(classtreeContrastId, dataState, oldDataState, map);
    }

    @Override
    public void updateRsClasstreeContrastStateByCode(String tenantCode, String classtreeContrastCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)classtreeContrastCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateRsClasstreeContrastModelByCode(tenantCode, classtreeContrastCode, dataState, oldDataState, map);
    }

    @Override
    public void updateRsClasstreeContrast(RsClasstreeContrastDomain rsClasstreeContrastDomain) throws ApiException {
        String msg = this.checkRsClasstreeContrast(rsClasstreeContrastDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("rs.RsClasstreeContrastServiceImpl.updateRsClasstreeContrast.checkRsClasstreeContrast", msg);
        }
        RsClasstreeContrast oldRsClasstreeContrast = this.getRsClasstreeContrastModelById(rsClasstreeContrastDomain.getClasstreeContrastId());
        if (null == oldRsClasstreeContrast) {
            throw new ApiException("rs.RsClasstreeContrastServiceImpl.updateRsClasstreeContrast.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        RsClasstreeContrast rsClasstreeContrast = this.makeRsClasstreeContrast(rsClasstreeContrastDomain, oldRsClasstreeContrast);
        this.setRsClasstreeContrastUpdataDefault(rsClasstreeContrast);
        this.updateRsClasstreeContrastModel(rsClasstreeContrast);
    }

    @Override
    public RsClasstreeContrast getRsClasstreeContrast(Integer classtreeContrastId) {
        if (null == classtreeContrastId) {
            return null;
        }
        return this.getRsClasstreeContrastModelById(classtreeContrastId);
    }

    @Override
    public void deleteRsClasstreeContrast(Integer classtreeContrastId) throws ApiException {
        if (null == classtreeContrastId) {
            return;
        }
        this.deleteRsClasstreeContrastModel(classtreeContrastId);
    }

    @Override
    public QueryResult<RsClasstreeContrast> queryRsClasstreeContrastPage(Map<String, Object> map) {
        List<RsClasstreeContrast> rsClasstreeContrastList = this.queryRsClasstreeContrastModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countRsClasstreeContrast(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(rsClasstreeContrastList);
        return queryResult;
    }

    @Override
    public RsClasstreeContrast getRsClasstreeContrastByCode(String tenantCode, String classtreeContrastCode) throws ApiException {
        if (StringUtils.isBlank((String)classtreeContrastCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("classtreeContrastCode", classtreeContrastCode);
        return this.getRsClasstreeContrastModelByCode(map);
    }

    @Override
    public void deleteRsClasstreeContrastByCode(String tenantCode, String classtreeContrastCode) throws ApiException {
        if (StringUtils.isBlank((String)classtreeContrastCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("classtreeContrastCode", classtreeContrastCode);
        this.delRsClasstreeContrastModelByCode(map);
    }
}

