/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.resources.util;

import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class ThreadPoolUtil {
    private static volatile ThreadPoolExecutor threadPool;

    public static void execute(Runnable runnable) {
        ThreadPoolUtil.getThreadPool().execute(runnable);
    }

    public static <T> Future<T> submit(Callable<T> callable) {
        return ThreadPoolUtil.getThreadPool().submit(callable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ThreadPoolExecutor getThreadPool() {
        if (threadPool != null) return threadPool;
        Class<ThreadPoolUtil> clazz = ThreadPoolUtil.class;
        synchronized (ThreadPoolUtil.class) {
            if (threadPool != null) return threadPool;
            threadPool = new ThreadPoolExecutor(8, 16, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(64), new ThreadPoolExecutor.CallerRunsPolicy());
            // ** MonitorExit[var0] (shouldn't be in output)
            return threadPool;
        }
    }

    public static void main(String[] args) {
        ThreadPoolUtil.execute(() -> {
            try {
                Thread.sleep(300L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }
}

