/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.resources.service.impl;

import com.alibaba.fastjson.JSON;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.spring.ApplicationContextUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.resources.dao.RsClasstreeMapper;
import com.yqbsoft.laser.service.resources.domain.RsClasstreeDomain;
import com.yqbsoft.laser.service.resources.domain.RsClasstreeReDomain;
import com.yqbsoft.laser.service.resources.domain.RsSenddataDomain;
import com.yqbsoft.laser.service.resources.enums.ChannelCodeEnum;
import com.yqbsoft.laser.service.resources.model.RsClasstree;
import com.yqbsoft.laser.service.resources.model.RsSenddata;
import com.yqbsoft.laser.service.resources.service.RsClasstreeService;
import com.yqbsoft.laser.service.resources.service.RsSenddataBaseService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;

public class RsClasstreeServiceImpl
extends BaseServiceImpl
implements RsClasstreeService {
    private static final String SYS_CODE = "rs.RsClasstreeServiceImpl";
    private RsClasstreeMapper rsClasstreeMapper;
    RsSenddataBaseService rsSenddataBaseService;

    public RsClasstreeMapper getRsClasstreeMapper() {
        return this.rsClasstreeMapper;
    }

    public void setRsClasstreeMapper(RsClasstreeMapper rsClasstreeMapper) {
        this.rsClasstreeMapper = rsClasstreeMapper;
    }

    private Date getSysDate() {
        try {
            return this.rsClasstreeMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("rs.RsClasstreeServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkClasstree(RsClasstreeDomain rsClasstreeDomain) {
        if (null == rsClasstreeDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)rsClasstreeDomain.getClasstreeName())) {
            msg = msg + "ClasstreeName\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)rsClasstreeDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setClasstreeDefault(RsClasstree rsClasstree) {
        if (null == rsClasstree) {
            return;
        }
        if (null == rsClasstree.getDataState()) {
            rsClasstree.setDataState(0);
        }
        if (null == rsClasstree.getGmtCreate()) {
            rsClasstree.setGmtCreate(this.getSysDate());
        }
        rsClasstree.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)rsClasstree.getClasstreeCode())) {
            rsClasstree.setClasstreeCode(this.getNo(null, "RsClasstree", "classtreeCode", rsClasstree.getTenantCode()));
        }
        if (StringUtils.isBlank((String)rsClasstree.getClasstreeNo())) {
            rsClasstree.setClasstreeNo(this.getNo(null, "RsClasstree", "classtreeNo", rsClasstree.getTenantCode()));
        }
    }

    private int getClasstreeMaxCode() {
        int code = 0;
        try {
            return this.rsClasstreeMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("rs.RsClasstreeServiceImpl.getClasstreeMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setClasstreeUpdataDefault(RsClasstree rsClasstree) {
        if (null == rsClasstree) {
            return;
        }
        rsClasstree.setGmtModified(this.getSysDate());
    }

    private void saveClasstreeModel(RsClasstree rsClasstree) throws ApiException {
        if (null == rsClasstree) {
            return;
        }
        try {
            this.rsClasstreeMapper.insert(rsClasstree);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsClasstreeServiceImpl.saveClasstreeModel.ex", (Throwable)e);
        }
    }

    private void saveClasstreeListModel(List<RsClasstree> rsClasstrees) throws ApiException {
        if (ListUtil.isEmpty(rsClasstrees)) {
            return;
        }
        try {
            this.rsClasstreeMapper.insertBatch(rsClasstrees);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsClasstreeServiceImpl.saveClasstreeListModel.ex", (Throwable)e);
        }
    }

    private RsClasstree getClasstreeModelById(Integer classtreeId) {
        if (null == classtreeId) {
            return null;
        }
        try {
            return this.rsClasstreeMapper.selectByPrimaryKey(classtreeId);
        }
        catch (Exception e) {
            this.logger.error("rs.RsClasstreeServiceImpl.getClasstreeModelById", (Throwable)e);
            return null;
        }
    }

    public RsClasstree getClasstreeModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        if (null == map.get("channelCode") || StringUtils.isEmpty((String)((String)map.get("channelCode")))) {
            List<RsClasstree> rsClasstrees = this.queryClasstreeModelPage(map);
            for (RsClasstree rsClasstree : rsClasstrees) {
                if (!StringUtils.isBlank((String)rsClasstree.getChannelCode())) continue;
                return rsClasstree;
            }
        }
        try {
            return this.rsClasstreeMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RsClasstreeServiceImpl.getClasstreeModelByCode", (Object)(map + "=:=" + e));
            return null;
        }
    }

    public void delClasstreeModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.rsClasstreeMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsClasstreeServiceImpl.delClasstreeModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rs.RsClasstreeServiceImpl.delClasstreeModelByCode.num");
        }
    }

    private void deleteClasstreeModel(Integer classtreeId) throws ApiException {
        if (null == classtreeId) {
            return;
        }
        int i = 0;
        try {
            i = this.rsClasstreeMapper.deleteByPrimaryKey(classtreeId);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsClasstreeServiceImpl.deleteClasstreeModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rs.RsClasstreeServiceImpl.deleteClasstreeModel.num");
        }
    }

    private void updateClasstreeModel(RsClasstree rsClasstree) throws ApiException {
        if (null == rsClasstree) {
            return;
        }
        try {
            this.rsClasstreeMapper.updateByPrimaryKeySelective(rsClasstree);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsClasstreeServiceImpl.updateClasstreeModel.ex", (Throwable)e);
        }
    }

    private void updateStateClasstreeModel(Integer classtreeId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == classtreeId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("classtreeId", classtreeId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.rsClasstreeMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsClasstreeServiceImpl.updateStateClasstreeModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("rs.RsClasstreeServiceImpl.updateStateClasstreeModel.null");
        }
    }

    private RsClasstree makeClasstree(RsClasstreeDomain rsClasstreeDomain, RsClasstree rsClasstree) {
        if (null == rsClasstreeDomain) {
            return null;
        }
        if (null == rsClasstree) {
            rsClasstree = new RsClasstree();
        }
        try {
            BeanUtils.copyAllPropertys((Object)rsClasstree, (Object)rsClasstreeDomain);
            return rsClasstree;
        }
        catch (Exception e) {
            this.logger.error("rs.RsClasstreeServiceImpl.makeClasstree", (Throwable)e);
            return null;
        }
    }

    private List<RsClasstree> queryClasstreeModelPage(Map<String, Object> parammap) {
        try {
            return this.rsClasstreeMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("rs.RsClasstreeServiceImpl.queryClasstreeModel", (Throwable)e);
            return null;
        }
    }

    private int countClasstree(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.rsClasstreeMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RsClasstreeServiceImpl.countClasstree", (Throwable)e);
        }
        return i;
    }

    @Override
    public List<RsSenddata> saveClasstree(RsClasstreeDomain rsClasstreeDomain) throws ApiException {
        return this.saveClasstreeRe(rsClasstreeDomain, true);
    }

    public List<RsSenddata> saveClasstreeRe(RsClasstreeDomain rsClasstreeDomain, boolean flag) throws ApiException {
        String msg = this.checkClasstree(rsClasstreeDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("rs.RsClasstreeServiceImpl.saveClasstree.checkClasstree", msg);
        }
        RsClasstree rsClasstree = this.makeClasstree(rsClasstreeDomain, null);
        this.setClasstreeDefault(rsClasstree);
        this.saveClasstreeModel(rsClasstree);
        rsClasstreeDomain.setClasstreeCode(rsClasstree.getClasstreeCode());
        List<RsSenddata> reSenddate = this.processFLowDataForHtml(rsClasstree, "update");
        if (flag) {
            ArrayList<RsClasstree> rsClasstrees = new ArrayList<RsClasstree>();
            rsClasstrees.add(rsClasstree);
            List<RsSenddata> rsSenddata = this.saveSenddata(rsClasstrees, "add");
            if (null != rsSenddata) {
                reSenddate.addAll(rsSenddata);
            }
        }
        return reSenddate;
    }

    @Override
    public void saveClasstreeList(List<RsClasstreeDomain> rsClasstreeDomains) throws ApiException {
        if (ListUtil.isEmpty(rsClasstreeDomains)) {
            return;
        }
        ArrayList<RsClasstree> rsClasstrees = new ArrayList<RsClasstree>();
        for (RsClasstreeDomain rsClasstreeDomain : rsClasstreeDomains) {
            String msg = this.checkClasstree(rsClasstreeDomain);
            if (StringUtils.isNotBlank((String)msg)) {
                throw new ApiException("rs.RsClasstreeServiceImpl.saveClasstreeList.checkClasstree", msg);
            }
            RsClasstree rsClasstree = this.makeClasstree(rsClasstreeDomain, null);
            this.setClasstreeDefault(rsClasstree);
            rsClasstrees.add(rsClasstree);
        }
        if (ListUtil.isNotEmpty(rsClasstrees)) {
            this.saveClasstreeListModel(rsClasstrees);
        }
    }

    @Override
    public void updateClasstreeState(Integer classtreeId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateClasstreeModel(classtreeId, dataState, oldDataState);
    }

    @Override
    public List<RsSenddata> updateClasstree(RsClasstreeDomain rsClasstreeDomain) throws ApiException {
        String msg = this.checkClasstree(rsClasstreeDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("rs.RsClasstreeServiceImpl.updateClasstree.checkClasstree", msg);
        }
        RsClasstree oldRsClasstree = this.getClasstreeModelById(rsClasstreeDomain.getClasstreeId());
        if (null == oldRsClasstree) {
            throw new ApiException("rs.RsClasstreeServiceImpl.updateClasstree.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        RsClasstree rsClasstree = this.makeClasstree(rsClasstreeDomain, oldRsClasstree);
        this.setClasstreeUpdataDefault(rsClasstree);
        this.updateClasstreeModel(rsClasstree);
        rsClasstree = this.getClasstreeModelById(rsClasstreeDomain.getClasstreeId());
        ArrayList<RsClasstree> rsClasstrees = new ArrayList<RsClasstree>();
        rsClasstrees.add(rsClasstree);
        List<RsSenddata> rsSenddata = this.saveSenddata(rsClasstrees, "update");
        if (null == rsSenddata) {
            rsSenddata = new ArrayList<RsSenddata>();
        }
        return rsSenddata;
    }

    @Override
    public RsClasstree getClasstree(Integer classtreeId) {
        return this.getClasstreeModelById(classtreeId);
    }

    @Override
    public List<RsSenddata> deleteClasstree(Integer classtreeId) throws ApiException {
        RsClasstree rsClasstree = this.getClasstree(classtreeId);
        if (null == rsClasstree) {
            throw new ApiException("rs.RsClasstreeServiceImpl.deleteClasstree.null");
        }
        ArrayList<RsClasstree> rsBrands = new ArrayList<RsClasstree>();
        rsBrands.add(rsClasstree);
        List<RsSenddata> rsSenddata = this.saveSenddata(rsBrands, "delete");
        if (null == rsSenddata) {
            rsSenddata = new ArrayList<RsSenddata>();
        }
        this.deleteClasstreeModel(classtreeId);
        this.processFLowDataForHtml(rsClasstree, "deleteop");
        return rsSenddata;
    }

    private List<RsSenddata> saveSenddata(List<RsClasstree> rsClasstrees, String requestType) {
        if (ListUtil.isEmpty(rsClasstrees) || StringUtils.isBlank((String)requestType)) {
            return null;
        }
        ArrayList<RsSenddataDomain> rsSenddataDomainList = new ArrayList<RsSenddataDomain>();
        for (RsClasstree rsClasstree : rsClasstrees) {
            String fdBizcodestr = JsonUtil.buildNormalBinder().toJson((Object)rsClasstree);
            RsSenddataDomain rsSenddataDomain = new RsSenddataDomain();
            rsSenddataDomain.setEsrequestType(requestType);
            rsSenddataDomain.setMemberCode(rsClasstree.getMemberCode());
            rsSenddataDomain.setChannelCode(rsClasstree.getChannelCode());
            rsSenddataDomain.setTenantCode(rsClasstree.getTenantCode());
            rsSenddataDomain.setAppmanageIcode(rsClasstree.getAppmanageIcode());
            rsSenddataDomain.setFdBizcode(rsClasstree.getClasstreeNo());
            rsSenddataDomain.setFdBiztype("RsClasstree");
            rsSenddataDomain.setFdBizcodestr(fdBizcodestr);
            rsSenddataDomain.setFdState(rsClasstree.getDataState());
            rsSenddataDomain.setFdBizid(rsClasstree.getClasstreeId());
            rsSenddataDomainList.add(rsSenddataDomain);
        }
        return this.getRsSenddataBaseService().saveDatasendBatch(rsSenddataDomainList);
    }

    public RsClasstree getClasstreeModelByNo(Map<String, Object> map) {
        if (MapUtil.isEmpty(map)) {
            return null;
        }
        try {
            return this.rsClasstreeMapper.getByNo(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RsClasstreeServiceImpl.getClasstreeModelByNo", (Throwable)e);
            return null;
        }
    }

    @Override
    public QueryResult<RsClasstree> queryClasstreePage(Map<String, Object> map) {
        List<RsClasstree> rsClasstreeList = this.queryClasstreeModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countClasstree(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(rsClasstreeList);
        return queryResult;
    }

    @Override
    public List<RsClasstreeReDomain> queryClasstree(String memberCode, String tenantCode) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("memberCode", memberCode);
        map.put("tenantCode", tenantCode);
        map.put("classtreeParentcode", "-1");
        List<RsClasstree> rsClasstreeList = this.queryClasstreeModelPage(map);
        if (null == rsClasstreeList || rsClasstreeList.isEmpty()) {
            return null;
        }
        ArrayList<RsClasstreeReDomain> rsClasstreeReDomainList = new ArrayList<RsClasstreeReDomain>();
        for (RsClasstree rsClasstree : rsClasstreeList) {
            rsClasstreeReDomainList.add(this.makeRsClasstreeReDomain(rsClasstree));
        }
        return rsClasstreeReDomainList;
    }

    @Override
    public List<RsClasstreeReDomain> queryClasstreeByParent(String classtreeParentcode, String memberCode, String tenantCode) {
        if (StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        if (StringUtils.isBlank((String)classtreeParentcode)) {
            classtreeParentcode = "-1";
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("memberCode", memberCode);
        map.put("tenantCode", tenantCode);
        map.put("classtreeParentcode", classtreeParentcode);
        List<RsClasstree> rsClasstreeList = this.queryClasstreeModelPage(map);
        if (null == rsClasstreeList || rsClasstreeList.isEmpty()) {
            return null;
        }
        ArrayList<RsClasstreeReDomain> rsClasstreeReDomainList = new ArrayList<RsClasstreeReDomain>();
        for (RsClasstree rsClasstree : rsClasstreeList) {
            rsClasstreeReDomainList.add(this.makeRsClasstreeReDomain(rsClasstree));
        }
        return rsClasstreeReDomainList;
    }

    @Override
    public List<RsSenddata> deleteClasstreeByNo(String classtreeNo, String channelCode, String tenantCode) throws ApiException {
        List<RsClasstree> rsClasstrees;
        HashMap<String, Object> parammap = new HashMap<String, Object>();
        parammap.put("classtreeNo", classtreeNo);
        parammap.put("tenantCode", tenantCode);
        if (StringUtils.isNotBlank((String)channelCode)) {
            parammap.put("channelCode", channelCode);
        }
        if (null == (rsClasstrees = this.queryClasstreeModelPage(parammap)) || ListUtil.isEmpty(rsClasstrees)) {
            return null;
        }
        ArrayList<RsSenddata> rsSenddataList = new ArrayList<RsSenddata>();
        for (RsClasstree rsClasstree : rsClasstrees) {
            List<RsSenddata> rsSenddatas = this.deleteClasstree(rsClasstree.getClasstreeId());
            if (!ListUtil.isNotEmpty(rsSenddatas)) continue;
            rsSenddataList.addAll(rsSenddatas);
        }
        return rsSenddataList;
    }

    @Override
    public RsClasstreeDomain getClasstreeByNo(Map<String, Object> map) throws ApiException {
        return this.makeClassTreeDomain(this.getClasstreeModelByNo(map));
    }

    @Override
    public List<RsSenddata> updateBatchDisClasstree(List<RsClasstreeDomain> rsClasstreeDomains) throws ApiException {
        if (ListUtil.isEmpty(rsClasstreeDomains)) {
            return null;
        }
        ArrayList<RsSenddata> rsSenddataList = new ArrayList<RsSenddata>();
        for (RsClasstreeDomain rsClasstreeDomain : rsClasstreeDomains) {
            List<RsSenddata> rsSenddatas = this.updateClasstree(rsClasstreeDomain);
            if (!ListUtil.isNotEmpty(rsSenddatas)) continue;
            rsSenddataList.addAll(rsSenddatas);
        }
        return rsSenddataList;
    }

    @Override
    public List<RsSenddata> saveBatchDisClasstree(List<RsClasstreeDomain> rsClasstreeDomains) throws ApiException {
        if (ListUtil.isEmpty(rsClasstreeDomains)) {
            return null;
        }
        HashMap<String, Object> parammap = new HashMap<String, Object>();
        ArrayList<RsSenddata> rsSenddataList = new ArrayList<RsSenddata>();
        for (RsClasstreeDomain rsClasstreeDomain : rsClasstreeDomains) {
            List<RsSenddata> skursSenddataList;
            RsClasstreeDomain rctDomain;
            parammap.put("classtreeOldno", rsClasstreeDomain.getClasstreeOldno());
            parammap.put("tenantCode", rsClasstreeDomain.getTenantCode());
            parammap.put("channelCode", rsClasstreeDomain.getChannelCode());
            if (StringUtils.isBlank((String)rsClasstreeDomain.getChannelCode())) {
                parammap.put("memberCode", rsClasstreeDomain.getMemberCode());
            }
            if (null == (rctDomain = this.getClasstreeByNo(parammap))) {
                skursSenddataList = this.saveClasstree(rsClasstreeDomain);
                if (!ListUtil.isNotEmpty(skursSenddataList)) continue;
                rsSenddataList.addAll(skursSenddataList);
                continue;
            }
            rctDomain.setClasstreeName(rsClasstreeDomain.getClasstreeName());
            skursSenddataList = this.updateClasstree(rctDomain);
            if (!ListUtil.isNotEmpty(skursSenddataList)) continue;
            rsSenddataList.addAll(skursSenddataList);
        }
        return rsSenddataList;
    }

    @Override
    public RsClasstree checkClasstreeName(String classtreeName, String tenantCode) {
        return this.checkClasstreeNameByChannelCode(classtreeName, tenantCode, null);
    }

    @Override
    public RsClasstree checkClasstreeNameByChannelCode(String classtreeName, String tenantCode, String channelCode) {
        if (StringUtils.isBlank((String)classtreeName) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String classtreeLast = "0";
        Map paramMap = null;
        paramMap = channelCode == null ? this.getQueryMapParam("classtreeName,tenantCode,classtreeLast", new Object[]{classtreeName, tenantCode, classtreeLast}) : this.getQueryMapParam("classtreeName,tenantCode,classtreeLast,channelCode", new Object[]{classtreeName, tenantCode, classtreeLast, channelCode});
        this.logger.error("checkClasstreeNameByChannelCode->paramMap:" + JSON.toJSONString((Object)paramMap));
        List<RsClasstree> classtrees = this.rsClasstreeMapper.query(paramMap);
        this.logger.error("checkClasstreeNameByChannelCode->classtrees:" + JSON.toJSONString(classtrees));
        if (CollectionUtils.isEmpty(classtrees)) {
            return null;
        }
        return classtrees.get(0);
    }

    private RsClasstreeReDomain makeRsClasstreeReDomain(RsClasstree rsClasstree) {
        if (null == rsClasstree) {
            return null;
        }
        RsClasstreeReDomain rsClasstreeReDomain = new RsClasstreeReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)rsClasstreeReDomain, (Object)rsClasstree);
            rsClasstreeReDomain.setChildList(this.queryClasstreeParent(rsClasstree.getMemberCode(), rsClasstree.getTenantCode(), rsClasstree.getClasstreeCode()));
        }
        catch (Exception e) {
            return null;
        }
        return rsClasstreeReDomain;
    }

    private List<RsClasstreeReDomain> queryClasstreeParent(String memberCode, String tenantCode, String classtreeParentcode) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("memberCode", memberCode);
        map.put("tenantCode", tenantCode);
        map.put("classtreeParentcode", classtreeParentcode);
        List<RsClasstree> rsClasstreeList = this.queryClasstreeModelPage(map);
        if (null == rsClasstreeList || rsClasstreeList.isEmpty()) {
            return null;
        }
        ArrayList<RsClasstreeReDomain> rsClasstreeReDomainList = new ArrayList<RsClasstreeReDomain>();
        for (RsClasstree rsClasstree : rsClasstreeList) {
            rsClasstreeReDomainList.add(this.makeRsClasstreeReDomain(rsClasstree));
        }
        return rsClasstreeReDomainList;
    }

    @Override
    public RsClasstree getClasstreeByCode(Map<String, Object> map) {
        if (MapUtil.isEmpty(map)) {
            return null;
        }
        return this.getClasstreeModelByCode(map);
    }

    public RsClasstreeDomain getClasstreeDomainByCode(Map<String, Object> map) {
        if (MapUtil.isEmpty(map)) {
            return null;
        }
        return this.makeClassTreeDomain(this.getClasstreeModelByCode(map));
    }

    @Override
    public void delClasstreeByCode(Map<String, Object> map) throws ApiException {
        RsClasstree rsClasstree = this.getClasstreeByCode(map);
        this.delClasstreeModelByCode(map);
        this.processFLowDataForHtml(rsClasstree, "deleteop");
    }

    @Override
    public List<RsClasstree> queryClasstreeByCodeList(Map<String, Object> parammap) {
        if (null == parammap) {
            return null;
        }
        return this.queryClasstreeModelByCodeList(parammap);
    }

    private List<RsClasstree> queryClasstreeModelByCodeList(Map<String, Object> parammap) {
        try {
            return this.rsClasstreeMapper.queryClasstreeByCodeList(parammap);
        }
        catch (Exception e) {
            this.logger.error("rs.RsClasstreeServiceImpl.queryClasstreeByCodeList", (Throwable)e);
            return null;
        }
    }

    public RsSenddataBaseService getRsSenddataBaseService() {
        if (null == this.rsSenddataBaseService) {
            this.rsSenddataBaseService = (RsSenddataBaseService)ApplicationContextUtil.getService((String)"rsSenddataBaseService");
        }
        return this.rsSenddataBaseService;
    }

    public List<RsSenddata> processFLowDataForHtml(RsClasstree rsClasstree, String esrequestType) {
        if (null == rsClasstree) {
            return null;
        }
        ArrayList<RsSenddataDomain> rsFlowDataList = new ArrayList<RsSenddataDomain>();
        String fdBizcodestr = JsonUtil.buildNormalBinder().toJson((Object)rsClasstree);
        RsSenddataDomain rsFlowData = new RsSenddataDomain();
        int fdState = 0;
        if (esrequestType.equals("deleteop")) {
            fdState = -1;
        }
        rsFlowData.setFdBizcodestr(fdBizcodestr);
        rsFlowData.setEsrequestType("update");
        rsFlowData.setTenantCode(rsClasstree.getTenantCode());
        rsFlowData.setFdBizcode(rsClasstree.getClasstreeCode());
        rsFlowData.setChannelCode(rsClasstree.getChannelCode());
        rsFlowData.setFdBiztype("RsClasstree");
        rsFlowData.setFdState(fdState);
        rsFlowDataList.add(rsFlowData);
        return this.getRsSenddataBaseService().saveDatasendBatch(rsFlowDataList);
    }

    @Override
    public List<RsSenddata> saveResourceInit(String tenantCode) throws ApiException {
        if (StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", "00000000");
        return this.classTreeInit(map, tenantCode);
    }

    @Override
    public List<RsSenddata> saveResourceByChannelInit(Map<String, Object> param) throws ApiException {
        String tenantCode = String.valueOf(param.get("tenantCode"));
        String channelCode = String.valueOf(param.get("channelCode"));
        String goodClass = String.valueOf(param.get("goodClass"));
        if (StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        if (StringUtils.isBlank((String)channelCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", "00000000");
        map.put("channelCode", ChannelCodeEnum.getChannelCode(goodClass));
        return this.classTreeByChannelInit(map, param);
    }

    private List<RsSenddata> classTreeInit(Map<String, Object> map, String tenantCode) {
        QueryResult<RsClasstree> rsClasstreeQueryResult = this.queryClasstreePage(map);
        List list = rsClasstreeQueryResult.getList();
        if (ListUtil.isEmpty((Collection)list)) {
            return null;
        }
        ArrayList<RsSenddata> rslist = new ArrayList<RsSenddata>();
        for (RsClasstree rsClasstree : list) {
            RsClasstree oldRsClasstree = this.getClasstreeByCode(this.getQueryMapParam("classtreeCode,tenantCode", new Object[]{rsClasstree.getClasstreeCode(), tenantCode}));
            if (null != oldRsClasstree) continue;
            RsClasstreeDomain rsClasstreeDomain = this.makeClassTreeDomain(rsClasstree);
            rsClasstreeDomain.setClasstreeId(null);
            rsClasstreeDomain.setTenantCode(tenantCode);
            List<RsSenddata> crslist = this.saveClasstreeRe(rsClasstreeDomain, false);
            if (!ListUtil.isNotEmpty(crslist)) continue;
            rslist.addAll(crslist);
        }
        return rslist;
    }

    private List<RsSenddata> classTreeByChannelInit(Map<String, Object> map, Map<String, Object> param) {
        String tenantCode = String.valueOf(param.get("tenantCode"));
        String channelCode = String.valueOf(param.get("channelCode"));
        String channelName = String.valueOf(param.get("channelName"));
        String memberCode = String.valueOf(param.get("memberCode"));
        String memberName = String.valueOf(param.get("memberName"));
        this.logger.info("rs.RsClasstreeServiceImpl.classTreeByChannelInit.map", map);
        QueryResult<RsClasstree> rsClasstreeQueryResult = this.queryClasstreePage(map);
        List list = rsClasstreeQueryResult.getList();
        if (ListUtil.isEmpty((Collection)list)) {
            return null;
        }
        ArrayList<RsSenddata> rslist = new ArrayList<RsSenddata>();
        for (RsClasstree rsClasstree : list) {
            RsClasstree oldRsClasstree = this.getClasstreeByCode(this.getQueryMapParam("classtreeCode,tenantCode,channelCode", new Object[]{rsClasstree.getClasstreeCode(), tenantCode, channelCode}));
            if (null != oldRsClasstree) continue;
            RsClasstreeDomain rsClasstreeDomain = this.makeClassTreeDomain(rsClasstree);
            rsClasstreeDomain.setClasstreeId(null);
            rsClasstreeDomain.setTenantCode(tenantCode);
            rsClasstreeDomain.setChannelCode(channelCode);
            rsClasstreeDomain.setChannelName(channelName);
            rsClasstreeDomain.setMemberCode(memberCode);
            rsClasstreeDomain.setMemberName(memberName);
            List<RsSenddata> crslist = this.saveClasstreeRe(rsClasstreeDomain, false);
            if (!ListUtil.isNotEmpty(crslist)) continue;
            rslist.addAll(crslist);
        }
        return rslist;
    }

    private RsClasstreeDomain makeClassTreeDomain(RsClasstree rsClasstree) {
        if (null == rsClasstree) {
            return null;
        }
        RsClasstreeDomain rsClasstreeDomain = new RsClasstreeDomain();
        try {
            BeanUtils.copyAllPropertys((Object)rsClasstreeDomain, (Object)rsClasstree);
            return rsClasstreeDomain;
        }
        catch (Exception e) {
            this.logger.error("rs.RsClasstreeServiceImpl.makeClassTreeDomain", (Throwable)e);
            return null;
        }
    }

    @Override
    public void processFLowDataForHtml(String tenantCode) {
    }

    @Override
    public void updateclasstreeParentcode(String classtreeCode, String classtreeParentcode, String tenantCode) throws ApiException {
        if (StringUtils.isBlank((String)classtreeCode) || StringUtils.isBlank((String)classtreeParentcode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("classtreeCode", classtreeCode);
        map.put("tenantCode", tenantCode);
        RsClasstree rsClasstree = this.getClasstreeModelByCode(map);
        RsClasstreeDomain rsClasstreeDomain = this.makeClassTreeDomain(rsClasstree);
        rsClasstreeDomain.setClasstreeParentcode(classtreeParentcode);
        this.updateClasstree(rsClasstreeDomain);
    }

    @Override
    public RsClasstree getClasstreeByName(String classtreeName, String tenantCode) {
        return this.getClasstreeModelByName(classtreeName, tenantCode);
    }

    @Override
    public void updateClasstreePtreeCode(String classtreeName, String pntreeCode, String tenantCode) throws ApiException {
        if (StringUtils.isBlank((String)classtreeName) || StringUtils.isBlank((String)pntreeCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        RsClasstree rsClasstree = this.getClasstreeModelByName(classtreeName, tenantCode);
        RsClasstreeDomain rsClasstreeDomain = this.makeClassTreeDomain(rsClasstree);
        rsClasstreeDomain.setPntreeCode(pntreeCode);
        try {
            this.updateClasstree(rsClasstreeDomain);
        }
        catch (ApiException e) {
            this.logger.error("rs.RsClasstreeServiceImpl.updateBrandState.e", (Object)"\u66f4\u65b0\u5931\u8d25============");
        }
    }

    public RsClasstree getClasstreeModelByName(String classtreeName, String tenantCode) {
        if (StringUtils.isEmpty((String)classtreeName) || StringUtils.isEmpty((String)tenantCode)) {
            throw new ApiException("rs.RsClasstreeServiceImpl.getClasstreeByName.null", "\u53c3\u6578\u4e3a\u7a7a");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("classtreeName", classtreeName);
        map.put("tenantCode", tenantCode);
        try {
            return this.rsClasstreeMapper.selectByName(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RsClasstreeServiceImpl.getClasstreeByName", (Throwable)e);
            return null;
        }
    }

    @Override
    public String getClasstreeFullName(String classtreeCode, String tenantCode) {
        String fullName = null;
        String fullCode = null;
        HashMap<String, Object> classMap = new HashMap<String, Object>();
        classMap.put("tenantCode", tenantCode);
        StringBuilder classtreeFullName = new StringBuilder();
        StringBuilder classtreeFullCode = new StringBuilder();
        while (!"-1".equals(classtreeCode)) {
            classMap.put("classtreeCode", classtreeCode);
            RsClasstree classtree = this.getClasstreeByCode(classMap);
            if (null == classtree) {
                return null;
            }
            classtreeFullName.insert(0, "/" + classtree.getClasstreeName());
            classtreeFullCode.insert(0, "/" + classtree.getClasstreeCode());
            classtreeCode = classtree.getClasstreeParentcode();
        }
        fullName = classtreeFullName.toString();
        fullCode = classtreeFullCode.toString();
        return fullCode.substring(1, fullCode.length()) + "," + fullName.substring(1, fullName.length());
    }

    @Override
    public RsClasstree getClasstreeByEocode(String classtreeEocode, String tenantCode) {
        return this.getClasstreeModelByEocode(classtreeEocode, tenantCode);
    }

    public RsClasstree getClasstreeModelByEocode(String classtreeEocode, String tenantCode) {
        if (StringUtils.isEmpty((String)classtreeEocode) || StringUtils.isEmpty((String)tenantCode)) {
            throw new ApiException("rs.RsClasstreeServiceImpl.getClasstreeModelByEocode.null", "\u53c3\u6578\u4e3a\u7a7a");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("classtreeEocode", classtreeEocode);
        map.put("tenantCode", tenantCode);
        try {
            return this.rsClasstreeMapper.selectByEocode(map);
        }
        catch (Exception e) {
            this.logger.warn("rs.RsClasstreeServiceImpl.getClasstreeModelByEocode", (Object)e);
            return null;
        }
    }

    @Override
    public List<RsSenddata> deleteClasstreeByCode(String classtreeCode, String channelCode, String tenantCode) throws ApiException {
        List<RsClasstree> rsClasstrees;
        if (StringUtils.isBlank((String)classtreeCode)) {
            return null;
        }
        HashMap<String, Object> parammap = new HashMap<String, Object>();
        parammap.put("classtreeCode", classtreeCode);
        parammap.put("tenantCode", tenantCode);
        if (StringUtils.isNotBlank((String)channelCode)) {
            parammap.put("channelCode", channelCode);
        }
        if (null == (rsClasstrees = this.queryClasstreeModelPage(parammap)) || ListUtil.isEmpty(rsClasstrees)) {
            return null;
        }
        ArrayList<RsSenddata> rsSenddataList = new ArrayList<RsSenddata>();
        for (RsClasstree rsClasstree : rsClasstrees) {
            List<RsSenddata> rsSenddatas = this.deleteClasstree(rsClasstree.getClasstreeId());
            if (!ListUtil.isNotEmpty(rsSenddatas)) continue;
            rsSenddataList.addAll(rsSenddatas);
        }
        return rsSenddataList;
    }

    @Override
    public List<RsClasstreeReDomain> queryClasstreeByChildCode(String classtreeCode, String tenantCode) {
        if (StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        if (StringUtils.isBlank((String)classtreeCode)) {
            return null;
        }
        return this.queryClasstreeByChild(classtreeCode, tenantCode);
    }

    private List<RsClasstreeReDomain> queryClasstreeByChild(String classtreeCode, String tenantCode) {
        if (StringUtils.isNotBlank((String)classtreeCode) || StringUtils.isNotBlank((String)tenantCode)) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("tenantCode", tenantCode);
            map.put("classtreeCode", classtreeCode);
            ArrayList<RsClasstreeReDomain> rsClasstreeReDomains = null;
            RsClasstreeReDomain rsClasstreeReDomain = null;
            List<RsClasstree> rsClasstreeList = this.queryClasstreeModelPage(map);
            if (ListUtil.isEmpty(rsClasstreeList)) {
                return null;
            }
            if (!"-1".equals(rsClasstreeList.get(0).getClasstreeParentcode())) {
                return this.queryClasstreeByChild(rsClasstreeList.get(0).getClasstreeParentcode(), tenantCode);
            }
            rsClasstreeReDomain = new RsClasstreeReDomain();
            RsClasstree rsClasstree = rsClasstreeList.get(0);
            try {
                BeanUtils.copyAllPropertysNotNull((Object)rsClasstreeReDomain, (Object)rsClasstree);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            rsClasstreeReDomains = new ArrayList<RsClasstreeReDomain>();
            rsClasstreeReDomains.add(rsClasstreeReDomain);
            return rsClasstreeReDomains;
        }
        return null;
    }
}

