/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.resources.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.resources.dao.RsStoreGoodsMapper;
import com.yqbsoft.laser.service.resources.domain.RsStoreGoodsDomain;
import com.yqbsoft.laser.service.resources.domain.RsStoreGoodsReDomain;
import com.yqbsoft.laser.service.resources.model.RsStoreGoods;
import com.yqbsoft.laser.service.resources.service.RsStoreGoodsService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RsStoreGoodsServiceImpl
extends BaseServiceImpl
implements RsStoreGoodsService {
    private static final String SYS_CODE = "rs.RsStoreGoodsServiceImpl";
    private RsStoreGoodsMapper rsStoreGoodsMapper;

    public void setRsStoreGoodsMapper(RsStoreGoodsMapper rsStoreGoodsMapper) {
        this.rsStoreGoodsMapper = rsStoreGoodsMapper;
    }

    private Date getSysDate() {
        try {
            return this.rsStoreGoodsMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("rs.RsStoreGoodsServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkStoreGoods(RsStoreGoodsDomain rsStoreGoodsDomain) {
        if (null == rsStoreGoodsDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)rsStoreGoodsDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setStoreGoodsDefault(RsStoreGoods rsStoreGoods) {
        if (null == rsStoreGoods) {
            return;
        }
        if (null == rsStoreGoods.getDataState()) {
            rsStoreGoods.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == rsStoreGoods.getGmtCreate()) {
            rsStoreGoods.setGmtCreate(date);
        }
        rsStoreGoods.setGmtModified(date);
        if (StringUtils.isBlank((String)rsStoreGoods.getStoreGoodsCode())) {
            rsStoreGoods.setStoreGoodsCode(this.getNo(null, "RsStoreGoods", "rsStoreGoods", rsStoreGoods.getTenantCode()));
        }
    }

    private int getStoreGoodsMaxCode() {
        int code = 0;
        try {
            return this.rsStoreGoodsMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("rs.RsStoreGoodsServiceImpl.getStoreGoodsMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setStoreGoodsUpdataDefault(RsStoreGoods rsStoreGoods) {
        if (null == rsStoreGoods) {
            return;
        }
        rsStoreGoods.setGmtModified(this.getSysDate());
    }

    private void saveStoreGoodsModel(RsStoreGoods rsStoreGoods) throws ApiException {
        if (null == rsStoreGoods) {
            return;
        }
        try {
            this.rsStoreGoodsMapper.insert(rsStoreGoods);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsStoreGoodsServiceImpl.saveStoreGoodsModel.ex", (Throwable)e);
        }
    }

    private void saveStoreGoodsBatchModel(List<RsStoreGoods> rsStoreGoodsList) throws ApiException {
        if (null == rsStoreGoodsList || rsStoreGoodsList.isEmpty()) {
            return;
        }
        try {
            this.rsStoreGoodsMapper.insertBatch(rsStoreGoodsList);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsStoreGoodsServiceImpl.saveStoreGoodsBatchModel.ex", (Throwable)e);
        }
    }

    private RsStoreGoods getStoreGoodsModelById(Integer storeGoodsId) {
        if (null == storeGoodsId) {
            return null;
        }
        try {
            return this.rsStoreGoodsMapper.selectByPrimaryKey(storeGoodsId);
        }
        catch (Exception e) {
            this.logger.error("rs.RsStoreGoodsServiceImpl.getStoreGoodsModelById", (Throwable)e);
            return null;
        }
    }

    private RsStoreGoods getStoreGoodsModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.rsStoreGoodsMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RsStoreGoodsServiceImpl.getStoreGoodsModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delStoreGoodsModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.rsStoreGoodsMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsStoreGoodsServiceImpl.delStoreGoodsModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rs.RsStoreGoodsServiceImpl.delStoreGoodsModelByCode.num");
        }
    }

    private void deleteStoreGoodsModel(Integer storeGoodsId) throws ApiException {
        if (null == storeGoodsId) {
            return;
        }
        int i = 0;
        try {
            i = this.rsStoreGoodsMapper.deleteByPrimaryKey(storeGoodsId);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsStoreGoodsServiceImpl.deleteStoreGoodsModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rs.RsStoreGoodsServiceImpl.deleteStoreGoodsModel.num");
        }
    }

    private void updateStoreGoodsModel(RsStoreGoods rsStoreGoods) throws ApiException {
        if (null == rsStoreGoods) {
            return;
        }
        int i = 0;
        try {
            i = this.rsStoreGoodsMapper.updateByPrimaryKey(rsStoreGoods);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsStoreGoodsServiceImpl.updateStoreGoodsModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rs.RsStoreGoodsServiceImpl.updateStoreGoodsModel.num");
        }
    }

    private void updateStateStoreGoodsModel(Integer storeGoodsId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == storeGoodsId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("storeGoodsId", storeGoodsId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.rsStoreGoodsMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsStoreGoodsServiceImpl.updateStateStoreGoodsModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("rs.RsStoreGoodsServiceImpl.updateStateStoreGoodsModel.null");
        }
    }

    private void updateStateStoreGoodsModelByCode(String tenantCode, String storeGoodsCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)storeGoodsCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("storeGoodsCode", storeGoodsCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.rsStoreGoodsMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsStoreGoodsServiceImpl.updateStateStoreGoodsModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("rs.RsStoreGoodsServiceImpl.updateStateStoreGoodsModelByCode.null");
        }
    }

    private RsStoreGoods makeStoreGoods(RsStoreGoodsDomain rsStoreGoodsDomain, RsStoreGoods rsStoreGoods) {
        if (null == rsStoreGoodsDomain) {
            return null;
        }
        if (null == rsStoreGoods) {
            rsStoreGoods = new RsStoreGoods();
        }
        try {
            BeanUtils.copyAllPropertys((Object)rsStoreGoods, (Object)rsStoreGoodsDomain);
            return rsStoreGoods;
        }
        catch (Exception e) {
            this.logger.error("rs.RsStoreGoodsServiceImpl.makeStoreGoods", (Throwable)e);
            return null;
        }
    }

    private RsStoreGoodsReDomain makeRsStoreGoodsReDomain(RsStoreGoods rsStoreGoods) {
        if (null == rsStoreGoods) {
            return null;
        }
        RsStoreGoodsReDomain rsStoreGoodsReDomain = new RsStoreGoodsReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)rsStoreGoodsReDomain, (Object)rsStoreGoods);
            return rsStoreGoodsReDomain;
        }
        catch (Exception e) {
            this.logger.error("rs.RsStoreGoodsServiceImpl.makeRsStoreGoodsReDomain", (Throwable)e);
            return null;
        }
    }

    private List<RsStoreGoods> queryStoreGoodsModelPage(Map<String, Object> parammap) {
        try {
            return this.rsStoreGoodsMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("rs.RsStoreGoodsServiceImpl.queryStoreGoodsModel", (Throwable)e);
            return null;
        }
    }

    private int countStoreGoods(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.rsStoreGoodsMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RsStoreGoodsServiceImpl.countStoreGoods", (Throwable)e);
        }
        return i;
    }

    private RsStoreGoods createRsStoreGoods(RsStoreGoodsDomain rsStoreGoodsDomain) {
        String msg = this.checkStoreGoods(rsStoreGoodsDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("rs.RsStoreGoodsServiceImpl.saveStoreGoods.checkStoreGoods", msg);
        }
        RsStoreGoods rsStoreGoods = this.makeStoreGoods(rsStoreGoodsDomain, null);
        this.setStoreGoodsDefault(rsStoreGoods);
        return rsStoreGoods;
    }

    @Override
    public String saveStoreGoods(RsStoreGoodsDomain rsStoreGoodsDomain) throws ApiException {
        RsStoreGoods rsStoreGoods = this.createRsStoreGoods(rsStoreGoodsDomain);
        this.saveStoreGoodsModel(rsStoreGoods);
        return rsStoreGoods.getStoreGoodsCode();
    }

    @Override
    public String saveStoreGoodsBatch(List<RsStoreGoodsDomain> rsStoreGoodsDomainList) throws ApiException {
        if (null == rsStoreGoodsDomainList || rsStoreGoodsDomainList.isEmpty()) {
            return null;
        }
        ArrayList<RsStoreGoods> rsStoreGoodsList = new ArrayList<RsStoreGoods>();
        String code = "";
        for (RsStoreGoodsDomain rsStoreGoodsDomain : rsStoreGoodsDomainList) {
            RsStoreGoods rsStoreGoods = this.createRsStoreGoods(rsStoreGoodsDomain);
            code = rsStoreGoods.getStoreGoodsCode();
            rsStoreGoodsList.add(rsStoreGoods);
        }
        this.saveStoreGoodsBatchModel(rsStoreGoodsList);
        return code;
    }

    @Override
    public void updateStoreGoodsState(Integer storeGoodsId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == storeGoodsId) {
            return;
        }
        this.updateStateStoreGoodsModel(storeGoodsId, dataState, oldDataState, map);
    }

    @Override
    public void updateStoreGoodsStateByCode(String tenantCode, String storeGoodsCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)storeGoodsCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateStoreGoodsModelByCode(tenantCode, storeGoodsCode, dataState, oldDataState, map);
    }

    @Override
    public void updateStoreGoods(RsStoreGoodsDomain rsStoreGoodsDomain) throws ApiException {
        String msg = this.checkStoreGoods(rsStoreGoodsDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("rs.RsStoreGoodsServiceImpl.updateStoreGoods.checkStoreGoods", msg);
        }
        RsStoreGoods oldRsStoreGoods = this.getStoreGoodsModelById(rsStoreGoodsDomain.getStoreGoodsId());
        if (null == oldRsStoreGoods) {
            throw new ApiException("rs.RsStoreGoodsServiceImpl.updateStoreGoods.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        RsStoreGoods rsStoreGoods = this.makeStoreGoods(rsStoreGoodsDomain, oldRsStoreGoods);
        this.setStoreGoodsUpdataDefault(rsStoreGoods);
        this.updateStoreGoodsModel(rsStoreGoods);
    }

    @Override
    public RsStoreGoods getStoreGoods(Integer storeGoodsId) {
        if (null == storeGoodsId) {
            return null;
        }
        return this.getStoreGoodsModelById(storeGoodsId);
    }

    @Override
    public void deleteStoreGoods(Integer storeGoodsId) throws ApiException {
        if (null == storeGoodsId) {
            return;
        }
        this.deleteStoreGoodsModel(storeGoodsId);
    }

    @Override
    public QueryResult<RsStoreGoods> queryStoreGoodsPage(Map<String, Object> map) {
        List<RsStoreGoods> rsStoreGoodsList = this.queryStoreGoodsModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countStoreGoods(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(rsStoreGoodsList);
        return queryResult;
    }

    @Override
    public RsStoreGoods getStoreGoodsByCode(String tenantCode, String storeGoodsCode) throws ApiException {
        if (StringUtils.isBlank((String)storeGoodsCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("storeGoodsCode", storeGoodsCode);
        return this.getStoreGoodsModelByCode(map);
    }

    @Override
    public void deleteStoreGoodsByCode(String tenantCode, String storeGoodsCode) throws ApiException {
        if (StringUtils.isBlank((String)storeGoodsCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("storeGoodsCode", storeGoodsCode);
        this.delStoreGoodsModelByCode(map);
    }
}

