/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.searchengine.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.yqbsoft.laser.service.esb.annotation.ApiMethod;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.log.performance.OpenPerfLogUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.searchengine.domain.AccurateQueryDomain;
import com.yqbsoft.laser.service.searchengine.domain.ReturnBean;
import com.yqbsoft.laser.service.searchengine.domain.SearchDomain;
import com.yqbsoft.laser.service.searchengine.domain.SortDomain;
import com.yqbsoft.laser.service.searchengine.domain.StoreDomain;
import com.yqbsoft.laser.service.searchengine.service.SearchengineService;
import com.yqbsoft.laser.service.searchengine.util.EsUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.index.query.TermQueryBuilder;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.collapse.CollapseBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.springframework.beans.factory.annotation.Autowired;

public class SearchengineServiceImpl
extends BaseServiceImpl
implements SearchengineService {
    private static final String SYS_CODE = "es.SearchengineServiceImpl";
    @Autowired
    EsUtil esUtil;
    private static final Pattern NUMBER_PATTERN = Pattern.compile("^\\d+$");
    private static final Pattern PINYIN_PATTERN = Pattern.compile("^[a-zA-Z]+$");
    private static final Pattern MIXED_PATTERN = Pattern.compile("^(?=.*[a-zA-Z])(?=.*[\\u4e00-\\u9fa5])[a-zA-Z\\u4e00-\\u9fa5]+$");
    private static final String search_all = "search_all";
    private static final String yushigui = "yushigui";
    private static final String yushiju = "yushiju";

    private static Collection<String> list2string(List<String> params, boolean flag) {
        if (ListUtil.isEmpty(params)) {
            return null;
        }
        ArrayList<String> res = new ArrayList<String>();
        for (String s : params) {
            if (StringUtils.isBlank((String)s) || "null".equals(s)) continue;
            if (!flag && null != s) {
                s = s.toLowerCase();
            }
            res.add(s);
        }
        return res;
    }

    @Override
    public boolean storeBatch(List<StoreDomain> storeDomainList) throws ApiException {
        if (ListUtil.isEmpty(storeDomainList)) {
            this.logger.error("es.SearchengineServiceImpl.storeBatch", (Object)"isnull");
            return false;
        }
        try {
            long start = System.currentTimeMillis();
            boolean flag = this.esUtil.bluk(storeDomainList);
            this.logger.info("es.SearchengineServiceImpl.storeBatch.\u8017\u65f6", (Object)(System.currentTimeMillis() - start));
            return flag;
        }
        catch (Exception e) {
            this.logger.error("es.SearchengineServiceImpl.storeBatch.storeDomainList", (Object)JsonUtil.buildNormalBinder().toJson(storeDomainList));
            this.logger.error("es.SearchengineServiceImpl.storeBatch", (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean store(StoreDomain storeDomain) throws ApiException {
        if (null == storeDomain || StringUtils.isBlank((String)storeDomain.getTenantCode()) || StringUtils.isBlank((String)storeDomain.getRequestType())) {
            return false;
        }
        ArrayList<StoreDomain> storeDomainList = new ArrayList<StoreDomain>();
        storeDomainList.add(storeDomain);
        return this.storeBatch(storeDomainList);
    }

    @Override
    public Map<String, Object> findByCode(String opcode, String bizType, String tenantCode) throws ApiException {
        if (StringUtils.isBlank((String)opcode) || StringUtils.isBlank((String)bizType) || StringUtils.isBlank((String)tenantCode)) {
            this.logger.error("es.SearchengineServiceImpl.findByCode.null", (Object)"null");
            return null;
        }
        try {
            long times = System.currentTimeMillis();
            String str = this.esUtil.httpUrlPoolGetByCode(tenantCode, bizType, opcode);
            this.logger.info("es.SearchengineServiceImpl.findByCode.find", (Object)(opcode + "=" + (System.currentTimeMillis() - times)));
            if (StringUtils.isBlank((String)str)) {
                this.logger.error("es.SearchengineServiceImpl.findByCode.str", (Object)opcode);
                return null;
            }
            Map remap = (Map)JSON.parseObject((String)str, (TypeReference)new TypeReference<Map<String, Object>>(){}, (Feature[])new Feature[0]);
            if (null == remap || MapUtil.isEmpty((Map)remap)) {
                this.logger.error("es.SearchengineServiceImpl.findByCode.remap", (Object)str);
                return null;
            }
            return remap;
        }
        catch (Exception e) {
            this.logger.error("es.SearchengineServiceImpl.findByCode.e", (Throwable)e);
            return null;
        }
    }

    @Override
    @ApiMethod(code="es.searchengine.find", name="\u83b7\u53d6\u6570\u636e", paramStr="searchDomain", description="")
    public ReturnBean find(SearchDomain searchDomain) throws ApiException {
        if (searchDomain == null || StringUtils.isBlank((String)searchDomain.getBizType())) {
            this.logger.error("es.SearchengineServiceImpl.find.null", (Object)"\u53c2\u6570\u4e3a\u7a7a");
            return null;
        }
        this.logger.info("es.SearchengineServiceImpl.find", (Object)("\u641c\u7d22\u53c2\u6570: " + JSON.toJSONString((Object)searchDomain)));
        String tenantCode = searchDomain.getTenantCode();
        if (StringUtils.isBlank((String)tenantCode)) {
            this.logger.error("es.SearchengineServiceImpl.find.tenantCode", (Object)"\u79df\u6237\u4ee3\u7801\u4e3a\u7a7a");
            return null;
        }
        Integer rows = 10;
        Integer page = 1;
        Map<String, Object> pageMap = searchDomain.getPageMap();
        if (pageMap != null && !pageMap.isEmpty()) {
            rows = SearchengineServiceImpl.getIntValue(pageMap, "rows", 10);
            page = SearchengineServiceImpl.getIntValue(pageMap, "page", 1);
        }
        int from = Math.max((page - 1) * rows, 0);
        SearchSourceBuilder builder = new SearchSourceBuilder().from(from).size(rows.intValue());
        SearchengineServiceImpl.handleSort(builder, searchDomain.getSortDomain());
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();
        SearchengineServiceImpl.handleTextQueries(boolQuery, searchDomain);
        SearchengineServiceImpl.handleRangeQueries(boolQuery, searchDomain);
        SearchengineServiceImpl.handleAccurateQueries(boolQuery, searchDomain);
        SearchengineServiceImpl.handleBuyerTypeQuery(boolQuery, searchDomain);
        SearchengineServiceImpl.handleAggregations(builder, searchDomain);
        SearchengineServiceImpl.handleCollapse(builder, searchDomain);
        builder.query((QueryBuilder)boolQuery);
        try {
            long startTime = System.currentTimeMillis();
            this.logger.info("es.SearchengineServiceImpl.find.searchRequest", (Object)("\u79df\u6237: " + tenantCode + ", \u4e1a\u52a1\u7c7b\u578b: " + searchDomain.getBizType() + ", \u67e5\u8be2: " + builder));
            SearchResponse searchResponse = this.esUtil.queryEs(tenantCode, searchDomain.getBizType(), builder);
            OpenPerfLogUtil.info((String)("[find] \u8017\u65f6: {}ms" + searchDomain.getBizType()), (long)(System.currentTimeMillis() - startTime));
            if (searchResponse == null || searchResponse.getHits() == null) {
                this.logger.error("es.SearchengineServiceImpl.find.emptyResponse", (Object)"\u641c\u7d22\u54cd\u5e94\u4e3a\u7a7a");
                return null;
            }
            SearchHit[] hits = searchResponse.getHits().getHits();
            if (hits == null || hits.length == 0) {
                this.logger.info("es.SearchengineServiceImpl.find.noResults", (Object)"\u672a\u627e\u5230\u5339\u914d\u7ed3\u679c");
                return null;
            }
            ReturnBean returnBean = new ReturnBean();
            returnBean.setCount((int)searchResponse.getHits().getTotalHits().value);
            returnBean.setPage(page);
            returnBean.setRow(rows);
            ArrayList<Map<String, Object>> sourceList = new ArrayList<Map<String, Object>>();
            for (SearchHit hit : hits) {
                Map source = hit.getSourceAsMap();
                source.put("score", Float.valueOf(hit.getScore()));
                sourceList.add(source);
            }
            returnBean.setSourcelist(sourceList);
            this.handleAggregationResults(returnBean, searchResponse.getAggregations());
            return returnBean;
        }
        catch (Exception e) {
            this.logger.error("es.SearchengineServiceImpl.find.exception", (Object)"\u641c\u7d22\u5904\u7406\u5f02\u5e38", (Throwable)e);
            throw new ApiException("\u641c\u7d22\u5931\u8d25", (Throwable)e);
        }
    }

    private static void handleSort(SearchSourceBuilder builder, SortDomain sortDomain) {
        if (sortDomain == null) {
            builder.sort("_score", SortOrder.DESC);
            return;
        }
        if (StringUtils.isNotBlank((String)sortDomain.getSortField())) {
            if (StringUtils.isNotBlank((String)sortDomain.getUnmappedType())) {
                builder.sort(SortBuilders.fieldSort((String)sortDomain.getSortField()).unmappedType(sortDomain.getUnmappedType()).order(SortOrder.fromString((String)sortDomain.getOrder())));
            } else {
                builder.sort(SortBuilders.fieldSort((String)sortDomain.getSortField()).order(SortOrder.fromString((String)sortDomain.getOrder())));
            }
        }
        if (ListUtil.isNotEmpty(sortDomain.getSortDomainList())) {
            for (SortDomain subSort : sortDomain.getSortDomainList()) {
                builder.sort(SortBuilders.fieldSort((String)subSort.getSortField()).order(SortOrder.fromString((String)subSort.getOrder())));
            }
        }
    }

    private static QueryBuilder buildQueryForKeyword(String keyword, String key) {
        BoolQueryBuilder keywordQuery = QueryBuilders.boolQuery();
        if ((keyword = keyword.trim()).isEmpty()) {
            return QueryBuilders.matchAllQuery();
        }
        if (keyword.startsWith("\"") && keyword.endsWith("\"")) {
            keyword = keyword.substring(1, keyword.length() - 1);
            SearchengineServiceImpl.addTermQueries(keywordQuery, keyword, key, true);
            return keywordQuery;
        }
        if (NUMBER_PATTERN.matcher(keyword).matches()) {
            SearchengineServiceImpl.addTermQueries(keywordQuery, keyword, key, false);
        } else if (PINYIN_PATTERN.matcher(keyword).matches()) {
            keywordQuery.should((QueryBuilder)QueryBuilders.termQuery((String)(key + ".pinyin"), (String)keyword.toLowerCase()));
            keywordQuery.should((QueryBuilder)QueryBuilders.matchPhraseQuery((String)(key + ".pinyin"), (Object)keyword.toLowerCase()));
            keywordQuery.should((QueryBuilder)QueryBuilders.termQuery((String)key, (String)keyword));
        } else if (MIXED_PATTERN.matcher(keyword).matches()) {
            SearchengineServiceImpl.addTermQueries(keywordQuery, keyword, key, true);
        } else {
            SearchengineServiceImpl.addTermQueries(keywordQuery, keyword, key, false);
        }
        return keywordQuery;
    }

    private static void addTermQueries(BoolQueryBuilder queryBuilder, String keyword, String key, boolean isMixed) {
        queryBuilder.should((QueryBuilder)QueryBuilders.matchPhraseQuery((String)key, (Object)keyword));
        if (isMixed) {
            queryBuilder.should((QueryBuilder)QueryBuilders.matchPhraseQuery((String)(key + ".pinyin"), (Object)keyword.toLowerCase()));
        } else {
            queryBuilder.should((QueryBuilder)QueryBuilders.matchPhraseQuery((String)(key + ".pinyin"), (Object)keyword));
        }
    }

    public static void main(String[] args) {
        String originalString = "\u8fd9\u662f\u4e00\u4e2a\u5305\u542byushigui\u7684\u5b57\u7b26\u4e32\uff0cyushigui\u9700\u8981\u88ab\u66ff\u6362\u6389";
        if (originalString.contains(yushigui)) {
            String replacedString = originalString.replace(yushigui, yushiju);
            System.out.println("\u66ff\u6362\u540e\u5b57\u7b26\u4e32: " + replacedString);
        }
        System.out.println("\u539f\u59cb\u5b57\u7b26\u4e32: " + originalString);
    }

    private static void handleTextQueries(BoolQueryBuilder boolQuery, SearchDomain searchDomain) {
        Map<String, Object> boolMap = searchDomain.getBoolMap();
        if (boolMap == null || boolMap.isEmpty()) {
            return;
        }
        for (Map.Entry<String, Object> entry : boolMap.entrySet()) {
            String[] keywords;
            String field = entry.getKey();
            String value = (String)entry.getValue();
            if (field.equals(search_all) && value.contains(yushigui)) {
                value = value.replace(yushigui, yushiju);
            }
            for (String keyword : keywords = SearchengineServiceImpl.splitKeywords(value)) {
                QueryBuilder queryBuilder = SearchengineServiceImpl.buildQueryForKeyword(keyword, field);
                boolQuery.must(queryBuilder);
            }
        }
    }

    private static String[] splitKeywords(String input) {
        ArrayList<String> keywords = new ArrayList<String>();
        Matcher matcher = Pattern.compile("\"([^\"]*)\"|(\\S+)").matcher(input);
        while (matcher.find()) {
            if (matcher.group(1) != null) {
                keywords.add(matcher.group(1));
                continue;
            }
            keywords.add(matcher.group(2));
        }
        return keywords.toArray(new String[0]);
    }

    private static void handleRangeQueries(BoolQueryBuilder boolQuery, SearchDomain searchDomain) {
        ArrayList<RangeQueryBuilder> rangeQueries = new ArrayList<RangeQueryBuilder>();
        if (searchDomain.getMinPrice() != null) {
            RangeQueryBuilder priceRange = QueryBuilders.rangeQuery((String)"pricesetNprice").gte((Object)searchDomain.getMinPrice());
            if (searchDomain.getMaxPrice() != null) {
                priceRange.lte((Object)searchDomain.getMaxPrice());
            }
            rangeQueries.add(priceRange);
        }
        if (searchDomain.getMinRefrice() != null) {
            RangeQueryBuilder refriceRange = QueryBuilders.rangeQuery((String)"pricesetRefrice").gte((Object)searchDomain.getMinRefrice());
            if (searchDomain.getMaxRefrice() != null) {
                refriceRange.lte((Object)searchDomain.getMaxRefrice());
            }
            rangeQueries.add(refriceRange);
        }
        if (searchDomain.getMinNum() != null || searchDomain.getMaxNum() != null) {
            RangeQueryBuilder numRange = QueryBuilders.rangeQuery((String)"goodsSupplynum");
            if (searchDomain.getMinNum() != null) {
                numRange.gt((Object)searchDomain.getMinNum());
            }
            if (searchDomain.getMaxNum() != null) {
                numRange.lt((Object)searchDomain.getMaxNum());
            }
            rangeQueries.add(numRange);
        }
        if (!rangeQueries.isEmpty()) {
            boolQuery.must().addAll(rangeQueries);
        }
    }

    private static void handleAccurateQueries(BoolQueryBuilder boolQuery, SearchDomain searchDomain) {
        String fieldValue;
        boolean isKeywordField;
        ArrayList<Object> accQueries = new ArrayList<Object>();
        ArrayList<Object> notAccQueries = new ArrayList<Object>();
        if (ListUtil.isNotEmpty(searchDomain.getAccurateQueryList())) {
            for (AccurateQueryDomain accurateQuery : searchDomain.getAccurateQueryList()) {
                isKeywordField = accurateQuery.getAccurateField().contains(".keyword");
                if (ListUtil.isNotEmpty(accurateQuery.getAccurateFieldValues())) {
                    accQueries.add(QueryBuilders.termsQuery((String)accurateQuery.getAccurateField(), SearchengineServiceImpl.list2string(accurateQuery.getAccurateFieldValues(), isKeywordField)));
                    continue;
                }
                fieldValue = accurateQuery.getAccurateFieldValue();
                if (!isKeywordField) {
                    fieldValue = fieldValue.toLowerCase();
                }
                accQueries.add(QueryBuilders.termQuery((String)accurateQuery.getAccurateField(), (String)fieldValue));
            }
        }
        if (ListUtil.isNotEmpty(searchDomain.getNotaccurateQueryList())) {
            for (AccurateQueryDomain accurateQuery : searchDomain.getNotaccurateQueryList()) {
                isKeywordField = accurateQuery.getAccurateField().contains(".keyword");
                if (ListUtil.isNotEmpty(accurateQuery.getAccurateFieldValues())) {
                    notAccQueries.add(QueryBuilders.termsQuery((String)accurateQuery.getAccurateField(), SearchengineServiceImpl.list2string(accurateQuery.getAccurateFieldValues(), isKeywordField)));
                    continue;
                }
                fieldValue = accurateQuery.getAccurateFieldValue();
                if (!isKeywordField) {
                    fieldValue = fieldValue.toLowerCase();
                }
                notAccQueries.add(QueryBuilders.termQuery((String)accurateQuery.getAccurateField(), (String)fieldValue));
            }
        }
        if (!accQueries.isEmpty()) {
            boolQuery.must().addAll(accQueries);
        }
        if (!notAccQueries.isEmpty()) {
            boolQuery.mustNot().addAll(notAccQueries);
        }
    }

    private static void handleBuyerTypeQuery(BoolQueryBuilder boolQuery, SearchDomain searchDomain) {
        if (searchDomain.getGoodsBuyType() == 1) {
            ArrayList<TermQueryBuilder> buyerQueries = new ArrayList<TermQueryBuilder>();
            buyerQueries.add(QueryBuilders.termQuery((String)"goodsBuyType", (int)0));
            BoolQueryBuilder newBuyerQuery = QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.termQuery((String)"goodsBuyType", (int)1));
            if (ListUtil.isNotEmpty(searchDomain.getGoodsBuyCodeStr())) {
                newBuyerQuery.must((QueryBuilder)QueryBuilders.termsQuery((String)"goodsBuyCodeStr.keyword", SearchengineServiceImpl.list2string(searchDomain.getGoodsBuyCodeStr(), true)));
            }
            boolQuery.should().addAll(buyerQueries);
        }
    }

    private static void handleAggregations(SearchSourceBuilder builder, SearchDomain searchDomain) {
        if (MapUtil.isEmpty(searchDomain.getGroupListMap()) && MapUtil.isEmpty(searchDomain.getGroupNumMap())) {
            return;
        }
        Object aggregationBuilder = null;
        if (MapUtil.isNotEmpty(searchDomain.getGroupListMap())) {
            if (SearchengineServiceImpl.isCsCliProductPool(searchDomain.getGroupListMap())) {
                SearchengineServiceImpl.queryCsCliProductPoolCopy(builder);
            } else {
                for (Map.Entry<String, Object> entry : searchDomain.getGroupListMap().entrySet()) {
                    String field = entry.getKey();
                    int size = Integer.parseInt(entry.getValue().toString());
                    if (aggregationBuilder == null) {
                        aggregationBuilder = ((TermsAggregationBuilder)AggregationBuilders.terms((String)field).field(field + ".keyword")).size(size);
                        continue;
                    }
                    aggregationBuilder = aggregationBuilder.subAggregation((AggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)field).field(field + ".keyword")).size(size));
                }
            }
        }
        if (!SearchengineServiceImpl.isCsCliProductPool(searchDomain.getGroupListMap()) && MapUtil.isNotEmpty(searchDomain.getGroupNumMap())) {
            for (String field : searchDomain.getGroupNumMap().keySet()) {
                aggregationBuilder = aggregationBuilder == null ? AggregationBuilders.min((String)(field + "min")).field(field) : aggregationBuilder.subAggregation((AggregationBuilder)AggregationBuilders.min((String)(field + "min")).field(field));
                aggregationBuilder = aggregationBuilder.subAggregation((AggregationBuilder)AggregationBuilders.max((String)(field + "max")).field(field));
                aggregationBuilder = aggregationBuilder.subAggregation((AggregationBuilder)AggregationBuilders.avg((String)(field + "avg")).field(field));
                aggregationBuilder = aggregationBuilder.subAggregation((AggregationBuilder)AggregationBuilders.sum((String)(field + "sum")).field(field));
            }
        }
        if (aggregationBuilder != null) {
            builder.aggregation(aggregationBuilder);
        }
    }

    private static void handleCollapse(SearchSourceBuilder builder, SearchDomain searchDomain) {
        String collapseStr = searchDomain.getCollapseStr();
        if (StringUtils.isNotBlank((String)collapseStr)) {
            builder.collapse(new CollapseBuilder(collapseStr));
        }
    }

    private void handleAggregationResults(ReturnBean returnBean, Aggregations aggregations) {
        if (aggregations == null || aggregations.getAsMap().isEmpty()) {
            return;
        }
        HashMap<String, Object> aggregationResults = new HashMap<String, Object>();
        for (Map.Entry entry : aggregations.getAsMap().entrySet()) {
            String key = (String)entry.getKey();
            Aggregation aggregation = (Aggregation)entry.getValue();
            if (!(aggregation instanceof Terms)) continue;
            Terms terms = (Terms)aggregation;
            ArrayList buckets = new ArrayList();
            for (Terms.Bucket bucket : terms.getBuckets()) {
                HashMap<String, Object> bucketMap = new HashMap<String, Object>();
                bucketMap.put("key", bucket.getKeyAsString());
                bucketMap.put("doc_count", bucket.getDocCount());
                buckets.add(bucketMap);
            }
            aggregationResults.put(key, buckets);
        }
        returnBean.setAggregations(aggregationResults);
    }

    private static int getIntValue(Map<String, Object> map, String key, int defaultValue) {
        if (map == null || !map.containsKey(key)) {
            return defaultValue;
        }
        Object value = map.get(key);
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof String) {
            try {
                return Integer.parseInt((String)value);
            }
            catch (NumberFormatException e) {
                return defaultValue;
            }
        }
        return defaultValue;
    }

    public static boolean isCsCliProductPool(Map<String, Object> map) {
        String[] split;
        if (MapUtil.isEmpty(map)) {
            return false;
        }
        for (String key : split = "brandName,brandCode,memberCcode,memberCname,classtreeCode,classtreeName".split(",")) {
            if (map.containsKey(key)) continue;
            return false;
        }
        return true;
    }

    public static void queryCsCliProductPoolCopy(SearchSourceBuilder builder) {
        String[] filterList;
        for (String filterKey : filterList = new String[]{"brandName", "brandCode", "memberCcode", "memberCname", "classtreeCode", "classtreeName"}) {
            TermsAggregationBuilder aggregationBuilder = ((TermsAggregationBuilder)AggregationBuilders.terms((String)filterKey).field(filterKey + ".keyword")).size(Integer.MAX_VALUE);
            builder.aggregation((AggregationBuilder)aggregationBuilder);
        }
    }
}

