/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.user.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import com.yqbsoft.laser.service.user.dao.UmCompanyMapper;
import com.yqbsoft.laser.service.user.domain.UmCompanyDomain;
import com.yqbsoft.laser.service.user.domain.UmCompanyReDomain;
import com.yqbsoft.laser.service.user.model.UmCompany;
import com.yqbsoft.laser.service.user.service.UmCompanyService;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UmCompanyServiceImpl
extends BaseServiceImpl
implements UmCompanyService {
    public static final String SYS_CODE = "um.USER.UmCompanyServiceImpl";
    private UmCompanyMapper umCompanyMapper;

    public void setUmCompanyMapper(UmCompanyMapper umCompanyMapper) {
        this.umCompanyMapper = umCompanyMapper;
    }

    private Date getSysDate() {
        try {
            return this.umCompanyMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmCompanyServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkCompany(UmCompanyDomain umCompanyDomain) {
        if (null == umCompanyDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        return msg;
    }

    private void setCompanyDefault(UmCompany umCompany) {
        if (null == umCompany) {
            return;
        }
        if (null == umCompany.getDataState()) {
            umCompany.setDataState(0);
        }
        if (null == umCompany.getGmtCreate()) {
            umCompany.setGmtCreate(this.getSysDate());
        }
        umCompany.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)umCompany.getCompanyCode())) {
            umCompany.setCompanyCode(this.createUUIDString());
        }
    }

    private int getCompanyMaxCode() {
        int code = 0;
        try {
            return this.umCompanyMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmCompanyServiceImpl.getCompanyMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setCompanyUpdataDefault(UmCompany umCompany) {
        if (null == umCompany) {
            return;
        }
        umCompany.setGmtModified(this.getSysDate());
    }

    private void saveCompanyModel(UmCompany umCompany) throws ApiException {
        if (null == umCompany) {
            return;
        }
        try {
            this.umCompanyMapper.insert(umCompany);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UmCompanyServiceImpl.saveCompanyModel.ex", (Throwable)e);
        }
    }

    private UmCompany getCompanyModelById(Integer companyId) {
        if (null == companyId) {
            return null;
        }
        try {
            return this.umCompanyMapper.selectByPrimaryKey(companyId);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmCompanyServiceImpl.getCompanyModelById", (Throwable)e);
            return null;
        }
    }

    public UmCompany getCompanyModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.umCompanyMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmCompanyServiceImpl.getCompanyModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delCompanyModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.umCompanyMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UmCompanyServiceImpl.delCompanyModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("um.USER.UmCompanyServiceImpl.delCompanyModelByCode.num");
        }
    }

    private void deleteCompanyModel(Integer companyId) throws ApiException {
        if (null == companyId) {
            return;
        }
        int i = 0;
        try {
            i = this.umCompanyMapper.deleteByPrimaryKey(companyId);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UmCompanyServiceImpl.deleteCompanyModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("um.USER.UmCompanyServiceImpl.deleteCompanyModel.num");
        }
    }

    private void updateCompanyModel(UmCompany umCompany) throws ApiException {
        if (null == umCompany) {
            return;
        }
        try {
            this.umCompanyMapper.updateByPrimaryKeySelective(umCompany);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UmCompanyServiceImpl.updateCompanyModel.ex", (Throwable)e);
        }
    }

    private void updateStateCompanyModel(Integer companyId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == companyId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("companyId", companyId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.umCompanyMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UmCompanyServiceImpl.updateStateCompanyModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("um.USER.UmCompanyServiceImpl.updateStateCompanyModel.null");
        }
    }

    private UmCompany makeCompany(UmCompanyDomain umCompanyDomain, UmCompany umCompany) {
        if (null == umCompanyDomain) {
            return null;
        }
        if (null == umCompany) {
            umCompany = new UmCompany();
        }
        try {
            BeanUtils.copyAllPropertys((Object)umCompany, (Object)umCompanyDomain);
            return umCompany;
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmCompanyServiceImpl.makeCompany", (Throwable)e);
            return null;
        }
    }

    private List<UmCompany> queryCompanyModelPage(Map<String, Object> parammap) {
        try {
            return this.umCompanyMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmCompanyServiceImpl.queryCompanyModel", (Throwable)e);
            return null;
        }
    }

    private int countCompany(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.umCompanyMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmCompanyServiceImpl.countCompany", (Throwable)e);
        }
        return i;
    }

    @Override
    public void saveCompany(UmCompanyDomain umCompanyDomain) throws ApiException {
        String msg = this.checkCompany(umCompanyDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("um.USER.UmCompanyServiceImpl.saveCompany.checkCompany", msg);
        }
        UmCompany umCompany = this.makeCompany(umCompanyDomain, null);
        this.setCompanyDefault(umCompany);
        this.saveCompanyModel(umCompany);
    }

    @Override
    public void updateCompanyState(Integer companyId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateCompanyModel(companyId, dataState, oldDataState);
    }

    @Override
    public void updateCompany(UmCompanyDomain umCompanyDomain) throws ApiException {
        String msg = this.checkCompany(umCompanyDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("um.USER.UmCompanyServiceImpl.updateCompany.checkCompany", msg);
        }
        UmCompany oldUmCompany = this.getCompanyModelById(umCompanyDomain.getCompanyId());
        if (null == oldUmCompany) {
            throw new ApiException("um.USER.UmCompanyServiceImpl.updateCompany.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        UmCompany umCompany = this.makeCompany(umCompanyDomain, oldUmCompany);
        this.setCompanyUpdataDefault(umCompany);
        this.updateCompanyModel(umCompany);
    }

    @Override
    public UmCompany getCompany(Integer companyId) {
        return this.getCompanyModelById(companyId);
    }

    @Override
    public void deleteCompany(Integer companyId) throws ApiException {
        this.deleteCompanyModel(companyId);
    }

    @Override
    public QueryResult<UmCompany> queryCompanyPage(Map<String, Object> map) {
        List<UmCompany> umCompanyList = this.queryCompanyModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countCompany(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(umCompanyList);
        return queryResult;
    }

    @Override
    public UmCompany getCompanyByCode(Map<String, Object> map) {
        return this.getCompanyModelByCode(map);
    }

    @Override
    public void delCompanyByCode(Map<String, Object> map) throws ApiException {
        this.delCompanyModelByCode(map);
    }

    @Override
    public String saveCompanyRe(UmCompanyReDomain umCompanyReDomain) throws ApiException {
        String msg = this.checkCompany(umCompanyReDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("um.USER.UmCompanyServiceImpl.saveCompanyRe.checkCompany", msg);
        }
        UmCompany umCompany = this.makeCompany(umCompanyReDomain, null);
        this.setCompanyDefault(umCompany);
        this.saveCompanyModel(umCompany);
        String companyCode = umCompany.getCompanyCode();
        return companyCode;
    }
}

