/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.user.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.DoubleUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import com.yqbsoft.laser.service.user.dao.UmUconfigMapper;
import com.yqbsoft.laser.service.user.domain.BsProvinceDomain;
import com.yqbsoft.laser.service.user.domain.UmUconfigDomain;
import com.yqbsoft.laser.service.user.domain.UmUconfigReDomain;
import com.yqbsoft.laser.service.user.model.UmUconfig;
import com.yqbsoft.laser.service.user.service.UmUconfigService;
import com.yqbsoft.laser.service.user.utils.LatLonUtil;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UmUconfigServiceImpl
extends BaseServiceImpl
implements UmUconfigService {
    private static final String SYS_CODE = "um.USER.UmUconfigServiceImpl";
    private UmUconfigMapper umUconfigMapper;
    private static double EARTH_RADIUS = 6378.137;

    public void setUmUconfigMapper(UmUconfigMapper umUconfigMapper) {
        this.umUconfigMapper = umUconfigMapper;
    }

    private Date getSysDate() {
        try {
            return this.umUconfigMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmUconfigServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkUmUconfig(UmUconfigDomain umUconfigDomain) {
        if (null == umUconfigDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)umUconfigDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setUmUconfigDefault(UmUconfig umUconfig) {
        if (null == umUconfig) {
            return;
        }
        if (null == umUconfig.getDataState()) {
            umUconfig.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == umUconfig.getGmtCreate()) {
            umUconfig.setGmtCreate(date);
        }
        umUconfig.setGmtModified(date);
        if (StringUtils.isBlank((String)umUconfig.getUconfigCode())) {
            umUconfig.setUconfigCode(this.getNo(null, "UmUconfig", "umUconfig", umUconfig.getTenantCode()));
        }
    }

    private int getUmUconfigMaxCode() {
        int code = 0;
        try {
            return this.umUconfigMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmUconfigServiceImpl.getUmUconfigMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setUmUconfigUpdataDefault(UmUconfig umUconfig) {
        if (null == umUconfig) {
            return;
        }
        umUconfig.setGmtModified(this.getSysDate());
    }

    private void saveUmUconfigModel(UmUconfig umUconfig) throws ApiException {
        if (null == umUconfig) {
            return;
        }
        try {
            this.umUconfigMapper.insert(umUconfig);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UmUconfigServiceImpl.saveUmUconfigModel.ex", (Throwable)e);
        }
    }

    private void saveUmUconfigBatchModel(List<UmUconfig> umUconfigList) throws ApiException {
        if (null == umUconfigList || umUconfigList.isEmpty()) {
            return;
        }
        try {
            this.umUconfigMapper.insertBatch(umUconfigList);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UmUconfigServiceImpl.saveUmUconfigBatchModel.ex", (Throwable)e);
        }
    }

    private UmUconfig getUmUconfigModelById(Integer uconfigId) {
        if (null == uconfigId) {
            return null;
        }
        try {
            return this.umUconfigMapper.selectByPrimaryKey(uconfigId);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmUconfigServiceImpl.getUmUconfigModelById", (Throwable)e);
            return null;
        }
    }

    private UmUconfig getUmUconfigModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.umUconfigMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmUconfigServiceImpl.getUmUconfigModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delUmUconfigModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.umUconfigMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UmUconfigServiceImpl.delUmUconfigModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("um.USER.UmUconfigServiceImpl.delUmUconfigModelByCode.num");
        }
    }

    private void deleteUmUconfigModel(Integer uconfigId) throws ApiException {
        if (null == uconfigId) {
            return;
        }
        int i = 0;
        try {
            i = this.umUconfigMapper.deleteByPrimaryKey(uconfigId);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UmUconfigServiceImpl.deleteUmUconfigModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("um.USER.UmUconfigServiceImpl.deleteUmUconfigModel.num");
        }
    }

    private void updateUmUconfigModel(UmUconfig umUconfig) throws ApiException {
        if (null == umUconfig) {
            return;
        }
        int i = 0;
        try {
            i = this.umUconfigMapper.updateByPrimaryKeySelective(umUconfig);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UmUconfigServiceImpl.updateUmUconfigModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("um.USER.UmUconfigServiceImpl.updateUmUconfigModel.num");
        }
    }

    private void updateStateUmUconfigModel(Integer uconfigId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == uconfigId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("uconfigId", uconfigId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.umUconfigMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UmUconfigServiceImpl.updateStateUmUconfigModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("um.USER.UmUconfigServiceImpl.updateStateUmUconfigModel.null");
        }
    }

    private void updateStateUmUconfigModelByCode(String tenantCode, String uconfigCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)uconfigCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("uconfigCode", uconfigCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.umUconfigMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UmUconfigServiceImpl.updateStateUmUconfigModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("um.USER.UmUconfigServiceImpl.updateStateUmUconfigModelByCode.null");
        }
    }

    private UmUconfig makeUmUconfig(UmUconfigDomain umUconfigDomain, UmUconfig umUconfig) {
        if (null == umUconfigDomain) {
            return null;
        }
        if (null == umUconfig) {
            umUconfig = new UmUconfig();
        }
        try {
            BeanUtils.copyAllPropertys((Object)umUconfig, (Object)umUconfigDomain);
            return umUconfig;
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmUconfigServiceImpl.makeUmUconfig", (Throwable)e);
            return null;
        }
    }

    private UmUconfigReDomain makeUmUconfigReDomain(UmUconfig umUconfig) {
        if (null == umUconfig) {
            return null;
        }
        UmUconfigReDomain umUconfigReDomain = new UmUconfigReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)umUconfigReDomain, (Object)umUconfig);
            return umUconfigReDomain;
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmUconfigServiceImpl.makeUmUconfigReDomain", (Throwable)e);
            return null;
        }
    }

    private List<UmUconfig> queryUmUconfigModelPage(Map<String, Object> parammap) {
        try {
            return this.umUconfigMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmUconfigServiceImpl.queryUmUconfigModel", (Throwable)e);
            return null;
        }
    }

    private int countUmUconfig(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.umUconfigMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmUconfigServiceImpl.countUmUconfig", (Throwable)e);
        }
        return i;
    }

    private UmUconfig createUmUconfig(UmUconfigDomain umUconfigDomain) {
        String msg = this.checkUmUconfig(umUconfigDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("um.USER.UmUconfigServiceImpl.saveUmUconfig.checkUmUconfig", msg);
        }
        UmUconfig umUconfig = this.makeUmUconfig(umUconfigDomain, null);
        this.setUmUconfigDefault(umUconfig);
        return umUconfig;
    }

    @Override
    public String saveUmUconfig(UmUconfigDomain umUconfigDomain) throws ApiException {
        UmUconfig umUconfig = this.createUmUconfig(umUconfigDomain);
        this.saveUmUconfigModel(umUconfig);
        return umUconfig.getUconfigCode();
    }

    @Override
    public String saveUmUconfigBatch(List<UmUconfigDomain> umUconfigDomainList) throws ApiException {
        if (null == umUconfigDomainList || umUconfigDomainList.isEmpty()) {
            return null;
        }
        ArrayList<UmUconfig> umUconfigList = new ArrayList<UmUconfig>();
        String code = "";
        for (UmUconfigDomain umUconfigDomain : umUconfigDomainList) {
            UmUconfig umUconfig = this.createUmUconfig(umUconfigDomain);
            code = umUconfig.getUconfigCode();
            umUconfigList.add(umUconfig);
            this.saveOrUpdateDisUconfig(umUconfig);
        }
        this.saveUmUconfigBatchModel(umUconfigList);
        return code;
    }

    @Override
    public void updateUmUconfigState(Integer uconfigId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == uconfigId) {
            return;
        }
        this.updateStateUmUconfigModel(uconfigId, dataState, oldDataState, map);
    }

    @Override
    public void updateUmUconfigStateByCode(String tenantCode, String uconfigCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)uconfigCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateUmUconfigModelByCode(tenantCode, uconfigCode, dataState, oldDataState, map);
    }

    @Override
    public void updateUmUconfig(UmUconfigDomain umUconfigDomain) throws ApiException {
        String msg = this.checkUmUconfig(umUconfigDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("um.USER.UmUconfigServiceImpl.updateUmUconfig.checkUmUconfig", msg);
        }
        UmUconfig oldUmUconfig = this.getUmUconfigModelById(umUconfigDomain.getUconfigId());
        if (null == oldUmUconfig) {
            throw new ApiException("um.USER.UmUconfigServiceImpl.updateUmUconfig.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        UmUconfig umUconfig = this.makeUmUconfig(umUconfigDomain, oldUmUconfig);
        this.setUmUconfigUpdataDefault(umUconfig);
        this.saveOrUpdateDisUconfig(umUconfig);
        this.updateUmUconfigModel(umUconfig);
    }

    @Override
    public UmUconfig getUmUconfig(Integer uconfigId) {
        if (null == uconfigId) {
            return null;
        }
        return this.getUmUconfigModelById(uconfigId);
    }

    @Override
    public void deleteUmUconfig(Integer uconfigId) throws ApiException {
        if (null == uconfigId) {
            return;
        }
        UmUconfig umUconfig = this.getUmUconfig(uconfigId);
        this.deleteUconfigCache(umUconfig);
        this.deleteUmUconfigModel(uconfigId);
    }

    @Override
    public QueryResult<UmUconfig> queryUmUconfigPage(Map<String, Object> map) {
        List<UmUconfig> umUconfigList = this.queryUmUconfigModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countUmUconfig(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(umUconfigList);
        return queryResult;
    }

    @Override
    public UmUconfig getUmUconfigByCode(String tenantCode, String uconfigCode) throws ApiException {
        if (StringUtils.isBlank((String)uconfigCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("uconfigCode", uconfigCode);
        return this.getUmUconfigModelByCode(map);
    }

    @Override
    public void deleteUmUconfigByCode(String tenantCode, String uconfigCode) throws ApiException {
        if (StringUtils.isBlank((String)uconfigCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("uconfigCode", uconfigCode);
        this.delUmUconfigModelByCode(map);
    }

    @Override
    public List<Map<String, Object>> queryCustClueRange(String areaCode, String tenantCode) {
        if (StringUtils.isBlank((String)areaCode) || StringUtils.isBlank((String)tenantCode)) {
            this.logger.error("um.USER.UmUconfigServiceImpl.queryCustClueRange", (Object)"areaCode isnull");
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("uconfigPro", "areaCode");
        map.put("uconfigValue", areaCode);
        map.put("tenantCode", tenantCode);
        List<UmUconfig> umUconfigs = this.queryUmUconfigModelPage(map);
        if (ListUtil.isEmpty(umUconfigs)) {
            return null;
        }
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>();
        for (UmUconfig umUconfig : umUconfigs) {
            HashMap<String, String> resultMap = new HashMap<String, String>();
            resultMap.put("memberPcode", umUconfig.getUserinfoCode());
            resultList.add(resultMap);
        }
        return resultList;
    }

    private void deleteUconfigCache(UmUconfig umUconfig) {
        if (null == umUconfig || StringUtils.isBlank((String)umUconfig.getUconfigSort())) {
            return;
        }
        String key = umUconfig.getTenantCode();
        String json = DisUtil.getRemotMap((String)("Um_uconfig_" + umUconfig.getUconfigSort()), (String)key);
        if (StringUtils.isBlank((String)json)) {
            return;
        }
        List mlist = JsonUtil.buildNormalBinder().getJsonToList(json, UmUconfig.class);
        ArrayList<UmUconfig> mprlist = new ArrayList<UmUconfig>();
        if (ListUtil.isNotEmpty((Collection)mlist)) {
            for (UmUconfig uconfig : mlist) {
                if (uconfig.getUconfigCode().equals(umUconfig.getUconfigCode())) continue;
                mprlist.add(uconfig);
            }
        }
        DisUtil.setMapVer((String)("Um_uconfig_" + umUconfig.getUconfigSort()), (String)key, (String)JsonUtil.buildNormalBinder().toJson(mprlist));
    }

    private void saveOrUpdateDisUconfig(UmUconfig umUconfig) {
        if (null == umUconfig || StringUtils.isBlank((String)umUconfig.getUconfigSort())) {
            return;
        }
        String key = umUconfig.getTenantCode();
        String json = DisUtil.getRemotMap((String)("Um_uconfig_" + umUconfig.getUconfigSort()), (String)key);
        if (StringUtils.isNotBlank((String)json)) {
            List mlist = JsonUtil.buildNormalBinder().getJsonToList(json, UmUconfig.class);
            ArrayList<UmUconfig> mprlist = new ArrayList<UmUconfig>();
            if (ListUtil.isNotEmpty((Collection)mlist)) {
                boolean flag = false;
                for (UmUconfig disUconfigDomain : mlist) {
                    if (StringUtils.isBlank((String)disUconfigDomain.getUconfigCode())) continue;
                    if (disUconfigDomain.getUconfigCode().equals(umUconfig.getUconfigCode())) {
                        flag = true;
                        mprlist.add(umUconfig);
                        continue;
                    }
                    mprlist.add(disUconfigDomain);
                }
                if (!flag) {
                    mprlist.add(umUconfig);
                }
            } else {
                mprlist.add(umUconfig);
            }
            DisUtil.setMapVer((String)("Um_uconfig_" + umUconfig.getUconfigSort()), (String)key, (String)JsonUtil.buildNormalBinder().toJson(mprlist));
        } else {
            ArrayList<UmUconfig> mlist = new ArrayList<UmUconfig>();
            mlist.add(umUconfig);
            DisUtil.setMapVer((String)("Um_uconfig_" + umUconfig.getUconfigSort()), (String)key, (String)JsonUtil.buildNormalBinder().toJson(mlist));
        }
    }

    @Override
    public List<UmUconfig> checkRange(double lat, double lng, String tenantCode) {
        if (DoubleUtil.isBlank((Double)lat) || DoubleUtil.isBlank((Double)lng) || StringUtils.isBlank((String)tenantCode)) {
            this.logger.error("um.USER.UmUconfigServiceImpl.checkRange", (Object)"param-is-null");
            return null;
        }
        String json = DisUtil.getRemotMap((String)"Um_uconfig_0", (String)tenantCode);
        if (StringUtils.isBlank((String)json)) {
            this.logger.error("um.USER.UmUconfigServiceImpl.checkRange", (Object)"disResult-is-null");
            return null;
        }
        return this.getRangeUconfig(lat, lng, json);
    }

    @Override
    public UmUconfig getUmConfigNearest(double lat, double lng, String tenantCode) {
        List<UmUconfig> umUconfigs = this.checkRange(lat, lng, tenantCode);
        if (ListUtil.isEmpty(umUconfigs)) {
            this.logger.error("um.USER.UmUconfigServiceImpl.getUmConfigNearest umUconfigs is null", null);
            return null;
        }
        UmUconfig umUconfigNearest = new UmUconfig();
        HashMap<String, UmUconfig> map = new HashMap<String, UmUconfig>();
        double last = 0.0;
        for (UmUconfig umUconfig : umUconfigs) {
            String lat1 = umUconfig.getUconfigValue();
            String lng1 = umUconfig.getUconfigValue1();
            double distance = LatLonUtil.getDistance(lng, lat, Double.parseDouble(lng1), Double.parseDouble(lat1));
            if (null == map.get("nearest")) {
                map.put("nearest", umUconfig);
                last = distance;
                continue;
            }
            if (!(last > distance)) continue;
            map.put("nearest", umUconfig);
            last = distance;
        }
        if (MapUtil.isNotEmpty(map)) {
            umUconfigNearest = (UmUconfig)map.get("nearest");
        }
        return umUconfigNearest;
    }

    @Override
    public UmUconfig getUmConfigNearestGroupByClass(double lat, double lng, String tenantCode, String goodsClass) {
        List<UmUconfig> umUconfigs = this.checkRange(lat, lng, tenantCode);
        if (ListUtil.isEmpty(umUconfigs)) {
            this.logger.error("um.USER.UmUconfigServiceImpl.getUmConfigNearest umUconfigs is null", null);
            return null;
        }
        ArrayList<UmUconfig> newUmUconfigs = new ArrayList<UmUconfig>();
        for (UmUconfig umUconfig : umUconfigs) {
            if (!goodsClass.equals(umUconfig.getGoodsClass())) continue;
            newUmUconfigs.add(umUconfig);
        }
        if (ListUtil.isEmpty(newUmUconfigs)) {
            this.logger.error("um.USER.UmUconfigServiceImpl.getUmConfigNearest newUmUconfigs is null", null);
            return null;
        }
        UmUconfig umUconfigNearest = new UmUconfig();
        HashMap<String, UmUconfig> map = new HashMap<String, UmUconfig>();
        double last = 0.0;
        for (UmUconfig umUconfig : newUmUconfigs) {
            String lat1 = umUconfig.getUconfigValue();
            String lng1 = umUconfig.getUconfigValue1();
            double distance = LatLonUtil.getDistance(lng, lat, Double.parseDouble(lng1), Double.parseDouble(lat1));
            if (null == map.get("nearest")) {
                map.put("nearest", umUconfig);
                last = distance;
                continue;
            }
            if (!(last > distance)) continue;
            map.put("nearest", umUconfig);
            last = distance;
        }
        if (MapUtil.isNotEmpty(map)) {
            umUconfigNearest = (UmUconfig)map.get("nearest");
        }
        return umUconfigNearest;
    }

    @Override
    public void queryCatchUmuconfig() throws ApiException {
        List<UmUconfig> umUconfigLsit = this.queryUmUconfigModelPage(new HashMap<String, Object>());
        if (null == umUconfigLsit || umUconfigLsit.isEmpty()) {
            DisUtil.delMapVer((String)"Um_uconfig_0", (String[])new String[0]);
            DisUtil.delMapVer((String)"Um_uconfig_3", (String[])new String[0]);
            return;
        }
        List<UmUconfig> umUconfigStoreList_0 = Collections.synchronizedList(new ArrayList());
        List<UmUconfig> umUconfigStoreList_3 = Collections.synchronizedList(new ArrayList());
        HashMap<String, List<UmUconfig>> map = new HashMap<String, List<UmUconfig>>();
        HashMap<String, List<UmUconfig>> whmap = new HashMap<String, List<UmUconfig>>();
        for (UmUconfig umUconfig : umUconfigLsit) {
            if (StringUtils.isBlank((String)umUconfig.getUconfigSort())) continue;
            if (umUconfig.getUconfigSort().equals("0")) {
                umUconfigStoreList_0 = (List<UmUconfig>)map.get(umUconfig.getTenantCode());
                if (null == umUconfigStoreList_0) {
                    umUconfigStoreList_0 = Collections.synchronizedList(new ArrayList());
                    map.put(umUconfig.getTenantCode(), umUconfigStoreList_0);
                }
                umUconfigStoreList_0.add(umUconfig);
            }
            if (!umUconfig.getUconfigSort().equals("3")) continue;
            umUconfigStoreList_3 = (List<UmUconfig>)whmap.get(umUconfig.getTenantCode());
            if (null == umUconfigStoreList_3) {
                umUconfigStoreList_3 = Collections.synchronizedList(new ArrayList());
                whmap.put(umUconfig.getTenantCode(), umUconfigStoreList_3);
            }
            umUconfigStoreList_3.add(umUconfig);
        }
        if (MapUtil.isNotEmpty(map)) {
            for (String key : map.keySet()) {
                DisUtil.setMapVer((String)"Um_uconfig_0", (String)key, (String)JsonUtil.buildNormalBinder().toJson(map.get(key)));
            }
        }
        if (MapUtil.isNotEmpty(whmap)) {
            for (String key : whmap.keySet()) {
                DisUtil.setMapVer((String)"Um_uconfig_3", (String)key, (String)JsonUtil.buildNormalBinder().toJson(whmap.get(key)));
            }
        }
        this.logger.error("UmUconfigServiceImpl.queryCatchUmuconfig", (Object)"---------------------------end");
    }

    @Override
    public Map<String, Object> queryWhRange(String tenantCode) {
        if (StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        List list = DisUtil.getMapListJson((String)"Um_uconfig_3", (String)tenantCode, UmUconfig.class);
        if (ListUtil.isEmpty((Collection)list)) {
            return null;
        }
        HashMap<String, Object> remap = new HashMap<String, Object>();
        String areaStr = "";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("tenantCode", tenantCode);
        paramMap.put("map", JsonUtil.buildNormalBinder().toJson(param));
        QueryResult qlist = this.sendReSupObject("bs.province.queryProvincePage", paramMap, BsProvinceDomain.class);
        HashMap<String, String> province = new HashMap<String, String>();
        if (null != qlist && ListUtil.isNotEmpty((Collection)qlist.getList())) {
            for (BsProvinceDomain bsProvinceDomain : qlist.getList()) {
                province.put(bsProvinceDomain.getProvinceCode(), bsProvinceDomain.getProvincName());
            }
        }
        for (UmUconfig umUconfig : list) {
            Map tempmap;
            areaStr = umUconfig.getUconfigLvalue();
            if (StringUtils.isBlank((String)areaStr) || !MapUtil.isNotEmpty((Map)(tempmap = JsonUtil.buildNormalBinder().getJsonToMap(areaStr, String.class, Object.class)))) continue;
            for (String key : tempmap.keySet()) {
                if (province.containsKey(key) || remap.containsKey(key)) continue;
                remap.put(key, tempmap.get(key));
            }
        }
        return remap;
    }

    private List<UmUconfig> getRangeUconfig(double lat, double lng, String json) {
        List mlist = JsonUtil.buildNormalBinder().getJsonToList(json, UmUconfig.class);
        ArrayList<UmUconfig> resList = new ArrayList<UmUconfig>();
        boolean flg = false;
        for (UmUconfig uconfigDomain : mlist) {
            if (StringUtils.isBlank((String)uconfigDomain.getUconfigType()) || !(flg = "rd".equals(uconfigDomain.getUconfigType()) ? this.checkRadiusRange(lat, lng, uconfigDomain) : this.checkFenceRange(lat, lng, uconfigDomain))) continue;
            resList.add(uconfigDomain);
        }
        return resList;
    }

    private boolean checkFenceRange(double lat, double lng, UmUconfig uconfigDomain) {
        String uconfigLvalue = uconfigDomain.getUconfigLvalue();
        if (StringUtils.isBlank((String)uconfigLvalue)) {
            return false;
        }
        try {
            Point2D.Double point = new Point2D.Double();
            point.x = lat;
            point.y = lng;
            List list = JsonUtil.buildNormalBinder().getJsonToList(uconfigLvalue, Point2D.Double.class);
            return UmUconfigServiceImpl.isInPolygon(point, list);
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean checkRadiusRange(double lat, double lng, UmUconfig uconfigDomain) {
        String lat1 = uconfigDomain.getUconfigValue();
        String lng1 = uconfigDomain.getUconfigValue1();
        String radius = uconfigDomain.getUconfigValue2();
        if (StringUtils.isBlank((String)lat1) || StringUtils.isBlank((String)lng1) || StringUtils.isBlank((String)radius)) {
            return false;
        }
        try {
            return UmUconfigServiceImpl.isInCircle(Double.valueOf(radius), lat, lng, Double.valueOf(lat1), Double.valueOf(lng1));
        }
        catch (Exception e) {
            return false;
        }
    }

    private static double rad(double d) {
        return d * Math.PI / 180.0;
    }

    public static boolean isInCircle(double radius, double lat1, double lng1, double lat2, double lng2) {
        double radLat1 = UmUconfigServiceImpl.rad(lat1);
        double radLat2 = UmUconfigServiceImpl.rad(lat2);
        double a = radLat1 - radLat2;
        double b = UmUconfigServiceImpl.rad(lng1) - UmUconfigServiceImpl.rad(lng2);
        double s = 2.0 * Math.asin(Math.sqrt(Math.pow(Math.sin(a / 2.0), 2.0) + Math.cos(radLat1) * Math.cos(radLat2) * Math.pow(Math.sin(b / 2.0), 2.0)));
        s *= EARTH_RADIUS;
        return !((s = (double)(Math.round(s * 10000.0) / 10000L)) > radius);
    }

    public static boolean isInPolygon(Point2D.Double point, List<Point2D.Double> pts) {
        int N = pts.size();
        boolean boundOrVertex = true;
        int intersectCount = 0;
        double precision = 2.0E-10;
        Point2D.Double p = point;
        Point2D.Double p1 = pts.get(0);
        for (int i = 1; i <= N; ++i) {
            if (p.equals(p1)) {
                return boundOrVertex;
            }
            Point2D.Double p2 = pts.get(i % N);
            if (p.x < Math.min(p1.x, p2.x) || p.x > Math.max(p1.x, p2.x)) {
                p1 = p2;
                continue;
            }
            if (p.x > Math.min(p1.x, p2.x) && p.x < Math.max(p1.x, p2.x)) {
                if (p.y <= Math.max(p1.y, p2.y)) {
                    if (p1.x == p2.x && p.y >= Math.min(p1.y, p2.y)) {
                        return boundOrVertex;
                    }
                    if (p1.y == p2.y) {
                        if (p1.y == p.y) {
                            return boundOrVertex;
                        }
                        ++intersectCount;
                    } else {
                        double xinters = (p.x - p1.x) * (p2.y - p1.y) / (p2.x - p1.x) + p1.y;
                        if (Math.abs(p.y - xinters) < precision) {
                            return boundOrVertex;
                        }
                        if (p.y < xinters) {
                            ++intersectCount;
                        }
                    }
                }
            } else if (p.x == p2.x && p.y <= p2.y) {
                Point2D.Double p3 = pts.get((i + 1) % N);
                intersectCount = p.x >= Math.min(p1.x, p3.x) && p.x <= Math.max(p1.x, p3.x) ? ++intersectCount : (intersectCount += 2);
            }
            p1 = p2;
        }
        return intersectCount % 2 != 0;
    }
}

