/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.virtualdepositor.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.spring.SpringApplicationContextUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import com.yqbsoft.laser.service.virtualdepositor.constant.VdFaccountDirectionEnum;
import com.yqbsoft.laser.service.virtualdepositor.dao.VdFaccountClearMapper;
import com.yqbsoft.laser.service.virtualdepositor.domain.VdFaccountClearDomain;
import com.yqbsoft.laser.service.virtualdepositor.domain.VdFaccountDoDomain;
import com.yqbsoft.laser.service.virtualdepositor.domain.VdFaccountDtDomain;
import com.yqbsoft.laser.service.virtualdepositor.domain.VdFaccountInnerInfo;
import com.yqbsoft.laser.service.virtualdepositor.model.VdFaccountClear;
import com.yqbsoft.laser.service.virtualdepositor.service.VdFaccountAbstractService;
import com.yqbsoft.laser.service.virtualdepositor.service.VdFaccountClearService;
import com.yqbsoft.laser.service.virtualdepositor.service.VdFaccountInnerService;
import com.yqbsoft.laser.service.virtualdepositor.service.VdFaccountOuterService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class VdFaccountClearServiceImpl
extends BaseServiceImpl
implements VdFaccountClearService {
    public static final String SYS_CODE = "vd.VdFaccountClearServiceImpl";
    private static final String GET_FACCOUNT_INNER_INFO = "vd.faccountInner.getFaccountInnerInfoByNo";
    private VdFaccountClearMapper vdFaccountClearMapper;
    VdFaccountInnerService vdFaccountInnerService;
    VdFaccountOuterService vdFaccountOuterService;

    public void setVdFaccountClearMapper(VdFaccountClearMapper vdFaccountClearMapper) {
        this.vdFaccountClearMapper = vdFaccountClearMapper;
    }

    public void setVdFaccountInnerService(VdFaccountInnerService vdFaccountInnerService) {
        this.vdFaccountInnerService = vdFaccountInnerService;
    }

    public void setVdFaccountOuterService(VdFaccountOuterService vdFaccountOuterService) {
        this.vdFaccountOuterService = vdFaccountOuterService;
    }

    private Date getSysDate() {
        try {
            return this.vdFaccountClearMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("vd.VdFaccountClearServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkFaccountClear(VdFaccountClearDomain vdFaccountClearDomain) {
        if (null == vdFaccountClearDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        return msg;
    }

    private void setFaccountClearDefault(VdFaccountClear vdFaccountClear) {
        if (null == vdFaccountClear) {
            return;
        }
        if (null == vdFaccountClear.getDataState()) {
            vdFaccountClear.setDataState(0);
        }
        if (null == vdFaccountClear.getFaccountClearState()) {
            vdFaccountClear.setFaccountClearState(0);
        }
        if (null == vdFaccountClear.getGmtCreate()) {
            vdFaccountClear.setGmtCreate(this.getSysDate());
        }
        vdFaccountClear.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)vdFaccountClear.getFaccountClearSeqno())) {
            vdFaccountClear.setFaccountClearSeqno(this.createUUIDString());
        }
    }

    private int getFaccountClearMaxCode() {
        int code = 0;
        try {
            return this.vdFaccountClearMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("vd.VdFaccountClearServiceImpl.getFaccountClearMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setFaccountClearUpdataDefault(VdFaccountClear vdFaccountClear) {
        if (null == vdFaccountClear) {
            return;
        }
        vdFaccountClear.setGmtModified(this.getSysDate());
    }

    private void saveFaccountClearModel(VdFaccountClear vdFaccountClear) throws ApiException {
        if (null == vdFaccountClear) {
            return;
        }
        try {
            this.vdFaccountClearMapper.insert(vdFaccountClear);
        }
        catch (Exception e) {
            throw new ApiException("vd.VdFaccountClearServiceImpl.saveFaccountClearModel.ex", (Throwable)e);
        }
    }

    private void saveFaccountClearBatchModel(List<VdFaccountClear> vdFaccountClearList) throws ApiException {
        if (null == vdFaccountClearList || vdFaccountClearList.isEmpty()) {
            return;
        }
        try {
            this.vdFaccountClearMapper.insertBatch(vdFaccountClearList);
        }
        catch (Exception e) {
            throw new ApiException("vd.VdFaccountClearServiceImpl.saveFaccountClearModel.ex", (Throwable)e);
        }
    }

    private VdFaccountClear getFaccountClearModelById(Integer faccountClearId) {
        if (null == faccountClearId) {
            return null;
        }
        try {
            return this.vdFaccountClearMapper.selectByPrimaryKey(faccountClearId);
        }
        catch (Exception e) {
            this.logger.error("vd.VdFaccountClearServiceImpl.getFaccountClearModelById", (Throwable)e);
            return null;
        }
    }

    public VdFaccountClear getFaccountClearModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.vdFaccountClearMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("vd.VdFaccountClearServiceImpl.getFaccountClearModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delFaccountClearModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.vdFaccountClearMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("vd.VdFaccountClearServiceImpl.delFaccountClearModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("vd.VdFaccountClearServiceImpl.delFaccountClearModelByCode.num");
        }
    }

    private void deleteFaccountClearModel(Integer faccountClearId) throws ApiException {
        if (null == faccountClearId) {
            return;
        }
        int i = 0;
        try {
            i = this.vdFaccountClearMapper.deleteByPrimaryKey(faccountClearId);
        }
        catch (Exception e) {
            throw new ApiException("vd.VdFaccountClearServiceImpl.deleteFaccountClearModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("vd.VdFaccountClearServiceImpl.deleteFaccountClearModel.num");
        }
    }

    private void updateFaccountClearModel(VdFaccountClear vdFaccountClear) throws ApiException {
        if (null == vdFaccountClear) {
            return;
        }
        try {
            this.vdFaccountClearMapper.updateByPrimaryKeySelective(vdFaccountClear);
        }
        catch (Exception e) {
            throw new ApiException("vd.VdFaccountClearServiceImpl.updateFaccountClearModel.ex", (Throwable)e);
        }
    }

    private void updateCallStateFaccountClearModel(Integer faccountClearId, Integer dataState, Integer oldDataState, String memo) throws ApiException {
        if (null == faccountClearId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("faccountClearId", faccountClearId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        map.put("memo", memo);
        int i = 0;
        try {
            i = this.vdFaccountClearMapper.updateCallStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("vd.VdFaccountClearServiceImpl.updateCallStateFaccountClearModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("vd.VdFaccountClearServiceImpl.updateCallStateFaccountClearModel.null", ((Object)map).toString());
        }
    }

    private void updateStateFaccountClearModel(Integer faccountClearId, Integer faccountClearState, Integer dataState, Integer oldDataState, String memo) throws ApiException {
        if (null == faccountClearId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("faccountClearId", faccountClearId);
        map.put("faccountClearState", faccountClearState);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        map.put("memo", memo);
        int i = 0;
        try {
            i = this.vdFaccountClearMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("vd.VdFaccountClearServiceImpl.updateStateFaccountClearModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("vd.VdFaccountClearServiceImpl.updateStateFaccountClearModel.null");
        }
    }

    private VdFaccountClear makeFaccountClear(VdFaccountClearDomain vdFaccountClearDomain, VdFaccountClear vdFaccountClear) {
        if (null == vdFaccountClearDomain) {
            return null;
        }
        if (null == vdFaccountClear) {
            vdFaccountClear = new VdFaccountClear();
        }
        try {
            BeanUtils.copyAllPropertys((Object)vdFaccountClear, (Object)vdFaccountClearDomain);
            return vdFaccountClear;
        }
        catch (Exception e) {
            this.logger.error("vd.VdFaccountClearServiceImpl.makeFaccountClear", (Throwable)e);
            return null;
        }
    }

    private List<VdFaccountClear> queryFaccountClearModelPage(Map<String, Object> parammap) {
        try {
            return this.vdFaccountClearMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("vd.VdFaccountClearServiceImpl.queryFaccountClearModel", (Throwable)e);
            return null;
        }
    }

    private int countFaccountClear(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.vdFaccountClearMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("vd.VdFaccountClearServiceImpl.countFaccountClear", (Throwable)e);
        }
        return i;
    }

    @Override
    public void saveFaccountClear(VdFaccountClearDomain vdFaccountClearDomain) throws ApiException {
        VdFaccountClear vdFaccountClear = this.createClear(vdFaccountClearDomain);
        this.saveFaccountClearModel(vdFaccountClear);
    }

    private VdFaccountClear createClear(VdFaccountClearDomain vdFaccountClearDomain) {
        String msg = this.checkFaccountClear(vdFaccountClearDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("vd.VdFaccountClearServiceImpl.saveFaccountClear.checkFaccountClear", msg);
        }
        VdFaccountClear vdFaccountClear = this.makeFaccountClear(vdFaccountClearDomain, null);
        this.setFaccountClearDefault(vdFaccountClear);
        vdFaccountClearDomain.setFaccountClearSeqno(vdFaccountClear.getFaccountClearSeqno());
        return vdFaccountClear;
    }

    @Override
    public void saveFaccountClearBatch(List<VdFaccountClearDomain> vdFaccountClearDomainList) throws ApiException {
        if (null == vdFaccountClearDomainList || vdFaccountClearDomainList.isEmpty()) {
            throw new ApiException("vd.VdFaccountClearServiceImpl.saveFaccountClearBatch.null", "null");
        }
        ArrayList<VdFaccountClear> vdFaccountClearList = new ArrayList<VdFaccountClear>();
        for (VdFaccountClearDomain vdFaccountClearDomain : vdFaccountClearDomainList) {
            vdFaccountClearList.add(this.createClear(vdFaccountClearDomain));
        }
        this.saveFaccountClearBatchModel(vdFaccountClearList);
    }

    @Override
    public void updateFaccountClearState(Integer faccountClearId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateFaccountClearModel(faccountClearId, null, dataState, oldDataState, null);
    }

    @Override
    public void updateFaccountClear(VdFaccountClearDomain vdFaccountClearDomain) throws ApiException {
        String msg = this.checkFaccountClear(vdFaccountClearDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("vd.VdFaccountClearServiceImpl.updateFaccountClear.checkFaccountClear", msg);
        }
        VdFaccountClear oldVdFaccountClear = this.getFaccountClearModelById(vdFaccountClearDomain.getFaccountClearId());
        if (null == oldVdFaccountClear) {
            throw new ApiException("vd.VdFaccountClearServiceImpl.updateFaccountClear.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        VdFaccountClear vdFaccountClear = this.makeFaccountClear(vdFaccountClearDomain, oldVdFaccountClear);
        this.setFaccountClearUpdataDefault(vdFaccountClear);
        this.updateFaccountClearModel(vdFaccountClear);
    }

    @Override
    public VdFaccountClear getFaccountClear(Integer faccountClearId) {
        return this.getFaccountClearModelById(faccountClearId);
    }

    @Override
    public void deleteFaccountClear(Integer faccountClearId) throws ApiException {
        this.deleteFaccountClearModel(faccountClearId);
    }

    @Override
    public QueryResult<VdFaccountClear> queryFaccountClearPage(Map<String, Object> map) {
        List<VdFaccountClear> vdFaccountClearList = this.queryFaccountClearModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countFaccountClear(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(vdFaccountClearList);
        return queryResult;
    }

    @Override
    public VdFaccountClear getFaccountClearByCode(Map<String, Object> map) {
        return this.getFaccountClearModelByCode(map);
    }

    @Override
    public void delFaccountClearByCode(Map<String, Object> map) throws ApiException {
        this.delFaccountClearModelByCode(map);
    }

    @Override
    public List<VdFaccountClear> updateFaccountClearError(List<VdFaccountClearDomain> vdFaccountClearDomainList) throws ApiException {
        if (null == vdFaccountClearDomainList || vdFaccountClearDomainList.isEmpty()) {
            return null;
        }
        ArrayList<VdFaccountClear> list = new ArrayList<VdFaccountClear>();
        HashMap<String, Object> map = new HashMap<String, Object>();
        VdFaccountClear vdFaccountClear = null;
        for (VdFaccountClearDomain vdFaccountClearDomain : vdFaccountClearDomainList) {
            map.put("faccountClearSeqno", vdFaccountClearDomain.getFaccountClearSeqno());
            map.put("tenantCode", vdFaccountClearDomain.getTenantCode());
            vdFaccountClear = this.getFaccountClearByCode(map);
            if (null == vdFaccountClear) {
                throw new ApiException("vd.VdFaccountClearServiceImpl.updateFaccountClearError.vdFaccountClear", "null");
            }
            vdFaccountClear.setDataState(3);
            this.updateStateFaccountClearModel(vdFaccountClear.getFaccountClearId(), 1, 3, null, "3");
            list.add(vdFaccountClear);
        }
        return list;
    }

    @Override
    public List<VdFaccountClear> updateExcuteFaccountClear(List<VdFaccountClearDomain> vdFaccountClearDomainList) throws ApiException {
        if (null == vdFaccountClearDomainList || vdFaccountClearDomainList.isEmpty()) {
            return null;
        }
        ArrayList<VdFaccountClear> list = new ArrayList<VdFaccountClear>();
        HashMap<String, Object> map = new HashMap<String, Object>();
        VdFaccountClear vdFaccountClear = null;
        Collections.sort(vdFaccountClearDomainList, new Comparator<VdFaccountClearDomain>(){

            @Override
            public int compare(VdFaccountClearDomain arg0, VdFaccountClearDomain arg1) {
                int len1;
                int len0 = arg0.getFaccountId().length();
                if (len0 > (len1 = arg1.getFaccountId().length())) {
                    return -1;
                }
                if (len0 < len1) {
                    return 1;
                }
                return arg0.getFaccountId().compareTo(arg1.getFaccountId());
            }
        });
        for (VdFaccountClearDomain vdFaccountClearDomain : vdFaccountClearDomainList) {
            map.put("faccountClearSeqno", vdFaccountClearDomain.getFaccountClearSeqno());
            map.put("tenantCode", vdFaccountClearDomain.getTenantCode());
            vdFaccountClear = this.getFaccountClearByCode(map);
            if (null == vdFaccountClear) {
                throw new ApiException("vd.VdFaccountClearServiceImpl.updateExcuteFaccountClear.vdFaccountClear", ((Object)map).toString());
            }
            if (!this.saveBalanceClear(vdFaccountClearDomain, vdFaccountClear)) {
                vdFaccountClear.setDataState(3);
                throw new ApiException("vd.VdFaccountClearServiceImpl.updateExcuteFaccountClear.error", "error");
            }
            vdFaccountClear.setDataState(2);
            this.updateStateFaccountClearModel(vdFaccountClear.getFaccountClearId(), 1, 2, 1, "2");
            list.add(vdFaccountClear);
        }
        return list;
    }

    @Override
    public void updateFaccountBalance(String faccountNo, String targetBalance, String tenantCode) {
        assert (!StringUtils.hasBlank((String[])new String[]{faccountNo, targetBalance, tenantCode})) : "faccountNo, targetBalance, tenantCode can`t be blank";
        VdFaccountInnerInfo info = (VdFaccountInnerInfo)this.getForObject(GET_FACCOUNT_INNER_INFO, VdFaccountInnerInfo.class, this.getQueryMapParam("faccountInnerNo,tenantCode", new Object[]{faccountNo, tenantCode}));
        if (info == null) {
            throw new ApiException("ITEM.NOT.FOUND", "can`t found record \u67e5\u627e\u4e0d\u5230\u76f8\u5173\u8bb0\u5f55");
        }
        VdFaccountDoDomain faccountDoDomain = this.makeFaccount(info);
        try {
            this.setOrderDcAndOrderAmount(new BigDecimal(targetBalance), info.getFaccountAmount(), info.getCurrencyDirection(), faccountDoDomain);
            this.putchFaccountBalanceOne(faccountDoDomain);
        }
        catch (Exception e) {
            throw new ApiException("Fail", e.getMessage(), (Throwable)e);
        }
    }

    private VdFaccountDoDomain makeFaccount(VdFaccountInnerInfo info) {
        assert (info != null);
        VdFaccountDoDomain faccountDoDomain = new VdFaccountDoDomain();
        faccountDoDomain.setOrderCurrency(info.getCurrencyCode());
        faccountDoDomain.setFchannelClassifyCode(info.getFaccountType());
        faccountDoDomain.setFundType(info.getFundType());
        faccountDoDomain.setTenantCode(info.getTenantCode());
        faccountDoDomain.setFaccountId(info.getFaccountInnerNo());
        return faccountDoDomain;
    }

    private void setOrderDcAndOrderAmount(BigDecimal target, BigDecimal source, String currencyDirection, VdFaccountDoDomain vdFaccountDoDomain) {
        assert (target != null && source != null && vdFaccountDoDomain != null);
        if (target.compareTo(source) == 0) {
            this.logger.debug("ILLEGAL.OPERATION", (Object)"targetBalance eq source");
            return;
        }
        boolean isGain = target.compareTo(source) > 0;
        vdFaccountDoDomain.setOrderAmount(target.subtract(source).abs());
        vdFaccountDoDomain.setOrderDc(VdFaccountDirectionEnum.getInternshipDirection(currencyDirection, isGain));
    }

    private boolean saveBalanceClear(VdFaccountClearDomain vdFaccountClearDomain, VdFaccountClear vdFaccountClear) throws ApiException {
        if (null == vdFaccountClearDomain || null == vdFaccountClear) {
            throw new ApiException("vd.VdFaccountClearServiceImpl.saveFaccountClear.null", "null");
        }
        this.updateFaccountClearState(vdFaccountClear.getFaccountClearId(), 1, 0);
        VdFaccountDtDomain vdFaccountDtDomain = this.putchFaccountBalanceOne(this.makeFaccount(vdFaccountClear));
        return vdFaccountDtDomain.isCont();
    }

    private VdFaccountDoDomain makeFaccount(VdFaccountClear vdFaccountClear) {
        if (null == vdFaccountClear) {
            return null;
        }
        VdFaccountDoDomain vdFaccountDoDomain = new VdFaccountDoDomain();
        try {
            BeanUtils.copyAllPropertys((Object)vdFaccountDoDomain, (Object)vdFaccountClear);
            return vdFaccountDoDomain;
        }
        catch (Exception e) {
            this.logger.error("vd.VdFaccountClearServiceImpl.makeFaccount.e", (Throwable)e);
            return null;
        }
    }

    private void saveVdFaccountDtAndTitleByMQ(String vdFaccountAbstractServiceBeanName, VdFaccountDtDomain faccountDtDomain) {
        if (faccountDtDomain.isCont()) {
            this.saveMqDt(vdFaccountAbstractServiceBeanName, faccountDtDomain.getTenantCode(), faccountDtDomain);
        }
    }

    private VdFaccountDtDomain putchFaccountBalanceOne(VdFaccountDoDomain vdFaccountDoDomain) {
        this.checkFaccount(vdFaccountDoDomain);
        String vdFaccountAbstractServiceName = this.getFaccountServiceId(vdFaccountDoDomain.getFchannelClassifyCode(), vdFaccountDoDomain.getTenantCode());
        if (StringUtils.isBlank((String)vdFaccountAbstractServiceName)) {
            throw new ApiException("vd.VdFaccountClearServiceImpl.getFaccountServiceId", "null");
        }
        VdFaccountDtDomain faccountDtDomain = null;
        faccountDtDomain = "vdFaccountInnerService".equals(vdFaccountAbstractServiceName) ? this.vdFaccountInnerService.saveFaccountBalanceOne(vdFaccountDoDomain) : this.vdFaccountOuterService.saveFaccountBalanceOne(vdFaccountDoDomain);
        this.saveVdFaccountDtAndTitleByMQ(vdFaccountAbstractServiceName, faccountDtDomain);
        return faccountDtDomain;
    }

    private void checkFaccount(VdFaccountDoDomain vdFaccountDomain) {
        String errMsg = null;
        if (null == vdFaccountDomain) {
            errMsg = "vdFaccountDomain can`t be null";
        } else if (StringUtils.isBlank((String)vdFaccountDomain.getTenantCode())) {
            errMsg = "tenantCode can`t be null";
        } else if (StringUtils.isBlank((String)vdFaccountDomain.getFchannelClassifyCode())) {
            errMsg = "fchannelClassifyCode can`t be null";
        }
        if (errMsg != null) {
            throw new ApiException("vd.VdFaccountClearServiceImpl.checkFaccount", errMsg);
        }
    }

    private VdFaccountAbstractService getFaccountService(String serId) {
        VdFaccountAbstractService result = (VdFaccountAbstractService)SpringApplicationContextUtil.getBean((String)serId);
        if (result == null) {
            throw new ApiException("vd.VdFaccountClearServiceImpl.getFaccountService", "SpringApplicationContextUtil can`t getBean by" + serId);
        }
        return result;
    }

    private String getFaccountServiceId(String faccountType, String tenantCode) {
        if ("test".equals(faccountType)) {
            return "vdFaccountInnerService";
        }
        String str = DisUtil.getMap((String)"FaccountType_serviceid", (String)(faccountType + "-" + tenantCode));
        if (StringUtils.isEmpty((String)str)) {
            return DisUtil.getMap((String)"FaccountType_serviceid", (String)(faccountType + "-" + "00000000"));
        }
        return str;
    }

    private void saveMqDt(String vdFaccountAbstractServiceId, String tenantCode, VdFaccountDtDomain vdFaccountDtDomain) {
        String apiCodeContext = DisUtil.getMap((String)"FaccountType_apicode", (String)(vdFaccountAbstractServiceId + "-" + tenantCode));
        if (StringUtils.isBlank((String)apiCodeContext)) {
            apiCodeContext = DisUtil.getMap((String)"FaccountType_apicode", (String)(vdFaccountAbstractServiceId + "-" + "00000000"));
        }
        if (StringUtils.isBlank((String)apiCodeContext)) {
            throw new ApiException("vd.VdFaccountClearServiceImpl.saveMqDt.api", vdFaccountAbstractServiceId + " is null");
        }
        if ("faccountInner".equals(apiCodeContext)) {
            this.vdFaccountInnerService.saveFaccountDtOne(vdFaccountDtDomain);
        } else {
            this.vdFaccountOuterService.saveFaccountDtOne(vdFaccountDtDomain);
        }
    }

    private void saveMqTitle(String vdFaccountAbstractServiceId, String tenantCode, VdFaccountDtDomain vdFaccountDtDomain) {
        HashMap<String, String> map = new HashMap<String, String>();
        String apiCode = DisUtil.getMap((String)"FaccountType_tapicode", (String)(vdFaccountAbstractServiceId + "-" + tenantCode));
        if (StringUtils.isBlank((String)apiCode)) {
            apiCode = DisUtil.getMap((String)"FaccountType_tapicode", (String)(vdFaccountAbstractServiceId + "-" + "00000000"));
        }
        if (StringUtils.isBlank((String)apiCode)) {
            throw new ApiException("vd.VdFaccountClearServiceImpl.saveMqTitle.api", vdFaccountAbstractServiceId + " null");
        }
        map.put("vdFaccountDtDomain", JsonUtil.buildNormalBinder().toJson((Object)vdFaccountDtDomain));
        this.getInternalRouter().inInvoke(apiCode, "1.0", "0", map);
    }

    @Override
    public void updateFaccountClearCallState(Integer faccountClearId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateCallStateFaccountClearModel(faccountClearId, dataState, oldDataState, null);
    }
}

