/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.virtualdepositor.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.DateUtil;
import com.yqbsoft.laser.service.tool.util.EmptyUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.RandomUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import com.yqbsoft.laser.service.virtualdepositor.dao.VdFaccountOuterDtMapper;
import com.yqbsoft.laser.service.virtualdepositor.dao.VdFaccountOuterMapper;
import com.yqbsoft.laser.service.virtualdepositor.dao.VdFaccountOuterSubsetMapper;
import com.yqbsoft.laser.service.virtualdepositor.domain.BalanceBean;
import com.yqbsoft.laser.service.virtualdepositor.domain.IncomeAmountContext;
import com.yqbsoft.laser.service.virtualdepositor.domain.OrderBean;
import com.yqbsoft.laser.service.virtualdepositor.domain.VdFaccountAikang;
import com.yqbsoft.laser.service.virtualdepositor.domain.VdFaccountDefReDomain;
import com.yqbsoft.laser.service.virtualdepositor.domain.VdFaccountDefSubsetReDomain;
import com.yqbsoft.laser.service.virtualdepositor.domain.VdFaccountDoDomain;
import com.yqbsoft.laser.service.virtualdepositor.domain.VdFaccountDomain;
import com.yqbsoft.laser.service.virtualdepositor.domain.VdFaccountDtDomain;
import com.yqbsoft.laser.service.virtualdepositor.domain.VdFaccountInfo;
import com.yqbsoft.laser.service.virtualdepositor.domain.VdFaccountOuterDomain;
import com.yqbsoft.laser.service.virtualdepositor.domain.VdFaccountOuterDtDomain;
import com.yqbsoft.laser.service.virtualdepositor.domain.VdFaccountOuterReDomain;
import com.yqbsoft.laser.service.virtualdepositor.domain.VdFaccountOuterSubsetDomain;
import com.yqbsoft.laser.service.virtualdepositor.domain.VdFaccountOuterSubsetReDomain;
import com.yqbsoft.laser.service.virtualdepositor.domain.VdFaccountSubsetDomain;
import com.yqbsoft.laser.service.virtualdepositor.model.VdFaccountOuter;
import com.yqbsoft.laser.service.virtualdepositor.model.VdFaccountOuterDt;
import com.yqbsoft.laser.service.virtualdepositor.model.VdFaccountOuterDtAll;
import com.yqbsoft.laser.service.virtualdepositor.model.VdFaccountOuterSubset;
import com.yqbsoft.laser.service.virtualdepositor.service.VdFaccountDefService;
import com.yqbsoft.laser.service.virtualdepositor.service.VdFaccountOuterService;
import com.yqbsoft.laser.service.virtualdepositor.service.impl.VdFaccountAbstractServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;

public class VdFaccountOuterServiceImpl
extends VdFaccountAbstractServiceImpl
implements VdFaccountOuterService {
    public static final String SYS_CODE = "vd.VdFaccountOuterServiceImpl";
    private VdFaccountOuterMapper vdFaccountOuterMapper;
    private VdFaccountOuterSubsetMapper vdFaccountOuterSubsetMapper;
    private VdFaccountOuterDtMapper vdFaccountOuterDtMapper;
    private VdFaccountDefService vdFaccountDefService;

    public void setVdFaccountDefService(VdFaccountDefService vdFaccountDefService) {
        this.vdFaccountDefService = vdFaccountDefService;
    }

    public void setVdFaccountOuterMapper(VdFaccountOuterMapper vdFaccountOuterMapper) {
        this.vdFaccountOuterMapper = vdFaccountOuterMapper;
    }

    public void setVdFaccountOuterSubsetMapper(VdFaccountOuterSubsetMapper vdFaccountOuterSubsetMapper) {
        this.vdFaccountOuterSubsetMapper = vdFaccountOuterSubsetMapper;
    }

    public void setVdFaccountOuterDtMapper(VdFaccountOuterDtMapper vdFaccountOuterDtMapper) {
        this.vdFaccountOuterDtMapper = vdFaccountOuterDtMapper;
    }

    private Date getSysDate() {
        try {
            return this.vdFaccountOuterMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("vd.VdFaccountOuterServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkFaccountOuter(VdFaccountOuterDomain vdFaccountOuterDomain) {
        if (null == vdFaccountOuterDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        return msg;
    }

    private void setFaccountOuterDefault(VdFaccountOuter vdFaccountOuter) {
        if (null == vdFaccountOuter) {
            return;
        }
        if (null == vdFaccountOuter.getDataState()) {
            vdFaccountOuter.setDataState(0);
        }
        if (null == vdFaccountOuter.getGmtCreate()) {
            vdFaccountOuter.setGmtCreate(this.getSysDate());
        }
        vdFaccountOuter.setGmtModified(this.getSysDate());
        String r = RandomUtils.generateRandom((int)1, (Integer)0);
        String codepix = vdFaccountOuter.getFaccountTitileCode() + vdFaccountOuter.getMerchantCode() + vdFaccountOuter.getCurrencyCode() + vdFaccountOuter.getFaccountType();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("faccountOuterNo", codepix);
        map.put("tenantCode", vdFaccountOuter.getTenantCode());
        String maxCode = this.getOuterMaxNo(map);
        String no = "01";
        if (StringUtils.isNotBlank((String)maxCode)) {
            maxCode = maxCode.substring(maxCode.length() - 3, maxCode.length() - 1);
            long nol = Long.valueOf(maxCode) + 1L;
            no = String.format("%02d", nol);
        }
        vdFaccountOuter.setFaccountOuterNo(codepix + no + r);
    }

    private String getOuterMaxNo(Map<String, Object> map) {
        String code = "";
        try {
            if (map.get("faccountOuterNo") != null && !"null".equals(map.get("faccountOuterNo").toString())) {
                return this.vdFaccountOuterMapper.getMaxNo(map);
            }
        }
        catch (Exception e) {
            this.logger.error("vd.VdFaccountOuterServiceImpl.getOuterMaxCode", (Throwable)e);
        }
        return code;
    }

    private void setFaccountOuterUpdataDefault(VdFaccountOuter vdFaccountOuter) {
        if (null == vdFaccountOuter) {
            return;
        }
        vdFaccountOuter.setGmtModified(this.getSysDate());
    }

    private void saveFaccountOuterModel(VdFaccountOuter vdFaccountOuter) throws ApiException {
        if (null == vdFaccountOuter) {
            return;
        }
        try {
            this.vdFaccountOuterMapper.insert(vdFaccountOuter);
        }
        catch (Exception e) {
            throw new ApiException("vd.VdFaccountOuterServiceImpl.saveFaccountOuterModel.ex", (Throwable)e);
        }
    }

    private VdFaccountOuter getFaccountOuterModelById(Integer faccountOuterId) {
        if (null == faccountOuterId) {
            return null;
        }
        try {
            return this.vdFaccountOuterMapper.selectByPrimaryKey(faccountOuterId);
        }
        catch (Exception e) {
            this.logger.error("vd.VdFaccountOuterServiceImpl.getFaccountOuterModelById", (Throwable)e);
            return null;
        }
    }

    public VdFaccountOuter getFaccountOuterModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.vdFaccountOuterMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("vd.VdFaccountOuterServiceImpl.getFaccountOuterModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delFaccountOuterModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.vdFaccountOuterMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("vd.VdFaccountOuterServiceImpl.delFaccountOuterModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("vd.VdFaccountOuterServiceImpl.delFaccountOuterModelByCode.num");
        }
    }

    private VdFaccountOuter getFaccountOuterLockByCodeModel(String faccountOuterNo, String tenantCode) {
        if (StringUtils.isBlank((String)faccountOuterNo)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("faccountOuterNo", faccountOuterNo);
        map.put("tenantCode", tenantCode);
        try {
            return this.vdFaccountOuterMapper.getLockByPrimaryCode(map);
        }
        catch (Exception e) {
            throw new ApiException("vd.VdFaccountOuterServiceImpl.getFaccountOuterModelLockByCode.ex", ((Object)map).toString(), (Throwable)e);
        }
    }

    private void updateFaccountOuterLockByCodeModel(String faccountOuterNo, String tenantCode) {
        if (StringUtils.isBlank((String)faccountOuterNo)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("faccountOuterNo", faccountOuterNo);
        map.put("tenantCode", tenantCode);
        int i = 0;
        try {
            i = this.vdFaccountOuterMapper.updateLockByPrimaryCode(map);
        }
        catch (Exception e) {
            throw new ApiException("vd.VdFaccountOuterServiceImpl.updateFaccountOuterLockByCodeModel.ex", ((Object)map).toString(), (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("vd.VdFaccountOuterServiceImpl.updateFaccountOuterLockByCodeModel.num", ((Object)map).toString());
        }
    }

    private void deleteFaccountOuterModel(Integer faccountOuterId) throws ApiException {
        if (null == faccountOuterId) {
            return;
        }
        int i = 0;
        try {
            i = this.vdFaccountOuterMapper.deleteByPrimaryKey(faccountOuterId);
        }
        catch (Exception e) {
            throw new ApiException("vd.VdFaccountOuterServiceImpl.deleteFaccountOuterModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("vd.VdFaccountOuterServiceImpl.deleteFaccountOuterModel.num");
        }
    }

    private void updateFaccountOuterModel(VdFaccountOuter vdFaccountOuter) throws ApiException {
        if (null == vdFaccountOuter) {
            return;
        }
        try {
            this.vdFaccountOuterMapper.updateByPrimaryKeySelective(vdFaccountOuter);
        }
        catch (Exception e) {
            throw new ApiException("vd.VdFaccountOuterServiceImpl.updateFaccountOuterModel.ex", (Throwable)e);
        }
    }

    public void updateFaccountOuterByCodeModel(Map<String, Object> map) throws ApiException {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.vdFaccountOuterMapper.updateByPrimaryCode(map);
        }
        catch (Exception e) {
            throw new ApiException("vd.VdFaccountOuterServiceImpl.updateFaccountOuterByCodeModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("vd.VdFaccountOuterServiceImpl.updateFaccountOuterByCodeModel.null");
        }
    }

    private void updateStateFaccountOuterModel(Integer faccountOuterId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == faccountOuterId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("faccountOuterId", faccountOuterId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.vdFaccountOuterMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("vd.VdFaccountOuterServiceImpl.updateStateFaccountOuterModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("vd.VdFaccountOuterServiceImpl.updateStateFaccountOuterModel.null");
        }
    }

    private VdFaccountOuter makeFaccountOuter(VdFaccountOuterDomain vdFaccountOuterDomain, VdFaccountOuter vdFaccountOuter) {
        if (null == vdFaccountOuterDomain) {
            return null;
        }
        if (null == vdFaccountOuter) {
            vdFaccountOuter = new VdFaccountOuter();
        }
        try {
            BeanUtils.copyAllPropertys((Object)vdFaccountOuter, (Object)vdFaccountOuterDomain);
        }
        catch (Exception e) {
            this.logger.error("vd.VdFaccountOuterServiceImpl.makeFaccountOuter", (Throwable)e);
        }
        return vdFaccountOuter;
    }

    private VdFaccountOuterReDomain makeFaccountOuterReDomain(VdFaccountOuter vdFaccountOuter, VdFaccountOuterReDomain vdFaccountOuterReDomain) {
        if (null == vdFaccountOuter) {
            return null;
        }
        if (null == vdFaccountOuterReDomain) {
            vdFaccountOuterReDomain = new VdFaccountOuterReDomain();
        }
        try {
            BeanUtils.copyAllPropertys((Object)vdFaccountOuterReDomain, (Object)vdFaccountOuter);
        }
        catch (Exception e) {
            this.logger.error("vd.VdFaccountOuterServiceImpl.makeFaccountOuterDomain", (Throwable)e);
        }
        return vdFaccountOuterReDomain;
    }

    private List<VdFaccountOuter> queryFaccountOuterModelPage(Map<String, Object> parammap) {
        try {
            return this.vdFaccountOuterMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("vd.VdFaccountOuterServiceImpl.queryFaccountOuterModel", (Throwable)e);
            return null;
        }
    }

    private int countFaccountOuter(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.vdFaccountOuterMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("vd.VdFaccountOuterServiceImpl.countFaccountOuter", (Throwable)e);
        }
        return i;
    }

    private String checkFaccountOuterSubset(VdFaccountOuterSubsetDomain vdFaccountOuterSubsetDomain) {
        if (null == vdFaccountOuterSubsetDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        return msg;
    }

    private void setFaccountOuterSubsetDefault(VdFaccountOuterSubset vdFaccountOuterSubset) {
        if (null == vdFaccountOuterSubset) {
            return;
        }
        if (null == vdFaccountOuterSubset.getDataState()) {
            vdFaccountOuterSubset.setDataState(0);
        }
        if (null == vdFaccountOuterSubset.getGmtCreate()) {
            vdFaccountOuterSubset.setGmtCreate(this.getSysDate());
        }
        vdFaccountOuterSubset.setGmtModified(this.getSysDate());
        vdFaccountOuterSubset.setFaccountOuterSubsetNo(vdFaccountOuterSubset.getFaccountOuterNo() + vdFaccountOuterSubset.getFundType());
        if (vdFaccountOuterSubset.getFaccountAmount() == null) {
            vdFaccountOuterSubset.setFaccountAmount(BigDecimal.ZERO);
        }
        if (vdFaccountOuterSubset.getFaccountPortion() == null) {
            vdFaccountOuterSubset.setFaccountPortion(BigDecimal.ZERO);
        }
        if (vdFaccountOuterSubset.getFaccountPrice() == null) {
            vdFaccountOuterSubset.setFaccountPrice(BigDecimal.ONE);
        }
    }

    private int getSubsetMaxCode() {
        int code = 0;
        try {
            return this.vdFaccountOuterSubsetMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("vd.VdFaccountOuterServiceImpl.getSubsetMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setFaccountOuterSubsetUpdataDefault(VdFaccountOuterSubset vdFaccountOuterSubset) {
        if (null == vdFaccountOuterSubset) {
            return;
        }
        vdFaccountOuterSubset.setGmtModified(this.getSysDate());
    }

    private void saveFaccountOuterSubsetModel(VdFaccountOuterSubset vdFaccountOuterSubset) throws ApiException {
        if (null == vdFaccountOuterSubset) {
            return;
        }
        try {
            this.vdFaccountOuterSubsetMapper.insert(vdFaccountOuterSubset);
        }
        catch (Exception e) {
            throw new ApiException("vd.VdFaccountOuterServiceImpl.saveFaccountOuterSubsetModel.ex", (Throwable)e);
        }
    }

    private VdFaccountOuterSubset getFaccountOuterSubsetModelById(Integer faccountOuterSubsetId) {
        if (null == faccountOuterSubsetId) {
            return null;
        }
        try {
            return this.vdFaccountOuterSubsetMapper.selectByPrimaryKey(faccountOuterSubsetId);
        }
        catch (Exception e) {
            this.logger.error("vd.VdFaccountOuterServiceImpl.getFaccountOuterSubsetModelById", (Throwable)e);
            return null;
        }
    }

    public VdFaccountOuterSubset getFaccountOuterSubsetModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.vdFaccountOuterSubsetMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("vd.VdFaccountOuterServiceImpl.getFaccountOuterSubsetModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delFaccountOuterSubsetModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.vdFaccountOuterSubsetMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("vd.VdFaccountOuterServiceImpl.delFaccountOuterSubsetModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("vd.VdFaccountOuterServiceImpl.delFaccountOuterSubsetModelByCode.num");
        }
    }

    private void deleteFaccountOuterSubsetModel(Integer faccountOuterSubsetId) throws ApiException {
        if (null == faccountOuterSubsetId) {
            return;
        }
        int i = 0;
        try {
            i = this.vdFaccountOuterSubsetMapper.deleteByPrimaryKey(faccountOuterSubsetId);
        }
        catch (Exception e) {
            throw new ApiException("vd.VdFaccountOuterServiceImpl.deleteFaccountOuterSubsetModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("vd.VdFaccountOuterServiceImpl.deleteFaccountOuterSubsetModel.num");
        }
    }

    private void updateFaccountOuterSubsetModel(VdFaccountOuterSubset vdFaccountOuterSubset) throws ApiException {
        if (null == vdFaccountOuterSubset) {
            return;
        }
        try {
            this.vdFaccountOuterSubsetMapper.updateByPrimaryKeySelective(vdFaccountOuterSubset);
        }
        catch (Exception e) {
            throw new ApiException("vd.VdFaccountOuterServiceImpl.updateFaccountOuterSubsetModel.ex", (Throwable)e);
        }
    }

    private void updateBalanceFaccountOuterSubsetModel(Map<String, Object> map) throws ApiException {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.vdFaccountOuterSubsetMapper.updateByPrimaryCode(map);
        }
        catch (Exception e) {
            throw new ApiException("vd.VdFaccountOuterServiceImpl.updateFaccountOuterSubsetByCodeModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("vd.VdFaccountOuterServiceImpl.updateFaccountOuterSubsetByCodeModel.null", map.toString());
        }
    }

    private void updateFaccountOuterSubsetModel(Map<String, Object> map) throws ApiException {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.vdFaccountOuterSubsetMapper.updateFaccountOuterSubset(map);
        }
        catch (Exception e) {
            throw new ApiException("vd.VdFaccountOuterServiceImpl.updateFaccountOuterSubsetModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("vd.VdFaccountOuterServiceImpl.updateFaccountOuterSubsetModel.null", map.toString());
        }
    }

    private void updateStateFaccountOuterSubsetModel(Integer faccountOuterSubsetId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == faccountOuterSubsetId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("faccountOuterSubsetId", faccountOuterSubsetId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.vdFaccountOuterSubsetMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("vd.VdFaccountOuterServiceImpl.updateStateFaccountOuterSubsetModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("vd.VdFaccountOuterServiceImpl.updateStateFaccountOuterSubsetModel.null");
        }
    }

    private VdFaccountOuterSubset makeFaccountOuterSubset(VdFaccountOuterSubsetDomain vdFaccountOuterSubsetDomain, VdFaccountOuterSubset vdFaccountOuterSubset) {
        if (null == vdFaccountOuterSubsetDomain) {
            return null;
        }
        if (null == vdFaccountOuterSubset) {
            vdFaccountOuterSubset = new VdFaccountOuterSubset();
        }
        try {
            BeanUtils.copyAllPropertys((Object)vdFaccountOuterSubset, (Object)vdFaccountOuterSubsetDomain);
        }
        catch (Exception e) {
            this.logger.error("vd.VdFaccountOuterServiceImpl.makeFaccountOuterSubset", (Throwable)e);
        }
        return vdFaccountOuterSubset;
    }

    private VdFaccountOuterSubsetReDomain makeFaccountOuterSubsetReDomain(VdFaccountOuterSubset vdFaccountOuterSubset, VdFaccountOuterSubsetReDomain vdFaccountOuterSubsetReDomain) {
        if (null == vdFaccountOuterSubset) {
            return null;
        }
        if (null == vdFaccountOuterSubsetReDomain) {
            vdFaccountOuterSubsetReDomain = new VdFaccountOuterSubsetReDomain();
        }
        try {
            BeanUtils.copyAllPropertys((Object)vdFaccountOuterSubsetReDomain, (Object)vdFaccountOuterSubset);
        }
        catch (Exception e) {
            this.logger.error("vd.VdFaccountOuterServiceImpl.makeFaccountOuterSubsetReDomain", (Throwable)e);
        }
        return vdFaccountOuterSubsetReDomain;
    }

    private List<VdFaccountOuterSubset> queryFaccountOuterSubsetModelPage(Map<String, Object> parammap) {
        try {
            return this.vdFaccountOuterSubsetMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("vd.VdFaccountOuterServiceImpl.queryFaccountOuterSubsetModel", (Throwable)e);
            return null;
        }
    }

    private VdFaccountOuterSubset getLockByPrimaryCodeModel(Map<String, Object> parammap) {
        try {
            return this.vdFaccountOuterSubsetMapper.getLockByPrimaryCode(parammap);
        }
        catch (Exception e) {
            this.logger.error("vd.VdFaccountOuterServiceImpl.getLockByPrimaryCodeModel", (Object)parammap.toString(), (Throwable)e);
            return null;
        }
    }

    private int countFaccountOuterSubset(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.vdFaccountOuterSubsetMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("vd.VdFaccountOuterServiceImpl.countFaccountOuterSubset", (Throwable)e);
        }
        return i;
    }

    private String checkFaccountOuterDt(VdFaccountOuterDtDomain vdFaccountOuterDtDomain) {
        if (null == vdFaccountOuterDtDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        return msg;
    }

    private void setFaccountOuterDtDefault(VdFaccountOuterDt vdFaccountOuterDt) {
        if (null == vdFaccountOuterDt) {
            return;
        }
        if (null == vdFaccountOuterDt.getDataState()) {
            vdFaccountOuterDt.setDataState(0);
        }
        if (null == vdFaccountOuterDt.getGmtCreate()) {
            vdFaccountOuterDt.setGmtCreate(this.getSysDate());
        }
        vdFaccountOuterDt.setGmtModified(this.getSysDate());
        String flagStr = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)(vdFaccountOuterDt.getTenantCode() + "-price_check-price_check"));
        if (StringUtils.isNotBlank((String)flagStr) && null != vdFaccountOuterDt.getOrderAmount() && vdFaccountOuterDt.getOrderAmount().compareTo(BigDecimal.ZERO) < 0) {
            vdFaccountOuterDt.setOrderDc("1");
        }
    }

    private int getOuterDtMaxCode() {
        int code = 0;
        try {
            return this.vdFaccountOuterDtMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("vd.VdFaccountOuterServiceImpl.getOuterDtMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setFaccountOuterDtUpdataDefault(VdFaccountOuterDt vdFaccountOuterDt) {
        if (null == vdFaccountOuterDt) {
            return;
        }
        vdFaccountOuterDt.setGmtModified(this.getSysDate());
    }

    private void saveFaccountOuterDtModel(VdFaccountOuterDt vdFaccountOuterDt) throws ApiException {
        if (null == vdFaccountOuterDt) {
            return;
        }
        try {
            this.vdFaccountOuterDtMapper.insert(vdFaccountOuterDt);
        }
        catch (Exception e) {
            throw new ApiException("vd.VdFaccountOuterServiceImpl.saveFaccountOuterDtModel.ex", (Throwable)e);
        }
    }

    private void saveFaccountOuterDtListModel(List<VdFaccountOuterDt> vdFaccountOuterDtList) throws ApiException {
        if (null == vdFaccountOuterDtList || vdFaccountOuterDtList.isEmpty()) {
            return;
        }
        try {
            this.vdFaccountOuterDtMapper.insertBatch(vdFaccountOuterDtList);
        }
        catch (Exception e) {
            throw new ApiException("vd.VdFaccountOuterServiceImpl.saveFaccountOuterDtListModel.ex", (Throwable)e);
        }
    }

    private VdFaccountOuterDt getFaccountOuterDtModelById(Integer faccountOuterDtId) {
        if (null == faccountOuterDtId) {
            return null;
        }
        try {
            return this.vdFaccountOuterDtMapper.selectByPrimaryKey(faccountOuterDtId);
        }
        catch (Exception e) {
            this.logger.error("vd.VdFaccountOuterServiceImpl.getFaccountOuterDtModelById", (Throwable)e);
            return null;
        }
    }

    public VdFaccountOuterDt getFaccountOuterDtModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.vdFaccountOuterDtMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("vd.VdFaccountOuterServiceImpl.getFaccountOuterDtModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delFaccountOuterDtModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.vdFaccountOuterDtMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("vd.VdFaccountOuterServiceImpl.delFaccountOuterDtModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("vd.VdFaccountOuterServiceImpl.delFaccountOuterDtModelByCode.num");
        }
    }

    private void deleteFaccountOuterDtModel(Integer faccountOuterDtId) throws ApiException {
        if (null == faccountOuterDtId) {
            return;
        }
        int i = 0;
        try {
            i = this.vdFaccountOuterDtMapper.deleteByPrimaryKey(faccountOuterDtId);
        }
        catch (Exception e) {
            throw new ApiException("vd.VdFaccountOuterServiceImpl.deleteFaccountOuterDtModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("vd.VdFaccountOuterServiceImpl.deleteFaccountOuterDtModel.num");
        }
    }

    private void updateFaccountOuterDtModel(VdFaccountOuterDt vdFaccountOuterDt) throws ApiException {
        if (null == vdFaccountOuterDt) {
            return;
        }
        try {
            this.vdFaccountOuterDtMapper.updateByPrimaryKeySelective(vdFaccountOuterDt);
        }
        catch (Exception e) {
            throw new ApiException("vd.VdFaccountOuterServiceImpl.updateFaccountOuterDtModel.ex", (Throwable)e);
        }
    }

    private void updateStateFaccountOuterDtModel(Integer faccountOuterDtId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == faccountOuterDtId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("faccountOuterDtId", faccountOuterDtId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.vdFaccountOuterDtMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("vd.VdFaccountOuterServiceImpl.updateStateFaccountOuterDtModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("vd.VdFaccountOuterServiceImpl.updateStateFaccountOuterDtModel.null");
        }
    }

    private VdFaccountOuterDt makeFaccountOuterDt(VdFaccountOuterDtDomain vdFaccountOuterDtDomain, VdFaccountOuterDt vdFaccountOuterDt) {
        if (null == vdFaccountOuterDtDomain) {
            return null;
        }
        if (null == vdFaccountOuterDt) {
            vdFaccountOuterDt = new VdFaccountOuterDt();
        }
        try {
            BeanUtils.copyAllPropertys((Object)vdFaccountOuterDt, (Object)vdFaccountOuterDtDomain);
        }
        catch (Exception e) {
            this.logger.error("vd.VdFaccountOuterServiceImpl.makeFaccountOuterDt", (Throwable)e);
        }
        return vdFaccountOuterDt;
    }

    private List<VdFaccountOuterDt> queryFaccountOuterDtModelPage(Map<String, Object> parammap) {
        try {
            return this.vdFaccountOuterDtMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("vd.VdFaccountOuterServiceImpl.queryFaccountOuterDtModel", (Throwable)e);
            return null;
        }
    }

    private int countFaccountOuterDt(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.vdFaccountOuterDtMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("vd.VdFaccountOuterServiceImpl.countFaccountOuterDt", (Throwable)e);
        }
        return i;
    }

    private List<VdFaccountOuterDt> makeOuterDt(List<VdFaccountDtDomain> vdFaccountDtDomainList) {
        if (null == vdFaccountDtDomainList || vdFaccountDtDomainList.isEmpty()) {
            return null;
        }
        ArrayList<VdFaccountOuterDt> vdFaccountOuterDtList = new ArrayList<VdFaccountOuterDt>();
        for (VdFaccountDtDomain vdFaccountDtDomain : vdFaccountDtDomainList) {
            vdFaccountOuterDtList.add(this.makeOuterDt(vdFaccountDtDomain));
        }
        return vdFaccountOuterDtList;
    }

    private VdFaccountOuterDt makeOuterDt(VdFaccountDtDomain vdFaccountDtDomain) {
        if (null == vdFaccountDtDomain) {
            return null;
        }
        VdFaccountOuterDt vdFaccountOuterDt = new VdFaccountOuterDt();
        try {
            BeanUtils.copyAllPropertys((Object)vdFaccountOuterDt, (Object)vdFaccountDtDomain);
            vdFaccountOuterDt.setFaccountOuterDtOsqeno(vdFaccountDtDomain.getFaccountDtOsqeno());
            vdFaccountOuterDt.setFaccountOuterDtSqeno(this.createUUIDString());
            vdFaccountOuterDt.setFaccountOuterNo(vdFaccountDtDomain.getFaccountNo());
            vdFaccountOuterDt.setFaccountOuterName(vdFaccountDtDomain.getFaccountName());
            if (null == vdFaccountOuterDt.getGmtCreate()) {
                vdFaccountOuterDt.setGmtCreate(this.getSysDate());
            }
            vdFaccountOuterDt.setGmtModified(this.getSysDate());
            vdFaccountOuterDt.setDataState(0);
            return vdFaccountOuterDt;
        }
        catch (Exception e) {
            throw new ApiException("vd.VdFaccountOuterServiceImpl.makeOuterDt.e", (Throwable)e);
        }
    }

    @Override
    public void saveFaccountOuter(VdFaccountOuterDomain vdFaccountOuterDomain) throws ApiException {
        String msg = this.checkFaccountOuter(vdFaccountOuterDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("vd.VdFaccountOuterServiceImpl.saveFaccountOuter.checkFaccountOuter", msg);
        }
        VdFaccountOuter vdFaccountOuter = this.makeFaccountOuter(vdFaccountOuterDomain, null);
        this.setFaccountOuterDefault(vdFaccountOuter);
        this.saveFaccountOuterModel(vdFaccountOuter);
        vdFaccountOuterDomain.setFaccountOuterNo(vdFaccountOuter.getFaccountOuterNo());
        vdFaccountOuterDomain.setFaccountNo(vdFaccountOuter.getFaccountOuterNo());
        vdFaccountOuterDomain.setFaccountName(vdFaccountOuter.getFaccountOuterName());
        vdFaccountOuterDomain.setFaccountOuterName(vdFaccountOuter.getFaccountOuterName());
    }

    @Override
    public void updateFaccountOuterState(Integer faccountOuterId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateFaccountOuterModel(faccountOuterId, dataState, oldDataState);
    }

    @Override
    public void updateFaccountOuter(VdFaccountOuterDomain vdFaccountOuterDomain) throws ApiException {
        String msg = this.checkFaccountOuter(vdFaccountOuterDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("vd.VdFaccountOuterServiceImpl.updateFaccountOuter.checkFaccountOuter", msg);
        }
        VdFaccountOuter oldVdFaccountOuter = this.getFaccountOuterModelById(vdFaccountOuterDomain.getFaccountOuterId());
        if (null == oldVdFaccountOuter) {
            throw new ApiException("vd.VdFaccountOuterServiceImpl.updateFaccountOuter.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        VdFaccountOuter vdFaccountOuter = this.makeFaccountOuter(vdFaccountOuterDomain, oldVdFaccountOuter);
        this.setFaccountOuterUpdataDefault(vdFaccountOuter);
        this.updateFaccountOuterModel(vdFaccountOuter);
    }

    @Override
    public VdFaccountOuter getFaccountOuter(Integer faccountOuterId) {
        return this.getFaccountOuterModelById(faccountOuterId);
    }

    @Override
    public VdFaccountOuterReDomain getFaccountOuterByNo(String faccountOuterNo, String tenantCode) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("faccountOuterNo", faccountOuterNo);
        map.put("tenantCode", tenantCode);
        VdFaccountOuter vdFaccountOuter = this.getFaccountOuterModelByCode(map);
        if (null == vdFaccountOuter) {
            return null;
        }
        VdFaccountOuterReDomain vdFaccountOuterReDomain = this.makeFaccountOuterReDomain(vdFaccountOuter, null);
        List<VdFaccountOuterSubset> subsetList = this.queryFaccountOuterSubsetModelPage(map);
        if (null != subsetList && !subsetList.isEmpty()) {
            ArrayList<VdFaccountOuterSubsetReDomain> subsetReList = new ArrayList<VdFaccountOuterSubsetReDomain>();
            for (VdFaccountOuterSubset vdFaccountOuterSubset : subsetList) {
                subsetReList.add(this.makeFaccountOuterSubsetReDomain(vdFaccountOuterSubset, null));
            }
            vdFaccountOuterReDomain.setSubsetReList(subsetReList);
        }
        return vdFaccountOuterReDomain;
    }

    @Override
    public void deleteFaccountOuter(Integer faccountOuterId) throws ApiException {
        this.deleteFaccountOuterModel(faccountOuterId);
    }

    @Override
    public QueryResult<VdFaccountInfo> queryFaccountOuterPage(Map<String, Object> map) {
        List<VdFaccountOuter> vdFaccountOuterList = this.queryFaccountOuterModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countFaccountOuter(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(this.makeInfo(vdFaccountOuterList));
        return queryResult;
    }

    @Override
    public QueryResult<VdFaccountInfo> queryFaccountInfoPage(Map<String, Object> map) {
        List<VdFaccountOuter> vdFaccountOuterList = this.queryFaccountOuterModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countFaccountOuter(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(this.makeInfoStr(vdFaccountOuterList, (String)map.get("type")));
        return queryResult;
    }

    private List<VdFaccountInfo> makeInfoStr(List<VdFaccountOuter> list, String type) {
        if (ListUtil.isEmpty(list)) {
            return null;
        }
        ArrayList<VdFaccountInfo> infoList = new ArrayList<VdFaccountInfo>();
        for (VdFaccountOuter vdFaccountOuter : list) {
            infoList.add(this.makeInfoStr(vdFaccountOuter, type));
        }
        return infoList;
    }

    private VdFaccountInfo makeInfoStr(VdFaccountOuter vdFaccountOuter, String type) {
        if (null == vdFaccountOuter) {
            return null;
        }
        VdFaccountInfo vdFaccountInfo = new VdFaccountInfo().convertToVdFaccountInfo(vdFaccountOuter);
        if (null == vdFaccountInfo) {
            return null;
        }
        List<VdFaccountOuterSubset> subsetList = this.queryFaccountOuterSubsetModelPage(this.getQueryMapParam("faccountOuterNo,tenantCode", new Object[]{vdFaccountInfo.getFaccountOuterNo(), vdFaccountInfo.getTenantCode()}));
        vdFaccountInfo.setSubsetList(subsetList);
        this.makeBanlceNew(vdFaccountInfo, subsetList, type);
        return vdFaccountInfo;
    }

    @Override
    public void saveFaccountOuterSubset(VdFaccountOuterSubsetDomain vdFaccountOuterSubsetDomain) throws ApiException {
        String msg = this.checkFaccountOuterSubset(vdFaccountOuterSubsetDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("vd.VdFaccountOuterServiceImpl.saveFaccountOuterSubset.checkFaccountOuterSubset", msg);
        }
        VdFaccountOuterSubset vdFaccountOuterSubset = this.makeFaccountOuterSubset(vdFaccountOuterSubsetDomain, null);
        this.setFaccountOuterSubsetDefault(vdFaccountOuterSubset);
        this.saveFaccountOuterSubsetModel(vdFaccountOuterSubset);
    }

    @Override
    public void updateFaccountOuterSubsetState(Integer faccountOuterSubsetId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateFaccountOuterSubsetModel(faccountOuterSubsetId, dataState, oldDataState);
    }

    @Override
    public void updateFaccountOuterSubset(VdFaccountOuterSubsetDomain vdFaccountOuterSubsetDomain) throws ApiException {
        String msg = this.checkFaccountOuterSubset(vdFaccountOuterSubsetDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("vd.VdFaccountOuterServiceImpl.updateFaccountOuterSubset.checkFaccountOuterSubset", msg);
        }
        VdFaccountOuterSubset oldVdFaccountOuterSubset = this.getFaccountOuterSubsetModelById(vdFaccountOuterSubsetDomain.getFaccountOuterSubsetId());
        if (null == oldVdFaccountOuterSubset) {
            throw new ApiException("vd.VdFaccountOuterServiceImpl.updateFaccountOuterSubset.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        VdFaccountOuterSubset vdFaccountOuterSubset = this.makeFaccountOuterSubset(vdFaccountOuterSubsetDomain, oldVdFaccountOuterSubset);
        this.setFaccountOuterSubsetUpdataDefault(vdFaccountOuterSubset);
        this.updateFaccountOuterSubsetModel(vdFaccountOuterSubset);
    }

    @Override
    public VdFaccountOuterSubset getFaccountOuterSubset(Integer faccountOuterSubsetId) {
        return this.getFaccountOuterSubsetModelById(faccountOuterSubsetId);
    }

    @Override
    public void deleteFaccountOuterSubset(Integer faccountOuterSubsetId) throws ApiException {
        this.deleteFaccountOuterSubsetModel(faccountOuterSubsetId);
    }

    @Override
    public QueryResult<VdFaccountOuterSubset> queryFaccountOuterSubsetPage(Map<String, Object> map) {
        List<VdFaccountOuterSubset> vdFaccountOuterSubsetList = this.queryFaccountOuterSubsetModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countFaccountOuterSubset(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(vdFaccountOuterSubsetList);
        return queryResult;
    }

    @Override
    public void saveFaccountOuterDt(VdFaccountOuterDtDomain vdFaccountOuterDtDomain) throws ApiException {
        String msg = this.checkFaccountOuterDt(vdFaccountOuterDtDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("vd.VdFaccountOuterServiceImpl.saveFaccountOuterDt.checkFaccountOuterDt", msg);
        }
        VdFaccountOuterDt vdFaccountOuterDt = this.makeFaccountOuterDt(vdFaccountOuterDtDomain, null);
        this.setFaccountOuterDtDefault(vdFaccountOuterDt);
        this.saveFaccountOuterDtModel(vdFaccountOuterDt);
    }

    @Override
    public void updateFaccountOuterDtState(Integer faccountOuterDtId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateFaccountOuterDtModel(faccountOuterDtId, dataState, oldDataState);
    }

    @Override
    public void updateFaccountOuterDt(VdFaccountOuterDtDomain vdFaccountOuterDtDomain) throws ApiException {
        String msg = this.checkFaccountOuterDt(vdFaccountOuterDtDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("vd.VdFaccountOuterServiceImpl.updateFaccountOuterDt.checkFaccountOuterDt", msg);
        }
        VdFaccountOuterDt oldVdFaccountOuterDt = this.getFaccountOuterDtModelById(vdFaccountOuterDtDomain.getFaccountOuterDtId());
        if (null == oldVdFaccountOuterDt) {
            throw new ApiException("vd.VdFaccountOuterServiceImpl.updateFaccountOuterDt.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        VdFaccountOuterDt vdFaccountOuterDt = this.makeFaccountOuterDt(vdFaccountOuterDtDomain, oldVdFaccountOuterDt);
        this.setFaccountOuterDtUpdataDefault(vdFaccountOuterDt);
        this.updateFaccountOuterDtModel(vdFaccountOuterDt);
    }

    @Override
    public VdFaccountOuterDt getFaccountOuterDt(Integer faccountOuterDtId) {
        return this.getFaccountOuterDtModelById(faccountOuterDtId);
    }

    @Override
    public void deleteFaccountOuterDt(Integer faccountOuterDtId) throws ApiException {
        this.deleteFaccountOuterDtModel(faccountOuterDtId);
    }

    @Override
    public QueryResult<VdFaccountOuterDt> queryFaccountOuterDtPage(Map<String, Object> map) {
        List<VdFaccountOuterDt> vdFaccountOuterDtList = this.queryFaccountOuterDtModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countFaccountOuterDt(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(vdFaccountOuterDtList);
        return queryResult;
    }

    @Override
    public void saveFaccountDt(List<VdFaccountDtDomain> vdFaccountDtDomainList) throws ApiException {
        List<VdFaccountOuterDt> vdFaccountOuterDtList = this.makeOuterDt(vdFaccountDtDomainList);
        if (null == vdFaccountOuterDtList || vdFaccountOuterDtList.isEmpty()) {
            throw new ApiException("vd.VdFaccountOuterServiceImpl.saveFaccountDt.null", "null");
        }
        this.saveFaccountOuterDtListModel(vdFaccountOuterDtList);
    }

    @Override
    public void saveFaccountDtOne(VdFaccountDtDomain vdFaccountDtDomain) throws ApiException {
        VdFaccountOuterDt vdFaccountOuterDt = this.makeOuterDt(vdFaccountDtDomain);
        if (null == vdFaccountOuterDt) {
            throw new ApiException("vd.VdFaccountOuterServiceImpl.saveFaccountDtOne.null", "null");
        }
        this.roundAmount(vdFaccountOuterDt);
        this.saveFaccountOuterDtModel(vdFaccountOuterDt);
    }

    public void roundAmount(VdFaccountOuterDt vdFaccountOuterDt) {
        if (vdFaccountOuterDt.getFaccountAfamount() != null) {
            vdFaccountOuterDt.setFaccountAfamount(vdFaccountOuterDt.getFaccountAfamount().setScale(6, 5));
        }
        if (vdFaccountOuterDt.getFaccountBfamount() != null) {
            vdFaccountOuterDt.setFaccountBfamount(vdFaccountOuterDt.getFaccountBfamount().setScale(6, 5));
        }
        if (vdFaccountOuterDt.getFaccountAfprice() != null) {
            vdFaccountOuterDt.setFaccountAfprice(vdFaccountOuterDt.getFaccountAfprice().setScale(6, 5));
        }
        if (vdFaccountOuterDt.getFaccountBfprice() != null) {
            vdFaccountOuterDt.setFaccountBfprice(vdFaccountOuterDt.getFaccountBfprice().setScale(6, 5));
        }
    }

    @Override
    public List<VdFaccountInfo> queryOuterFaccount(String merchantCode, String faccountType, String tenantCode) {
        if (StringUtils.isBlank((String)merchantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("merchantCode", merchantCode);
        map.put("faccountType", faccountType);
        map.put("tenantCode", tenantCode);
        List<VdFaccountOuter> list = this.queryFaccountOuterModelPage(map);
        if (null == list || list.isEmpty()) {
            return null;
        }
        List<VdFaccountInfo> infoList = this.makeInfo(list);
        return infoList;
    }

    @Override
    public List<VdFaccountInfo> queryOuterFaccountNew(String merchantCode, String faccountType, String type, String tenantCode) {
        if (StringUtils.isBlank((String)merchantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("merchantCode", merchantCode);
        map.put("faccountType", faccountType);
        map.put("tenantCode", tenantCode);
        List<VdFaccountOuter> list = this.queryFaccountOuterModelPage(map);
        if (null == list || list.isEmpty()) {
            return null;
        }
        List<VdFaccountInfo> infoList = this.makeInfoNew(list, type);
        return infoList;
    }

    private List<VdFaccountInfo> makeInfo(List<VdFaccountOuter> list) {
        if (ListUtil.isEmpty(list)) {
            return null;
        }
        ArrayList<VdFaccountInfo> infoList = new ArrayList<VdFaccountInfo>();
        for (VdFaccountOuter vdFaccountOuter : list) {
            infoList.add(this.makeInfo(vdFaccountOuter));
        }
        return infoList;
    }

    private List<VdFaccountInfo> makeInfoNew(List<VdFaccountOuter> list, String type) {
        if (ListUtil.isEmpty(list)) {
            return null;
        }
        ArrayList<VdFaccountInfo> infoList = new ArrayList<VdFaccountInfo>();
        for (VdFaccountOuter vdFaccountOuter : list) {
            infoList.add(this.makeInfoNew(vdFaccountOuter, type));
        }
        return infoList;
    }

    private VdFaccountInfo makeInfoNew(VdFaccountOuter vdFaccountOuter, String type) {
        if (null == vdFaccountOuter) {
            return null;
        }
        VdFaccountInfo vdFaccountInfo = new VdFaccountInfo().convertToVdFaccountInfo(vdFaccountOuter);
        if (null == vdFaccountInfo) {
            return null;
        }
        List<VdFaccountOuterSubset> subsetList = this.queryFaccountOuterSubsetModelPage(this.getQueryMapParam("faccountOuterNo,tenantCode", new Object[]{vdFaccountInfo.getFaccountOuterNo(), vdFaccountInfo.getTenantCode()}));
        vdFaccountInfo.setSubsetList(subsetList);
        this.makeBanlceNew(vdFaccountInfo, subsetList, type);
        return vdFaccountInfo;
    }

    private VdFaccountInfo makeInfo(VdFaccountOuter vdFaccountOuter) {
        if (null == vdFaccountOuter) {
            return null;
        }
        VdFaccountInfo vdFaccountInfo = new VdFaccountInfo().convertToVdFaccountInfo(vdFaccountOuter);
        if (null == vdFaccountInfo) {
            return null;
        }
        List<VdFaccountOuterSubset> subsetList = this.queryFaccountOuterSubsetModelPage(this.getQueryMapParam("faccountOuterNo,tenantCode", new Object[]{vdFaccountInfo.getFaccountOuterNo(), vdFaccountInfo.getTenantCode()}));
        vdFaccountInfo.setSubsetList(subsetList);
        this.makeBanlce(vdFaccountInfo, subsetList);
        return vdFaccountInfo;
    }

    private void makeBanlceNew(VdFaccountInfo vdFaccountInfo, List<VdFaccountOuterSubset> subsetList, String type) {
        if (null == vdFaccountInfo || null == subsetList || subsetList.isEmpty()) {
            return;
        }
        if (StringUtils.isBlank((String)vdFaccountInfo.getFundType())) {
            vdFaccountInfo.setFundType("01");
        }
        for (VdFaccountOuterSubset vdFaccountOuterSubset : subsetList) {
            if (StringUtils.isNotBlank((String)type)) {
                if (!type.equals(vdFaccountOuterSubset.getFundType())) continue;
                vdFaccountInfo.setCurrencyDirection(vdFaccountOuterSubset.getCurrencyDirection());
                vdFaccountInfo.setCurrencyCode(vdFaccountOuterSubset.getCurrencyCode());
                vdFaccountInfo.setFaccountAmount(vdFaccountOuterSubset.getFaccountAmount());
                vdFaccountInfo.setFaccountPortion(vdFaccountOuterSubset.getFaccountPortion());
                vdFaccountInfo.setFaccountPrice(vdFaccountOuterSubset.getFaccountPrice());
                continue;
            }
            if (!vdFaccountInfo.getFundType().equals(vdFaccountOuterSubset.getFundType())) continue;
            vdFaccountInfo.setCurrencyDirection(vdFaccountOuterSubset.getCurrencyDirection());
            vdFaccountInfo.setCurrencyCode(vdFaccountOuterSubset.getCurrencyCode());
            vdFaccountInfo.setFaccountAmount(vdFaccountOuterSubset.getFaccountAmount());
            vdFaccountInfo.setFaccountPortion(vdFaccountOuterSubset.getFaccountPortion());
            vdFaccountInfo.setFaccountPrice(vdFaccountOuterSubset.getFaccountPrice());
        }
    }

    private void makeBanlce(VdFaccountInfo vdFaccountInfo, List<VdFaccountOuterSubset> subsetList) {
        if (null == vdFaccountInfo || null == subsetList || subsetList.isEmpty()) {
            return;
        }
        if (StringUtils.isBlank((String)vdFaccountInfo.getFundType())) {
            vdFaccountInfo.setFundType("01");
        }
        for (VdFaccountOuterSubset vdFaccountOuterSubset : subsetList) {
            if (!vdFaccountInfo.getFundType().equals(vdFaccountOuterSubset.getFundType())) continue;
            vdFaccountInfo.setCurrencyDirection(vdFaccountOuterSubset.getCurrencyDirection());
            vdFaccountInfo.setCurrencyCode(vdFaccountOuterSubset.getCurrencyCode());
            vdFaccountInfo.setFaccountAmount(vdFaccountOuterSubset.getFaccountAmount());
            vdFaccountInfo.setFaccountPortion(vdFaccountOuterSubset.getFaccountPortion());
            vdFaccountInfo.setFaccountPrice(vdFaccountOuterSubset.getFaccountPrice());
        }
    }

    @Override
    public List<VdFaccountDtDomain> saveFaccountBalance(List<VdFaccountDoDomain> vdFaccountDoDomainList) throws ApiException {
        if (null == vdFaccountDoDomainList || vdFaccountDoDomainList.isEmpty()) {
            throw new ApiException("vd.VdFaccountOuterServiceImpl.saveFaccountBalance.null", "null");
        }
        Collections.sort(vdFaccountDoDomainList, new Comparator<VdFaccountDoDomain>(){

            @Override
            public int compare(VdFaccountDoDomain arg0, VdFaccountDoDomain arg1) {
                return arg0.getFaccountId().compareTo(arg1.getFaccountId());
            }
        });
        ArrayList<VdFaccountDtDomain> dtList = new ArrayList<VdFaccountDtDomain>();
        for (VdFaccountDoDomain vdFaccountDoDomain : vdFaccountDoDomainList) {
            dtList.add(this.saveBalance(vdFaccountDoDomain));
        }
        return dtList;
    }

    @Override
    public VdFaccountDtDomain saveFaccountBalanceOne(VdFaccountDoDomain vdFaccountDoDomain) throws ApiException {
        if (null == vdFaccountDoDomain) {
            throw new ApiException("vd.VdFaccountOuterServiceImpl.saveFaccountBalancOne.null", "null");
        }
        return this.saveBalance(vdFaccountDoDomain);
    }

    private String checkDo(VdFaccountDoDomain vdFaccountDoDomain) {
        if (null == vdFaccountDoDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)vdFaccountDoDomain.getFaccountId())) {
            msg = msg + "\u8d26\u6237\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)vdFaccountDoDomain.getOrderDc())) {
            msg = msg + "\u501f\u8d37\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)vdFaccountDoDomain.getOrderCurrency())) {
            msg = msg + "\u5e01\u79cd\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)vdFaccountDoDomain.getFundType())) {
            msg = msg + "\u8d44\u91d1\u5c5e\u6027\u4e3a\u7a7a;";
        }
        return msg;
    }

    private VdFaccountDtDomain saveBalance(VdFaccountDoDomain vdFaccountDoDomain) {
        String msg = this.checkDo(vdFaccountDoDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("vd.VdFaccountOuterServiceImpl.saveBalance.null", msg);
        }
        VdFaccountOuter vdFaccountOuter = this.getFaccountOuterLockByCodeModel(vdFaccountDoDomain.getFaccountId(), vdFaccountDoDomain.getTenantCode());
        if (null == vdFaccountOuter) {
            throw new ApiException("vd.VdFaccountOuterServiceImpl.saveBalance.vdFaccountOuter", "\u8d26\u6237\u5f02\u5e38");
        }
        VdFaccountOuterSubset vdFaccountOuterSubset = this.getSunset(vdFaccountDoDomain);
        if (null == vdFaccountOuterSubset) {
            this.logger.error("vd.VdFaccountOuterServiceImpl.saveBalance.vdFaccountOuterSubset", (Object)JsonUtil.buildNormalBinder().toJson((Object)vdFaccountDoDomain));
            throw new ApiException("vd.VdFaccountOuterServiceImpl.saveBalance.vdFaccountOuterSubset", "\u5b57\u8d26\u6237\u5f02\u5e38");
        }
        VdFaccountDtDomain vdFaccountDtDomain = this.saveBalance(vdFaccountDoDomain, vdFaccountOuterSubset);
        if (null == vdFaccountDtDomain) {
            this.logger.error("vd.VdFaccountOuterServiceImpl.saveBalance.vdFaccountDtDomain", (Object)(JsonUtil.buildNormalBinder().toJson((Object)vdFaccountDoDomain) + "vdFaccountOuterSubset" + JsonUtil.buildNormalBinder().toJson((Object)vdFaccountOuterSubset)));
            throw new ApiException("vd.VdFaccountOuterServiceImpl.saveBalance.vdFaccountDtDomain", "\u8d26\u6237\u5f02\u5e38");
        }
        vdFaccountDtDomain.setFaccountName(vdFaccountOuter.getFaccountOuterName());
        return vdFaccountDtDomain;
    }

    private VdFaccountOuterSubset getSunset(VdFaccountDoDomain vdFaccountDoDomain) {
        if (null == vdFaccountDoDomain) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("faccountOuterSubsetNo", vdFaccountDoDomain.getFaccountId() + "01");
        map.put("tenantCode", vdFaccountDoDomain.getTenantCode());
        VdFaccountOuterSubset vdFaccountOuterSubset = this.getFaccountOuterSubsetModelByCode(map);
        return vdFaccountOuterSubset;
    }

    private VdFaccountDtDomain saveBalance(VdFaccountDoDomain vdFaccountDoDomain, VdFaccountOuterSubset vdFaccountOuterSubset) {
        if (null == vdFaccountDoDomain || null == vdFaccountOuterSubset) {
            return null;
        }
        BalanceBean balanceBean = new BalanceBean();
        OrderBean orderBean = new OrderBean();
        try {
            BeanUtils.copyAllPropertys((Object)balanceBean, (Object)vdFaccountOuterSubset);
            BeanUtils.copyAllPropertys((Object)orderBean, (Object)vdFaccountDoDomain);
        }
        catch (Exception e) {
            throw new ApiException("vd.VdFaccountOuterServiceImpl.saveBalance.copy", "\u8d26\u6237\u5f02\u5e38");
        }
        balanceBean.operation(orderBean);
        VdFaccountDtDomain vdFaccountDtDomain = this.makeToDt(vdFaccountDoDomain, vdFaccountOuterSubset);
        if (null == vdFaccountDtDomain) {
            throw new ApiException("vd.VdFaccountOuterServiceImpl.saveBalance.makeToDt", "\u8d26\u6237\u5f02\u5e38");
        }
        if (balanceBean.isDirectionAllOrFaccountAmountGtZero()) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("faccountOuterSubsetNo", vdFaccountOuterSubset.getFaccountOuterSubsetNo());
            map.put("tenantCode", vdFaccountOuterSubset.getTenantCode());
            map.put("currencyDirection", balanceBean.getCurrencyDirection());
            map.put("faccountAmount", balanceBean.getFaccountAmount());
            map.put("faccountPortion", balanceBean.getFaccountPortion());
            map.put("faccountPrice", balanceBean.getFaccountPrice());
            this.updateBalanceFaccountOuterSubsetModel(map);
        }
        vdFaccountDtDomain.setCont(balanceBean.isDirectionAllOrFaccountAmountGtZero());
        vdFaccountDtDomain.setFaccountAfamount(balanceBean.getFaccountAmount());
        vdFaccountDtDomain.setFaccountAfportion(balanceBean.getFaccountPortion());
        vdFaccountDtDomain.setFaccountAfprice(balanceBean.getFaccountPrice());
        vdFaccountDtDomain.setCurrencyAfdirection(balanceBean.getCurrencyDirection());
        vdFaccountDtDomain.setFaccountingDate(DateUtil.getDateString((Date)new Date(), (String)"yyyyMMdd"));
        return vdFaccountDtDomain;
    }

    private VdFaccountDtDomain makeToDt(VdFaccountDoDomain vdFaccountDoDomain, VdFaccountOuterSubset vdFaccountOuterSubset) {
        if (null == vdFaccountDoDomain || null == vdFaccountOuterSubset) {
            return null;
        }
        VdFaccountDtDomain vdFaccountDtDomain = new VdFaccountDtDomain();
        try {
            BeanUtils.copyAllPropertys((Object)vdFaccountDtDomain, (Object)vdFaccountDoDomain);
            vdFaccountDtDomain.setGmtCreate(this.getSysDate());
            vdFaccountDtDomain.setFaccountNo(vdFaccountOuterSubset.getFaccountOuterNo());
            vdFaccountDtDomain.setFaccountTitileCode(vdFaccountOuterSubset.getFaccountTitileCode());
            vdFaccountDtDomain.setFaccountBfamount(vdFaccountOuterSubset.getFaccountAmount());
            vdFaccountDtDomain.setFaccountBfportion(vdFaccountOuterSubset.getFaccountPortion());
            vdFaccountDtDomain.setFaccountBfprice(vdFaccountOuterSubset.getFaccountPrice());
            vdFaccountDtDomain.setCurrencyBfdirection(vdFaccountOuterSubset.getFaccountDirection());
            vdFaccountDtDomain.setCurrencyCode(vdFaccountOuterSubset.getCurrencyCode());
            return vdFaccountDtDomain;
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public List<VdFaccountDomain> saveOpenFaccount(List<VdFaccountDomain> vdFaccountDomainList) throws ApiException {
        if (null == vdFaccountDomainList || vdFaccountDomainList.isEmpty()) {
            throw new ApiException("vd.VdFaccountOuterServiceImpl.saveOpenFaccount.null", "null");
        }
        VdFaccountOuterDomain vdFaccountOuterDomain = null;
        for (VdFaccountDomain vdFaccountDomain : vdFaccountDomainList) {
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            parameters.put("channelCode", vdFaccountDomain.getChannelCode());
            parameters.put("tenantCode", vdFaccountDomain.getTenantCode());
            parameters.put("merchantCode", vdFaccountDomain.getMerchantCode());
            parameters.put("fundType", vdFaccountDomain.getFundType());
            List<VdFaccountOuter> query = this.vdFaccountOuterMapper.query(parameters);
            if (CollectionUtils.isNotEmpty(query)) continue;
            vdFaccountOuterDomain = this.makeFaccountToOuter(vdFaccountDomain);
            if (null == vdFaccountOuterDomain) {
                throw new ApiException("vd.VdFaccountOuterServiceImpl.makeFaccountToOuter.null", "null");
            }
            this.saveFaccountOuter(vdFaccountOuterDomain);
            vdFaccountDomain.setFaccountNo(vdFaccountOuterDomain.getFaccountOuterNo());
            this.saveSubsetList(vdFaccountOuterDomain.getFaccountNo(), vdFaccountDomain.getSubsetList());
            vdFaccountDomain.setSubsetList(null);
        }
        return vdFaccountDomainList;
    }

    private void saveSubsetList(String faccountOuterNo, List<VdFaccountSubsetDomain> subsetList) {
        if (null == subsetList || subsetList.isEmpty()) {
            throw new ApiException("vd.VdFaccountOuterServiceImpl.saveSubsetList.null", "null");
        }
        VdFaccountOuterSubsetDomain vdFaccountOuterSubsetDomain = null;
        for (VdFaccountSubsetDomain vdFaccountSubsetDomain : subsetList) {
            vdFaccountOuterSubsetDomain = this.makeFaccountToOuterSubset(vdFaccountSubsetDomain);
            if (null == vdFaccountOuterSubsetDomain) {
                throw new ApiException("vd.VdFaccountOuterServiceImpl.saveSubsetList.make", "null");
            }
            vdFaccountOuterSubsetDomain.setFaccountOuterNo(faccountOuterNo);
            this.saveFaccountOuterSubset(vdFaccountOuterSubsetDomain);
        }
    }

    private VdFaccountOuterSubsetDomain makeFaccountToOuterSubset(VdFaccountSubsetDomain vdFaccountSubsetDomain) {
        if (null == vdFaccountSubsetDomain) {
            return null;
        }
        VdFaccountOuterSubsetDomain vdFaccountOuterSubsetDomain = new VdFaccountOuterSubsetDomain();
        try {
            BeanUtils.copyAllPropertys((Object)vdFaccountOuterSubsetDomain, (Object)vdFaccountSubsetDomain);
        }
        catch (Exception e) {
            this.logger.error("vd.VdFaccountOuterServiceImpl.makeFaccountToOuterSubset.e", (Throwable)e);
            return null;
        }
        return vdFaccountOuterSubsetDomain;
    }

    private VdFaccountOuterDomain makeFaccountToOuter(VdFaccountDomain vdFaccountDomain) {
        if (null == vdFaccountDomain) {
            return null;
        }
        VdFaccountOuterDomain vdFaccountOuterDomain = new VdFaccountOuterDomain();
        try {
            BeanUtils.copyAllPropertys((Object)vdFaccountOuterDomain, (Object)vdFaccountDomain);
            vdFaccountOuterDomain.setFaccountOuterName(vdFaccountDomain.getFaccountName());
        }
        catch (Exception e) {
            return null;
        }
        return vdFaccountOuterDomain;
    }

    @Override
    public String queryOuterFaccountInfo(String merchantCode, String faccountType, String tenantCode) {
        List<VdFaccountInfo> list = this.queryOuterFaccount(merchantCode, faccountType, tenantCode);
        HashMap<String, List<VdFaccountInfo>> map = new HashMap<String, List<VdFaccountInfo>>();
        map.put("list", list);
        return JsonUtil.buildNormalBinder().toJson(map);
    }

    @Override
    public QueryResult<VdFaccountOuterDtAll> queryOuterFaccountDtAll(Map<String, Object> map) {
        this.checkparam(map);
        List<VdFaccountOuterDtAll> list = this.queryFaccountOuterDtAllPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countFaccountOuterDtAll(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(list);
        return queryResult;
    }

    private List<VdFaccountOuterDtAll> queryFaccountOuterDtAllPage(Map<String, Object> parammap) {
        try {
            return this.vdFaccountOuterDtMapper.querybyMerber(parammap);
        }
        catch (Exception e) {
            this.logger.error("vd.VdFaccountOuterServiceImpl.queryFaccountOuterDtAllPage", (Throwable)e);
            return null;
        }
    }

    private int countFaccountOuterDtAll(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.vdFaccountOuterDtMapper.countbyMerber(map);
        }
        catch (Exception e) {
            this.logger.error("vd.VdFaccountOuterServiceImpl.countFaccountOuterDt", (Throwable)e);
        }
        return i;
    }

    private void checkparam(Map<String, Object> map) {
        try {
            Objects.requireNonNull(map, "\u53c2\u6570\u4e3a\u7a7a");
            Objects.requireNonNull(map.get("tenantCode"), "\u79df\u6237ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        catch (IllegalArgumentException e) {
            throw new ApiException("vd.VdFaccountOuterServiceImpl.queryOuterFaccountDtAll.ex", e.getMessage());
        }
    }

    @Override
    public String queryOuterFaccountDtAllForeign(Map<String, Object> map) {
        Object startRow = map.get("startRow");
        Object rows = map.get("rows");
        if (startRow != null && startRow != null) {
            map.put("startRow", Integer.valueOf(startRow.toString()));
            map.put("rows", Integer.valueOf(rows.toString()));
        }
        QueryResult<VdFaccountOuterDtAll> obj = this.queryOuterFaccountDtAll(map);
        return JsonUtil.buildNormalBinder().toJson(obj);
    }

    @Override
    public Map<String, Object> queryFaccountIncome(Map<String, String> map) {
        String tenantCode = map.get("tenantCode");
        String merchantCode = map.get("merchantCode");
        String faccountType = map.get("faccountType");
        if (StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)merchantCode)) {
            this.logger.error("vd.VdFaccountOuterServiceImpl.summryFaccountIncome", (Object)"\u53c2\u6570\u4e3a\u7a7a");
            return null;
        }
        List<VdFaccountOuter> vdFaccountOuters = this.queryFaccountOuterModelPage(this.getQueryParamMap("tenantCode,merchantCode,faccountType", new Object[]{tenantCode, merchantCode, faccountType}));
        if (ListUtil.isEmpty(vdFaccountOuters)) {
            this.logger.error("vd.VdFaccountOuterServiceImpl.summryFaccountIncome", (Object)"\u865a\u62df\u8d26\u6237\u5f02\u5e38");
            return null;
        }
        VdFaccountOuter vdFaccountOuter = vdFaccountOuters.get(0);
        return this.exchangeIncome(vdFaccountOuter, map);
    }

    @Override
    public List<Map<String, Object>> queryFaccountOverview(Map<String, String> map) {
        if (map == null || !map.containsKey("tenantCode")) {
            this.logger.error("tenantcode can`t be null");
            return null;
        }
        return this.vdFaccountOuterDtMapper.fAccountOuterOverview(map);
    }

    @Override
    public List<Map<String, Object>> statFaccountOverviewByDay(Map<String, Object> map) throws ApiException {
        if (map == null) {
            return null;
        }
        return this.vdFaccountOuterDtMapper.statFaccountOverviewByDay(map);
    }

    private Map<String, Object> exchangeIncome(VdFaccountOuter vdFaccountOuter, Map<String, String> map) {
        String titileCode = vdFaccountOuter.getFaccountTitileCode();
        String add = "";
        String sub = "";
        if ("2".equals(titileCode.substring(0, 1))) {
            sub = "1";
            add = "2";
        } else if ("1".equals(titileCode.substring(0, 1))) {
            add = "1";
            sub = "2";
        }
        map.put("faccountOuterNo", vdFaccountOuter.getFaccountOuterNo());
        IncomeAmountContext IAC_ADD = this.resultIncome(map, add);
        IncomeAmountContext IAC_SUB = this.resultIncome(map, sub);
        HashMap<String, Object> resutlMap = new HashMap<String, Object>();
        resutlMap.put("count", IAC_ADD.getCount() + IAC_SUB.getCount());
        resutlMap.put("amount", IAC_ADD.getAmount().subtract(IAC_SUB.getAmount()).setScale(2));
        return resutlMap;
    }

    private IncomeAmountContext resultIncome(Map<String, String> queryMap, String dc) {
        if (MapUtil.isEmpty(queryMap)) {
            return new IncomeAmountContext();
        }
        queryMap.put("orderDc", dc);
        Map<String, Object> subAmount = this.summaryIncomeAmount(queryMap);
        Integer count = 0;
        BigDecimal money = BigDecimal.ZERO;
        if (MapUtil.isNotEmpty(subAmount) && (count = Integer.valueOf(subAmount.get("count").toString())) != 0) {
            money = new BigDecimal(subAmount.get("amount").toString());
        }
        return new IncomeAmountContext(count, money);
    }

    private Map<String, Object> summaryIncomeAmount(Map<String, String> map) {
        try {
            return this.vdFaccountOuterDtMapper.summaryIncomeAmount(map);
        }
        catch (Exception e) {
            this.logger.error("vd.VdFaccountOuterServiceImpl.summaryIncomeAmount", (Throwable)e);
            return null;
        }
    }

    @Override
    public Map<String, Object> summaryFaccountAmount(Map<String, String> map) {
        return this.summaryIncomeAmount(map);
    }

    @Override
    public List<VdFaccountInfo> savePolishAccountInfo(String merchantCode, String faccountType, String tenantCode) {
        String fchannelCode = "0" + faccountType.substring(0, 1);
        List<VdFaccountDefReDomain> defList = this.vdFaccountDefService.queryFaccountDefByFchannelCode(fchannelCode, faccountType, tenantCode);
        if (ListUtil.isEmpty(defList) && ListUtil.isEmpty(defList = this.vdFaccountDefService.queryFaccountDefByFchannelCode(fchannelCode, faccountType, "00000000"))) {
            return null;
        }
        this.saveOpenFaccount(this.makeFaccountList(tenantCode, merchantCode, null, defList));
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("merchantCode", merchantCode);
        map.put("faccountType", faccountType);
        map.put("tenantCode", tenantCode);
        List<VdFaccountOuter> list = this.queryFaccountOuterModelPage(map);
        ArrayList<VdFaccountInfo> infoList = new ArrayList<VdFaccountInfo>();
        for (VdFaccountOuter vdFaccountOuter : list) {
            infoList.add(this.makeInfo(vdFaccountOuter));
        }
        return infoList;
    }

    private List<VdFaccountDomain> makeFaccountList(String tenantCode, String merchantCode, String faccountTitileCode, List<VdFaccountDefReDomain> defList) {
        if (null == defList || defList.isEmpty()) {
            return null;
        }
        ArrayList<VdFaccountDomain> vdFaccountDomainList = new ArrayList<VdFaccountDomain>();
        VdFaccountDomain vdFaccountDomain = null;
        if (null == faccountTitileCode) {
            faccountTitileCode = "";
        }
        for (VdFaccountDefReDomain vdFaccountDefReDomain : defList) {
            vdFaccountDomain = new VdFaccountDomain();
            vdFaccountDomain.setFaccountName(vdFaccountDefReDomain.getFaccountDefName());
            vdFaccountDomain.setTenantCode(tenantCode);
            vdFaccountDomain.setMerchantCode(merchantCode);
            vdFaccountDomain.setCurrencyCode(vdFaccountDefReDomain.getCurrencyCode());
            vdFaccountDomain.setFaccountLevel(vdFaccountDefReDomain.getFaccountLevel());
            vdFaccountDomain.setFaccountAttribute(vdFaccountDefReDomain.getFaccountAttribute());
            vdFaccountDomain.setFundType(vdFaccountDefReDomain.getFundType());
            if (StringUtils.isNotBlank((String)vdFaccountDefReDomain.getFaccountTitileCode())) {
                vdFaccountDomain.setFaccountTitileCode(vdFaccountDefReDomain.getFaccountTitileCode().replace("{titileCode}", faccountTitileCode));
            } else {
                vdFaccountDomain.setFaccountTitileCode(faccountTitileCode);
            }
            vdFaccountDomain.setFaccountType(vdFaccountDefReDomain.getFaccountType());
            vdFaccountDomain.setFaccountDirection(vdFaccountDefReDomain.getFaccountDirection());
            vdFaccountDomain.setSubsetList(this.makeFaccountSubsetList(vdFaccountDefReDomain, tenantCode));
            vdFaccountDomainList.add(vdFaccountDomain);
        }
        return vdFaccountDomainList;
    }

    private List<VdFaccountSubsetDomain> makeFaccountSubsetList(VdFaccountDefReDomain vdFaccountDefReDomain, String tenantCode) {
        if (null == vdFaccountDefReDomain || null == vdFaccountDefReDomain.getDefSubList() || vdFaccountDefReDomain.getDefSubList().isEmpty()) {
            throw new ApiException("vd.VdFaccountOuterServiceImpl.makeFaccountSubsetList.null", "null");
        }
        ArrayList<VdFaccountSubsetDomain> vdFaccountSubsetDomainList = new ArrayList<VdFaccountSubsetDomain>();
        VdFaccountSubsetDomain vdFaccountSubsetDomain = null;
        for (VdFaccountDefSubsetReDomain vdFaccountDefSubsetReDomain : vdFaccountDefReDomain.getDefSubList()) {
            vdFaccountSubsetDomain = new VdFaccountSubsetDomain();
            vdFaccountSubsetDomain.setTenantCode(tenantCode);
            vdFaccountSubsetDomain.setCurrencyCode(vdFaccountDefSubsetReDomain.getCurrencyCode());
            vdFaccountSubsetDomain.setFaccountTitileCode(vdFaccountDefSubsetReDomain.getFaccountTitileCode());
            vdFaccountSubsetDomain.setFaccountDirection(vdFaccountDefSubsetReDomain.getFaccountDirection());
            vdFaccountSubsetDomain.setFundType(vdFaccountDefSubsetReDomain.getFundType());
            vdFaccountSubsetDomainList.add(vdFaccountSubsetDomain);
        }
        return vdFaccountSubsetDomainList;
    }

    private BigDecimal countOrderMountByMouthModel(Map<String, Object> parammap) {
        try {
            return this.vdFaccountOuterDtMapper.countOrderMountByMouth(parammap);
        }
        catch (Exception e) {
            this.logger.error("vd.VdFaccountOuterServiceImpl.countOrderMountByMouthModel", (Throwable)e);
            return null;
        }
    }

    @Override
    public String countOrderMountByMouth(Map<String, Object> map) {
        if (null == map.get("merchantCode") || null == map.get("tenantCode")) {
            return null;
        }
        HashMap<String, Object> paramap = new HashMap<String, Object>();
        paramap.put("merchantCode", map.get("merchantCode").toString());
        paramap.put("tenantCode", map.get("tenantCode").toString());
        String f = map.get("merchantCode").toString().substring(0, 1);
        paramap.put("faccountType", f + "01");
        paramap.put("fundType", "01");
        List<VdFaccountOuter> vdFaccountOuters = this.queryFaccountOuterModelPage(paramap);
        if (ListUtil.isEmpty(vdFaccountOuters)) {
            return null;
        }
        String faccountOuterNo = vdFaccountOuters.get(0).getFaccountOuterNo();
        if (StringUtils.isBlank((String)faccountOuterNo)) {
            return null;
        }
        map.put("faccountOuterNo", faccountOuterNo);
        BigDecimal bigDecimal = this.countOrderMountByMouthModel(map);
        if (null == bigDecimal) {
            return null;
        }
        return bigDecimal.toString();
    }

    @Override
    public Map<String, Object> countVdFaccountOuterDt(Map<String, Object> map) {
        return this.countVdFaccountOuterDtModel(map);
    }

    private Map<String, Object> countVdFaccountOuterDtModel(Map<String, Object> map) {
        try {
            return this.vdFaccountOuterDtMapper.countVdFaccountOuterDt(map);
        }
        catch (Exception e) {
            this.logger.error("vd.VdFaccountOuterServiceImpl.countVdFaccountOuterDtModel", (Throwable)e);
            return null;
        }
    }

    @Override
    public QueryResult<VdFaccountOuterDt> queryFaccountOuterDtAvailableAndFreezePage(Map<String, Object> map) {
        if (null == map.get("availableOuterNo") || null == map.get("freezeOuterNo")) {
            return null;
        }
        List<VdFaccountOuterDt> vdFaccountOuterDtList = this.queryAvailableAndFreezePage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countAvailableAndFreezeFaccountOuterDt(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(vdFaccountOuterDtList);
        return queryResult;
    }

    private int countAvailableAndFreezeFaccountOuterDt(Map<String, Object> map) {
        int count = 0;
        try {
            count = this.vdFaccountOuterDtMapper.countAvailableAndFreezeFaccountOuterDt(map);
        }
        catch (Exception e) {
            this.logger.error("vd.VdFaccountOuterServiceImpl.countFaccountOuter", (Throwable)e);
        }
        return count;
    }

    private List<VdFaccountOuterDt> queryAvailableAndFreezePage(Map<String, Object> parammap) {
        try {
            return this.vdFaccountOuterDtMapper.queryAvailableAndFreezePage(parammap);
        }
        catch (Exception e) {
            this.logger.error("vd.VdFaccountOuterServiceImpl.queryAvailableAndFreezePage", (Throwable)e);
            return null;
        }
    }

    @Override
    public QueryResult<VdFaccountOuter> queryFaccountOuterPageNew(Map<String, Object> map) {
        List<VdFaccountOuter> vdFaccountOuterList = this.queryFaccountOuterModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countFaccountOuter(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(vdFaccountOuterList);
        return queryResult;
    }

    private boolean lockSubsetData(Map<String, Object> map) {
        if (map.isEmpty()) {
            return false;
        }
        int i = 0;
        try {
            i = this.vdFaccountOuterSubsetMapper.lockDataByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("vd.VdFaccountOuterServiceImpl.lockSubsetData", map.toString(), (Throwable)e);
        }
        return i > 0;
    }

    @Override
    public String updateFaccountOuterSubsetByMap(Map<String, Object> map) throws ApiException {
        if (MapUtil.isEmpty(map) || EmptyUtil.isEmpty((Object)map.get("faccountOuterSubsetId")) || EmptyUtil.isEmpty((Object)map.get("faccountAmount")) || EmptyUtil.isEmpty((Object)map.get("type"))) {
            this.logger.error("vd.VdFaccountOuterServiceImpl.updateFaccountOuterSubsetByMap", map);
            return "error";
        }
        VdFaccountOuterSubset oldVdFaccountOuterSubset = this.getFaccountOuterSubsetModelById(Integer.valueOf(map.get("faccountOuterSubsetId").toString()));
        if (null == oldVdFaccountOuterSubset) {
            throw new ApiException("vd.VdFaccountOuterServiceImpl.updateFaccountOuterSubset.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        BigDecimal faccountAmount = new BigDecimal(map.get("faccountAmount").toString());
        if ("1".equals(map.get("type").toString())) {
            faccountAmount = new BigDecimal("-1").multiply(faccountAmount);
            if (oldVdFaccountOuterSubset.getFaccountAmount().subtract(faccountAmount).compareTo(BigDecimal.ZERO) < 0) {
                this.logger.error("vd.VdFaccountOuterServiceImpl.updateFaccountOuterSubsetByMap", (Object)(map + "faccountAmount:" + oldVdFaccountOuterSubset.getFaccountAmount()));
                return "error";
            }
        }
        map.put("faccountAmount", faccountAmount);
        this.updateFaccountOuterSubsetModel(map);
        return "success";
    }

    @Override
    public String updateFaccountOuterDtStatus(final String tenantCode, final String channelCode) throws ApiException {
        if (StringUtils.isBlank((String)tenantCode)) {
            this.logger.error("vd.VdFaccountOuterServiceImpl.updateFaccountOuterDtStatus.tenantCode", (Object)"tenantCode\u6ca1\u6709\u4f20");
            return "tenantCode\u6ca1\u6709\u4f20";
        }
        if (StringUtils.isBlank((String)channelCode)) {
            this.logger.error("vd.VdFaccountOuterServiceImpl.updateFaccountOuterDtStatus.channelCode", (Object)"channelCode\u6ca1\u6709\u4f20");
            return "channelCode\u6ca1\u6709\u4f20";
        }
        HashMap<String, Object> vdMap = new HashMap<String, Object>(){
            {
                this.put("tenantCode", tenantCode);
                this.put("channelCode", channelCode);
                this.put("businessType", "withDraw");
                this.put("dataStateStr", "1,2,5,6");
            }
        };
        final QueryResult<VdFaccountOuterDt> vdFaccountOuterDtQueryResult = this.queryFaccountOuterDtPage((Map<String, Object>)vdMap);
        this.logger.error("vd.VdFaccountOuterServiceImpl.updateFaccountOuterDtStatus.vdMap", (Object)JsonUtil.buildNormalBinder().toJson((Object)vdMap));
        if (null == vdFaccountOuterDtQueryResult || ListUtil.isEmpty((Collection)vdFaccountOuterDtQueryResult.getList())) {
            return "\u67e5\u8be2\u6570\u636e\u4e3a\u7a7a";
        }
        this.logger.error("vd.VdFaccountOuterServiceImpl.queryMemberWithdrawCashStatus.vdFaccountOuterDtQueryResult", (Object)JsonUtil.buildNormalBinder().toJson(vdFaccountOuterDtQueryResult));
        HashMap<String, Object> paramMap = new HashMap<String, Object>(){
            {
                this.put("tenantCode", tenantCode);
                this.put("channelCode", channelCode);
                this.put("fchannelCode", "pingan");
                this.put("proappCode", "022");
                this.put("vdFaccountOuterDtReDomains", JsonUtil.buildNormalBinder().toJson((Object)vdFaccountOuterDtQueryResult.getList()));
            }
        };
        HashMap<String, String> parMap = new HashMap<String, String>();
        parMap.put("fchannelCode", "pingan");
        parMap.put("map", JsonUtil.buildNonNullBinder().toJson((Object)paramMap));
        this.logger.error("vd.VdFaccountOuterServiceImpl.updateFaccountOuterDtStatus.\u8fdc\u7a0b\u8c03\u7528\u5f00\u59cb");
        this.getInternalRouter().inInvoke("cmc.channelWithdrawal.queryMemberWithdrawCashStatus", parMap);
        this.logger.error("vd.VdFaccountOuterServiceImpl.updateFaccountOuterDtStatus.\u8fdc\u7a0b\u8c03\u7528\u7ed3\u675fparMap", (Object)JsonUtil.buildNormalBinder().toJson(parMap));
        return "SUCCESS";
    }

    @Override
    public QueryResult<VdFaccountAikang> queryAikangFaccountInfoPage(Map<String, Object> map) {
        List<VdFaccountAikang> vdFaccountOuterList = this.vdFaccountOuterMapper.queryAikangFaccountInfoPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.vdFaccountOuterMapper.countAikangFaccountOuter(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(vdFaccountOuterList);
        return queryResult;
    }

    @Override
    public void saveFaccountOuterAk(List<VdFaccountDomain> vdFaccountDomainList) throws ApiException {
        this.saveOpenFaccount(vdFaccountDomainList);
    }
}

