/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.warehouse.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import com.yqbsoft.laser.service.warehouse.WhStoreConstants;
import com.yqbsoft.laser.service.warehouse.dao.WhUserWhMapper;
import com.yqbsoft.laser.service.warehouse.domain.WhUserwhConfDomain;
import com.yqbsoft.laser.service.warehouse.domain.WhUserwhDomain;
import com.yqbsoft.laser.service.warehouse.domain.WhUserwhMemDomain;
import com.yqbsoft.laser.service.warehouse.domain.WhUserwhReDomain;
import com.yqbsoft.laser.service.warehouse.model.WhUserwh;
import com.yqbsoft.laser.service.warehouse.model.WhUserwhConf;
import com.yqbsoft.laser.service.warehouse.model.WhUserwhMem;
import com.yqbsoft.laser.service.warehouse.service.WhUserwhConfService;
import com.yqbsoft.laser.service.warehouse.service.WhUserwhMemService;
import com.yqbsoft.laser.service.warehouse.service.WhUserwhService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class WhUserwhServiceImpl
extends BaseServiceImpl
implements WhUserwhService {
    private static final String SYS_CODE = "wh.WhUserwhServiceImpl";
    private WhUserWhMapper whUserwhMapper;
    private WhUserwhConfService whUserwhConfService;
    private WhUserwhMemService whUserwhMemService;
    private String cachekey = "userwhCode-TenantCode";
    private String userwhCodeCachekey = "whuserwhconf-userwhCode";
    private String userwhCodeCachekey_key = "whuserwhconf-userwhCode-key";
    private String userwhCodeCachekey_value = "whuserwhconf-userwhCode-value";
    private String userwhCodeMemCachekey_key = "whuserwhmem-userwhCode-key";
    private String userwhCodeMemCachekey_value = "whuserwhmem-userwhCode-value";

    public void setWhUserwhMapper(WhUserWhMapper whUserwhMapper) {
        this.whUserwhMapper = whUserwhMapper;
    }

    public void setWhUserwhConfService(WhUserwhConfService whUserwhConfService) {
        this.whUserwhConfService = whUserwhConfService;
    }

    public void setWhUserwhMemService(WhUserwhMemService whUserwhMemService) {
        this.whUserwhMemService = whUserwhMemService;
    }

    private Date getSysDate() {
        try {
            return this.whUserwhMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("wh.WhUserwhServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkUserwh(WhUserwhDomain whUserwhDomain) {
        if (null == whUserwhDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)whUserwhDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setUserwhDefault(WhUserwh whUserwh) {
        if (null == whUserwh) {
            return;
        }
        if (null == whUserwh.getDataState()) {
            whUserwh.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == whUserwh.getGmtCreate()) {
            whUserwh.setGmtCreate(date);
        }
        whUserwh.setGmtModified(date);
        if (StringUtils.isBlank((String)whUserwh.getUserwhCode())) {
            whUserwh.setUserwhCode(this.getNo(null, "WhUserwh", "whUserwh", whUserwh.getTenantCode()));
        }
    }

    private int getUserwhMaxCode() {
        int code = 0;
        try {
            return this.whUserwhMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("wh.WhUserwhServiceImpl.getUserwhMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setUserwhUpdataDefault(WhUserwh whUserwh) {
        if (null == whUserwh) {
            return;
        }
        whUserwh.setGmtModified(this.getSysDate());
    }

    private void saveUserwhModel(WhUserwh whUserwh) throws ApiException {
        if (null == whUserwh) {
            return;
        }
        try {
            this.whUserwhMapper.insert(whUserwh);
        }
        catch (Exception e) {
            throw new ApiException("wh.WhUserwhServiceImpl.saveUserwhModel.ex", (Throwable)e);
        }
    }

    private void saveUserwhBatchModel(List<WhUserwh> whUserwhList) throws ApiException {
        if (null == whUserwhList || whUserwhList.isEmpty()) {
            return;
        }
        try {
            this.whUserwhMapper.insertBatch(whUserwhList);
        }
        catch (Exception e) {
            throw new ApiException("wh.WhUserwhServiceImpl.saveUserwhBatchModel.ex", (Throwable)e);
        }
    }

    private WhUserwh getUserwhModelById(Integer userwhId) {
        if (null == userwhId) {
            return null;
        }
        try {
            return this.whUserwhMapper.selectByPrimaryKey(userwhId);
        }
        catch (Exception e) {
            this.logger.error("wh.WhUserwhServiceImpl.getUserwhModelById", (Throwable)e);
            return null;
        }
    }

    private WhUserwh getUserwhModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.whUserwhMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("wh.WhUserwhServiceImpl.getUserwhModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delUserwhModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.whUserwhMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("wh.WhUserwhServiceImpl.delUserwhModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("wh.WhUserwhServiceImpl.delUserwhModelByCode.num");
        }
    }

    private void deleteUserwhModel(Integer userwhId) throws ApiException {
        if (null == userwhId) {
            return;
        }
        int i = 0;
        try {
            i = this.whUserwhMapper.deleteByPrimaryKey(userwhId);
        }
        catch (Exception e) {
            throw new ApiException("wh.WhUserwhServiceImpl.deleteUserwhModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("wh.WhUserwhServiceImpl.deleteUserwhModel.num", userwhId.toString());
        }
    }

    private void updateUserwhModel(WhUserwh whUserwh) throws ApiException {
        if (null == whUserwh) {
            return;
        }
        int i = 0;
        try {
            i = this.whUserwhMapper.updateByPrimaryKeySelective(whUserwh);
        }
        catch (Exception e) {
            throw new ApiException("wh.WhUserwhServiceImpl.updateUserwhModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("wh.WhUserwhServiceImpl.updateUserwhModel.num");
        }
    }

    private void updateUserwhModelModelWithNull(WhUserwh whUserwh) throws ApiException {
        if (null == whUserwh) {
            return;
        }
        int i = 0;
        try {
            i = this.whUserwhMapper.updateByPrimaryKey(whUserwh);
        }
        catch (Exception e) {
            throw new ApiException("wh.WhUserwhServiceImpl.updateUserwhModelModelWithNull.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("wh.WhUserwhServiceImpl.updateUserwhModelModelWithNull.num");
        }
    }

    private void updateStateUserwhModel(Integer userwhId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == userwhId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("userwhId", userwhId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.whUserwhMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("wh.WhUserwhServiceImpl.updateStateUserwhModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("wh.WhUserwhServiceImpl.updateStateUserwhModel.null");
        }
    }

    private void updateStateUserwhModelByCode(String tenantCode, String userwhCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)userwhCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("userwhCode", userwhCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.whUserwhMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("wh.WhUserwhServiceImpl.updateStateUserwhModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("wh.WhUserwhServiceImpl.updateStateUserwhModelByCode.null");
        }
    }

    private WhUserwh makeUserwh(WhUserwhDomain whUserwhDomain, WhUserwh whUserwh) {
        if (null == whUserwhDomain) {
            return null;
        }
        if (null == whUserwh) {
            whUserwh = new WhUserwh();
        }
        try {
            BeanUtils.copyAllPropertys((Object)whUserwh, (Object)whUserwhDomain);
            return whUserwh;
        }
        catch (Exception e) {
            this.logger.error("wh.WhUserwhServiceImpl.makeUserwh", (Throwable)e);
            return null;
        }
    }

    private WhUserwhDomain makeWhUserwhDomain(WhUserwhDomain whUserwhDomain, WhUserwh whUserwh) {
        if (null == whUserwh) {
            return null;
        }
        if (null == whUserwhDomain) {
            whUserwhDomain = new WhUserwhDomain();
        }
        try {
            BeanUtils.copyAllPropertys((Object)whUserwhDomain, (Object)whUserwh);
            return whUserwhDomain;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private WhUserwhReDomain makeWhUserwhReDomain(WhUserwh whUserwh) {
        if (null == whUserwh) {
            return null;
        }
        WhUserwhReDomain whUserwhReDomain = new WhUserwhReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)whUserwhReDomain, (Object)whUserwh);
            return whUserwhReDomain;
        }
        catch (Exception e) {
            this.logger.error("wh.WhUserwhServiceImpl.makeWhUserwhReDomain", (Throwable)e);
            return null;
        }
    }

    private List<WhUserwh> queryUserwhModelPage(Map<String, Object> parammap) {
        try {
            return this.whUserwhMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("wh.WhUserwhServiceImpl.queryUserwhModel", (Throwable)e);
            return null;
        }
    }

    private int countUserwh(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.whUserwhMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("wh.WhUserwhServiceImpl.countUserwh", (Throwable)e);
        }
        return i;
    }

    private WhUserwh createWhUserwh(WhUserwhDomain whUserwhDomain) {
        String msg = this.checkUserwh(whUserwhDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("wh.WhUserwhServiceImpl.saveUserwh.checkUserwh", msg);
        }
        WhUserwh whUserwh = this.makeUserwh(whUserwhDomain, null);
        this.setUserwhDefault(whUserwh);
        return whUserwh;
    }

    @Override
    public String saveUserwh(WhUserwhDomain whUserwhDomain) throws ApiException {
        WhUserwh whUserwh = null;
        if (null == whUserwhDomain.getUserwhCode()) {
            whUserwh = this.createWhUserwh(whUserwhDomain);
            this.saveUserwhModel(whUserwh);
        } else {
            whUserwh = this.getUserwhByCode(whUserwhDomain.getTenantCode(), whUserwhDomain.getUserwhCode());
        }
        if (null == whUserwh) {
            throw new ApiException("wh.WhUserwhServiceImpl.saveUserwh", "\u5bf9\u8c61\u4e3a\u7a7a");
        }
        if (null != whUserwh && ListUtil.isNotEmpty(whUserwhDomain.getWhUserwhConfDomainList())) {
            this.saveMpriceConfListDomain(whUserwhDomain.getWhUserwhConfDomainList(), whUserwh);
        }
        if (null != whUserwh && ListUtil.isNotEmpty(whUserwhDomain.getWhUserwhMemDomainList())) {
            this.saveMpriceMemListDomain(whUserwhDomain.getWhUserwhMemDomainList(), whUserwh);
        }
        if (null != whUserwh && WhStoreConstants.dataState_start.intValue() == whUserwh.getDataState().intValue()) {
            this.updateWhUserwhCache(whUserwh);
        }
        return whUserwh.getUserwhCode();
    }

    private void saveMpriceConfListDomain(List<WhUserwhConfDomain> whUserwhConfDomainList, WhUserwh whUserwh) {
        if (ListUtil.isEmpty(whUserwhConfDomainList)) {
            return;
        }
        ArrayList<WhUserwhConfDomain> whUserwhConfDomainListList = new ArrayList<WhUserwhConfDomain>();
        HashMap<String, Object> parammap = new HashMap<String, Object>();
        for (WhUserwhConfDomain whUserwhConfDomain : whUserwhConfDomainList) {
            try {
                BeanUtils.copyAllPropertys((Object)whUserwhConfDomain, (Object)whUserwh);
            }
            catch (Exception exception) {
                // empty catch block
            }
            parammap.put("userwhCode", whUserwhConfDomain.getUserwhCode());
            parammap.put("tenantCode", whUserwhConfDomain.getTenantCode());
            parammap.put("userwhConfType", whUserwhConfDomain.getUserwhConfType());
            parammap.put("userwhConfValue", whUserwhConfDomain.getUserwhConfValue());
            QueryResult<WhUserwhConf> whUserwhConfQueryResult = this.whUserwhConfService.queryUserwhConfPage(parammap);
            if (!ListUtil.isEmpty((Collection)whUserwhConfQueryResult.getList())) continue;
            whUserwhConfDomainListList.add(whUserwhConfDomain);
        }
        this.logger.error("wh.WhUserwhServiceImplsaveMpriceConfListDomain", (Object)JsonUtil.buildNonDefaultBinder().toJson(whUserwhConfDomainListList));
        this.whUserwhConfService.saveUserwhConfBatch(whUserwhConfDomainListList);
    }

    private void saveMpriceMemListDomain(List<WhUserwhMemDomain> whUserwhMemDomainList, WhUserwh whUserwh) {
        if (ListUtil.isEmpty(whUserwhMemDomainList)) {
            return;
        }
        ArrayList<WhUserwhMemDomain> userwhMemDomainList = new ArrayList<WhUserwhMemDomain>();
        HashMap<String, Object> parammap = new HashMap<String, Object>();
        for (WhUserwhMemDomain whUserwhMemDomain : whUserwhMemDomainList) {
            try {
                BeanUtils.copyAllPropertys((Object)whUserwhMemDomain, (Object)whUserwh);
            }
            catch (Exception exception) {
                // empty catch block
            }
            parammap.put("userwhCode", whUserwhMemDomain.getUserwhCode());
            parammap.put("tenantCode", whUserwhMemDomain.getTenantCode());
            parammap.put("userwhMemType", whUserwhMemDomain.getUserwhMemType());
            parammap.put("userwhMemValue", whUserwhMemDomain.getUserwhMemValue());
            QueryResult<WhUserwhMem> whUserwhMemQueryResult = this.whUserwhMemService.queryUserwhMemPage(parammap);
            if (!ListUtil.isEmpty((Collection)whUserwhMemQueryResult.getList())) continue;
            userwhMemDomainList.add(whUserwhMemDomain);
        }
        this.logger.error("wh.WhUserwhServiceImplsaveMpriceConfListDomain", (Object)JsonUtil.buildNonDefaultBinder().toJson(userwhMemDomainList));
        this.whUserwhMemService.saveUserwhMemBatch(userwhMemDomainList);
    }

    private WhUserwhConfDomain makeWhUserwhConfDomain(WhUserwhConf whUserwhConf) {
        if (null == whUserwhConf) {
            return null;
        }
        WhUserwhConfDomain whUserwhConfDomain = new WhUserwhConfDomain();
        try {
            BeanUtils.copyAllPropertys((Object)whUserwhConfDomain, (Object)whUserwhConf);
            return whUserwhConfDomain;
        }
        catch (Exception e) {
            this.logger.error("wh.WhUserwhServiceImpl.makeWhUserwhConfReDomain", (Throwable)e);
            return null;
        }
    }

    private WhUserwhMemDomain makeWhUserwhMemDomain(WhUserwhMem whUserwhMem) {
        if (null == whUserwhMem) {
            return null;
        }
        WhUserwhMemDomain whUserwhMemDomain = new WhUserwhMemDomain();
        try {
            BeanUtils.copyAllPropertys((Object)whUserwhMemDomain, (Object)whUserwhMem);
            return whUserwhMemDomain;
        }
        catch (Exception e) {
            this.logger.error("wh.WhUserwhServiceImpl.makeWhUserwhConfReDomain", (Throwable)e);
            return null;
        }
    }

    private List<WhUserwhConfDomain> makeConfDomain(List<WhUserwhConf> whUserwhConfList) {
        if (ListUtil.isEmpty(whUserwhConfList)) {
            return null;
        }
        ArrayList<WhUserwhConfDomain> whUserwhConfDomainList = new ArrayList<WhUserwhConfDomain>();
        for (WhUserwhConf whUserwhConf : whUserwhConfList) {
            WhUserwhConfDomain whUserwhConfDomain = this.makeWhUserwhConfDomain(whUserwhConf);
            if (null == whUserwhConfDomain) continue;
            whUserwhConfDomainList.add(whUserwhConfDomain);
        }
        return whUserwhConfDomainList;
    }

    private List<WhUserwhMemDomain> makeUserwhMemDomain(List<WhUserwhMem> whUserwhMemList) {
        if (ListUtil.isEmpty(whUserwhMemList)) {
            return null;
        }
        ArrayList<WhUserwhMemDomain> whUserwhConfDomainList = new ArrayList<WhUserwhMemDomain>();
        for (WhUserwhMem whUserwhMemDomain : whUserwhMemList) {
            WhUserwhMemDomain whUserwhConfDomain = this.makeWhUserwhMemDomain(whUserwhMemDomain);
            if (null == whUserwhConfDomain) continue;
            whUserwhConfDomainList.add(whUserwhConfDomain);
        }
        return whUserwhConfDomainList;
    }

    private List<WhUserwhDomain> whDomainsort(List<WhUserwhDomain> mlist) {
        if (ListUtil.isEmpty(mlist)) {
            return null;
        }
        Collections.sort(mlist, new Comparator<WhUserwhDomain>(){

            @Override
            public int compare(WhUserwhDomain arg0, WhUserwhDomain arg1) {
                if (arg0.getUserwhWeight() > arg1.getUserwhWeight()) {
                    return 1;
                }
                if (arg0.getUserwhWeight() < arg1.getUserwhWeight()) {
                    return -1;
                }
                return arg0.getUserwhWeight().compareTo(arg0.getUserwhWeight());
            }
        });
        return mlist;
    }

    private void updateWhUserwhCache(WhUserwh whUserwh) {
        this.logger.error(SYS_CODE, (Object)"-----------------updateWhUserwhCache---------------------\u66f4\u65b0\u5e93\u5b58\u8bbe\u7f6e\u5f00\u59cb\u4e86");
        if (null == whUserwh) {
            return;
        }
        String va = "all";
        if (StringUtils.isBlank((String)whUserwh.getUserwhScope())) {
            whUserwh.setUserwhScope("0");
        }
        WhUserwhDomain whUserwhDomain = this.makeWhUserwhDomain(null, whUserwh);
        Map ddMap = DisUtil.getMapAll((String)this.userwhCodeCachekey);
        this.logger.error("wh.WhUserwhServiceImpl.-----------------updateWhUserwhCache---------------------", (Object)JsonUtil.buildNormalBinder().toJson((Object)ddMap));
        ConcurrentHashMap<String, String> saveMap = new ConcurrentHashMap<String, String>();
        String ddmapkey = whUserwh.getWarehouseCode() + "-" + whUserwh.getTenantCode();
        HashMap<String, Object> confparammap = new HashMap<String, Object>();
        ConcurrentHashMap ddListMap = new ConcurrentHashMap();
        if (MapUtil.isEmpty((Map)ddMap)) {
            ArrayList<WhUserwhDomain> dlist = new ArrayList<WhUserwhDomain>();
            dlist.add(whUserwhDomain);
            ddListMap.put(ddmapkey, dlist);
            for (String key : ddListMap.keySet()) {
                saveMap.put(key, JsonUtil.buildNormalBinder().toJson(this.whDomainsort((List)ddListMap.get(key))));
            }
            this.logger.error("wh.WhUserwhServiceImpl.-----------------updateWhUserwhCache---------------------", (Object)JsonUtil.buildNormalBinder().toJson(saveMap));
            DisUtil.setMapVer((String)this.userwhCodeCachekey, saveMap);
        } else {
            boolean flag = false;
            for (String s : ddMap.keySet()) {
                if (s.equals(ddmapkey)) {
                    flag = true;
                    List whUserwhDomainList = JsonUtil.buildNormalBinder().getJsonToList((String)ddMap.get(s), WhUserwhDomain.class);
                    ArrayList<WhUserwhDomain> whlist = new ArrayList<WhUserwhDomain>();
                    boolean flag2 = false;
                    for (WhUserwhDomain userwhDomain : whUserwhDomainList) {
                        if (userwhDomain.getUserwhCode().equals(whUserwh.getUserwhCode())) {
                            flag2 = true;
                            whlist.add(whUserwhDomain);
                            continue;
                        }
                        whlist.add(userwhDomain);
                    }
                    if (!flag2) {
                        whlist.add(whUserwhDomain);
                    }
                    saveMap.put(ddmapkey, JsonUtil.buildNormalBinder().toJson(this.whDomainsort(whlist)));
                    continue;
                }
                saveMap.put(s, (String)ddMap.get(s));
            }
            if (!flag) {
                saveMap.put(ddmapkey, JsonUtil.buildNormalBinder().toJson(this.whDomainsort(Arrays.asList(whUserwhDomain))));
            }
            this.logger.error("wh.WhUserwhServiceImpl.-----------------updateWhUserwhCache---------------------", (Object)JsonUtil.buildNormalBinder().toJson(saveMap));
            DisUtil.setMapVer((String)this.userwhCodeCachekey, saveMap);
        }
        String orthKey = whUserwh.getUserwhCode() + "-" + whUserwh.getTenantCode();
        DisUtil.del((String)(this.userwhCodeCachekey_key + "-" + orthKey));
        DisUtil.del((String)(this.userwhCodeCachekey_value + "-" + orthKey));
        DisUtil.del((String)(this.userwhCodeMemCachekey_key + "-" + orthKey));
        DisUtil.del((String)(this.userwhCodeMemCachekey_value + "-" + orthKey));
        confparammap.put("userwhCode", whUserwh.getUserwhCode());
        confparammap.put("tenantCode", whUserwh.getTenantCode());
        List<WhUserwhConf> upcachelist = this.queryWhUserwhConfModelPage(confparammap);
        List<WhUserwhMem> mpMpriceMemList = this.queryWhUserwhMemModelPage(confparammap);
        if (ListUtil.isNotEmpty(upcachelist)) {
            HashMap<String, String> keymap = new HashMap<String, String>();
            HashMap<String, String> valuemap = new HashMap<String, String>();
            for (WhUserwhConf whUserwhConf : upcachelist) {
                if (StringUtils.isBlank((String)whUserwhConf.getUserwhConfTerm())) {
                    whUserwhConf.setUserwhConfTerm("=");
                }
                keymap.put(whUserwhConf.getUserwhConfType() + "-" + whUserwhConf.getUserwhConfTerm(), whUserwhConf.getUserwhConfType() + "-" + whUserwhConf.getUserwhConfTerm());
                if (whUserwhConf.getUserwhConfTerm().equals("=") || whUserwhConf.getUserwhConfTerm().equals("!=")) {
                    valuemap.put(whUserwhConf.getUserwhConfType() + "-" + whUserwhConf.getUserwhConfTerm() + "-" + whUserwhConf.getUserwhConfValue(), JsonUtil.buildNormalBinder().toJson((Object)whUserwhConf));
                    continue;
                }
                valuemap.put(whUserwhConf.getUserwhConfType() + "-" + whUserwhConf.getUserwhConfTerm(), JsonUtil.buildNormalBinder().toJson((Object)whUserwhConf));
            }
            DisUtil.setMapVer((String)(this.userwhCodeCachekey_key + "-" + orthKey), keymap);
            DisUtil.setMapVer((String)(this.userwhCodeCachekey_value + "-" + orthKey), valuemap);
        }
        if (ListUtil.isNotEmpty(mpMpriceMemList)) {
            HashMap<String, String> keymapMem = new HashMap<String, String>();
            HashMap<String, String> valuemapMem = new HashMap<String, String>();
            for (WhUserwhMem whUserwhMem : mpMpriceMemList) {
                if (StringUtils.isBlank((String)whUserwhMem.getUserwhMemTerm())) {
                    whUserwhMem.setUserwhMemTerm("=");
                }
                keymapMem.put(whUserwhMem.getUserwhMemType() + "-" + whUserwhMem.getUserwhMemTerm(), whUserwhMem.getUserwhMemType() + "-" + whUserwhMem.getUserwhMemTerm());
                if (whUserwhMem.getUserwhMemTerm().equals("=") || whUserwhMem.getUserwhMemTerm().equals("!=")) {
                    valuemapMem.put(whUserwhMem.getUserwhMemType() + "-" + whUserwhMem.getUserwhMemTerm() + "-" + whUserwhMem.getUserwhMemValue(), JsonUtil.buildNormalBinder().toJson((Object)whUserwhMem));
                    continue;
                }
                valuemapMem.put(whUserwhMem.getUserwhMemType() + "-" + whUserwhMem.getUserwhMemTerm(), JsonUtil.buildNormalBinder().toJson((Object)whUserwhMem));
            }
            DisUtil.setMapVer((String)(this.userwhCodeMemCachekey_key + "-" + orthKey), keymapMem);
            DisUtil.setMapVer((String)(this.userwhCodeMemCachekey_value + "-" + orthKey), valuemapMem);
        }
    }

    private List<WhUserwhConf> queryWhUserwhConfModelPage(Map<String, Object> parammap) {
        QueryResult<WhUserwhConf> whUserwhConfQueryResult = this.whUserwhConfService.queryUserwhConfPage(parammap);
        if (null == whUserwhConfQueryResult && ListUtil.isEmpty((Collection)whUserwhConfQueryResult.getList())) {
            return null;
        }
        return whUserwhConfQueryResult.getList();
    }

    private List<WhUserwhMem> queryWhUserwhMemModelPage(Map<String, Object> parammap) {
        QueryResult<WhUserwhMem> whUserwhMemQueryResult = this.whUserwhMemService.queryUserwhMemPage(parammap);
        if (null == whUserwhMemQueryResult && ListUtil.isEmpty((Collection)whUserwhMemQueryResult.getList())) {
            return null;
        }
        return whUserwhMemQueryResult.getList();
    }

    @Override
    public String saveUserwhBatch(List<WhUserwhDomain> whUserwhDomainList) throws ApiException {
        if (null == whUserwhDomainList || whUserwhDomainList.isEmpty()) {
            return null;
        }
        ArrayList<WhUserwh> whUserwhList = new ArrayList<WhUserwh>();
        String code = "";
        for (WhUserwhDomain whUserwhDomain : whUserwhDomainList) {
            WhUserwh whUserwh = this.createWhUserwh(whUserwhDomain);
            code = whUserwh.getUserwhCode();
            whUserwhList.add(whUserwh);
        }
        this.saveUserwhBatchModel(whUserwhList);
        return code;
    }

    @Override
    public void updateUserwhState(Integer userwhId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == userwhId) {
            return;
        }
        this.updateStateUserwhModel(userwhId, dataState, oldDataState, map);
    }

    @Override
    public void updateUserwhStateByCode(String tenantCode, String userwhCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)userwhCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateUserwhModelByCode(tenantCode, userwhCode, dataState, oldDataState, map);
    }

    private void deletewhUserwhCache(WhUserwh whUserwh) {
        String key;
        String json;
        if (null == whUserwh) {
            return;
        }
        String va = "all";
        if (StringUtils.isNotBlank((String)whUserwh.getWarehouseCode())) {
            va = whUserwh.getWarehouseCode();
        }
        if (StringUtils.isBlank((String)(json = DisUtil.getRemotMap((String)this.cachekey, (String)(key = whUserwh.getUserwhCode() + "-" + va))))) {
            return;
        }
        List mlist = JsonUtil.buildNormalBinder().getJsonToList(json, WhUserwhDomain.class);
        ArrayList<WhUserwhDomain> mlist2 = new ArrayList<WhUserwhDomain>();
        if (ListUtil.isNotEmpty((Collection)mlist)) {
            for (WhUserwhDomain mpMpriceDomain2 : mlist) {
                if (mpMpriceDomain2.getUserwhCode().equals(whUserwh.getUserwhCode())) continue;
                mlist2.add(mpMpriceDomain2);
            }
        }
        DisUtil.setMapVer((String)this.cachekey, (String)key, (String)JsonUtil.buildNormalBinder().toJson(this.whDomainsort(mlist2)));
    }

    @Override
    public void updateUserwh(WhUserwhDomain whUserwhDomain) throws ApiException {
        String msg = this.checkUserwh(whUserwhDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("wh.WhUserwhServiceImpl.updateUserwh.checkUserwh", msg);
        }
        this.logger.error("wh.WhUserwhServiceImplupdateUserwh", (Object)JsonUtil.buildNonNullBinder().toJson((Object)whUserwhDomain));
        WhUserwh oldWhUserwh = this.getUserwhModelById(whUserwhDomain.getUserwhId());
        if (null == oldWhUserwh) {
            throw new ApiException("wh.WhUserwhServiceImpl.updateUserwh.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        WhUserwh whUserwh = this.makeUserwh(whUserwhDomain, oldWhUserwh);
        this.setUserwhUpdataDefault(whUserwh);
        this.updateUserwhModel(whUserwh);
        if (ListUtil.isNotEmpty(whUserwhDomain.getWhUserwhConfDomainList())) {
            this.whUserwhConfService.deleteUserwhConfByUserwhCode(whUserwhDomain.getTenantCode(), whUserwhDomain.getUserwhCode());
            this.saveMpriceConfListDomain(whUserwhDomain.getWhUserwhConfDomainList(), whUserwh);
        }
        if (ListUtil.isNotEmpty(whUserwhDomain.getWhUserwhMemDomainList())) {
            this.whUserwhMemService.deleteUserwhMemByUserwhCode(whUserwhDomain.getTenantCode(), whUserwhDomain.getUserwhCode());
            this.saveMpriceMemListDomain(whUserwhDomain.getWhUserwhMemDomainList(), whUserwh);
        }
        if (WhStoreConstants.dataState_start.intValue() != whUserwh.getDataState().intValue()) {
            this.deletewhUserwhCache(whUserwh);
        } else if (WhStoreConstants.dataState_start.intValue() == whUserwh.getDataState().intValue()) {
            this.updateWhUserwhCache(whUserwh);
        }
    }

    @Override
    public WhUserwh getUserwh(Integer userwhId) {
        if (null == userwhId) {
            return null;
        }
        return this.getUserwhModelById(userwhId);
    }

    @Override
    public void deleteUserwh(Integer userwhId) throws ApiException {
        QueryResult<WhUserwhMem> whUserwhMemQueryResult;
        if (null == userwhId) {
            return;
        }
        WhUserwh whUserwh = this.getUserwh(userwhId);
        if (null == whUserwh) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", whUserwh.getTenantCode());
        map.put("userwhMemCode", whUserwh.getUserwhCode());
        QueryResult<WhUserwhConf> whUserwhConfQueryResult = this.whUserwhConfService.queryUserwhConfPage(map);
        if (null != whUserwhConfQueryResult && ListUtil.isNotEmpty((Collection)whUserwhConfQueryResult.getList())) {
            this.whUserwhConfService.deleteUserwhConfByCode(whUserwh.getTenantCode(), whUserwh.getUserwhCode());
        }
        if (null != (whUserwhMemQueryResult = this.whUserwhMemService.queryUserwhMemPage(map)) && ListUtil.isNotEmpty((Collection)whUserwhMemQueryResult.getList())) {
            this.whUserwhMemService.deleteUserwhMemByCode(whUserwh.getTenantCode(), whUserwh.getUserwhCode());
        }
        this.deleteUserwhModel(userwhId);
        this.deletewhUserwhCache(whUserwh);
    }

    @Override
    public QueryResult<WhUserwh> queryUserwhPage(Map<String, Object> map) {
        List<WhUserwh> whUserwhList = this.queryUserwhModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countUserwh(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(whUserwhList);
        return queryResult;
    }

    @Override
    public WhUserwh getUserwhByCode(String tenantCode, String userwhCode) throws ApiException {
        if (StringUtils.isBlank((String)userwhCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("userwhCode", userwhCode);
        return this.getUserwhModelByCode(map);
    }

    @Override
    public void deleteUserwhByCode(String tenantCode, String userwhCode) throws ApiException {
        if (StringUtils.isBlank((String)userwhCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("userwhCode", userwhCode);
        this.delUserwhModelByCode(map);
    }

    @Override
    public void queryMpriceLoadCache() {
        this.logger.info("wh.WhUserwhServiceImpl.queryMpriceLoadCache", (Object)"===========start==========");
        HashMap<String, Object> parammap = new HashMap<String, Object>();
        parammap.put("dataState", WhStoreConstants.dataState_start);
        QueryResult<WhUserwh> whUserwhQueryResult = this.queryUserwhPage(parammap);
        if (null == whUserwhQueryResult || ListUtil.isEmpty((Collection)whUserwhQueryResult.getList())) {
            DisUtil.delVer((String)this.cachekey);
            this.logger.info("MpMpriceService.queryMpriceLoadCache", (Object)"===========del-end==========");
            return;
        }
        ConcurrentHashMap<String, String> ddMap = new ConcurrentHashMap<String, String>();
        HashMap<String, Object> confparammap = new HashMap<String, Object>();
        ConcurrentHashMap<String, ArrayList<WhUserwhDomain>> ddListMap = new ConcurrentHashMap<String, ArrayList<WhUserwhDomain>>();
        for (WhUserwh whUserwh : whUserwhQueryResult.getList()) {
            String va = "all";
            if (StringUtils.isNotBlank((String)whUserwh.getWarehouseCode())) {
                va = whUserwh.getWarehouseCode();
            }
            WhUserwhDomain whUserwhDomain = this.makeWhUserwhDomain(null, whUserwh);
            confparammap.put("userwhCode", whUserwh.getUserwhCode());
            confparammap.put("tenantCode", whUserwh.getTenantCode());
            List<WhUserwhConf> upcachelist = this.queryWhUserwhConfModelPage(confparammap);
            whUserwhDomain.setWhUserwhConfDomainList(this.makeConfDomain(upcachelist));
            List<WhUserwhMem> mpMpriceMemList = this.queryWhUserwhMemModelPage(confparammap);
            whUserwhDomain.setWhUserwhMemDomainList(this.makeUserwhMemDomain(mpMpriceMemList));
            String key = whUserwh.getTenantCode() + "-" + va;
            ArrayList<WhUserwhDomain> mlist = (ArrayList<WhUserwhDomain>)ddListMap.get(key);
            if (null == mlist) {
                mlist = new ArrayList<WhUserwhDomain>();
                ddListMap.put(key, mlist);
            }
            mlist.add(whUserwhDomain);
        }
        for (String key : ddListMap.keySet()) {
            ddMap.put(key, JsonUtil.buildNormalBinder().toJson(this.whDomainsort((List)ddListMap.get(key))));
        }
        DisUtil.setMapVer((String)this.cachekey, ddMap);
        this.logger.debug("wh.WhUserwhServiceImpl.queryMpriceLoadCache", (Object)("===========add-end==========" + JsonUtil.buildNormalBinder().toJson(ddMap)));
    }

    @Override
    public void saveOrUpdateUserwhBatch(List<WhUserwhDomain> whUserwhDomainList) throws ApiException {
        if (ListUtil.isEmpty(whUserwhDomainList)) {
            this.logger.error("wh.WhUserwhServiceImpl.saveOrUpdateUserwhBatch", (Object)"whUserwhDomainList is null");
            return;
        }
        for (WhUserwhDomain whUserwhDomain : whUserwhDomainList) {
            if (whUserwhDomain.getUserwhId() == null) {
                this.saveUserwh(whUserwhDomain);
                continue;
            }
            this.updateUserwh(whUserwhDomain);
        }
    }

    @Override
    public void queryWhUserwhLoadCache() {
        this.logger.info("whUserwhService.queryWhUserwhLoadCache", (Object)"===========start==========");
        HashMap<String, Object> parammap = new HashMap<String, Object>();
        parammap.put("dataState", WhStoreConstants.dataState_start);
        QueryResult<WhUserwh> whUserwhQueryResult = this.queryUserwhPage(parammap);
        if (null == whUserwhQueryResult || ListUtil.isEmpty((Collection)whUserwhQueryResult.getList())) {
            Map ddMap = DisUtil.getMapAll((String)this.userwhCodeCachekey);
            DisUtil.delVer((String)this.userwhCodeCachekey);
            if (MapUtil.isNotEmpty((Map)ddMap)) {
                for (String key : ddMap.keySet()) {
                    DisUtil.del((String)(this.userwhCodeCachekey_key + "-" + key));
                    DisUtil.del((String)(this.userwhCodeCachekey_value + "-" + key));
                    DisUtil.del((String)(this.userwhCodeMemCachekey_key + "-" + key));
                    DisUtil.del((String)(this.userwhCodeMemCachekey_value + "-" + key));
                }
            }
            this.logger.info("MpMpriceService.queryWhUserwhLoadCache", (Object)"===========del-end==========");
            return;
        }
        ConcurrentHashMap<String, String> ddMap = new ConcurrentHashMap<String, String>();
        HashMap<String, Object> confparammap = new HashMap<String, Object>();
        ConcurrentHashMap<String, ArrayList<WhUserwhDomain>> ddListMap = new ConcurrentHashMap<String, ArrayList<WhUserwhDomain>>();
        for (WhUserwh whUserwh : whUserwhQueryResult.getList()) {
            if (StringUtils.isBlank((String)whUserwh.getWarehouseCode())) {
                whUserwh.setWarehouseCode("all");
            }
            WhUserwhDomain whUserwhDomain = this.makeWhUserwhDomain(null, whUserwh);
            confparammap.put("userwhCode", whUserwh.getUserwhCode());
            confparammap.put("tenantCode", whUserwh.getTenantCode());
            List<WhUserwhConf> upcachelist = this.queryWhUserwhConfModelPage(confparammap);
            List<WhUserwhMem> mpMpriceMemList = this.queryWhUserwhMemModelPage(confparammap);
            if (ListUtil.isNotEmpty(upcachelist)) {
                HashMap<String, String> keymap = new HashMap<String, String>();
                HashMap<String, String> valuemap = new HashMap<String, String>();
                for (WhUserwhConf whUserwhConf : upcachelist) {
                    if (StringUtils.isBlank((String)whUserwhConf.getUserwhConfTerm())) {
                        whUserwhConf.setUserwhConfTerm("=");
                    }
                    keymap.put(whUserwhConf.getUserwhConfType() + "-" + whUserwhConf.getUserwhConfTerm(), whUserwhConf.getUserwhConfType() + "-" + whUserwhConf.getUserwhConfTerm());
                    if (whUserwhConf.getUserwhConfTerm().equals("=") || whUserwhConf.getUserwhConfTerm().equals("!=")) {
                        valuemap.put(whUserwhConf.getUserwhConfType() + "-" + whUserwhConf.getUserwhConfTerm() + "-" + whUserwhConf.getUserwhConfValue(), JsonUtil.buildNormalBinder().toJson((Object)whUserwhConf));
                        continue;
                    }
                    valuemap.put(whUserwhConf.getUserwhConfType() + "-" + whUserwhConf.getUserwhConfTerm(), JsonUtil.buildNormalBinder().toJson((Object)whUserwhConf));
                }
                DisUtil.setMapVer((String)(this.userwhCodeCachekey_key + "-" + whUserwh.getUserwhCode() + "-" + whUserwh.getTenantCode()), keymap);
                DisUtil.setMapVer((String)(this.userwhCodeCachekey_value + "-" + whUserwh.getUserwhCode() + "-" + whUserwh.getTenantCode()), valuemap);
            } else {
                DisUtil.del((String)(this.userwhCodeCachekey_key + "-" + whUserwh.getUserwhCode() + "-" + whUserwh.getTenantCode()));
                DisUtil.del((String)(this.userwhCodeCachekey_value + "-" + whUserwh.getUserwhCode() + "-" + whUserwh.getTenantCode()));
            }
            if (ListUtil.isNotEmpty(mpMpriceMemList)) {
                HashMap<String, String> keymapMem = new HashMap<String, String>();
                HashMap<String, String> valuemapMem = new HashMap<String, String>();
                for (WhUserwhMem whUserwhMem : mpMpriceMemList) {
                    if (StringUtils.isBlank((String)whUserwhMem.getUserwhMemTerm())) {
                        whUserwhMem.setUserwhMemTerm("=");
                    }
                    keymapMem.put(whUserwhMem.getUserwhMemType() + "-" + whUserwhMem.getUserwhMemTerm(), whUserwhMem.getUserwhMemType() + "-" + whUserwhMem.getUserwhMemTerm());
                    if (whUserwhMem.getUserwhMemTerm().equals("=") || whUserwhMem.getUserwhMemTerm().equals("!=")) {
                        valuemapMem.put(whUserwhMem.getUserwhMemType() + "-" + whUserwhMem.getUserwhMemTerm() + "-" + whUserwhMem.getUserwhMemValue(), JsonUtil.buildNormalBinder().toJson((Object)whUserwhMem));
                        continue;
                    }
                    valuemapMem.put(whUserwhMem.getUserwhMemType() + "-" + whUserwhMem.getUserwhMemTerm(), JsonUtil.buildNormalBinder().toJson((Object)whUserwhMem));
                }
                DisUtil.setMapVer((String)(this.userwhCodeMemCachekey_key + "-" + whUserwh.getUserwhCode() + "-" + whUserwh.getTenantCode()), keymapMem);
                DisUtil.setMapVer((String)(this.userwhCodeMemCachekey_value + "-" + whUserwh.getUserwhCode() + "-" + whUserwh.getTenantCode()), valuemapMem);
            } else {
                DisUtil.del((String)(this.userwhCodeMemCachekey_key + "-" + whUserwh.getUserwhCode() + "-" + whUserwh.getTenantCode()));
                DisUtil.del((String)(this.userwhCodeMemCachekey_value + "-" + whUserwh.getUserwhCode() + "-" + whUserwh.getTenantCode()));
            }
            ArrayList<WhUserwhDomain> dlist = (ArrayList<WhUserwhDomain>)ddListMap.get(whUserwh.getWarehouseCode() + "-" + whUserwh.getTenantCode());
            if (null == dlist) {
                dlist = new ArrayList<WhUserwhDomain>();
                ddListMap.put(whUserwh.getWarehouseCode() + "-" + whUserwh.getTenantCode(), dlist);
            }
            dlist.add(whUserwhDomain);
        }
        for (String key : ddListMap.keySet()) {
            ddMap.put(key, JsonUtil.buildNormalBinder().toJson(this.whDomainsort((List)ddListMap.get(key))));
        }
        DisUtil.setMapVer((String)this.userwhCodeCachekey, ddMap);
        this.logger.info("whUserwhService.queryWhUserwhLoadCache", (Object)"===========add-end==========");
    }
}

