/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.warehouse.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import com.yqbsoft.laser.service.warehouse.dao.WhUserwhMemMapper;
import com.yqbsoft.laser.service.warehouse.domain.WhUserwhMemDomain;
import com.yqbsoft.laser.service.warehouse.domain.WhUserwhMemReDomain;
import com.yqbsoft.laser.service.warehouse.model.WhUserwhMem;
import com.yqbsoft.laser.service.warehouse.service.WhUserwhMemService;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class WhUserwhMemServiceImpl
extends BaseServiceImpl
implements WhUserwhMemService {
    private static final String SYS_CODE = "wh.WhUserwhMemServiceImpl";
    private WhUserwhMemMapper whUserwhMemMapper;

    public void setWhUserwhMemMapper(WhUserwhMemMapper whUserwhMemMapper) {
        this.whUserwhMemMapper = whUserwhMemMapper;
    }

    private Date getSysDate() {
        try {
            return this.whUserwhMemMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("wh.WhUserwhMemServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkUserwhMem(WhUserwhMemDomain whUserwhMemDomain) {
        if (null == whUserwhMemDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)whUserwhMemDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setUserwhMemDefault(WhUserwhMem whUserwhMem) {
        if (null == whUserwhMem) {
            return;
        }
        if (null == whUserwhMem.getDataState()) {
            whUserwhMem.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == whUserwhMem.getGmtCreate()) {
            whUserwhMem.setGmtCreate(date);
        }
        whUserwhMem.setGmtModified(date);
        if (StringUtils.isBlank((String)whUserwhMem.getUserwhMemCode())) {
            whUserwhMem.setUserwhMemCode(this.getNo(null, "WhUserwhMem", "whUserwhMem", whUserwhMem.getTenantCode()));
        }
    }

    private int getUserwhMemMaxCode() {
        int code = 0;
        try {
            return this.whUserwhMemMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("wh.WhUserwhMemServiceImpl.getUserwhMemMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setUserwhMemUpdataDefault(WhUserwhMem whUserwhMem) {
        if (null == whUserwhMem) {
            return;
        }
        whUserwhMem.setGmtModified(this.getSysDate());
    }

    private void saveUserwhMemModel(WhUserwhMem whUserwhMem) throws ApiException {
        if (null == whUserwhMem) {
            return;
        }
        try {
            this.whUserwhMemMapper.insert(whUserwhMem);
        }
        catch (Exception e) {
            throw new ApiException("wh.WhUserwhMemServiceImpl.saveUserwhMemModel.ex", (Throwable)e);
        }
    }

    private void saveUserwhMemBatchModel(List<WhUserwhMem> whUserwhMemList) throws ApiException {
        if (null == whUserwhMemList || whUserwhMemList.isEmpty()) {
            return;
        }
        try {
            this.whUserwhMemMapper.insertBatch(whUserwhMemList);
        }
        catch (Exception e) {
            throw new ApiException("wh.WhUserwhMemServiceImpl.saveUserwhMemBatchModel.ex", (Throwable)e);
        }
    }

    private WhUserwhMem getUserwhMemModelById(Integer userwhMemId) {
        if (null == userwhMemId) {
            return null;
        }
        try {
            return this.whUserwhMemMapper.selectByPrimaryKey(userwhMemId);
        }
        catch (Exception e) {
            this.logger.error("wh.WhUserwhMemServiceImpl.getUserwhMemModelById", (Throwable)e);
            return null;
        }
    }

    private WhUserwhMem getUserwhMemModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.whUserwhMemMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("wh.WhUserwhMemServiceImpl.getUserwhMemModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delUserwhMemModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.whUserwhMemMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("wh.WhUserwhMemServiceImpl.delUserwhMemModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("wh.WhUserwhMemServiceImpl.delUserwhMemModelByCode.num");
        }
    }

    private void delUserwhMemModelByUserwhCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.whUserwhMemMapper.delByUserwhCode(map);
        }
        catch (Exception e) {
            throw new ApiException("wh.WhUserwhMemServiceImpl.delUserwhMemModelByUserwhCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("wh.WhUserwhMemServiceImpl.delUserwhMemModelByUserwhCode.num");
        }
    }

    private void deleteUserwhMemModel(Integer userwhMemId) throws ApiException {
        if (null == userwhMemId) {
            return;
        }
        int i = 0;
        try {
            i = this.whUserwhMemMapper.deleteByPrimaryKey(userwhMemId);
        }
        catch (Exception e) {
            throw new ApiException("wh.WhUserwhMemServiceImpl.deleteUserwhMemModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("wh.WhUserwhMemServiceImpl.deleteUserwhMemModel.num");
        }
    }

    private void updateUserwhMemModel(WhUserwhMem whUserwhMem) throws ApiException {
        if (null == whUserwhMem) {
            return;
        }
        int i = 0;
        try {
            i = this.whUserwhMemMapper.updateByPrimaryKey(whUserwhMem);
        }
        catch (Exception e) {
            throw new ApiException("wh.WhUserwhMemServiceImpl.updateUserwhMemModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("wh.WhUserwhMemServiceImpl.updateUserwhMemModel.num");
        }
    }

    private void updateStateUserwhMemModel(Integer userwhMemId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == userwhMemId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("userwhMemId", userwhMemId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.whUserwhMemMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("wh.WhUserwhMemServiceImpl.updateStateUserwhMemModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("wh.WhUserwhMemServiceImpl.updateStateUserwhMemModel.null");
        }
    }

    private void updateStateUserwhMemModelByCode(String tenantCode, String userwhMemCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)userwhMemCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("userwhMemCode", userwhMemCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.whUserwhMemMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("wh.WhUserwhMemServiceImpl.updateStateUserwhMemModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("wh.WhUserwhMemServiceImpl.updateStateUserwhMemModelByCode.null");
        }
    }

    private WhUserwhMem makeUserwhMem(WhUserwhMemDomain whUserwhMemDomain, WhUserwhMem whUserwhMem) {
        if (null == whUserwhMemDomain) {
            return null;
        }
        if (null == whUserwhMem) {
            whUserwhMem = new WhUserwhMem();
        }
        try {
            BeanUtils.copyAllPropertys((Object)whUserwhMem, (Object)whUserwhMemDomain);
            return whUserwhMem;
        }
        catch (Exception e) {
            this.logger.error("wh.WhUserwhMemServiceImpl.makeUserwhMem", (Throwable)e);
            return null;
        }
    }

    private WhUserwhMemReDomain makeWhUserwhMemReDomain(WhUserwhMem whUserwhMem) {
        if (null == whUserwhMem) {
            return null;
        }
        WhUserwhMemReDomain whUserwhMemReDomain = new WhUserwhMemReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)whUserwhMemReDomain, (Object)whUserwhMem);
            return whUserwhMemReDomain;
        }
        catch (Exception e) {
            this.logger.error("wh.WhUserwhMemServiceImpl.makeWhUserwhMemReDomain", (Throwable)e);
            return null;
        }
    }

    private List<WhUserwhMem> queryUserwhMemModelPage(Map<String, Object> parammap) {
        try {
            return this.whUserwhMemMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("wh.WhUserwhMemServiceImpl.queryUserwhMemModel", (Throwable)e);
            return null;
        }
    }

    private int countUserwhMem(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.whUserwhMemMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("wh.WhUserwhMemServiceImpl.countUserwhMem", (Throwable)e);
        }
        return i;
    }

    private WhUserwhMem createWhUserwhMem(WhUserwhMemDomain whUserwhMemDomain) {
        String msg = this.checkUserwhMem(whUserwhMemDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("wh.WhUserwhMemServiceImpl.saveUserwhMem.checkUserwhMem", msg);
        }
        WhUserwhMem whUserwhMem = this.makeUserwhMem(whUserwhMemDomain, null);
        this.setUserwhMemDefault(whUserwhMem);
        return whUserwhMem;
    }

    @Override
    public String saveUserwhMem(WhUserwhMemDomain whUserwhMemDomain) throws ApiException {
        WhUserwhMem whUserwhMem = this.createWhUserwhMem(whUserwhMemDomain);
        this.saveUserwhMemModel(whUserwhMem);
        return whUserwhMem.getUserwhMemCode();
    }

    @Override
    public String saveUserwhMemBatch(List<WhUserwhMemDomain> whUserwhMemDomainList) throws ApiException {
        if (null == whUserwhMemDomainList || whUserwhMemDomainList.isEmpty()) {
            return null;
        }
        ArrayList<WhUserwhMem> whUserwhMemList = new ArrayList<WhUserwhMem>();
        String code = "";
        for (WhUserwhMemDomain whUserwhMemDomain : whUserwhMemDomainList) {
            WhUserwhMem whUserwhMem = this.createWhUserwhMem(whUserwhMemDomain);
            code = whUserwhMem.getUserwhMemCode();
            whUserwhMemList.add(whUserwhMem);
        }
        this.saveUserwhMemBatchModel(whUserwhMemList);
        return code;
    }

    @Override
    public void updateUserwhMemState(Integer userwhMemId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == userwhMemId) {
            return;
        }
        this.updateStateUserwhMemModel(userwhMemId, dataState, oldDataState, map);
    }

    @Override
    public void updateUserwhMemStateByCode(String tenantCode, String userwhMemCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)userwhMemCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateUserwhMemModelByCode(tenantCode, userwhMemCode, dataState, oldDataState, map);
    }

    @Override
    public void updateUserwhMem(WhUserwhMemDomain whUserwhMemDomain) throws ApiException {
        String msg = this.checkUserwhMem(whUserwhMemDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("wh.WhUserwhMemServiceImpl.updateUserwhMem.checkUserwhMem", msg);
        }
        WhUserwhMem oldWhUserwhMem = this.getUserwhMemModelById(whUserwhMemDomain.getUserwhMemId());
        if (null == oldWhUserwhMem) {
            throw new ApiException("wh.WhUserwhMemServiceImpl.updateUserwhMem.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        WhUserwhMem whUserwhMem = this.makeUserwhMem(whUserwhMemDomain, oldWhUserwhMem);
        this.setUserwhMemUpdataDefault(whUserwhMem);
        this.updateUserwhMemModel(whUserwhMem);
    }

    @Override
    public WhUserwhMem getUserwhMem(Integer userwhMemId) {
        if (null == userwhMemId) {
            return null;
        }
        return this.getUserwhMemModelById(userwhMemId);
    }

    @Override
    public void deleteUserwhMem(Integer userwhMemId) throws ApiException {
        if (null == userwhMemId) {
            return;
        }
        this.deleteUserwhMemModel(userwhMemId);
    }

    @Override
    public QueryResult<WhUserwhMem> queryUserwhMemPage(Map<String, Object> map) {
        List<WhUserwhMem> whUserwhMemList = this.queryUserwhMemModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countUserwhMem(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(whUserwhMemList);
        return queryResult;
    }

    @Override
    public WhUserwhMem getUserwhMemByCode(String tenantCode, String userwhMemCode) throws ApiException {
        if (StringUtils.isBlank((String)userwhMemCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("userwhMemCode", userwhMemCode);
        return this.getUserwhMemModelByCode(map);
    }

    @Override
    public void deleteUserwhMemByCode(String tenantCode, String userwhMemCode) throws ApiException {
        if (StringUtils.isBlank((String)userwhMemCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("userwhMemCode", userwhMemCode);
        this.delUserwhMemModelByCode(map);
    }

    @Override
    public void deleteUserwhMemByUserwhCode(String tenantCode, String userwhCode) throws ApiException {
        if (StringUtils.isBlank((String)userwhCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("userwhCode", userwhCode);
        this.delUserwhMemModelByUserwhCode(map);
    }
}

