/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.des;

import com.qianjiang.des.Coder;
import java.security.Key;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;

public abstract class DESCoder
extends Coder {
    public static final String ALGORITHM = "DES";

    private static Key toKey(byte[] key) throws Exception {
        DESKeySpec dks = new DESKeySpec(key);
        SecretKeyFactory keyFactory = SecretKeyFactory.getInstance(ALGORITHM);
        return keyFactory.generateSecret(dks);
    }

    public static byte[] decrypt(byte[] data, String key) throws Exception {
        Key k = DESCoder.toKey(DESCoder.decryptBASE64(key));
        Cipher cipher = Cipher.getInstance(ALGORITHM);
        cipher.init(2, k);
        return cipher.doFinal(data);
    }

    public static byte[] encrypt(byte[] data, String key) throws Exception {
        Key k = DESCoder.toKey(DESCoder.decryptBASE64(key));
        Cipher cipher = Cipher.getInstance(ALGORITHM);
        cipher.init(1, k);
        return cipher.doFinal(data);
    }

    public static String initKey() throws Exception {
        return DESCoder.initKey(null);
    }

    public static String initKey(String seed) throws Exception {
        SecureRandom secureRandom = null;
        secureRandom = seed != null ? new SecureRandom(DESCoder.decryptBASE64(seed)) : new SecureRandom();
        KeyGenerator kg = KeyGenerator.getInstance(ALGORITHM);
        kg.init(secureRandom);
        SecretKey secretKey = kg.generateKey();
        return DESCoder.encryptBASE64(secretKey.getEncoded());
    }
}

