/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.util.uploadutil;

import com.qianjiang.manager.bean.ImageSet;
import com.qianjiang.util.MyLogger;
import com.qianjiang.util.UtilDate;
import java.io.File;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItem;
import org.springframework.web.multipart.MultipartFile;

public class UploadImgCommon {
    private static final MyLogger LOGGER = new MyLogger(UploadImgCommon.class);
    protected static final String IMAGE = "image";
    protected static final String MEDIA = "media";
    private static long maxSize = 0xA00000L;
    private static long mediaMaxSize = 524288000L;
    private static HashMap<String, String> extMap = new HashMap();
    protected static String picPath;
    protected static String prefix;
    protected static String suffix;
    protected static final int THREE = 3;
    protected static final String SYMBOLS = "@";
    protected static final int SMALL = 56;
    protected static final int SMALLIMG = 0;
    protected static final String OLDIMG = "oldimg";
    protected static final String LOGGERINFO1 = "\u539f\u56fe\u5730\u5740\uff1a";
    protected static final String LOGGERINFO2 = "\u5c3a\u5bf8\u7684\u56fe\u7247\u5730\u5740\uff1a";
    protected static final String LOGGERINFO3 = "\u56fe\u7247\u4e0a\u4f20\uff0c\u8fd4\u56dekey\u503c\u5217\u8868\u9519\u8bef";
    protected static final String IMAGEPATH = "IMAGEPATH";
    protected static final String MEDIAPATH = "MEDIAPATH";

    public static String getPicNamePathSuffix() {
        String fileName = "";
        try {
            long now = System.currentTimeMillis();
            prefix = String.valueOf(now);
            picPath = UploadImgCommon.getHostAndPort().getProperty(IMAGEPATH) + UtilDate.todayFormatString(new Date()) + "/";
            File picSaveFile = new File(picPath);
            if (!picSaveFile.exists()) {
                picSaveFile.mkdirs();
            }
            suffix = ".jpg";
            fileName = picPath + prefix + suffix;
            LOGGER.info("\u521b\u5efa\u6587\u4ef6\u6210\u529f\uff0c\u6587\u4ef6\u540d\uff1a" + fileName);
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u521b\u5efa\u672c\u5730\u6587\u4ef6\u5931\u8d25" + e.getMessage(), e);
        }
        return fileName;
    }

    public static String getVideoNamePathSuffix() {
        String fileName = "";
        try {
            long now = System.currentTimeMillis();
            prefix = String.valueOf(now);
            picPath = UploadImgCommon.getHostAndPort().getProperty(MEDIAPATH) + UtilDate.todayFormatString(new Date()) + "/";
            File picSaveFile = new File(picPath);
            if (!picSaveFile.exists()) {
                picSaveFile.mkdirs();
            }
            suffix = ".mp4";
            fileName = picPath + prefix + suffix;
            LOGGER.info("\u521b\u5efa\u89c6\u9891\u6587\u4ef6\u6210\u529f\uff0c\u6587\u4ef6\u540d\uff1a" + fileName);
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u521b\u5efa\u4e0a\u4f20\u89c6\u9891\u672c\u5730\u670d\u52a1\u5668\u5730\u5740\u5931\u8d25:" + e.getLocalizedMessage(), e);
        }
        return fileName;
    }

    public static int[] getImgSet(List<ImageSet> imgSet) {
        int[] widths = new int[imgSet.size()];
        for (int i = 0; i < imgSet.size(); ++i) {
            widths[i] = Integer.parseInt(imgSet.get(i).getRuleWidth());
        }
        return widths;
    }

    public static int[] getImgSetOut85(List<ImageSet> imgSet) {
        int[] widths = new int[3];
        for (int i = 0; i < imgSet.size(); ++i) {
            if ("85".equals(imgSet.get(i).getRuleWidth())) {
                if (i >= 3) continue;
                --i;
                continue;
            }
            widths[i] = Integer.parseInt(imgSet.get(i).getRuleWidth());
        }
        return widths;
    }

    public static void sortWidth(int[] widths) {
        for (int i = 0; i < widths.length; ++i) {
            for (int j = i + 1; j < widths.length; ++j) {
                if (widths[i] <= widths[j]) continue;
                int temp = widths[i];
                widths[i] = widths[j];
                widths[j] = temp;
            }
        }
    }

    public static String getHttpAndPort(HttpServletRequest request) {
        return request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort();
    }

    public static Properties getHostAndPort() {
        Properties p = new Properties();
        try {
            InputStream inputStream = UploadImgCommon.class.getClassLoader().getResourceAsStream("config/image.properties");
            p.load(inputStream);
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u8bfb\u53d6Properties\u5c5e\u6027\u6587\u4ef6\u9519\u8bef" + e.getMessage(), e);
        }
        return p;
    }

    public static boolean checkFileForSpringUpload(MultipartFile muFile) {
        boolean bool = true;
        if (muFile.getSize() > maxSize) {
            LOGGER.error("=============>\u4e0a\u4f20" + muFile.getOriginalFilename() + "\u6587\u4ef6\u5927\u5c0f\u8d85\u8fc7\u9650\u5236");
            bool = false;
            return bool;
        }
        String fileName = muFile.getOriginalFilename();
        String fileExt = fileName.substring(fileName.lastIndexOf(".") + 1).toLowerCase();
        if (!Arrays.asList(extMap.get(IMAGE).split(",")).contains(fileExt)) {
            LOGGER.error("\u4e0a\u4f20\u6587\u4ef6" + muFile.getOriginalFilename() + "\u6269\u5c55\u540d\u662f\u4e0d\u5141\u8bb8\u7684\u6269\u5c55\u540d\u3002\n\u53ea\u5141\u8bb8" + extMap.get(IMAGE) + "\u683c\u5f0f\u3002");
            bool = false;
            return bool;
        }
        return bool;
    }

    public static boolean checkFileAndMedia(FileItem file, String dirName) {
        boolean bool = true;
        long fileSize = file.getSize();
        String fileName = file.getName();
        if (fileSize > maxSize && fileSize > mediaMaxSize) {
            LOGGER.error("=============>\u4e0a\u4f20" + file.getFieldName() + "\u6587\u4ef6\u5927\u5c0f\u8d85\u8fc7\u9650\u5236");
            bool = false;
            return bool;
        }
        String fileExt = fileName.substring(fileName.lastIndexOf(".") + 1).toLowerCase();
        if (!Arrays.asList(extMap.get(dirName).split(",")).contains(fileExt)) {
            LOGGER.error("\u4e0a\u4f20\u6587\u4ef6" + file.getFieldName() + "\u6269\u5c55\u540d\u662f\u4e0d\u5141\u8bb8\u7684\u6269\u5c55\u540d\u3002\n\u53ea\u5141\u8bb8" + extMap.get(dirName) + "\u683c\u5f0f\u3002");
            bool = false;
            return bool;
        }
        return bool;
    }

    static {
        extMap.put(IMAGE, "gif,jpg,jpeg,png,bmp");
        extMap.put(MEDIA, "mp4");
    }
}

