/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.auth.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;

public class HttpUtil {
    private static final String USERAGENT = "User-Agent";
    private static final String DEFAULT_CHARSET = "utf-8";
    public static final int CONNECTIMEOUT = 5000;
    public static final int READTIMEOUT = 5000;
    public static final String USER_AGENT = "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/31.0.1650.63 Safari/537.36";

    private HttpUtil() {
    }

    public static String post(String url, String body, Map<String, String> headers) throws IOException {
        Map<String, String> headers1 = headers;
        if (headers1 == null) {
            headers1 = new HashMap<String, String>();
            headers.put("Content-Type", "application/x-www-form-urlencoded");
            headers.put(USERAGENT, USER_AGENT);
        }
        return HttpUtil.fetch("POST", url, body, headers1);
    }

    public static String post(String url, String body) throws IOException {
        return HttpUtil.post(url, body, null);
    }

    public static String get(String url) throws IOException {
        return HttpUtil.get(url, null);
    }

    public static String get(String url, Map<String, String> headers) throws IOException {
        Map<String, String> headers1 = headers;
        if (headers1 == null) {
            headers1 = new HashMap<String, String>();
            headers.put(USERAGENT, USER_AGENT);
        }
        return HttpUtil.fetch("GET", url, null, headers1);
    }

    public static String postForm(String url, Map<String, String> params) throws IOException {
        return HttpUtil.postForm(url, params, null);
    }

    public static String postForm(String url, Map<String, String> params, Map<String, String> headers) throws IOException {
        Map<String, String> headers1 = headers;
        if (headers1 == null) {
            headers1 = new HashMap<String, String>();
            headers.put("Content-Type", "application/x-www-form-urlencoded");
            headers.put(USERAGENT, USER_AGENT);
        }
        String body = "";
        if (params != null) {
            boolean first = true;
            for (String param : params.keySet()) {
                if (first) {
                    first = false;
                } else {
                    body = body + "&";
                }
                String value = params.get(param);
                body = body + URLEncoder.encode(param, DEFAULT_CHARSET) + "=";
                body = body + URLEncoder.encode(value, DEFAULT_CHARSET);
            }
        }
        return HttpUtil.post(url, body, headers1);
    }

    public static String appendQueryParams(String url, Map<String, String> params) throws IOException {
        String fullUrl = new String(url);
        if (params != null) {
            boolean first = fullUrl.indexOf(63) == -1;
            for (String param : params.keySet()) {
                if (first) {
                    fullUrl = fullUrl + '?';
                    first = false;
                } else {
                    fullUrl = fullUrl + '&';
                }
                String value = params.get(param);
                fullUrl = fullUrl + URLEncoder.encode(param, DEFAULT_CHARSET) + '=';
                fullUrl = fullUrl + URLEncoder.encode(value, DEFAULT_CHARSET);
            }
        }
        return fullUrl;
    }

    public static Map<String, String> getQueryParams(String url) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        int start = url.indexOf(63);
        while (start != -1) {
            int equals = url.indexOf(61, start);
            String param = "";
            param = equals != -1 ? url.substring(start + 1, equals) : url.substring(start + 1);
            String value = "";
            if (equals != -1) {
                start = url.indexOf(38, equals);
                value = start != -1 ? url.substring(equals + 1, start) : url.substring(equals + 1);
            }
            params.put(URLDecoder.decode(param, DEFAULT_CHARSET), URLDecoder.decode(value, DEFAULT_CHARSET));
        }
        return params;
    }

    public static String removeQueryParams(String url) {
        int q = url.indexOf(63);
        if (q != -1) {
            return url.substring(0, q);
        }
        return url;
    }

    public static String fetch(String method, String url, String body, Map<String, String> headers) throws IOException {
        URL u = new URL(url);
        HttpURLConnection conn = (HttpURLConnection)u.openConnection();
        conn.setConnectTimeout(5000);
        conn.setReadTimeout(5000);
        if (method != null) {
            conn.setRequestMethod(method);
        }
        if (headers != null) {
            for (String key : headers.keySet()) {
                conn.addRequestProperty(key, headers.get(key));
            }
        }
        if (body != null) {
            conn.setDoOutput(true);
            OutputStream os = conn.getOutputStream();
            os.write(body.getBytes());
            os.flush();
            os.close();
        }
        InputStream is = conn.getInputStream();
        String response = HttpUtil.streamToString(is);
        is.close();
        if (conn.getResponseCode() == 301) {
            String location = conn.getHeaderField("Location");
            return HttpUtil.fetch(method, location, body, headers);
        }
        return response;
    }

    public static String streamToString(InputStream in) throws IOException {
        int n;
        StringBuilder out = new StringBuilder();
        byte[] b = new byte[4096];
        while ((n = in.read(b)) != -1) {
            out.append(new String(b, 0, n));
        }
        return out.toString();
    }
}

