/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.auth.oauth;

import com.qianjiang.auth.oauth.AbstractOAuth;
import com.qianjiang.auth.util.HttpUtil;
import com.qianjiang.auth.util.TokenUtil;
import com.qianjiang.operlog.util.OperaLogBean;
import com.qianjiang.operlog.util.OperaLogUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class OAuthBaidu
extends AbstractOAuth {
    private static final String EXINFO = "\u767e\u5ea6\u7b2c\u4e09\u65b9\u767b\u5f55\u5b9e\u73b0";
    private static final String AUTH_URL = "https://openapi.baidu.com/oauth/2.0/authorize";
    private static final String TOKEN_URL = "https://openapi.baidu.com/oauth/2.0/token";
    private static final String USER_INFO_URL = "https://openapi.baidu.com/rest/2.0/passport/users/getInfo";
    private static final String PHOTO_URL = "http://tb.himg.baidu.com/sys/portrait/item/";

    public OAuthBaidu() {
    }

    public OAuthBaidu(String authName, String clientId, String clientSecret, String redirectUri) {
        super(authName, clientId, clientSecret, redirectUri);
    }

    @Override
    public String getAuthorizeUrl() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("response_type", "code");
        params.put("client_id", this.getClientId());
        params.put("redirect_uri", this.getRedirectUri());
        try {
            return HttpUtil.appendQueryParams(AUTH_URL, params);
        }
        catch (IOException e) {
            OperaLogUtil.addOperaException(new OperaLogBean(e, EXINFO));
            return null;
        }
    }

    @Override
    public Map<String, Object> getUserInfoByCode(String code) {
        String accessToken = this.getTokenByCode(code);
        String userInfo = this.getUserInfo(accessToken);
        Map userinfo = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(userInfo, String.class, String.class);
        if (null != userinfo.get("portrait") && !"".equals(userinfo.get("portrait"))) {
            userinfo.put("portrait", PHOTO_URL + userinfo.get("portrait").toString());
        }
        return userinfo;
    }

    private String getTokenByCode(String code) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("code", code);
        params.put("client_id", this.getClientId());
        params.put("client_secret", this.getClientSecret());
        params.put("grant_type", "authorization_code");
        params.put("redirect_uri", this.getRedirectUri());
        try {
            return TokenUtil.getAccessToken(HttpUtil.postForm(TOKEN_URL, params));
        }
        catch (IOException e) {
            OperaLogUtil.addOperaException(new OperaLogBean(e, EXINFO));
            return null;
        }
    }

    private String getUserInfo(String accessToken) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("access_token", accessToken);
        try {
            return HttpUtil.postForm(USER_INFO_URL, params);
        }
        catch (IOException e) {
            OperaLogUtil.addOperaException(new OperaLogBean(e, EXINFO));
            return null;
        }
    }
}

