/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.common.service.Impl;

import com.qianjiang.common.service.SeoService;
import com.qianjiang.system.bean.SeoConf;
import com.qianjiang.system.mobile.service.MobSiteBasicService;
import com.qianjiang.system.service.BasicSetService;
import com.qianjiang.system.service.ISeoConfBiz;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.servlet.ModelAndView;

@Service(value="SeoService")
public class SeoServiceImpl
implements SeoService {
    @Resource(name="seoConfBizImpl")
    private ISeoConfBiz seoconfbiz;
    @Resource(name="basicSetService")
    private BasicSetService basicSetService;
    @Resource(name="MobSiteBasicService")
    private MobSiteBasicService mobSiteBasicService;

    @Override
    public ModelAndView getCurrSeo(ModelAndView mav) {
        mav.addObject("seo", (Object)this.getSeo());
        mav.addObject("sys", (Object)this.basicSetService.findBasicSet());
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        String path = request.getContextPath();
        String basePath = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + path + "/";
        mav.addObject("mobSiteBasic", (Object)this.mobSiteBasicService.selectCurrMobSiteBasic(basePath));
        return mav;
    }

    private SeoConf getSeo() {
        SeoConf seo = this.seoconfbiz.querySeoByUsedStatus();
        if (null == seo) {
            seo = new SeoConf();
            String bsetName = this.basicSetService.findBasicSet().getBsetName();
            if (null != bsetName && !"".equals(bsetName)) {
                seo.setMete(bsetName);
            } else {
                seo.setMete("");
            }
            seo.setMeteKey("");
            seo.setMeteDes("");
        }
        return seo;
    }
}

