/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.auth.oauth;

import com.qianjiang.auth.bean.Auth;
import com.qianjiang.auth.oauth.AbstractOAuth;
import com.qianjiang.auth.oauth.OAuthBaidu;
import com.qianjiang.auth.oauth.OAuthQQ;
import com.qianjiang.auth.oauth.OAuthSina;

public final class OAuthFactory {
    private static OAuthFactory instance;

    private OAuthFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static OAuthFactory getInstance() {
        if (instance != null) return instance;
        Class<OAuthFactory> clazz = OAuthFactory.class;
        synchronized (OAuthFactory.class) {
            if (instance != null) return instance;
            instance = new OAuthFactory();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public AbstractOAuth buildOAuth(Auth auth) {
        if (null == auth) {
            return null;
        }
        AbstractOAuth oauth = null;
        String authName = auth.getAuthName();
        String clientId = auth.getAuthClientId();
        String clientSecret = auth.getAuthClientSecret();
        String redirectUri = auth.getAuthRedirectUri();
        if ("QQ".equalsIgnoreCase(authName)) {
            oauth = new OAuthQQ(authName, clientId, clientSecret, redirectUri);
        } else if ("baidu".equalsIgnoreCase(authName)) {
            oauth = new OAuthBaidu(authName, clientId, clientSecret, redirectUri);
        } else if ("sina".equalsIgnoreCase(authName)) {
            oauth = new OAuthSina(authName, clientId, clientSecret, redirectUri);
        }
        return oauth;
    }
}

