/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.customer.bean;

import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.Date;
import javax.validation.constraints.Pattern;

public class CustomerPointLevel {
    private Long pointLevelId;
    @Pattern(regexp="[^\\<\\>]*")
    private String pointLevelName;
    @Pattern(regexp="[0-9\\,]+")
    private String pointNeed;
    private int pointNeedOnce;
    private BigDecimal pointDiscount;
    private String isDefault;
    private Date createTime;
    private Date modifiedTime;
    private Date delTime;
    private String delFlag;
    private Long minPoint;
    private Long maxPoint;

    public Long getPointLevelId() {
        return this.pointLevelId;
    }

    public void setPointLevelId(Long pointLevelId) {
        this.pointLevelId = pointLevelId;
    }

    public String getPointLevelName() {
        return this.pointLevelName;
    }

    public void setPointLevelName(String pointLevelName) {
        this.pointLevelName = pointLevelName;
    }

    public String getPointNeed() {
        return this.pointNeed;
    }

    public void setPointNeed(String pointNeed) {
        this.pointNeed = pointNeed;
    }

    public BigDecimal getPointDiscount() {
        return this.pointDiscount;
    }

    public void setPointDiscount(BigDecimal pointDiscount) {
        this.pointDiscount = pointDiscount;
    }

    public String getIsDefault() {
        return this.isDefault;
    }

    public void setIsDefault(String isDefault) {
        this.isDefault = isDefault;
    }

    public Date getCreateTime() {
        if (this.createTime != null) {
            return new Date(this.createTime.getTime());
        }
        return null;
    }

    public void setCreateTime(Date createTime) {
        Date timeTemp;
        if (createTime != null && (timeTemp = (Date)createTime.clone()) != null) {
            this.createTime = timeTemp;
        }
    }

    public Date getModifiedTime() {
        if (this.modifiedTime != null) {
            return new Date(this.modifiedTime.getTime());
        }
        return null;
    }

    public void setModifiedTime(Date modifiedTime) {
        Date timeTemp;
        if (modifiedTime != null && (timeTemp = (Date)modifiedTime.clone()) != null) {
            this.modifiedTime = timeTemp;
        }
    }

    public Date getDelTime() {
        if (this.delTime != null) {
            return new Date(this.delTime.getTime());
        }
        return null;
    }

    public void setDelTime(Date delTime) {
        Date timeTemp;
        if (delTime != null && (timeTemp = (Date)delTime.clone()) != null) {
            this.delTime = timeTemp;
        }
    }

    public String getDelFlag() {
        return this.delFlag;
    }

    public void setDelFlag(String delFlag) {
        this.delFlag = delFlag;
    }

    public boolean isPointInThisRegion(int point) {
        if (StringUtils.isEmpty((String)this.pointNeed)) {
            return false;
        }
        try {
            String[] sRegin = this.pointNeed.split("~");
            return Integer.valueOf(sRegin[0]) <= point && point < Integer.valueOf(sRegin[1]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public void setMinAndMaxPoint() {
        if (StringUtils.isEmpty((String)this.pointNeed)) {
            return;
        }
        try {
            String[] sRegin = this.pointNeed.split("~");
            this.minPoint = Long.valueOf(sRegin[0]);
            this.maxPoint = Long.valueOf(sRegin[1]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Long getMinPoint() {
        return this.minPoint;
    }

    public void setMinPoint(Long minPoint) {
        this.minPoint = minPoint;
    }

    public Long getMaxPoint() {
        return this.maxPoint;
    }

    public void setMaxPoint(Long maxPoint) {
        this.maxPoint = maxPoint;
    }

    public int getPointNeedOnce() {
        return this.pointNeedOnce;
    }

    public void setPointNeedOnce(int pointNeedOnce) {
        this.pointNeedOnce = pointNeedOnce;
    }
}

