/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.utils;

import com.qianjiang.util.MyLogger;
import com.qianjiang.utils.HexUtil;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public final class MD5Util {
    public static final MyLogger LOGGER = new MyLogger(MD5Util.class);
    private static final BigInteger PRIVATE_D = new BigInteger("3206586642942415709865087389521403230384599658161226562177807849299468150139");
    private static final BigInteger N = new BigInteger("7318321375709168120463791861978437703461807315898125152257493378072925281977");

    private MD5Util() {
    }

    static MessageDigest getDigest() {
        try {
            return MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] md5(byte[] data) {
        return MD5Util.getDigest().digest(data);
    }

    public static byte[] md5(String data, String charset) {
        if (charset == null) {
            return MD5Util.md5(data.getBytes());
        }
        try {
            return MD5Util.md5(data.getBytes(charset));
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.info(e);
            return null;
        }
    }

    public static String md5Hex(byte[] data) {
        return HexUtil.toHexString(MD5Util.md5(data));
    }

    public static String md5Hex(String data) {
        return HexUtil.toHexString(MD5Util.md5(data, null));
    }

    public static String md5Hex(String data, String charset) {
        return HexUtil.toHexString(MD5Util.md5(data, charset));
    }

    public static String getDecryptLoginPassword(String str) {
        byte[] ptext = HexUtil.toByteArray(str);
        BigInteger encryC = new BigInteger(ptext);
        BigInteger variable = encryC.modPow(PRIVATE_D, N);
        byte[] mt = variable.toByteArray();
        StringBuffer buffer = new StringBuffer();
        for (int i = mt.length - 1; i > -1; --i) {
            buffer.append((char)mt[i]);
        }
        return buffer.substring(0, buffer.length() - 10).toString();
    }
}

