/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.utils;

import com.qianjiang.utils.UIDFactory;

public class UUID
extends UIDFactory {
    protected static final int BITS8 = 8;
    protected static final int BYTELEN = 16;
    protected static final int HIMASK = 240;
    protected static final int LO8BITMASK = 255;
    protected static final int LOMASK = 15;
    protected static final long MAX_INT = 32767L;
    protected static final long MAX_LONG = Integer.MAX_VALUE;
    protected long mhiTag;
    protected long mloTag;
    protected String muuid = null;

    protected UUID(long highTag, long loTag) {
        this.mhiTag = highTag;
        this.mloTag = loTag;
        this.muuid = UUID.toString(this.toByteArray());
    }

    protected UUID() {
        this.next();
        this.muuid = UUID.toString(this.toByteArray());
    }

    private static byte hiNibble(byte b) {
        return (byte)(b >> 4 & 0xF);
    }

    private static byte loNibble(byte b) {
        return (byte)(b & 0xF);
    }

    public boolean equals(Object obj) {
        try {
            if (obj == null) {
                return false;
            }
            UUID uuid = (UUID)obj;
            boolean flag = uuid.mhiTag == this.mhiTag && uuid.mloTag == this.mloTag;
            return flag;
        }
        catch (ClassCastException cce) {
            return false;
        }
    }

    public int hashCode() {
        int result = (int)(this.mhiTag ^ this.mhiTag >>> 32);
        result = 31 * result + (int)(this.mloTag ^ this.mloTag >>> 32);
        return result;
    }

    @Override
    public String getNextUID() {
        this.next();
        return this.muuid;
    }

    @Override
    public String getUID() {
        return this.muuid;
    }

    @Override
    public void setUID(String uidStr) throws Exception {
        long loTag = 0L;
        long hiTag = 0L;
        int len = uidStr.length();
        if (32 != len) {
            throw new Exception("bad string format");
        }
        int idx = 0;
        for (int i = 0; i < 2; ++i) {
            loTag = 0L;
            for (int j = 0; j < len / 2; ++j) {
                String s = uidStr.substring(idx++, idx);
                int val = Integer.parseInt(s, 16);
                loTag <<= 4;
                loTag |= (long)val;
            }
            if (i != 0) continue;
            hiTag = loTag;
        }
        this.mhiTag = hiTag;
        this.mloTag = loTag;
        this.muuid = UUID.toString(this.toByteArray());
    }

    @Override
    public String toPrintableString() {
        int i;
        byte[] bytes = this.toByteArray();
        if (16 != bytes.length) {
            return "** Bad UUID Format/Value **";
        }
        StringBuffer buf = new StringBuffer();
        for (i = 0; i < 4; ++i) {
            buf.append(Integer.toHexString(UUID.hiNibble(bytes[i])));
            buf.append(Integer.toHexString(UUID.loNibble(bytes[i])));
        }
        while (i < 10) {
            buf.append('-');
            for (int j = 0; j < 2; ++j) {
                buf.append(Integer.toHexString(UUID.hiNibble(bytes[i])));
                buf.append(Integer.toHexString(UUID.loNibble(bytes[i++])));
            }
        }
        buf.append('-');
        while (i < 16) {
            buf.append(Integer.toHexString(UUID.hiNibble(bytes[i])));
            buf.append(Integer.toHexString(UUID.loNibble(bytes[i])));
            ++i;
        }
        return buf.toString();
    }

    public String toString() {
        return this.muuid;
    }

    protected static UIDFactory getInstance() {
        return new UUID();
    }

    protected static String toString(byte[] bytes) {
        if (16 != bytes.length) {
            return "** Bad UUID Format/Value **";
        }
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < 16; ++i) {
            buf.append(Integer.toHexString(UUID.hiNibble(bytes[i])));
            buf.append(Integer.toHexString(UUID.loNibble(bytes[i])));
        }
        return buf.toString();
    }

    protected void next() {
        this.mhiTag = System.currentTimeMillis() + Long.MIN_VALUE ^ MACHINEID;
        this.mloTag = EPOCH + Math.abs(M_RANDOM.nextLong());
        this.muuid = UUID.toString(this.toByteArray());
    }

    protected byte[] toByteArray() {
        int i;
        byte[] bytes = new byte[16];
        int idx = 15;
        long val = this.mloTag;
        for (i = 0; i < 8; ++i) {
            bytes[idx--] = (byte)(val & 0xFFL);
            val >>= 8;
        }
        val = this.mhiTag;
        for (i = 0; i < 8; ++i) {
            bytes[idx--] = (byte)(val & 0xFFL);
            val >>= 8;
        }
        if (!this.isMD5()) {
            return bytes;
        }
        return UUID.toMD5(bytes);
    }
}

