/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.customer.bean;

import com.qianjiang.customer.bean.Customer;
import com.qianjiang.customer.bean.CustomerPointLevel;
import com.qianjiang.customer.service.CustomerPointServiceMapper;
import java.util.List;
import java.util.concurrent.RecursiveAction;

public class CustomerPointLevelTask
extends RecursiveAction {
    private int first;
    private int last;
    private List<Customer> customers;
    private CustomerPointServiceMapper customerPointServiceMapper;
    private List<CustomerPointLevel> customerPointLevels;

    public CustomerPointLevelTask(int first, int last, List<Customer> customers, CustomerPointServiceMapper customerPointServiceMapper, List<CustomerPointLevel> customerPointLevels) {
        this.customerPointLevels = customerPointLevels;
        this.customers = customers;
        this.customerPointServiceMapper = customerPointServiceMapper;
        this.first = first;
        this.last = last;
    }

    @Override
    protected void compute() {
        if (this.last - this.first < 50) {
            for (int i = this.first; i < this.last; ++i) {
                Customer customer = this.customers.get(i);
                CustomerPointLevel customerPointLevel = this.customerPointServiceMapper.getCustomerPointLevelByPoint(this.customerPointServiceMapper.getCustomerAllPointSimple(customer.getCustomerId() + ""), this.customerPointLevels);
                if (null == customerPointLevel) continue;
                customer.setPointLevelId(customerPointLevel.getPointLevelId());
            }
        } else {
            int middle = (this.last + this.first) / 2;
            CustomerPointLevelTask left = new CustomerPointLevelTask(this.first, middle, this.customers, this.customerPointServiceMapper, this.customerPointLevels);
            CustomerPointLevelTask right = new CustomerPointLevelTask(middle, this.last, this.customers, this.customerPointServiceMapper, this.customerPointLevels);
            CustomerPointLevelTask.invokeAll(left, right);
        }
    }
}

