/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.coupon.service.impl;

import com.qianjiang.coupon.bean.Coupon;
import com.qianjiang.coupon.bean.CouponNo;
import com.qianjiang.coupon.bean.CouponRe;
import com.qianjiang.coupon.service.CouponNoService;
import com.qianjiang.util.PageBean;
import com.yqbsoft.laser.html.common.send.PostParamMap;
import com.yqbsoft.laser.html.common.send.SupperFacade;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.springframework.stereotype.Service;

@Service(value="CouponNoService")
public class CouponNoServiceImpl
extends SupperFacade
implements CouponNoService {
    @Override
    public List<CouponNo> selectNoByCouponId(Long couponId) {
        PostParamMap pmap = new PostParamMap("pm.coupon.CouponNoService.selectNoByCouponId");
        pmap.putParam("couponId", (Object)couponId);
        return this.htmlIBaseService.getForList(pmap, CouponNo.class);
    }

    @Override
    public int updateCodeIsUse(String codeNo, String orderCode) {
        PostParamMap pmap = new PostParamMap("pm.coupon.CouponNoService.updateCodeIsUse");
        pmap.putParam("codeNo", (Object)codeNo);
        pmap.putParam("orderCode", (Object)orderCode);
        return (Integer)this.htmlIBaseService.senReObject(pmap, Integer.class);
    }

    @Override
    public CouponNo selectNoByCouponIdByStatus(Long couponNo) {
        PostParamMap pmap = new PostParamMap("pm.coupon.CouponNoService.selectNoByCouponIdByStatus");
        pmap.putParam("couponNo", (Object)couponNo);
        return (CouponNo)this.htmlIBaseService.senReObject(pmap, CouponNo.class);
    }

    @Override
    public PageBean selectList(PageBean pb, Long couponId, CouponNo couponNo) {
        PostParamMap pmap = new PostParamMap("pm.coupon.CouponNoService.selectList");
        pmap.putParamToJson("pb", (Object)pb);
        pmap.putParam("couponId", (Object)couponId);
        pmap.putParamToJson("couponNo", (Object)couponNo);
        return (PageBean)this.htmlIBaseService.senReObject(pmap, PageBean.class);
    }

    @Override
    public int changeCouponGetAndStatus(Long codeId) {
        PostParamMap pmap = new PostParamMap("pm.coupon.CouponNoService.changeCouponGetAndStatus");
        pmap.putParam("codeId", (Object)codeId);
        return (Integer)this.htmlIBaseService.senReObject(pmap, Integer.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exportCouponCodeNo(HttpServletResponse response, Long couponId) {
        Object ouputStream2;
        HSSFRow tempRow;
        CouponNo couponNo;
        PostParamMap pmap = new PostParamMap("pm.coupon.CouponNoService.exportCouponCodeNo");
        pmap.putParam("couponId", (Object)couponId);
        CouponRe couponRe = (CouponRe)this.htmlIBaseService.senReObject(pmap, CouponRe.class);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        List<CouponNo> couponNos = couponRe.getCouponNoList();
        Coupon coupon = couponRe.getCoupon();
        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFCellStyle style = wb.createCellStyle();
        style.setAlignment((short)2);
        HSSFSheet sheet1 = wb.createSheet("\u4f18\u60e0\u5238\u5238\u7801\u5217\u8868");
        sheet1.createFreezePane(255, 1);
        sheet1.setColumnWidth(1, 11000);
        sheet1.setColumnWidth(3, 5000);
        sheet1.setColumnWidth(4, 5000);
        HSSFRow headRow = sheet1.createRow(0);
        headRow.createCell(0).setCellValue("\u5e8f\u53f7");
        headRow.createCell(1).setCellValue("\u5238\u7801");
        headRow.createCell(2).setCellValue("\u5238\u7801\u72b6\u6001");
        headRow.createCell(3).setCellValue("\u9886\u53d6\u65f6\u95f4");
        headRow.createCell(4).setCellValue("\u9886\u53d6\u4eba");
        if (couponNos != null && !couponNos.isEmpty()) {
            for (int i = 0; i < couponNos.size(); ++i) {
                couponNo = couponNos.get(i);
                tempRow = sheet1.createRow(1 + i);
                tempRow.createCell(0).setCellValue((double)(i + 1));
                tempRow.createCell(1).setCellValue(couponNo.getCodeNo());
                tempRow.createCell(2).setCellValue(couponNo.getCodeStatus());
                if (couponNo.getCodeGetTime() != null) {
                    tempRow.createCell(3).setCellValue(sdf.format(couponNo.getCodeGetTime()));
                }
                if (couponNo.getCustomerName() == null) continue;
                tempRow.createCell(4).setCellValue(couponNo.getCustomerName());
            }
        }
        String filename = coupon.getCouponName() + "\u5238\u7801.xls";
        response.setContentType("application/vnd.ms-excel");
        response.setHeader("Content-disposition", "attachment;filename=" + URLEncoder.encode(filename));
        try {
            ServletOutputStream ouputStream2 = response.getOutputStream();
            wb.write((OutputStream)ouputStream2);
            ouputStream2.flush();
            ouputStream2.close();
        }
        catch (IOException e) {
            ouputStream2 = null;
        }
        finally {
            filename = null;
            couponNo = null;
            wb = null;
            ouputStream2 = null;
            style = null;
            tempRow = null;
        }
    }

    @Override
    public int getCouponGetNoByCouponId(Long couponId) {
        PostParamMap pmap = new PostParamMap("pm.coupon.CouponNoService.getCouponGetNoByCouponId");
        pmap.putParam("couponId", (Object)couponId);
        return (Integer)this.htmlIBaseService.senReObject(pmap, Integer.class);
    }

    @Override
    public int updateCouponCustomer(Long codeId, Long cId) {
        PostParamMap pmap = new PostParamMap("pm.coupon.CouponNoService.updateCouponCustomer");
        pmap.putParam("codeId", (Object)codeId);
        pmap.putParam("cId", (Object)cId);
        return (Integer)this.htmlIBaseService.senReObject(pmap, Integer.class);
    }

    @Override
    public int selectReadyGet(Long couponId, Long cId) {
        PostParamMap pmap = new PostParamMap("pm.coupon.CouponNoService.selectReadyGet");
        pmap.putParam("couponId", (Object)couponId);
        pmap.putParam("cId", (Object)cId);
        return (Integer)this.htmlIBaseService.senReObject(pmap, Integer.class);
    }

    @Override
    public Long queryUsedCountByCouponId(Long couponId) {
        PostParamMap pmap = new PostParamMap("pm.coupon.CouponNoService.queryUsedCountByCouponId");
        pmap.putParam("couponId", (Object)couponId);
        return (Long)this.htmlIBaseService.senReObject(pmap, Long.class);
    }

    @Override
    public int selectCountAllByCouponId(Long couponId) {
        PostParamMap pmap = new PostParamMap("pm.coupon.CouponNoService.selectCountAllByCouponId");
        pmap.putParam("couponId", (Object)couponId);
        return (Integer)this.htmlIBaseService.senReObject(pmap, Integer.class);
    }

    @Override
    public int selectCouponNoByStatus(Long couponId) {
        PostParamMap pmap = new PostParamMap("pm.coupon.CouponNoService.selectCouponNoByStatus");
        pmap.putParam("couponId", (Object)couponId);
        return (Integer)this.htmlIBaseService.senReObject(pmap, Integer.class);
    }

    @Override
    public List<CouponNo> selectCouponList(Long couponId, CouponNo couponNo) {
        PostParamMap pmap = new PostParamMap("pm.coupon.CouponNoService.selectCouponList");
        pmap.putParam("couponId", (Object)couponId);
        pmap.putParamToJson("couponNo", (Object)couponNo);
        return this.htmlIBaseService.getForList(pmap, CouponNo.class);
    }

    @Override
    public int selectCouponByCode(String couponNo, Long cId) {
        PostParamMap pmap = new PostParamMap("pm.coupon.CouponNoService.selectCouponByCode");
        pmap.putParam("couponNo", (Object)couponNo);
        pmap.putParam("cId", (Object)cId);
        return (Integer)this.htmlIBaseService.senReObject(pmap, Integer.class);
    }

    @Override
    public CouponNo selectCouponNoByCode(String code) {
        PostParamMap pmap = new PostParamMap("pm.coupon.CouponNoService.selectCouponNoByCode");
        pmap.putParam("code", (Object)code);
        return (CouponNo)this.htmlIBaseService.senReObject(pmap, CouponNo.class);
    }
}

