/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.goods.controller;

import com.qianjiang.excel.FileBean;
import com.qianjiang.goods.bean.GoodsBrand;
import com.qianjiang.goods.bean.PageBean;
import com.qianjiang.goods.service.GoodsBrandService;
import com.qianjiang.goods.util.SelectBean;
import com.qianjiang.operlog.util.IPAddress;
import com.qianjiang.operlog.util.OperaLogUtil;
import com.qianjiang.system.mobile.service.MobSiteBasicService;
import com.qianjiang.system.service.BasicSetService;
import com.qianjiang.uploadfileset.service.UploadFileSetService;
import com.qianjiang.util.MyLogger;
import com.qianjiang.util.UploadUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URLEncoder;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller
public class BrandController {
    private static final MyLogger LOGGER = new MyLogger(BrandController.class);
    private static final String LOGOFILE = "logoFile";
    private static final String LOGGERINFO1 = "-->\u54c1\u724c\u540d\u79f0\u3010";
    private static final String LOGGERINFO2 = "\u3011,\u7528\u6237\u540d\uff1a";
    private GoodsBrandService goodsBrandService;
    @Resource(name="UploadFileSetService")
    private UploadFileSetService uploadFileSetService;
    @Resource(name="basicSetService")
    private BasicSetService basicSetService;
    @Resource(name="MobSiteBasicService")
    private MobSiteBasicService mobSiteBasicService;

    public GoodsBrandService getGoodsBrandService() {
        return this.goodsBrandService;
    }

    @Resource(name="GoodsBrandService")
    public void setGoodsBrandService(GoodsBrandService goodsBrandService) {
        this.goodsBrandService = goodsBrandService;
    }

    @RequestMapping(value={"/findAllBrand"})
    public ModelAndView findAllBrand(HttpServletRequest request, HttpServletResponse response, PageBean pb, SelectBean selectBean) {
        ModelAndView mav = new ModelAndView();
        mav.setViewName("jsp/goods/goods_brand");
        mav.addObject("pageBean", (Object)this.goodsBrandService.searchByPageBean(pb, selectBean));
        mav.addObject("ufs", (Object)this.uploadFileSetService.getCurrUploadFileSet());
        request.setAttribute("selectBean", (Object)selectBean);
        LOGGER.info((Object)"\u5206\u9875\u67e5\u8be2\u5546\u54c1\u54c1\u724c ");
        return mav;
    }

    @RequestMapping(value={"/chooseTrademark"})
    public ModelAndView chooseTrademark(HttpServletRequest request, HttpServletResponse response, PageBean pb, SelectBean selectBean) {
        ModelAndView mav = new ModelAndView();
        mav.setViewName("jsp/channel/brand_list");
        mav.addObject("pageBean", (Object)this.goodsBrandService.searchByPageBean(pb, selectBean));
        request.setAttribute("selectBean", (Object)selectBean);
        return mav;
    }

    @RequestMapping(value={"/chooseBrand"})
    public ModelAndView chooseBrand(HttpServletRequest request, HttpServletResponse response, PageBean pb, SelectBean selectBean) {
        ModelAndView mav = new ModelAndView();
        mav.setViewName("jsp/channel/brand_list");
        mav.addObject("pageBean", (Object)this.goodsBrandService.searchByPageBean(pb, selectBean));
        request.setAttribute("selectBean", (Object)selectBean);
        return mav;
    }

    @RequestMapping(value={"/saveBrand"})
    public ModelAndView saveBrand(@Valid GoodsBrand goodsBrand, MultipartHttpServletRequest request) {
        MultipartFile imageFile = null;
        imageFile = request.getFile(LOGOFILE) == null ? request.getFile("picFile") : request.getFile(LOGOFILE);
        if (imageFile != null && !imageFile.isEmpty()) {
            goodsBrand.setBrandLogo((String)UploadUtil.uploadFile((MultipartFile)imageFile).get("oldimg"));
        }
        if (this.goodsBrandService.selectByBrandName(goodsBrand.getBrandName()) == 0) {
            int result = this.goodsBrandService.insertGoodsBrand(goodsBrand, (String)request.getSession().getAttribute("name"));
            if (null != goodsBrand.getBrandName() && 1 == result) {
                OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)((String)request.getSession().getAttribute("name")), (String)"\u4fdd\u5b58\u5546\u54c1\u54c1\u724c", (String)((String)request.getSession().getAttribute("operaPath") + LOGGERINFO1 + goodsBrand.getBrandName() + LOGGERINFO2 + (String)request.getSession().getAttribute("name")));
                LOGGER.info((Object)("\u4fdd\u5b58\u54c1\u724c\u4fe1\u606f\u4fdd\u5b58\u54c1\u724c\u4e3a" + goodsBrand.getBrandNickname() + "\u6210\u529f"));
            }
        }
        return new ModelAndView((View)new RedirectView("findAllBrand.htm"));
    }

    @RequestMapping(value={"/batchDelBrand"})
    public ModelAndView batchDelBrand(Long[] brandIds, HttpServletRequest request, PageBean pb) {
        this.goodsBrandService.batchDeleteGodosBrand(brandIds, (String)request.getSession().getAttribute("name"));
        LOGGER.info((Object)"\u6279\u91cf\u5220\u9664\u5546\u54c1\u54c1\u724c\u4fe1\u606f");
        OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)((String)request.getSession().getAttribute("name")), (String)"\u6279\u91cf\u5220\u9664\u5546\u54c1\u54c1\u724c", (String)((String)request.getSession().getAttribute("operaPath") + "\u7528\u6237\u540d\uff1a" + (String)request.getSession().getAttribute("name")));
        PageBean pbDb = this.goodsBrandService.searchByPageBean(pb, new SelectBean());
        return new ModelAndView((View)new RedirectView("findAllBrand.htm?pageNo=" + (pb.getPageNo() > pbDb.getTotalPages() ? pbDb.getTotalPages() : pb.getPageNo())));
    }

    @RequestMapping(value={"/updateBrand"})
    public ModelAndView updateBrand(@Valid GoodsBrand goodsBrand, MultipartHttpServletRequest request, PageBean pb) {
        MultipartFile imageFile = null;
        imageFile = request.getFile(LOGOFILE) == null ? request.getFile("picFile") : request.getFile(LOGOFILE);
        if (imageFile != null && !imageFile.isEmpty()) {
            goodsBrand.setBrandLogo((String)UploadUtil.uploadFile((MultipartFile)imageFile).get("oldimg"));
        }
        int result = this.goodsBrandService.updateGoodsBrad(goodsBrand, (String)request.getSession().getAttribute("name"));
        if (null != goodsBrand.getBrandNickname() && 1 == result) {
            OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)((String)request.getSession().getAttribute("name")), (String)"\u66f4\u65b0\u5546\u54c1\u54c1\u724c", (String)((String)request.getSession().getAttribute("operaPath") + LOGGERINFO1 + goodsBrand.getBrandName() + LOGGERINFO2 + (String)request.getSession().getAttribute("name")));
            LOGGER.info((Object)("\u66f4\u65b0\u54c1\u724c\u4fe1\u606f\u66f4\u65b0" + goodsBrand.getBrandDelName() + "\u6210\u529f"));
        }
        return new ModelAndView((View)new RedirectView("findAllBrand.htm?pageNo=" + pb.getPageNo() + "&pageSize=" + pb.getPageSize()));
    }

    @RequestMapping(value={"/toAddBrand"})
    public ModelAndView toAddBrand() {
        LOGGER.info((Object)"\u8df3\u8f6c\u5230\u6dfb\u52a0\u54c1\u724c\u7684\u9875\u9762");
        return new ModelAndView("jsp/goods/goodsBrandAdd");
    }

    @RequestMapping(value={"/toModifyBrand"})
    public ModelAndView toModifyBrand(Long brandId, PageBean pb) {
        LOGGER.info((Object)"\u8df3\u8f6c\u5230\u4fee\u6539\u54c1\u724c\u7684\u9875\u9762");
        return new ModelAndView("jsp/goods/goodsBrandModify", "brandId", (Object)brandId).addObject("pb", (Object)pb);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"exportGoodsBrand"})
    public void exportGoodsCate(HttpServletResponse response) {
        HSSFRow tempRow;
        List brands = this.goodsBrandService.queryAllBrandList();
        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFCellStyle style = wb.createCellStyle();
        style.setAlignment((short)2);
        HSSFSheet sheet1 = wb.createSheet("\u5546\u54c1\u5206\u7c7b\u5217\u8868");
        sheet1.createFreezePane(255, 1);
        HSSFRow headRow = sheet1.createRow(0);
        headRow.createCell(0).setCellValue("\u5e8f\u53f7");
        headRow.createCell(1).setCellValue("\u54c1\u724c\u540d\u79f0");
        headRow.createCell(2).setCellValue("\u54c1\u724c\u522b\u540d");
        headRow.createCell(3).setCellValue("\u54c1\u724c\u6392\u5e8f");
        headRow.createCell(4).setCellValue("\u54c1\u724clogo");
        GoodsBrand brand = null;
        if (null != brands && !brands.isEmpty()) {
            for (int i = 0; i < brands.size(); ++i) {
                brand = (GoodsBrand)brands.get(i);
                tempRow = sheet1.createRow(1 + i);
                tempRow.createCell(0).setCellValue((double)(i + 1));
                tempRow.createCell(1).setCellValue(brand.getBrandName());
                tempRow.createCell(2).setCellValue(brand.getBrandNickname() == null ? "" : brand.getBrandNickname());
                tempRow.createCell(3).setCellValue(brand.getBrandSort() == null ? "" : brand.getBrandSort() + "");
                tempRow.createCell(4).setCellValue(brand.getBrandLogo() == null ? "" : brand.getBrandLogo());
            }
        }
        response.setContentType("application/vnd.ms-excel");
        response.setHeader("Content-disposition", "attachment;filename=" + URLEncoder.encode("\u5546\u54c1\u54c1\u724c\u5907\u4efd.xls"));
        try {
            ServletOutputStream ouputStream = response.getOutputStream();
            wb.write((OutputStream)ouputStream);
            ouputStream.flush();
            ouputStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            LOGGER.error("\u5bfc\u51fa\u5546\u54c1\u54c1\u724c\u9519\u8bef" + e);
        }
        finally {
            brand = null;
            wb = null;
            Object ouputStream = null;
            style = null;
            tempRow = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"exportGoodsBrandTemp"})
    public void exportGoodsCateTemp(HttpServletResponse response) {
        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFCellStyle style = wb.createCellStyle();
        style.setAlignment((short)2);
        HSSFSheet sheet1 = wb.createSheet("\u54c1\u724c\u5bfc\u5165\u6a21\u677f");
        sheet1.createFreezePane(255, 1);
        HSSFRow headRow = sheet1.createRow(0);
        headRow.createCell(0).setCellValue("\u54c1\u724c\u540d\u79f0\uff08\u5fc5\u586b\uff09");
        headRow.createCell(1).setCellValue("\u54c1\u724c\u522b\u540d");
        headRow.createCell(2).setCellValue("\u54c1\u724c\u6392\u5e8f\uff08\u5fc5\u586b\uff09");
        response.setContentType("application/vnd.ms-excel");
        response.setHeader("Content-disposition", "attachment;filename=" + URLEncoder.encode("\u5546\u54c1\u54c1\u724c\u6a21\u677f.xls"));
        try {
            ServletOutputStream ouputStream = response.getOutputStream();
            wb.write((OutputStream)ouputStream);
            ouputStream.flush();
            ouputStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            LOGGER.error("\u5bfc\u51fa\u5546\u54c1\u54c1\u724c\u6a21\u677f\u9519\u8bef" + e);
        }
        finally {
            wb = null;
            Object ouputStream = null;
            style = null;
        }
    }

    @RequestMapping(value={"/importGoodsBrand"})
    public void importGoodsCate(HttpServletRequest request, HttpServletResponse response, Long goodsCateId, MultipartHttpServletRequest multiRequest) {
        String result = "200";
        PrintWriter out = null;
        try {
            out = response.getWriter();
            MultipartFile file = multiRequest.getFile("importExcel");
            FileBean fileBean = new FileBean();
            fileBean.setOriginalFilename(file.getOriginalFilename());
            fileBean.setFileb(file.getBytes());
            result = this.goodsBrandService.importGoodsBrandByExcel(fileBean);
            out.append("<script>parent.import_callback('" + result + "');</script>");
            out.flush();
        }
        catch (Exception e) {
            LOGGER.error("\u5bfc\u5165\u5546\u54c1\u5931\u8d25", (Throwable)e);
        }
    }

    @RequestMapping(value={"/queryAllBrandForChoose"})
    public ModelAndView queryMobCateBarForChoose(HttpServletRequest request, HttpServletResponse response, PageBean pb, SelectBean selectBean) {
        ModelAndView mav = new ModelAndView();
        mav.setViewName("jsp/appsite/choose_brand");
        mav.addObject("pb", (Object)this.goodsBrandService.searchByPageBean(pb, selectBean));
        request.setAttribute("selectBean", (Object)selectBean);
        return mav;
    }
}

