/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.supplier.controller;

import com.qianjiang.customer.bean.Customer;
import com.qianjiang.customer.bean.CustomerPunish;
import com.qianjiang.customer.bean.PunishRecord;
import com.qianjiang.customer.service.CustomerPunishService;
import com.qianjiang.customer.service.CustomerServiceMapper;
import com.qianjiang.customer.service.PunishRecordService;
import com.qianjiang.goods.bean.SolrGoodsInfo;
import com.qianjiang.goods.service.GoodsCateService;
import com.qianjiang.goods.service.GoodsService;
import com.qianjiang.goods.service.SearchAsyncService;
import com.qianjiang.operlog.util.IPAddress;
import com.qianjiang.operlog.util.OperaLogUtil;
import com.qianjiang.system.mobile.service.MobSiteBasicService;
import com.qianjiang.system.service.BasicSetService;
import com.qianjiang.system.service.DistrictService;
import com.qianjiang.system.util.AddressUtil;
import com.qianjiang.system.util.BasicSetUtil;
import com.qianjiang.third.supplier.service.StoreInfoService;
import com.qianjiang.third.supplier.service.ThirdStorePointService;
import com.qianjiang.thirdaudit.bean.DeduBrokeage;
import com.qianjiang.thirdaudit.bean.DeduBrokeageVo;
import com.qianjiang.thirdaudit.bean.StoreInfo;
import com.qianjiang.thirdaudit.service.AuditService;
import com.qianjiang.thirdaudit.service.StoreCommonSerivce;
import com.qianjiang.util.PageBean;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller
public class AuditController {
    private static final String PAGEBEAN = "pageBean";
    private static final String SHOWFLAG = "showFlag";
    private static final String STOREINFO = "storeInfo";
    private static final String SEARCHID = "searchId";
    private static final String SEARCHTEXT = "searchText";
    private static final String HADAUDITLIST = "hadauditlist.htm";
    private static final String THIRDCATE = "thirdcate";
    @Resource(name="customerServiceMapper")
    private CustomerServiceMapper customerServiceMapper;
    private AuditService auditService;
    @Resource(name="StoreCommonSerivce")
    private StoreCommonSerivce storeCommonSerivce;
    @Resource(name="CustomerPunishService")
    private CustomerPunishService customerPunishService;
    @Resource(name="PunishRecordService")
    private PunishRecordService punishRecordService;
    @Resource(name="StoreServiceMix")
    private StoreInfoService storeInfoService;
    @Resource(name="ThirdStorePointService")
    private ThirdStorePointService thirdStorePointService;
    @Resource(name="DistrictService")
    private DistrictService districtService;
    @Resource(name="basicSetService")
    private BasicSetService basicSetService;
    @Resource(name="MobSiteBasicService")
    private MobSiteBasicService mobSiteBasicService;
    @Resource
    private SearchAsyncService searchAsyncService;
    @Resource(name="GoodsService")
    private GoodsService goodsService;
    @Resource(name="GoodsCateService")
    private GoodsCateService goodsCateService;

    @RequestMapping(value={"/auditlist"})
    public ModelAndView auditList(PageBean pageBean, StoreInfo storeInfo, String showFlag, String[] attr, String searchId, String searchText) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        if (searchId != null) {
            if ("1".equals(searchId)) {
                storeInfo.setCompanyName(searchText);
            } else if ("2".equals(searchId)) {
                storeInfo.setStoreName(searchText);
            }
        }
        pageBean.setUrl("auditlist.htm");
        storeInfo.setCheckStatus("0");
        pageBean = this.auditService.selectAuditList(storeInfo, pageBean);
        resultMap.put(PAGEBEAN, pageBean);
        resultMap.put(SHOWFLAG, showFlag);
        resultMap.put("attr", attr);
        resultMap.put(STOREINFO, storeInfo);
        resultMap.put(SEARCHID, searchId);
        resultMap.put(SEARCHTEXT, searchText);
        ModelAndView mav = new ModelAndView("jsp/customer/auditlist");
        return mav.addAllObjects(resultMap);
    }

    @RequestMapping(value={"/auditchecklist"})
    public ModelAndView auditCheckList(PageBean pageBean, StoreInfo storeInfo, String showFlag, String[] attr, String searchId, String searchText) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        if (searchId != null) {
            if ("1".equals(searchId)) {
                storeInfo.setCompanyName(searchText);
            } else if ("2".equals(searchId)) {
                storeInfo.setStoreName(searchText);
            }
        }
        pageBean.setUrl("auditchecklist.htm");
        storeInfo.setCheckStatus("1");
        resultMap.put(PAGEBEAN, this.auditService.selectAuditList(storeInfo, pageBean));
        resultMap.put(SHOWFLAG, showFlag);
        resultMap.put("attr", attr);
        resultMap.put(STOREINFO, storeInfo);
        resultMap.put(SEARCHID, searchId);
        resultMap.put(SEARCHTEXT, searchText);
        ModelAndView mav = new ModelAndView("jsp/customer/auditlist");
        return mav.addAllObjects(resultMap);
    }

    @RequestMapping(value={"/setstore"})
    public ModelAndView setStore(HttpServletRequest request, Long setTore, String isShow, Long storeId, String isChoice) {
        this.auditService.setStore(setTore, isShow, storeId, isChoice);
        return new ModelAndView((View)new RedirectView(request.getContextPath() + "/hadauditlist.htm"));
    }

    @RequestMapping(value={"/hadauditlist"})
    public ModelAndView auditListUn(PageBean pageBean, StoreInfo storeInfo, String showFlag, String[] attr, String searchId, String searchText) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        if (searchId != null) {
            if ("1".equals(searchId)) {
                storeInfo.setCompanyName(searchText);
            } else if ("2".equals(searchId)) {
                storeInfo.setStoreName(searchText);
            }
        }
        pageBean.setUrl(HADAUDITLIST);
        storeInfo.setCheckStatus("1");
        resultMap.put(PAGEBEAN, this.auditService.selectAuditList(storeInfo, pageBean));
        resultMap.put(SHOWFLAG, showFlag);
        resultMap.put("attr", attr);
        resultMap.put(STOREINFO, storeInfo);
        resultMap.put(SEARCHID, searchId);
        resultMap.put(SEARCHTEXT, searchText);
        resultMap.put("punishList", this.customerPunishService.queryAllRules());
        ModelAndView mav = new ModelAndView("jsp/customer/hadauditedlist");
        return mav.addAllObjects(resultMap);
    }

    @RequestMapping(value={"/updatestore"})
    public ModelAndView updateStore(Long storeId, Long businessCircle, DeduBrokeage brokeage, String cellTime, String thirdIds, String payIds, String storeQi) {
        int cId = this.auditService.findcid(storeId);
        this.customerServiceMapper.updateStatus(cId);
        this.auditService.updateStore(thirdIds.split(","), brokeage, cellTime, payIds, storeQi);
        this.storeCommonSerivce.applyBrandToTrueBrand(thirdIds.split(","));
        this.storeCommonSerivce.updateAppStatus(storeId);
        return new ModelAndView((View)new RedirectView("auditlist.htm?checkStatus=0"));
    }

    @RequestMapping(value={"/newupdatestore"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public Integer newupdateStore(HttpServletRequest request, Long storeId, Long businessCircle, DeduBrokeage brokeage, String cellTime, String thirdIds, String payIds, String storeQi) {
        Integer flag;
        String cellTimeNew = cellTime;
        cellTimeNew = cellTimeNew.replace(",", "|");
        if (storeId != null) {
            flag = this.auditService.updateStore(storeId.toString().split(","), brokeage, cellTimeNew, payIds, storeQi);
            StoreInfo storeInfos = this.storeCommonSerivce.selectModelPrice(storeId);
            this.customerServiceMapper.updateStatus(storeInfos.getCustomerid().intValue());
        } else {
            flag = this.auditService.updateStore(thirdIds.split(","), brokeage, cellTimeNew, payIds, storeQi);
            this.storeCommonSerivce.applyBrandToTrueBrand(thirdIds.split(","));
            for (int i = 0; i < thirdIds.split(",").length; ++i) {
                StoreInfo storeInfos = this.storeCommonSerivce.selectModelPrice(Long.valueOf(Long.valueOf(thirdIds.split(",")[0])));
                this.customerServiceMapper.updateStatus(storeInfos.getCustomerid().intValue());
            }
        }
        OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)((String)request.getSession().getAttribute("name")), (String)"\u5ba1\u6838\u5e97\u94fa", (String)((String)request.getSession().getAttribute("operaPath") + "\u5ba1\u6838\u5e97\u94fa,\u7528\u6237\u540d\uff1a" + (String)request.getSession().getAttribute("name")));
        return flag;
    }

    @RequestMapping(value={"updateClassifyPay"})
    public ModelAndView updatePay(PageBean pageBean, Long storeId, Long businessCircle, Long[] payIds, String billingCycle, String deduction, String brokerage, HttpServletRequest request) {
        this.auditService.updatePayMent(storeId, billingCycle);
        this.auditService.updatePayWay(storeId, payIds, deduction, brokerage);
        return new ModelAndView((View)new RedirectView("hadauditlist.htm?pageNo=" + pageBean.getPageNo()));
    }

    @RequestMapping(value={"/newupdateclassifypay"})
    public ModelAndView newUpdatePay(Long storeId, Long businessCircle, String billingCycle) {
        this.auditService.updatePayMent(storeId, billingCycle);
        return null;
    }

    @RequestMapping(value={"/refusestore"})
    public ModelAndView refuseStore(HttpServletRequest request, StoreInfo storeInfo) {
        this.auditService.refuseStore(storeInfo);
        return new ModelAndView((View)new RedirectView("auditlist.htm?CheckStatus=0"));
    }

    @RequestMapping(value={"/newrefusestore"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int newrefuseStore(HttpServletRequest request, String thirdIds, StoreInfo storeInfo) {
        int flag = 0;
        if (storeInfo.getStoreId() != null) {
            flag = this.auditService.refuseStore(storeInfo);
        } else {
            String[] storeIds;
            for (String storeId : storeIds = thirdIds.split(",")) {
                storeInfo.setStoreId(Long.valueOf(storeId));
                this.auditService.refuseStore(storeInfo);
                ++flag;
            }
        }
        OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)((String)request.getSession().getAttribute("name")), (String)"\u6253\u56de\u5e97\u94fa", (String)((String)request.getSession().getAttribute("operaPath") + "\u6253\u56de\u5e97\u94fa,\u7528\u6237\u540d\uff1a" + (String)request.getSession().getAttribute("name")));
        return flag;
    }

    @RequestMapping(value={"sellerinfo"})
    public ModelAndView sellerinfo(HttpServletRequest request, Long storeId) {
        StoreInfo storeInfo = this.auditService.selectByCustomerId(storeId);
        String address = "";
        if (storeInfo != null && storeInfo.getBussAddrId() != null && storeInfo.getBussAddrId().split(",").length == 3) {
            AddressUtil addressUtil = this.districtService.queryAddressNameByDistrictId(Long.valueOf(storeInfo.getBussAddrId().split(",")[2]));
            address = addressUtil.getProvinceName() + "-" + addressUtil.getCityName() + "-" + addressUtil.getDistrictName();
        }
        return new ModelAndView("jsp/customer/sellerinfo").addObject("info", (Object)storeInfo).addObject("address", (Object)address).addObject(THIRDCATE, (Object)this.storeCommonSerivce.selectThirdCate(storeId)).addObject("thirdbrand", (Object)this.storeCommonSerivce.selectThirdBrand(storeId)).addObject("appbrand", (Object)this.storeCommonSerivce.selectApplyBrandbyStoreId(storeId));
    }

    @RequestMapping(value={"updatesellerinfo"})
    public ModelAndView updatesellerinfo(HttpServletRequest request, Long storeId) {
        return new ModelAndView("jsp/customer/updatesellerinfo").addObject(THIRDCATE, (Object)this.storeCommonSerivce.selectThirdCate(storeId)).addObject("storeId", (Object)storeId);
    }

    @RequestMapping(value={"newupdatesellerinfo"})
    public ModelAndView newUpdatesellerinfo(HttpServletRequest request, PageBean pb, Long storeId) {
        pb.setPageSize(6);
        return new ModelAndView("jsp/customer/updatesellerinfo").addObject(PAGEBEAN, (Object)this.storeCommonSerivce.newselectThirdCate(storeId, pb)).addObject("storeId", (Object)storeId).addObject(THIRDCATE, (Object)this.storeCommonSerivce.selectThirdCate(storeId));
    }

    @RequestMapping(value={"updatethridcate"})
    public ModelAndView updateThridCate(HttpServletRequest request, Long storeId, Long[] thirdCateId) {
        this.storeCommonSerivce.updateThridCate(storeId, thirdCateId);
        return new ModelAndView((View)new RedirectView("updatesellerinfo.htm?storeId=" + storeId));
    }

    @RequestMapping(value={"newupdatethridcate"})
    public ModelAndView newUpdateThridCate(HttpServletRequest request, Long storeId, Long[] thirdCateId) {
        this.storeCommonSerivce.updateThridCate(storeId, thirdCateId);
        return new ModelAndView((View)new RedirectView("newupdatesellerinfo.htm?storeId=" + storeId));
    }

    @RequestMapping(value={"deletesellerinfocate"})
    public ModelAndView deleteSellerinfoCate(HttpServletRequest request, Long cateId, Long thirdId) {
        this.storeCommonSerivce.deleteSellerinfoCate(thirdId, cateId);
        return new ModelAndView((View)new RedirectView("updatesellerinfo.htm?storeId=" + thirdId));
    }

    @RequestMapping(value={"newdeletesellerinfocate"})
    public ModelAndView newdeleteSellerinfoCate(HttpServletRequest request, Long cateId, Long thirdId) {
        this.storeCommonSerivce.deleteSellerinfoCate(thirdId, cateId);
        return null;
    }

    @RequestMapping(value={"selectDeduByStoreId"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public List<DeduBrokeageVo> selectDeduByStoreId(Long storeId) {
        return this.auditService.selectBrokeageByStoreId(storeId);
    }

    @RequestMapping(value={"/punishShop"})
    public ModelAndView punishShop(HttpServletRequest request, PunishRecord punishRecord, CustomerPunish customerPunish, String closeSstime, String closeEetime, String limitSstime, String limitEetime) {
        punishRecord.setOperatorId((Long)request.getSession().getAttribute("loginUserId"));
        punishRecord.setOperatorName(String.valueOf(request.getSession().getAttribute("name")));
        punishRecord.setPunishId(this.customerPunishService.queryIdByRule(customerPunish).getId());
        SimpleDateFormat formatDate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            if (!"".equals(closeSstime) && !"".equals(closeEetime)) {
                punishRecord.setCloseStime(formatDate.parse(closeSstime));
                punishRecord.setCloseEtime(formatDate.parse(closeEetime));
            }
            if (!"".equals(limitSstime) && !"".equals(limitEetime)) {
                punishRecord.setLimitStime(formatDate.parse(limitSstime));
                punishRecord.setLimitEtime(formatDate.parse(limitEetime));
            }
        }
        catch (ParseException e) {
            Customer cust = (Customer)request.getSession().getAttribute("cust");
            OperaLogUtil.addOperaException((String)cust.getCustomerUsername(), (Exception)e, (HttpServletRequest)request);
        }
        if ("0".equals(customerPunish.getRule())) {
            this.punishRecordService.addPunishRecord(punishRecord);
            StoreInfo storeInfo = new StoreInfo();
            storeInfo.setStoreId(punishRecord.getThirdId());
            storeInfo.setStoreStatus("1");
            this.punishRecordService.updateStoreStatus(storeInfo);
            List goodsInfo = this.goodsService.querySolrGoodsInfoByThirdId(punishRecord.getThirdId());
            ArrayList<Long> list = new ArrayList<Long>();
            for (SolrGoodsInfo solrGoodsInfo : goodsInfo) {
                Long thirdGoodsId = solrGoodsInfo.getGoodsId();
                this.searchAsyncService.deleteGoodsIndexToEs(thirdGoodsId);
                list.add(thirdGoodsId);
            }
            Long[] thirdGoodsIds = list.toArray(new Long[list.size()]);
            this.goodsService.batchUploadOrDownGoods(thirdGoodsIds, "0", (String)request.getSession().getAttribute("name"), "0", punishRecord.getThirdId());
        } else if ("1".equals(customerPunish.getRule())) {
            this.thirdStorePointService.reduceStorePoint(punishRecord, punishRecord.getThirdId(), punishRecord.getPunishReason(), punishRecord.getReducePoint().intValue());
        } else if ("2".equals(customerPunish.getRule())) {
            this.thirdStorePointService.reduceStoreMoney(punishRecord);
        } else if ("3".equals(customerPunish.getRule())) {
            this.punishRecordService.addPunishRecord(punishRecord);
        }
        return new ModelAndView((View)new RedirectView(HADAUDITLIST));
    }

    @RequestMapping(value={"updateStoreValidTime"})
    public ModelAndView updateStoreValidTime(String endTime, Long goodsBelo) {
        int count = this.auditService.updateStoreValidTime(endTime, goodsBelo);
        if (count > 0) {
            return new ModelAndView((View)new RedirectView(HADAUDITLIST));
        }
        return null;
    }

    @RequestMapping(value={"/queryAllPointByCusId"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public StoreInfo queryAllPointByCusId(long thirdId) {
        return this.storeInfoService.queryStorePointByThirdId(Long.valueOf(thirdId));
    }

    @RequestMapping(value={"/queryStoreBalanceByThirdId"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public StoreInfo queryStoreBalanceByThirdId(long thirdId) {
        return this.storeInfoService.queryStoreBalanceByThirdId(Long.valueOf(thirdId));
    }

    @RequestMapping(value={"/ajaxThirdList"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public Map<String, Object> ajaxThirdList(HttpServletRequest request, PageBean pageBean, StoreInfo storeInfo) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        storeInfo.setCheckStatus("1");
        resultMap.put("pb", this.auditService.selectAuditList(storeInfo, pageBean));
        String mobileAddress = this.basicSetService.findBasicSet().getMobileAddress();
        mobileAddress = BasicSetUtil.getAddress((String)mobileAddress);
        resultMap.put("address", mobileAddress);
        return resultMap;
    }

    public AuditService getAuditService() {
        return this.auditService;
    }

    @Resource(name="auditService")
    public void setAuditService(AuditService auditService) {
        this.auditService = auditService;
    }

    @RequestMapping(value={"/queryallgoodcate"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public List ceshi() {
        List queryAllParentGoosCate = this.goodsCateService.queryAllParentGoosCate(null);
        return queryAllParentGoosCate;
    }
}

