/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.channel.controller;

import com.qianjiang.channel.bean.Channel;
import com.qianjiang.channel.bean.ChannelStorey;
import com.qianjiang.channel.service.GoodsCateService;
import com.qianjiang.channel.service.SysChannelService;
import com.qianjiang.channel.service.impl.ChannelStoreyServiceImpl;
import com.qianjiang.image.service.InfoImageManageService;
import com.qianjiang.operlog.util.IPAddress;
import com.qianjiang.operlog.util.OperaLogUtil;
import com.qianjiang.util.MyLogger;
import com.qianjiang.util.PageBean;
import com.qianjiang.util.UploadUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller
public class ChannelStoreyController {
    private static final MyLogger LOGGER = new MyLogger(ChannelStoreyController.class);
    private static final String LOGINUSERID = "loginUserId";
    private static final String SHOW_ACTION = "showChannelStorey.htm";
    public static final String NAME = "name";
    public static final String OPERAPATH = "operaPath";
    public static final String LOGGERINFO1 = ",\u7528\u6237\u540d:";
    public static final String LOGGERINFO2 = "\u4fdd\u5b58\u697c\u5c42\u8bbe\u7f6e\u6210\u529f\uff01";
    public static final String LOGGERINFO3 = "\u4fdd\u5b58\u697c\u5c42\u8bbe\u7f6e\u5931\u8d25\uff01";
    public static final String QUERYCHANNELSTOREYBYPAGEBEAN_HTM = "queryChannelStoreyByPageBean.htm?CSRFToken=";
    private SysChannelService channelService;
    private ChannelStoreyServiceImpl channelStoreyServiceImpl;
    private GoodsCateService goodsCateService;
    @Resource(name="InfoImageManageService")
    private InfoImageManageService infoImageManageService;

    public SysChannelService getChannelService() {
        return this.channelService;
    }

    @Resource(name="SysChannelService")
    public void setChannelService(SysChannelService channelService) {
        this.channelService = channelService;
    }

    public GoodsCateService getGoodsCateService() {
        return this.goodsCateService;
    }

    @Resource(name="ChannelGoodsCateService")
    public void setGoodsCateService(GoodsCateService goodsCateService) {
        this.goodsCateService = goodsCateService;
    }

    public ChannelStoreyServiceImpl getChannelStoreyServiceImpl() {
        return this.channelStoreyServiceImpl;
    }

    @Resource(name="ChannelStoreyService")
    public void setChannelStoreyServiceImpl(ChannelStoreyServiceImpl channelStoreyServiceImpl) {
        this.channelStoreyServiceImpl = channelStoreyServiceImpl;
    }

    @RequestMapping(value={"/queryChannelStoreyByPageBean"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public Map queryChannelStoreyByPageBean(PageBean pb, Long channelId, HttpServletRequest request) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Channel channel = this.channelService.findChannelByID(channelId);
        map.put("pb", this.channelStoreyServiceImpl.selectchannelStoreyByParam(pb, channelId, null, null));
        map.put("channel", channel);
        map.put("goodsCate", this.goodsCateService.queryAllFirstGradeGoosCate());
        return map;
    }

    @RequestMapping(value={"/showChannelStorey"})
    public ModelAndView showChannelStorey(Long storeyId, Long channelId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Channel channel = this.channelService.findChannelByID(channelId);
        map.put("channel", channel);
        List goodsCates = this.goodsCateService.queryGoosCateByParentId(channel.getGoodsCatId());
        map.put("goodsCates", goodsCates);
        if (null != storeyId) {
            ChannelStorey channelStorey = this.channelStoreyServiceImpl.getChannelStoreyById(storeyId);
            map.put("channelStorey", channelStorey);
        }
        return new ModelAndView("jsp/channel/showChannelStorey", "map", map);
    }

    @RequestMapping(value={"/createChannelStoreyForChannel"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int createChannelStorey(HttpServletRequest request, HttpServletResponse response, @Valid ChannelStorey channelStorey, BindingResult bindingResult, Long channelId, Long tempId) {
        if (bindingResult.hasErrors()) {
            return 0;
        }
        Long loginUserId = (Long)request.getSession().getAttribute(LOGINUSERID);
        channelStorey.setTempId(tempId);
        channelStorey.setChannelId(channelId);
        channelStorey.setCreateUserId(loginUserId);
        int n = this.channelStoreyServiceImpl.saveChannelStorey(channelStorey);
        if (n > 0) {
            String customerName = (String)request.getSession().getAttribute(NAME);
            OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u6dfb\u52a0\u6a21\u677f\u697c\u5c42", (String)(request.getSession().getAttribute(OPERAPATH) + LOGGERINFO1 + customerName));
            LOGGER.debug(LOGGERINFO2);
        } else {
            LOGGER.debug(LOGGERINFO3);
        }
        return n;
    }

    @RequestMapping(value={"/createChannelStorey"})
    public ModelAndView createChannelStorey(MultipartHttpServletRequest request, HttpServletResponse response, @Valid ChannelStorey channelStorey, BindingResult bindingResult, Long channelId) {
        if (bindingResult.hasErrors()) {
            return new ModelAndView((View)new RedirectView(QUERYCHANNELSTOREYBYPAGEBEAN_HTM + request.getParameter("CSRFToken")));
        }
        Long loginUserId = (Long)request.getSession().getAttribute(LOGINUSERID);
        ModelAndView mav = new ModelAndView();
        try {
            MultipartFile file = request.getFile("netLogo");
            if (file.getSize() != 0L) {
                channelStorey.setStoreyImg(UploadUtil.uploadFileOne((MultipartFile)file, (HttpServletRequest)request));
                this.infoImageManageService.saveImage(channelStorey.getStoreyImg());
            }
            channelStorey.setChannelId(channelId);
            channelStorey.setCreateUserId(Long.valueOf(null == loginUserId ? 1L : loginUserId));
            int n = this.channelStoreyServiceImpl.saveChannelStorey(channelStorey);
            mav.addObject("channelId", (Object)channelId);
            if (n > 0) {
                String customerName = (String)request.getSession().getAttribute(NAME);
                OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u6dfb\u52a0\u9891\u9053\u697c\u5c42", (String)(request.getSession().getAttribute(OPERAPATH) + LOGGERINFO1 + customerName));
                LOGGER.debug(LOGGERINFO2);
                mav.setView((View)new RedirectView(QUERYCHANNELSTOREYBYPAGEBEAN_HTM + request.getParameter("CSRFToken")));
            } else {
                LOGGER.debug(LOGGERINFO3);
                mav.setView((View)new RedirectView(SHOW_ACTION));
            }
        }
        catch (Exception e) {
            LOGGER.error("\u4fdd\u5b58\u697c\u5c42\u8bbe\u7f6e\u5bf9\u8c61\u5f02\u5e38\uff01", (Throwable)e);
            mav.setView((View)new RedirectView(SHOW_ACTION));
        }
        return mav;
    }

    @RequestMapping(value={"/updateChannelStorey"})
    public ModelAndView updateChannelStorey(MultipartHttpServletRequest request, HttpServletResponse response, @Valid ChannelStorey channelStorey, BindingResult bindingResult, Long channelId) {
        if (bindingResult.hasErrors()) {
            return new ModelAndView((View)new RedirectView(QUERYCHANNELSTOREYBYPAGEBEAN_HTM + request.getParameter("CSRFToken")));
        }
        Long loginUserId = (Long)request.getSession().getAttribute(LOGINUSERID);
        ModelAndView mav = new ModelAndView();
        try {
            MultipartFile file = request.getFile("netLogo");
            if (file.getSize() != 0L) {
                channelStorey.setStoreyImg(UploadUtil.uploadFileOne((MultipartFile)file, (HttpServletRequest)request));
                this.infoImageManageService.saveImage(channelStorey.getStoreyImg());
            }
            channelStorey.setChannelId(channelId);
            channelStorey.setUpdateUserId(Long.valueOf(null == loginUserId ? 1L : loginUserId));
            int n = this.channelStoreyServiceImpl.updateChannelStorey(channelStorey);
            mav.addObject("channelId", (Object)channelId);
            if (n > 0) {
                String customerName = (String)request.getSession().getAttribute(NAME);
                OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u4fee\u6539\u9891\u9053\u697c\u5c42", (String)(request.getSession().getAttribute(OPERAPATH) + LOGGERINFO1 + customerName));
                LOGGER.debug(LOGGERINFO2);
                mav.setView((View)new RedirectView(QUERYCHANNELSTOREYBYPAGEBEAN_HTM + request.getParameter("CSRFToken")));
            } else {
                LOGGER.debug(LOGGERINFO3);
                mav.setView((View)new RedirectView(SHOW_ACTION));
            }
        }
        catch (Exception e) {
            LOGGER.error("\u4fdd\u5b58\u697c\u5c42\u8bbe\u7f6e\u5bf9\u8c61\u5f02\u5e38\uff01", (Throwable)e);
            mav.setView((View)new RedirectView(SHOW_ACTION));
        }
        return mav;
    }

    @RequestMapping(value={"/deleteChannelStorey"})
    public void deleteChannelStorey(HttpServletRequest request, HttpServletResponse response) {
        Long loginUserId = (Long)request.getSession().getAttribute(LOGINUSERID);
        if (null == loginUserId) {
            loginUserId = 1L;
        }
        String[] storeyIds = request.getParameterValues("storeyIds[]");
        for (int i = 0; i < storeyIds.length; ++i) {
            this.channelStoreyServiceImpl.deleteChannelStorey(Long.valueOf(storeyIds[i]), loginUserId);
        }
        String customerName = (String)request.getSession().getAttribute(NAME);
        OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u5220\u9664\u9891\u9053\u697c\u5c42", (String)(request.getSession().getAttribute(OPERAPATH) + LOGGERINFO1 + customerName));
    }
}

