/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.system.controller;

import com.qianjiang.operlog.util.IPAddress;
import com.qianjiang.operlog.util.OperaLogUtil;
import com.qianjiang.system.bean.BasicSet;
import com.qianjiang.system.bean.SysBasic;
import com.qianjiang.system.service.BasicSetService;
import com.qianjiang.system.service.SysBasicService;
import com.qianjiang.system.util.BasicSetUtil;
import com.qianjiang.uploadfileset.bean.UploadFileSet;
import com.qianjiang.uploadfileset.service.UploadFileSetService;
import com.qianjiang.util.MyLogger;
import com.qianjiang.util.PageRowsUtil;
import com.qianjiang.util.PropertieUtil;
import com.qianjiang.util.UploadUtil;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller
public class BasicSetController {
    private static final MyLogger LOGGER = new MyLogger(BasicSetController.class);
    public static final String NAME = "name";
    private static final String PATCHCA = "PATCHCA";
    public static final String OPERAPATH = "operaPath";
    private static final String LOGGERINFO1 = ",\u7528\u6237\u540d:";
    @Resource(name="basicSetService")
    private BasicSetService basicSetService;
    @Resource(name="SysBasicService")
    private SysBasicService sysBasicService;
    @Resource(name="UploadFileSetService")
    private UploadFileSetService uploadFileSetService;

    @RequestMapping(value={"/managerBasicSet"})
    public ModelAndView managerBasicSet(HttpServletRequest req, HttpServletResponse resp) {
        ModelAndView mav = new ModelAndView();
        try {
            SysBasic sysBasic = this.sysBasicService.getSysBasic();
            BasicSet findBasicSet = this.basicSetService.findBasicSet();
            UploadFileSet currUploadFileSet = this.uploadFileSetService.getCurrUploadFileSet();
            Properties properties = PropertieUtil.readPropertiesFile((InputStream)this.getClass().getClassLoader().getResourceAsStream("config/image.properties"));
            String[] extendNames = properties.get("FILE_EXTEND_NAME").toString().split(",");
            mav.addObject("sysBasic", (Object)sysBasic);
            mav.addObject("basciSet", (Object)findBasicSet);
            mav.addObject("pageRows", (Object)PageRowsUtil.getPageRows());
            mav.addObject("ufs", (Object)currUploadFileSet);
            mav.addObject("extendNames", (Object)extendNames);
            mav.setViewName("jsp/system/basicSet/managerBasicSettings");
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u5e73\u53f0\u57fa\u672c\u8bbe\u7f6e\u521d\u59cb\u5316\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return mav;
    }

    @RequestMapping(value={"/thirdBasicSet"})
    public ModelAndView thirdBasicSet(HttpServletRequest req, HttpServletResponse resp) {
        ModelAndView mav = new ModelAndView();
        try {
            BasicSet findBasicSet = this.basicSetService.findBasicSet();
            mav.addObject("basciSet", (Object)findBasicSet);
            mav.setViewName("jsp/system/basicSet/thirdBasicSettings");
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u5546\u5bb6\u57fa\u672c\u8bbe\u7f6e\u521d\u59cb\u5316\u5931\u8d25" + e.getMessage());
        }
        return mav;
    }

    @RequestMapping(value={"/memberBasicSet"})
    public ModelAndView memberBasicSet(HttpServletRequest req, HttpServletResponse resp) {
        ModelAndView mav = new ModelAndView();
        try {
            BasicSet findBasicSet = this.basicSetService.findBasicSet();
            mav.addObject("basciSet", (Object)findBasicSet);
            mav.setViewName("jsp/system/basicSet/memberBasicSettings");
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u4f1a\u5458\u57fa\u672c\u8bbe\u7f6e\u521d\u59cb\u5316\u5931\u8d25" + e.getMessage());
        }
        return mav;
    }

    @RequestMapping(value={"/saveManagerSet"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public Map<String, Object> saveManagerSet(HttpServletRequest req, HttpServletResponse resp, @Valid SysBasic sysBasic, @Valid UploadFileSet ufs, Integer pageRows, BindingResult bindingResult) {
        HashMap<String, Object> resultMap = new HashMap();
        try {
            resultMap = this.basicSetService.saveManagerSet(sysBasic, ufs, pageRows);
        }
        catch (Exception e) {
            e.getMessage();
            LOGGER.error("\u5e73\u53f0\u57fa\u672c\u4fe1\u606f\u8bbe\u7f6e\u4fdd\u5b58\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return resultMap;
    }

    @RequestMapping(value={"/saveThirdSet"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public Map<String, Object> saveThirdSet(HttpServletRequest req, HttpServletResponse resp, @Valid BasicSet basicSet, BindingResult bindingResult) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("result", false);
        try {
            int updateBasicSet = this.basicSetService.updateBasicSet(basicSet);
            if (updateBasicSet > 0) {
                resultMap.put("result", true);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u5546\u5bb6\u57fa\u672c\u4fe1\u606f\u8bbe\u7f6e\u4fdd\u5b58\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return resultMap;
    }

    @RequestMapping(value={"/saveMemberSet"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public Map<String, Object> saveMemberSet(HttpServletRequest req, HttpServletResponse resp, @Valid BasicSet basicSet, BindingResult bindingResult) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("result", false);
        try {
            int updateBasicSet = this.basicSetService.updateBasicSet(basicSet);
            if (updateBasicSet > 0) {
                resultMap.put("result", true);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u4f1a\u5458\u57fa\u672c\u4fe1\u606f\u8bbe\u7f6e\u4fdd\u5b58\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return resultMap;
    }

    @RequestMapping(value={"/basicset"})
    public ModelAndView basicSet(HttpServletRequest request, HttpServletResponse response) {
        return new ModelAndView("jsp/system/parameter", "parameter", (Object)this.basicSetService.findBasicSet()).addObject("sysBasic", (Object)this.sysBasicService.getSysBasic()).addObject("ufs", (Object)this.uploadFileSetService.getCurrUploadFileSet());
    }

    @RequestMapping(value={"/getBasicSetName"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public BasicSet getBasicSetName(HttpServletRequest request) {
        BasicSet set = new BasicSet();
        try {
            set = this.basicSetService.findBasicSet();
            String bsetAddress = BasicSetUtil.getAddress((String)set.getBsetAddress());
            request.getSession().setAttribute("bsetaddress", (Object)bsetAddress);
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u67e5\u8be2\u7ad9\u70b9\u4fe1\u606f\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return set;
    }

    @RequestMapping(value={"/getBasicset"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String basicSet() {
        String siteAddress = BasicSetUtil.getAddress((String)this.basicSetService.findBasicSet().getBsetAddress());
        return siteAddress;
    }

    @RequestMapping(value={"/newgetLoginPatcha"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String getLoginPatcha(HttpServletRequest request) {
        BasicSet basicSet = this.basicSetService.findBasicSet();
        if (basicSet != null && "0".equals(basicSet.getLoginPatcha())) {
            return request.getSession().getAttribute(PATCHCA) == null ? null : request.getSession().getAttribute(PATCHCA).toString();
        }
        return null;
    }

    @RequestMapping(value={"/updatebasic"})
    public ModelAndView updateBasicset(MultipartHttpServletRequest request, HttpServletResponse response, @Valid BasicSet basicSet, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return new ModelAndView((View)new RedirectView("basicset.htm"));
        }
        try {
            MultipartFile file = request.getFile("netLogo");
            MultipartFile hotLineFile = request.getFile("hotLine");
            MultipartFile siteLoginImg = request.getFile("siteLogin");
            MultipartFile thirdLoginImg = request.getFile("thirdLogin");
            if (!file.isEmpty()) {
                basicSet.setBsetLogo(UploadUtil.uploadFileOne((MultipartFile)file));
            }
            if (!hotLineFile.isEmpty()) {
                basicSet.setBsetHotline(UploadUtil.uploadFileOne((MultipartFile)hotLineFile));
            }
            if (!siteLoginImg.isEmpty()) {
                basicSet.setSiteLoginImg(UploadUtil.uploadFileOne((MultipartFile)siteLoginImg));
            }
            if (!thirdLoginImg.isEmpty()) {
                basicSet.setThirdLoginImg(UploadUtil.uploadFileOne((MultipartFile)thirdLoginImg));
            }
            this.basicSetService.updateBasicSet(basicSet);
            String customerName = (String)request.getSession().getAttribute(NAME);
            OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u4fee\u6539\u7ad9\u70b9\u8bbe\u7f6e", (String)(request.getSession().getAttribute(OPERAPATH) + LOGGERINFO1 + customerName));
        }
        catch (Exception e) {
            LOGGER.error("", (Throwable)e);
        }
        return new ModelAndView((View)new RedirectView("basicset.htm"));
    }

    @RequestMapping(value={"/updatebasicnew"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int updateBasicsetNew(HttpServletRequest request, HttpServletResponse response, @Valid BasicSet basicSet, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return -1;
        }
        try {
            this.basicSetService.updateBasicSet(basicSet);
            String customerName = (String)request.getSession().getAttribute(NAME);
            OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u4fee\u6539\u7ad9\u70b9\u8bbe\u7f6e", (String)(request.getSession().getAttribute(OPERAPATH) + LOGGERINFO1 + customerName));
        }
        catch (Exception e) {
            LOGGER.error("", (Throwable)e);
        }
        return 1;
    }

    @RequestMapping(value={"/updateLogPatcha"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public Map<String, Object> updateLogPatcha(HttpServletRequest request, HttpServletResponse response, String loginPatcha, Long bsetId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            BasicSet basicSet = new BasicSet();
            basicSet.setLoginPatcha(loginPatcha);
            basicSet.setBsetId(bsetId);
            this.basicSetService.updateBasicSet(basicSet);
            map.put("msg", "\u64cd\u4f5c\u6210\u529f\uff01");
            String customerName = (String)request.getSession().getAttribute(NAME);
            OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u4fee\u6539\u767b\u5f55\u9a8c\u8bc1\u7801\u5f00\u5173\u8bbe\u7f6e", (String)(request.getSession().getAttribute(OPERAPATH) + LOGGERINFO1 + customerName));
        }
        catch (Exception e) {
            LOGGER.error("", (Throwable)e);
            map.put("msg", "\u64cd\u4f5c\u5931\u8d25\uff01");
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/uploadImg"})
    public void uploadImg(MultipartHttpServletRequest request, HttpServletResponse response) {
        try (PrintWriter out = null;){
            out = response.getWriter();
            MultipartFile file = request.getFile("picFile");
            if (!file.isEmpty()) {
                if (this.checkExtendsName(file.getOriginalFilename())) {
                    String picPath = UploadUtil.uploadFileOne((MultipartFile)file);
                    out.append("<script>parent.callback('" + picPath + "');</script>");
                } else {
                    out.append("<script>parent.callback('error');</script>");
                }
            }
        }
    }

    private boolean checkExtendsName(String fileName) {
        String[] extendNames;
        if (null != fileName) {
            LOGGER.info((Object)("\u68c0\u67e5\u6587\u4ef6\u6269\u5c55\u540d\u3010" + fileName + "\u3011\u662f\u5426\u4e3a\u56fe\u7247"));
        }
        if (fileName.indexOf(".") < 0) {
            return false;
        }
        String extend = fileName.substring(fileName.lastIndexOf(".") + 1);
        for (String extendName : extendNames = new String[]{"jpg", "jpeg", "bmp", "png", "gif"}) {
            if (!extend.equals(extendName)) continue;
            return true;
        }
        return false;
    }
}

