/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.system.controller;

import com.qianjiang.system.bean.Storey;
import com.qianjiang.system.service.FloorService;
import com.qianjiang.system.service.StoreyService;
import com.qianjiang.system.util.SelectBean;
import com.qianjiang.util.MyLogger;
import com.qianjiang.util.PageBean;
import com.qianjiang.util.UploadUtil;
import java.io.PrintWriter;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller
public class StoreyController {
    private static final MyLogger LOGGER = new MyLogger(StoreyController.class);
    @Resource(name="storeyService")
    private StoreyService storeyService;
    @Resource(name="floorService")
    private FloorService floorService;
    private String page = "storey.htm";

    @RequestMapping(value={"/storey"})
    public ModelAndView paySet(HttpServletRequest request, HttpServletResponse response, PageBean pb, SelectBean selectBean) {
        if ("".equals(selectBean.getSearchText())) {
            selectBean.setCondition("");
        }
        request.setAttribute("selectBean", (Object)selectBean);
        ModelAndView model = new ModelAndView();
        model.addObject("pb", (Object)this.storeyService.findByPageBean(pb, selectBean));
        model.addObject("goodsCate", (Object)this.storeyService.findParentGoodsCate());
        model.addObject("flist", (Object)this.floorService.findAll());
        model.setViewName("jsp/system/storey");
        return model;
    }

    @RequestMapping(value={"/addstorey"})
    public ModelAndView addStorey(MultipartHttpServletRequest request, HttpServletResponse response, Storey storey) {
        MultipartFile file = request.getFile("netLogo");
        if (file.getSize() != 0L) {
            storey.setSeImg(UploadUtil.uploadFileOne((MultipartFile)file, (HttpServletRequest)request));
        }
        this.storeyService.insertStorey(storey);
        return new ModelAndView((View)new RedirectView(this.page));
    }

    @RequestMapping(value={"/findfloor"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public Storey findFloorOne(Long floorId) {
        return this.storeyService.findStoreyByFloorId(floorId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/delstorey"})
    public ModelAndView deleteStorey(HttpServletRequest request, HttpServletResponse response) {
        try (PrintWriter pr = null;){
            pr = response.getWriter();
            pr.print(this.storeyService.deleteStorey(request.getParameterValues("seIds[]")));
        }
        return null;
    }

    @RequestMapping(value={"/findstoreyone"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public Storey findStoreyOne(Long seId) {
        return this.storeyService.findStoreyById(seId);
    }

    @RequestMapping(value={"/updatestorey"})
    public ModelAndView updateStorey(MultipartHttpServletRequest request, HttpServletResponse response, Storey storey) {
        MultipartFile file = request.getFile("netLogo");
        if (file.getSize() != 0L) {
            storey.setSeImg(UploadUtil.uploadFileOne((MultipartFile)file, (HttpServletRequest)request));
        }
        this.storeyService.updateStorey(storey);
        return new ModelAndView((View)new RedirectView(this.page));
    }
}

