/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.information.controller;

import com.qianjiang.information.bean.InforSubject;
import com.qianjiang.information.bean.InforSubjectGoods;
import com.qianjiang.information.service.InforSubjectClassifyService;
import com.qianjiang.information.service.InforSubjectGoodsService;
import com.qianjiang.information.service.InforSubjectServcie;
import com.qianjiang.operlog.util.IPAddress;
import com.qianjiang.operlog.util.OperaLogUtil;
import com.qianjiang.system.mobile.service.MobSiteBasicService;
import com.qianjiang.system.service.BasicSetService;
import com.qianjiang.system.util.BasicSetUtil;
import com.qianjiang.util.MyLogger;
import com.qianjiang.util.PageBean;
import com.qianjiang.util.UploadUtil;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller
public class InforSubjectController {
    private static final MyLogger LOGGER = new MyLogger(InforSubjectController.class);
    public static final String NAME = "name";
    public static final String OPERAPATH = "operaPath";
    private static final String LOGINUSERID = "loginUserId";
    private static final String QUERYINFORSUBJECTBYPAGEBEAN_HTM = "queryInforSubjectByPageBean.htm";
    private static final String QUERYMOBILEINFORSUBJECTBYPAGEBEAN_HTM = "queryMobileInfoSubjectByPageBean.htm";
    private static final String LOGGERINFO1 = ",\u7528\u6237\u540d:";
    @Resource(name="basicSetService")
    private BasicSetService basicSetService;
    @Resource(name="MobSiteBasicService")
    private MobSiteBasicService mobSiteBasicService;
    @Resource(name="InforSubjectServcieImpl")
    private InforSubjectServcie subjectService;
    @Resource(name="InforSubjectClassifyServiceImpl")
    private InforSubjectClassifyService themaCateService;
    @Resource(name="InforSubjectGoodsServiceImpl")
    private InforSubjectGoodsService specialOrderService;

    @RequestMapping(value={"/queryInforSubjectByPageBean"})
    public ModelAndView queryInforSubjectByPageBean(PageBean pb, String titles, HttpServletRequest request) {
        String subjectTypes = "2";
        List list = this.themaCateService.findClassKindList(Long.valueOf(subjectTypes));
        PageBean listSubject = this.subjectService.selectPCSubjectByPageBean(pb, titles, subjectTypes);
        String siteAddress = this.basicSetService.findBasicSet().getBsetAddress();
        siteAddress = BasicSetUtil.getAddress((String)siteAddress);
        String addressAddress = siteAddress + "/subject/";
        return new ModelAndView("jsp/system/site_subject", "pb", (Object)listSubject).addObject("siteAddress", (Object)addressAddress).addObject("titles", (Object)titles).addObject("themaClassList", (Object)list);
    }

    @RequestMapping(value={"/queryMobileInfoSubjectByPageBean"})
    public String queryMobileInfoSubjectByPageBean(HttpServletRequest request, PageBean pb, String titles, Model model) {
        String subjectTypes = "1";
        model.addAttribute("pb", (Object)this.subjectService.selectMobileSubjectByPageBean(pb, titles, subjectTypes));
        model.addAttribute("titles", (Object)titles);
        String mobileAddress = this.basicSetService.findBasicSet().getMobileAddress();
        mobileAddress = BasicSetUtil.getAddress((String)mobileAddress);
        List list = this.themaCateService.findClassKindList(Long.valueOf(subjectTypes));
        model.addAttribute("themaClassList", (Object)list);
        model.addAttribute("siteAddress", (Object)mobileAddress);
        return "jsp/mobile/inforSubject";
    }

    @RequestMapping(value={"/ajaxQuerySubjectList"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public Map<String, Object> querySubjectList(PageBean pb, String title, HttpServletRequest request) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("pb", this.subjectService.selectSubjectByPageBean(pb, title, "0", "1", null));
        result.put("title", title);
        String mobileAddress = this.basicSetService.findBasicSet().getMobileAddress();
        mobileAddress = BasicSetUtil.getAddress((String)mobileAddress);
        result.put("address", mobileAddress + "/subject/");
        return result;
    }

    @RequestMapping(value={"/showInforSubject"})
    public ModelAndView showInforSubject(Long subjectId) {
        ModelAndView mav = new ModelAndView();
        HashMap<String, Object> mapParam = new HashMap<String, Object>();
        String subjectTypes = "1";
        if (null != subjectId) {
            mapParam.put("subjectId", subjectId);
            mapParam.put("subjectTypes", subjectTypes);
            LOGGER.debug("==============================\u67e5\u770b\u4e13\u9898\u5e76\u8df3\u8f6c\u5230\u67e5\u770b\u6216\u4fee\u6539\u9875\u9762==============================");
            mav.addObject("subject", (Object)this.subjectService.getSubject(mapParam));
        }
        String bsetAddress = BasicSetUtil.getAddress((String)this.basicSetService.findBasicSet().getBsetAddress());
        mav.addObject("siteAddress", (Object)bsetAddress);
        mav.setViewName("jsp/mobile/inforSubject");
        return mav;
    }

    @RequestMapping(value={"/addInforSubject"})
    public ModelAndView addPcInforSubject(MultipartHttpServletRequest request, @Valid InforSubject subject, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return new ModelAndView((View)new RedirectView(QUERYINFORSUBJECTBYPAGEBEAN_HTM));
        }
        LOGGER.debug("==============================\u6dfb\u52a0PC\u4e13\u9898==============================");
        subject.setTemp2("1");
        this.addInforSubject(request, subject);
        return new ModelAndView((View)new RedirectView(QUERYINFORSUBJECTBYPAGEBEAN_HTM));
    }

    @RequestMapping(value={"/addMobileInforSubject"})
    public ModelAndView addMobileInforSubject(MultipartHttpServletRequest request, @Valid InforSubject subject, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return new ModelAndView((View)new RedirectView(QUERYINFORSUBJECTBYPAGEBEAN_HTM));
        }
        LOGGER.debug("==============================\u6dfb\u52a0Mobile\u4e13\u9898==============================");
        subject.setTemp2("0");
        this.addInforSubject(request, subject);
        return new ModelAndView((View)new RedirectView(QUERYMOBILEINFORSUBJECTBYPAGEBEAN_HTM));
    }

    @RequestMapping(value={"/showinforsubjectajax"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public Map<String, Object> showInforSubjectAjax(Long subjectId, Long subjectTypes) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        HashMap<String, Long> mapParam = new HashMap<String, Long>();
        mapParam.put("subjectId", subjectId);
        mapParam.put("subjectTypes", subjectTypes);
        map.put("list", this.specialOrderService.selectByPrimaryKey(subjectId));
        map.put("inforSubject", this.subjectService.getSubject(mapParam));
        return map;
    }

    @RequestMapping(value={"/addMobileinforsubjectnew"})
    public ModelAndView addMobileInforSubjectNew(HttpServletRequest request, MultipartHttpServletRequest multipartRequest, @Valid InforSubject subject, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return new ModelAndView((View)new RedirectView(QUERYINFORSUBJECTBYPAGEBEAN_HTM));
        }
        LOGGER.debug("==============================\u6dfb\u52a0Mobile\u4e13\u9898==============================");
        String picImage = "";
        if (multipartRequest.getFile("picFiles") != null && !"".equals(multipartRequest.getFile("picFiles").getOriginalFilename())) {
            picImage = UploadUtil.uploadFileOne((MultipartFile)multipartRequest.getFile("picFiles"), (HttpServletRequest)request);
        }
        subject.setTitleImg(picImage);
        subject.setTemp2("0");
        this.addInforSubjectNew(request, subject);
        if (subject.getSubjectTypes() == 1) {
            return new ModelAndView((View)new RedirectView(QUERYMOBILEINFORSUBJECTBYPAGEBEAN_HTM));
        }
        return new ModelAndView((View)new RedirectView(QUERYINFORSUBJECTBYPAGEBEAN_HTM));
    }

    private void addInforSubjectNew(HttpServletRequest request, InforSubject subject) {
        Long loginUserId = (Long)request.getSession().getAttribute(LOGINUSERID);
        subject.setCreateUserId(loginUserId);
        subject.setUpdateUserId(loginUserId);
        int number = this.subjectService.saveSubject(subject);
        if (number > 0) {
            List list = this.subjectService.selectAllForSite();
            InforSubject subjectFirst = (InforSubject)list.get(0);
            ArrayList<InforSubjectGoods> inforSubjectGoodsList = new ArrayList<InforSubjectGoods>();
            String[] goodsNames = null;
            String[] goodsNos = null;
            String[] goodsIds = null;
            String[] goodsTag = null;
            String[] goodsPrice = null;
            String[] goodsImgurl = null;
            String[] prederPrice = null;
            if (subject != null) {
                if (subject.getGoodsName() != null && !subject.getGoodsName().equals("")) {
                    goodsNames = subject.getGoodsName().split(",");
                }
                if (subject.getGoodsNo() != null && !subject.getGoodsNo().equals("")) {
                    goodsNos = subject.getGoodsNo().split(",");
                }
                if (subject.getProductId() != null && !subject.getProductId().equals("")) {
                    goodsIds = subject.getProductId().split(",");
                }
                if (subject.getGoodsTag() != null && !subject.getGoodsTag().equals("")) {
                    goodsTag = subject.getGoodsTag().split(",");
                }
                if (subject.getPrice() != null && !subject.getPrice().equals("")) {
                    goodsPrice = subject.getPrice().split(",");
                }
                if (subject.getGoodsImgurl() != null && !subject.getGoodsImgurl().equals("")) {
                    goodsImgurl = subject.getGoodsImgurl().split("http:");
                }
                if (subject.getPrederPrice() != null && !subject.getPrederPrice().equals("")) {
                    prederPrice = subject.getPrederPrice().split(",");
                }
                Date date = new Date();
                String dateStr = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(date);
                if (goodsNames != null) {
                    for (int i = 0; i < goodsNames.length; ++i) {
                        InforSubjectGoods inforSubjectGoods = new InforSubjectGoods();
                        inforSubjectGoods.setCreateTime(dateStr);
                        inforSubjectGoods.setModifyTime(dateStr);
                        inforSubjectGoods.setDelflag(Integer.valueOf(0));
                        inforSubjectGoods.setSubjectId(subjectFirst.getSubjectId());
                        inforSubjectGoods.setSpecialFications(goodsTag[i]);
                        inforSubjectGoods.setSpecialGoodName(goodsNames[i]);
                        inforSubjectGoods.setSpecialGoodsNo(goodsNos[i]);
                        StringBuffer sb = new StringBuffer();
                        String http = "http:";
                        String goodsImageUrl = sb.append(http).append(goodsImgurl[i + 1]).toString();
                        inforSubjectGoods.setSpecialGoodUrl(goodsImageUrl);
                        inforSubjectGoods.setProductId(goodsIds[i]);
                        inforSubjectGoods.setPecialPrice(goodsPrice[i]);
                        inforSubjectGoods.setPrederPrice(Double.parseDouble(prederPrice[i]));
                        inforSubjectGoodsList.add(inforSubjectGoods);
                    }
                    this.specialOrderService.insertAllSpecial(inforSubjectGoodsList);
                }
            }
        }
        String customerName = (String)request.getSession().getAttribute(NAME);
        OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u6dfb\u52a0\u4e13\u9898", (String)(request.getSession().getAttribute(OPERAPATH) + LOGGERINFO1 + customerName));
    }

    @RequestMapping(value={"/updateInforSubject"})
    public ModelAndView updateInforSubject(MultipartHttpServletRequest request, @Valid InforSubject subject, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return new ModelAndView((View)new RedirectView(QUERYINFORSUBJECTBYPAGEBEAN_HTM));
        }
        Long loginUserId = (Long)request.getSession().getAttribute(LOGINUSERID);
        LOGGER.debug("==============================\u4fee\u6539\u4e13\u9898==============================");
        MultipartFile muFile = request.getFile("imageSrc");
        if (muFile.getSize() > 0L) {
            subject.setBackgroundImg(UploadUtil.uploadFileOne((MultipartFile)muFile, (HttpServletRequest)request));
        }
        try {
            if (null == loginUserId) {
                loginUserId = 1L;
            }
            subject.setUpdateUserId(loginUserId);
            this.subjectService.updateSubject(subject);
            String customerName = (String)request.getSession().getAttribute(NAME);
            OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u4fee\u6539\u4e13\u9898", (String)(request.getSession().getAttribute(OPERAPATH) + LOGGERINFO1 + customerName));
        }
        catch (Exception e) {
            LOGGER.error("==============================\u4fee\u6539\u4e13\u9898\u5931\u8d25\uff1a", (Throwable)e);
        }
        return new ModelAndView((View)new RedirectView(QUERYINFORSUBJECTBYPAGEBEAN_HTM));
    }

    @RequestMapping(value={"/updateMobileInforSubjectNew"})
    public ModelAndView updateMobileInfoSubjectNew(HttpServletRequest request, MultipartHttpServletRequest multipartRequest, @Valid InforSubject subject, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return new ModelAndView((View)new RedirectView(QUERYINFORSUBJECTBYPAGEBEAN_HTM));
        }
        String picImage = "";
        if (multipartRequest.getFile("picFiles") != null && !"".equals(multipartRequest.getFile("picFiles").getOriginalFilename())) {
            picImage = UploadUtil.uploadFileOne((MultipartFile)multipartRequest.getFile("picFiles"), (HttpServletRequest)request);
        }
        subject.setTitleImg(picImage);
        this.updateInfoSubjectNew(request, subject);
        if (subject.getSubjectTypes() == 1) {
            return new ModelAndView((View)new RedirectView(QUERYMOBILEINFORSUBJECTBYPAGEBEAN_HTM));
        }
        return new ModelAndView((View)new RedirectView(QUERYINFORSUBJECTBYPAGEBEAN_HTM));
    }

    private void updateInfoSubjectNew(HttpServletRequest request, InforSubject subject) {
        Long loginUserId = (Long)request.getSession().getAttribute(LOGINUSERID);
        LOGGER.debug("==============================\u4fee\u6539\u4e13\u9898==============================");
        try {
            subject.setUpdateUserId(loginUserId);
            int number = this.subjectService.updateSubject(subject);
            if (number > 0) {
                this.updateSubjectSpecialGoods(request, subject);
            }
            String customerName = (String)request.getSession().getAttribute(NAME);
            OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u4fee\u6539\u4e13\u9898", (String)(request.getSession().getAttribute(OPERAPATH) + LOGGERINFO1 + customerName));
        }
        catch (Exception e) {
            LOGGER.error("==============================\u4fee\u6539\u4e13\u9898\u5931\u8d25\uff1a", (Throwable)e);
        }
    }

    public void updateSubjectSpecialGoods(HttpServletRequest request, @Valid InforSubject subject) {
        InforSubjectGoods inforSubjectGoods;
        int i;
        Long loginUserId = (Long)request.getSession().getAttribute(LOGINUSERID);
        subject.setCreateUserId(loginUserId);
        subject.setUpdateUserId(loginUserId);
        String[] addOredit = null;
        if (subject.getAddOredit() != null && !subject.getAddOredit().equals("")) {
            addOredit = subject.getAddOredit().split(",");
        }
        List list = this.subjectService.selectAllForSite();
        ArrayList<InforSubjectGoods> inforSubjectGoodsList = new ArrayList<InforSubjectGoods>();
        String[] goodsNames = null;
        String[] goodsNos = null;
        String[] goodsIdPs = null;
        String[] goodsTag = null;
        String[] goodsPrice = null;
        String[] goodsImgurl = null;
        String[] prederPrice = null;
        Date date = new Date();
        String dateStr = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(date);
        if (addOredit != null && addOredit.length > 0 && subject != null) {
            if (subject.getGoodsName() != null && !subject.getGoodsName().equals("")) {
                goodsNames = subject.getGoodsName().split(",");
            }
            if (subject.getGoodsNo() != null && !subject.getGoodsNo().equals("")) {
                goodsNos = subject.getGoodsNo().split(",");
            }
            if (subject.getGoodsIdP() != null && !subject.getGoodsIdP().equals("")) {
                goodsIdPs = subject.getGoodsIdP().split(",");
            }
            if (subject.getGoodsTag() != null && !subject.getGoodsTag().equals("")) {
                goodsTag = subject.getGoodsTag().split(",");
            }
            if (subject.getPrice() != null && !subject.getPrice().equals("")) {
                goodsPrice = subject.getPrice().split(",");
            }
            if (subject.getGoodsImgurl() != null && !subject.getGoodsImgurl().equals("")) {
                goodsImgurl = subject.getGoodsImgurl().split("http:");
            }
            if (subject.getPrederPrice() != null && !subject.getPrederPrice().equals("")) {
                prederPrice = subject.getPrederPrice().split(",");
            }
            for (i = 0; i < addOredit.length; ++i) {
                if (!addOredit[i].equals("-1")) continue;
                inforSubjectGoods = new InforSubjectGoods();
                inforSubjectGoods.setCreateTime(dateStr);
                inforSubjectGoods.setModifyTime(dateStr);
                inforSubjectGoods.setDelflag(Integer.valueOf(0));
                inforSubjectGoods.setSubjectId(subject.getSubjectId());
                inforSubjectGoods.setSpecialFications(goodsTag[i]);
                inforSubjectGoods.setSpecialGoodName(goodsNames[i]);
                if (!goodsNos[i].equals("") && null != goodsNos[i]) {
                    inforSubjectGoods.setSpecialGoodsNo(goodsNos[i]);
                }
                if (!goodsImgurl[i + 1].equals("") && null != goodsImgurl[i + 1]) {
                    StringBuffer sb = new StringBuffer();
                    String http = "http:";
                    String goodsImageUrl = sb.append(http).append(goodsImgurl[i + 1]).toString();
                    inforSubjectGoods.setSpecialGoodUrl(goodsImageUrl);
                }
                inforSubjectGoods.setProductId(goodsIdPs[i]);
                inforSubjectGoods.setPecialPrice(goodsPrice[i]);
                if (!prederPrice[i].equals("") && null != prederPrice[i]) {
                    inforSubjectGoods.setPrederPrice(Double.parseDouble(prederPrice[i]));
                }
                inforSubjectGoodsList.add(inforSubjectGoods);
            }
            if (inforSubjectGoodsList.size() > 0) {
                this.specialOrderService.insertAllSpecial(inforSubjectGoodsList);
            }
        }
        if (subject.getProductIDArrayByDelete() != null && !subject.getProductIDArrayByDelete().equals("")) {
            String[] productIDArrayByDelete = subject.getProductIDArrayByDelete().split(",");
            for (i = 0; i < productIDArrayByDelete.length; ++i) {
                inforSubjectGoods = new InforSubjectGoods();
                String specialOrderId = productIDArrayByDelete[i];
                inforSubjectGoods.setSubjectId(subject.getSubjectId());
                inforSubjectGoods.setSpecialOrderId(Long.valueOf(specialOrderId));
                InforSubjectGoods spe = this.specialOrderService.selectSpecialOrder(inforSubjectGoods);
                if (spe == null) continue;
                this.specialOrderService.deleteByPrimaryKey(spe.getSpecialOrderId());
            }
        }
    }

    @RequestMapping(value={"/delInforSubject"})
    public void delInforSubject(HttpServletRequest request, HttpServletResponse response) {
        LOGGER.debug("==============================\u5220\u9664\u4e13\u9898==============================");
        try {
            String[] ids = request.getParameterValues("inforSubjectIds[]");
            Long[] sids = new Long[ids.length];
            for (int i = 0; i < ids.length; ++i) {
                sids[i] = Long.valueOf(ids[i]);
            }
            this.subjectService.batchDeleteSubject(sids);
            String customerName = (String)request.getSession().getAttribute(NAME);
            OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u5220\u9664\u4e13\u9898", (String)(request.getSession().getAttribute(OPERAPATH) + LOGGERINFO1 + customerName));
        }
        catch (NumberFormatException e) {
            LOGGER.error("==============================\u5220\u9664\u4e13\u9898\u5931\u8d25\uff1a", (Throwable)e);
        }
    }

    @RequestMapping(value={"/delMobileInfoSubjectNew"})
    public void delMobileInfoSubjectNew(HttpServletRequest request, HttpServletResponse response) {
        LOGGER.debug("==============================\u5220\u9664Mobile\u4e13\u9898==============================");
        this.delInfoSubjectNew(request, response);
    }

    private void delInfoSubjectNew(HttpServletRequest request, HttpServletResponse response) {
        try {
            String[] ids = request.getParameterValues("inforSubjectIds");
            System.out.println();
            Long[] sids = new Long[ids.length];
            for (int i = 0; i < ids.length; ++i) {
                sids[i] = Long.valueOf(ids[i]);
            }
            this.subjectService.batchDeleteSubject(sids);
            String customerName = (String)request.getSession().getAttribute(NAME);
            OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u5220\u9664\u4e13\u9898", (String)(request.getSession().getAttribute(OPERAPATH) + LOGGERINFO1 + customerName));
        }
        catch (NumberFormatException e) {
            LOGGER.error("==============================\u5220\u9664\u4e13\u9898\u5931\u8d25\uff1a", (Throwable)e);
        }
    }

    @ResponseBody
    @RequestMapping(value={"/checkSubjectByUrl"}, produces={"application/json;charset=UTF-8"})
    public boolean checkSubjectByUrl(String url, Long subjectId) {
        if (null != subjectId) {
            HashMap<String, Object> mapParam = new HashMap<String, Object>();
            String subjectTypes = "1";
            mapParam.put("subjectId", subjectId);
            mapParam.put("subjectTypes", subjectTypes);
            String subUrl = this.subjectService.getSubject(mapParam).getUrl();
            if (subUrl != null && "".equals(subUrl) && subUrl.equals(url)) {
                return true;
            }
        }
        return this.subjectService.checkByUrl(url);
    }

    @RequestMapping(value={"/addinforsubjectnew"})
    public ModelAndView addinforsubjectnew(HttpServletRequest request, @Valid InforSubject subject, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return new ModelAndView((View)new RedirectView(QUERYINFORSUBJECTBYPAGEBEAN_HTM));
        }
        LOGGER.debug("==============================\u6dfb\u52a0PC\u4e13\u9898==============================");
        subject.setTemp2("1");
        this.addInforSubjectNew(request, subject);
        return new ModelAndView((View)new RedirectView(QUERYINFORSUBJECTBYPAGEBEAN_HTM));
    }

    @RequestMapping(value={"/delinforsubjectnew"})
    public void delPCInforSubjectNew(HttpServletRequest request, HttpServletResponse response) {
        LOGGER.debug("==============================\u5220\u9664Manager\u4e13\u9898==============================");
        this.delInfoSubjectNew(request, response);
    }

    @RequestMapping(value={"/updateInforSubjectNew"})
    public ModelAndView updatePCInforSubjectNew(HttpServletRequest request, @Valid InforSubject subject, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return new ModelAndView((View)new RedirectView(QUERYINFORSUBJECTBYPAGEBEAN_HTM));
        }
        this.updateInfoSubjectNew(request, subject);
        return new ModelAndView((View)new RedirectView(QUERYINFORSUBJECTBYPAGEBEAN_HTM));
    }

    private void addInforSubject(MultipartHttpServletRequest request, InforSubject subject) {
        Long loginUserId = (Long)request.getSession().getAttribute(LOGINUSERID);
        MultipartFile muFile = request.getFile("imageSrc");
        if (muFile.getSize() > 0L) {
            subject.setBackgroundImg(UploadUtil.uploadFileOne((MultipartFile)muFile, (HttpServletRequest)request));
        }
        try {
            if (null == loginUserId) {
                loginUserId = 1L;
            }
            subject.setCreateUserId(loginUserId);
            subject.setUpdateUserId(loginUserId);
            this.subjectService.saveSubject(subject);
            String customerName = (String)request.getSession().getAttribute(NAME);
            OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u6dfb\u52a0\u4e13\u9898", (String)(request.getSession().getAttribute(OPERAPATH) + LOGGERINFO1 + customerName));
        }
        catch (Exception e) {
            LOGGER.error("==============================\u6dfb\u52a0\u4e13\u9898\u5931\u8d25\uff1a", (Throwable)e);
        }
    }
}

