/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.information.controller;

import com.qianjiang.information.bean.InfoOPTag;
import com.qianjiang.information.service.InfoOPTagService;
import com.qianjiang.information.service.InformationOnePageService;
import com.qianjiang.operlog.util.IPAddress;
import com.qianjiang.operlog.util.OperaLogUtil;
import com.qianjiang.temp.bean.SysTemp;
import com.qianjiang.temp.service.InfoSysTempService;
import com.qianjiang.util.MyLogger;
import com.qianjiang.util.PageBean;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller
public class InfoOPTagController {
    private static final MyLogger LOGGER = new MyLogger(InfoOPTagController.class);
    public static final String NAME = "name";
    public static final String OPERAPATH = "operaPath";
    private static final String QUERYINFOOPTAG_HTM = "queryInfoOPTag.htm?CSRFToken=";
    private static final String LOGGERINFO1 = ",\u7528\u6237\u540d:";
    private InfoOPTagService infoOPTagService;
    private InfoSysTempService channelSysTempService;
    @Resource(name="InformationOnePageService")
    private InformationOnePageService infoOnePageService;

    @RequestMapping(value={"/queryInfoOPTag"})
    public ModelAndView queryInfoOPTag(HttpServletRequest request, PageBean pb, HttpServletResponse response) {
        List sysTempList = this.channelSysTempService.queryAllSystemp();
        this.removeNoUseTemp(sysTempList);
        return new ModelAndView("jsp/information/infoOPTag", "infoOPTagList", (Object)this.infoOPTagService.findAllTag()).addObject("sysTempList", (Object)sysTempList);
    }

    private void removeNoUseTemp(List<SysTemp> sysTempList) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(1);
        list.add(4);
        list.add(6);
        list.add(7);
        list.add(8);
        ArrayList<SysTemp> removeList = new ArrayList<SysTemp>();
        for (SysTemp sysTemp : sysTempList) {
            if (!list.contains(sysTemp.getTempId())) continue;
            removeList.add(sysTemp);
        }
        sysTempList.removeAll(removeList);
    }

    @RequestMapping(value={"/addInfoOPTag"})
    public ModelAndView addInfoOPTag(@Valid InfoOPTag infoOPTag, BindingResult bindingResult, HttpServletRequest request) {
        if (bindingResult.hasErrors()) {
            return new ModelAndView((View)new RedirectView(QUERYINFOOPTAG_HTM + request.getParameter("CSRFToken")));
        }
        LOGGER.debug("==============================\u4fee\u6539\u5355\u9875\u6807\u7b7e==============================");
        try {
            this.infoOPTagService.createInfoOPTag(infoOPTag);
            String customerName = (String)request.getSession().getAttribute(NAME);
            OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u6dfb\u52a0\u5355\u9875\u6807\u7b7e", (String)(request.getSession().getAttribute(OPERAPATH) + LOGGERINFO1 + customerName));
        }
        catch (Exception e) {
            LOGGER.error("==============================\u4fee\u6539\u5355\u9875\u6807\u7b7e\u5931\u8d25\uff1a", (Throwable)e);
        }
        return new ModelAndView((View)new RedirectView(QUERYINFOOPTAG_HTM + request.getParameter("CSRFToken")));
    }

    @RequestMapping(value={"/updateInfoOPTag"})
    public ModelAndView updateInfoOPTag(@Valid InfoOPTag infoOPTag, BindingResult bindingResult, HttpServletRequest request) {
        if (bindingResult.hasErrors()) {
            return new ModelAndView((View)new RedirectView(QUERYINFOOPTAG_HTM + request.getParameter("CSRFToken")));
        }
        LOGGER.debug("==============================\u4fee\u6539\u5355\u9875\u6807\u7b7e==============================");
        try {
            this.infoOPTagService.updateInfoOPTag(infoOPTag);
            String customerName = (String)request.getSession().getAttribute(NAME);
            OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u4fee\u6539\u5355\u9875\u6807\u7b7e", (String)(request.getSession().getAttribute(OPERAPATH) + LOGGERINFO1 + customerName));
        }
        catch (Exception e) {
            LOGGER.error("==============================\u4fee\u6539\u5355\u9875\u6807\u7b7e\u5931\u8d25\uff1a", (Throwable)e);
        }
        return new ModelAndView((View)new RedirectView(QUERYINFOOPTAG_HTM + request.getParameter("CSRFToken")));
    }

    @RequestMapping(value={"/delInfoOPTag"})
    public ModelAndView delInfoOPTag(Long infoOPTagId, HttpServletRequest request) {
        LOGGER.debug("==============================\u5220\u9664\u5355\u9875\u6807\u7b7e==============================");
        try {
            this.infoOPTagService.deleteInfoOPTagById(infoOPTagId);
            String customerName = (String)request.getSession().getAttribute(NAME);
            OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u5220\u9664\u5355\u9875\u6807\u7b7e", (String)(request.getSession().getAttribute(OPERAPATH) + LOGGERINFO1 + customerName));
        }
        catch (Exception e) {
            LOGGER.error("==============================\u5220\u9664\u5355\u9875\u6807\u7b7e\u5931\u8d25\uff1a", (Throwable)e);
        }
        return new ModelAndView((View)new RedirectView(QUERYINFOOPTAG_HTM + request.getParameter("CSRFToken")));
    }

    @ResponseBody
    @RequestMapping(value={"/checkDelTag"}, produces={"application/json;charset=UTF-8"})
    public boolean checkDelTag(Long infoOPTagId) {
        return this.infoOnePageService.selectInfoOPCountByTag(infoOPTagId) <= 0;
    }

    public InfoOPTagService getInfoOPTagService() {
        return this.infoOPTagService;
    }

    @Resource(name="InfoOPTagService")
    public void setInfoOPTagService(InfoOPTagService infoOPTagService) {
        this.infoOPTagService = infoOPTagService;
    }

    public InfoSysTempService getChannelSysTempService() {
        return this.channelSysTempService;
    }

    @Resource(name="InfoSysTempService")
    public void setChannelSysTempService(InfoSysTempService channelSysTempService) {
        this.channelSysTempService = channelSysTempService;
    }
}

