/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.message.controller;

import com.qianjiang.message.bean.MessageBean;
import com.qianjiang.message.service.MessageService;
import com.qianjiang.util.MyLogger;
import com.qianjiang.util.PageBean;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller
public class MessageController {
    private static final MyLogger LOGGER = new MyLogger(MessageController.class);
    @Resource(name="MessageService")
    private MessageService messageService;

    @RequestMapping(value={"informUpdate"})
    public ModelAndView update(int informId, ModelMap map) {
        MessageBean message = this.messageService.selectById(informId);
        if (null != message.getInformSubject()) {
            LOGGER.info((Object)("\u6d88\u606f\u9875\u9762\u8df3\u8f6c\uff0c\u5f53\u524d\u6d88\u606f\u7684\u540d\u79f0\u4e3a\uff1a" + message.getInformSubject()));
        }
        map.put((Object)"message", (Object)message);
        return new ModelAndView("jsp/system/informSet");
    }

    @RequestMapping(value={"informUpdateAction"})
    public ModelAndView updateAction(MessageBean message) {
        if (null != message.getInformSubject()) {
            LOGGER.info((Object)("\u4fee\u6539\u4fe1\u606f\u3001\u90ae\u4ef6\u5bf9\u8c61\uff0c\u5f53\u524d\u6d88\u606f\u7684\u540d\u79f0\u4e3a\uff1a" + message.getInformSubject()));
        }
        this.messageService.updateInform(message);
        return new ModelAndView((View)new RedirectView("informList.htm"));
    }

    @RequestMapping(value={"informList"})
    public ModelAndView informList(PageBean pb, HttpServletRequest request) {
        ModelAndView mav = new ModelAndView();
        mav.setViewName("jsp/system/informList");
        mav.addObject("pageBean", (Object)this.messageService.selectList(pb));
        return mav;
    }
}

