/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.channel.controller;

import com.qianjiang.channel.bean.ChannelStorey;
import com.qianjiang.channel.bean.ChannelStoreyTag;
import com.qianjiang.channel.bean.ChannelTrademark;
import com.qianjiang.channel.service.ChannelStoreyService;
import com.qianjiang.channel.service.ChannelStoreyTagService;
import com.qianjiang.channel.service.ChannelTrademarkService;
import com.qianjiang.operlog.util.IPAddress;
import com.qianjiang.operlog.util.OperaLogUtil;
import com.qianjiang.util.MyLogger;
import com.qianjiang.util.PageBean;
import java.util.HashMap;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller
public class ChannelStoreyTagTrademarkController {
    private static final MyLogger LOGGER = new MyLogger(ChannelStoreyTagTrademarkController.class);
    private static final String LOGINUSERID = "loginUserId";
    public static final String NAME = "name";
    public static final String OPERAPATH = "operaPath";
    public static final String QUERYSTOREYTAGTRADEMARKBYPAGEBEAN_HTM = "queryStoreyTagTrademarkByPageBean.htm?storeyTagId=";
    public static final String LOGGERINFO1 = ",\u7528\u6237\u540d:";
    private ChannelStoreyService channelStoreyService;
    private ChannelStoreyTagService channelStoreyTagService;
    private ChannelTrademarkService channelTrademarkService;

    @RequestMapping(value={"/queryStoreyTagTrademarkByPageBean"})
    public ModelAndView queryStoreyTagTrademarkByPageBean(PageBean pb, Long storeyTagId) {
        ChannelStoreyTag storeyTag = this.channelStoreyTagService.getChannelStoreyTagById(storeyTagId);
        ChannelStorey channelStorey = this.channelStoreyService.getChannelStoreyById(storeyTag.getStoreyId());
        return new ModelAndView("jsp/channel/channel_storey_tag_trademark_list", "pb", (Object)this.channelTrademarkService.selectchannelTrademarkByParam(pb, null, null, null, storeyTagId, null, null)).addObject("storeyTag", (Object)storeyTag).addObject("channelStorey", (Object)channelStorey);
    }

    @RequestMapping(value={"/showStoreyTagTrademark"})
    public ModelAndView showStoreyTagTrademark(Long trademarkId, Long storeyTagId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        ChannelStoreyTag storeyTag = this.channelStoreyTagService.getChannelStoreyTagById(storeyTagId);
        ChannelStorey channelStorey = this.channelStoreyService.getChannelStoreyById(storeyTag.getStoreyId());
        map.put("storeyTag", storeyTag);
        map.put("channelStorey", channelStorey);
        if (null != trademarkId) {
            ChannelTrademark channelTrademark = this.channelTrademarkService.getChannelTrademarkById(trademarkId);
            map.put("channelTrademark", channelTrademark);
        }
        return new ModelAndView("jsp/channel/showChannelStoreyTagTrademark", "map", map);
    }

    @RequestMapping(value={"/createStoreyTagTrademark"})
    public ModelAndView createStoreyTagTrademark(HttpServletRequest request, @Valid ChannelTrademark channelTrademark, BindingResult bindingResult, Long storeyTagId) {
        if (bindingResult.hasErrors()) {
            return new ModelAndView((View)new RedirectView(QUERYSTOREYTAGTRADEMARKBYPAGEBEAN_HTM + storeyTagId + "&CSRFToken=" + request.getParameter("CSRFToken")));
        }
        Long loginUserId = (Long)request.getSession().getAttribute(LOGINUSERID);
        ModelAndView mav = new ModelAndView();
        try {
            if (null == loginUserId) {
                loginUserId = 1L;
            }
            channelTrademark.setCreateUserId(loginUserId);
            int n = this.channelTrademarkService.saveChannelTrademark(channelTrademark);
            if (n > 0) {
                String customerName = (String)request.getSession().getAttribute(NAME);
                OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u6dfb\u52a0\u697c\u5c42\u6807\u7b7e\u54c1\u724c", (String)(request.getSession().getAttribute(OPERAPATH) + LOGGERINFO1 + customerName));
                LOGGER.debug("\u4fdd\u5b58\u9891\u9053\u54c1\u724c\u6210\u529f\uff01");
            } else {
                LOGGER.debug("\u4fdd\u5b58\u9891\u9053\u54c1\u724c\u5931\u8d25\uff01");
            }
        }
        catch (Exception e) {
            LOGGER.error("\u4fdd\u5b58\u9891\u9053\u54c1\u724c\u5f02\u5e38\uff01", (Throwable)e);
        }
        mav.setView((View)new RedirectView(QUERYSTOREYTAGTRADEMARKBYPAGEBEAN_HTM + storeyTagId + "&CSRFToken=" + request.getParameter("CSRFToken")));
        return mav;
    }

    @RequestMapping(value={"/updateStoreyTagTrademark"})
    public ModelAndView updateStoreyTagTrademark(HttpServletRequest request, @Valid ChannelTrademark channelTrademark, BindingResult bindingResult, Long storeyTagId) {
        if (bindingResult.hasErrors()) {
            return new ModelAndView((View)new RedirectView(QUERYSTOREYTAGTRADEMARKBYPAGEBEAN_HTM + storeyTagId + "&CSRFToken=" + request.getParameter("CSRFToken")));
        }
        Long loginUserId = (Long)request.getSession().getAttribute(LOGINUSERID);
        ModelAndView mav = new ModelAndView();
        try {
            if (null == loginUserId) {
                loginUserId = 1L;
            }
            channelTrademark.setUpdateUserId(loginUserId);
            int n = this.channelTrademarkService.updateChannelTrademark(channelTrademark);
            if (n > 0) {
                String customerName = (String)request.getSession().getAttribute(NAME);
                OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u4fee\u6539\u697c\u5c42\u6807\u7b7e\u54c1\u724c", (String)(request.getSession().getAttribute(OPERAPATH) + LOGGERINFO1 + customerName));
                LOGGER.debug("\u4fee\u6539\u9891\u9053\u54c1\u724c\u6210\u529f\uff01");
            } else {
                LOGGER.debug("\u4fee\u6539\u9891\u9053\u54c1\u724c\u5931\u8d25\uff01");
            }
        }
        catch (Exception e) {
            LOGGER.error("\u4fee\u6539\u9891\u9053\u54c1\u724c\u5f02\u5e38\uff01", (Throwable)e);
        }
        mav.setView((View)new RedirectView(QUERYSTOREYTAGTRADEMARKBYPAGEBEAN_HTM + storeyTagId + "&CSRFToken=" + request.getParameter("CSRFToken")));
        return mav;
    }

    @RequestMapping(value={"/deleteStoreyTagTrademark"})
    public void deleteStoreyTagTrademark(HttpServletRequest request, HttpServletResponse response) {
        String[] trademarkIds = request.getParameterValues("trademarkIds[]");
        Long loginUserId = (Long)request.getSession().getAttribute(LOGINUSERID);
        if (null == loginUserId) {
            loginUserId = 1L;
        }
        for (int i = 0; i < trademarkIds.length; ++i) {
            this.channelTrademarkService.deleteChannelTrademark(Long.valueOf(trademarkIds[i]), loginUserId);
        }
        String customerName = (String)request.getSession().getAttribute(NAME);
        OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u5220\u9664\u697c\u5c42\u6807\u7b7e\u54c1\u724c", (String)(request.getSession().getAttribute(OPERAPATH) + LOGGERINFO1 + customerName));
    }

    public ChannelTrademarkService getChannelTrademarkService() {
        return this.channelTrademarkService;
    }

    @Resource(name="ChannelTrademarkService")
    public void setChannelTrademarkService(ChannelTrademarkService channelTrademarkService) {
        this.channelTrademarkService = channelTrademarkService;
    }

    public ChannelStoreyService getChannelStoreyService() {
        return this.channelStoreyService;
    }

    @Resource(name="ChannelStoreyService")
    public void setChannelStoreyService(ChannelStoreyService channelStoreyService) {
        this.channelStoreyService = channelStoreyService;
    }

    public ChannelStoreyTagService getChannelStoreyTagService() {
        return this.channelStoreyTagService;
    }

    @Resource(name="ChannelStoreyTagService")
    public void setChannelStoreyTagService(ChannelStoreyTagService channelStoreyTagService) {
        this.channelStoreyTagService = channelStoreyTagService;
    }
}

