/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.system.controller;

import com.qianjiang.operlog.util.IPAddress;
import com.qianjiang.operlog.util.OperaLogUtil;
import com.qianjiang.system.bean.ExpressConf;
import com.qianjiang.system.bean.LogisticsCompany;
import com.qianjiang.system.cache.IDictionarysCache;
import com.qianjiang.system.controller.BaseController;
import com.qianjiang.system.service.IExpressConfBiz;
import com.qianjiang.system.service.ILogisticsCompanyBiz;
import com.qianjiang.util.MyLogger;
import com.qianjiang.util.PageBean;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller(value="expressConfController")
public class ExpressConfController
extends BaseController {
    private static final MyLogger LOGGER = new MyLogger(ExpressConfController.class);
    private static final String[] DICTIONARYS_LIST = new String[0];
    private static final String INIT_EXPRESSCONF = "initExpressConf.htm";
    private static final String ADD_EXPRESSCONF_JSP = "jsp/system/express/expressconf_add";
    private static final String EXPRESSCONF_LIST_JSP = "jsp/system/express/expressconf_list";
    private static final String UPDATE_EXPRESSCONF_JSP = "jsp/system/express/expressconf_update";
    private static final String READ_EXPRESSCONF_JSP = "jsp/system/express/expressconf_read";
    private static final String DELETESTATUS = "deleteStatus";
    private static final String MSG = "msg";
    private static final String EXPRESSCONF = "expressConf";
    private static final String IDS = "ids";
    public static final String NAME = "name";
    public static final String OPERAPATH = "operaPath";
    private static final String INITEXPRESSCONF_HTM = "initExpressConf.htm";
    private static final String LOGGERINFO1 = ",\u7528\u6237\u540d:";
    @Resource(name="expressConfBizImpl")
    private IExpressConfBiz expressConfBizImpl;
    @Resource(name="dictionarysCache")
    private IDictionarysCache dictionarysCache;
    @Resource(name="logisticsCompanyBizImpl")
    private ILogisticsCompanyBiz logisticsCompanyBizImpl;

    @RequestMapping(value={"/initExpressConf"})
    public ModelAndView initExpressConf(PageBean pageBean, @RequestParam(value="deleteStatus", required=false, defaultValue="0") Integer deleteStatus, HttpServletRequest request) {
        pageBean.setUrl("initExpressConf.htm");
        ModelAndView mav = new ModelAndView();
        mav.setViewName(EXPRESSCONF_LIST_JSP);
        HashMap<String, Integer> pa = new HashMap<String, Integer>(1);
        pa.put(DELETESTATUS, deleteStatus);
        mav.addObject("pageBean", (Object)this.expressConfBizImpl.getExpressConfByField(pa, pageBean));
        mav.addObject(DELETESTATUS, (Object)deleteStatus);
        mav.addObject(MSG, request.getAttribute(MSG));
        mav.addObject(MSG, (Object)request.getParameter(MSG));
        this.fullDictionarys(mav);
        mav.addObject("deleteObjectSize", (Object)this.getDeleteObjectSize());
        return mav;
    }

    @RequestMapping(value={"/changeUserdStatus"})
    public ModelAndView changeUserdStatus(String usedStatus, int expressId, HttpServletRequest request) {
        try {
            ExpressConf expressConf = this.expressConfBizImpl.getExpressConfById(expressId);
            expressConf.setUsedStatus(usedStatus);
            this.expressConfBizImpl.updateExpressConf(expressConf);
            String customerName = (String)request.getSession().getAttribute(NAME);
            OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u4fee\u6539\u81ea\u63d0\u70b9\u542f\u7528\u72b6\u6001", (String)request.getSession().getAttribute(OPERAPATH).toString());
        }
        catch (Exception e) {
            LOGGER.error("\u4fee\u6539\u81ea\u63d0\u70b9\u542f\u7528\u72b6\u6001\uff1a=>", (Throwable)e);
        }
        return new ModelAndView((View)new RedirectView("initExpressConf.htm"));
    }

    private int getDeleteObjectSize() {
        HashMap<String, Integer> pa = new HashMap<String, Integer>(1);
        pa.put(DELETESTATUS, 1);
        try {
            return this.expressConfBizImpl.getExpressConfByFieldTotal(pa);
        }
        catch (Exception e) {
            LOGGER.error("\u83b7\u5f97\u5220\u9664\u5bf9\u8c61\u7684\u6570\u91cf\u5f02\u5e38\uff01", (Throwable)e);
            return 0;
        }
    }

    @RequestMapping(value={"/openAddExpressConfPage"})
    public ModelAndView openAddExpressConfPage(HttpServletRequest request) {
        ModelAndView mav = new ModelAndView();
        mav.setViewName(ADD_EXPRESSCONF_JSP);
        this.fullDictionarys(mav);
        return mav;
    }

    @RequestMapping(value={"/addExpressConf"})
    public ModelAndView addExpressConf(@Valid ExpressConf expressConf, BindingResult bindingResult, HttpServletRequest request) {
        if (bindingResult.hasErrors()) {
            return new ModelAndView((View)new RedirectView("initExpressConf.htm"));
        }
        ModelAndView mav = new ModelAndView();
        try {
            expressConf.setInsertDate(new Date());
            Long loginUserId = this.getLoginUserId(request);
            expressConf.setInsertId(loginUserId.intValue());
            expressConf.setDeleteStatus(0);
            boolean flag = this.expressConfBizImpl.saveExpressConf(expressConf);
            if (!flag) {
                mav.addObject(MSG, (Object)"\u4fdd\u5b58\u914d\u9001\u65b9\u5f0f\u8bbe\u7f6e\u5931\u8d25\uff01");
                return this.backAddPage(expressConf, mav);
            }
            String customerName = (String)request.getSession().getAttribute(NAME);
            OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u6dfb\u52a0\u914d\u9001\u65b9\u5f0f", (String)(request.getSession().getAttribute(OPERAPATH) + LOGGERINFO1 + customerName));
            mav.addObject(MSG, (Object)"\u4fdd\u5b58\u914d\u9001\u65b9\u5f0f\u8bbe\u7f6e\u6210\u529f\uff01");
            mav.setView((View)new RedirectView("initExpressConf.htm"));
        }
        catch (Exception e) {
            LOGGER.error("\u6dfb\u52a0\u914d\u9001\u65b9\u5f0f\u9519\u8bef\uff1a=>", (Throwable)e);
            mav.addObject(MSG, (Object)"\u4fdd\u5b58\u914d\u9001\u65b9\u5f0f\u8bbe\u7f6e\u5931\u8d25\uff01");
            return this.backAddPage(expressConf, mav);
        }
        return mav;
    }

    private Long getLoginUserId(HttpServletRequest request) {
        Long loginUserId = (Long)request.getSession().getAttribute("loginUserId");
        if (null == loginUserId) {
            loginUserId = 1L;
        }
        return loginUserId;
    }

    private ModelAndView backAddPage(ExpressConf expressConf, ModelAndView mav) {
        this.fullDictionarys(mav);
        mav.addObject(EXPRESSCONF, (Object)expressConf);
        mav.setViewName(ADD_EXPRESSCONF_JSP);
        return mav;
    }

    @RequestMapping(value={"/openUpdateExpressConfPage"})
    public ModelAndView openUpdateExpressConfPage(@RequestParam(value="id") Integer id) {
        ModelAndView mav = new ModelAndView();
        try {
            this.fullDictionarys(mav);
            mav.addObject(EXPRESSCONF, (Object)this.expressConfBizImpl.getExpressConfById(id.intValue()));
            mav.setViewName(UPDATE_EXPRESSCONF_JSP);
        }
        catch (Exception e) {
            LOGGER.error("\u52a0\u8f7d\u914d\u9001\u65b9\u5f0f\u8bbe\u7f6e\u5bf9\u8c61\u5931\u8d25\uff01", (Throwable)e);
            mav.addObject(MSG, (Object)"\u52a0\u8f7d\u914d\u9001\u65b9\u5f0f\u8bbe\u7f6e\u5bf9\u8c61\u5931\u8d25\uff01");
            mav.setView((View)new RedirectView("initExpressConf.htm"));
            return mav;
        }
        return mav;
    }

    @RequestMapping(value={"/selectExpressConfById"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public ExpressConf selectExpressConf(Integer expressId) {
        return this.expressConfBizImpl.getExpressConfById(expressId.intValue());
    }

    @RequestMapping(value={"/updateExpressConf"})
    public ModelAndView updateExpressConf(@Valid ExpressConf expressConf, BindingResult bindingResult, HttpServletRequest request) {
        if (bindingResult.hasErrors()) {
            return new ModelAndView((View)new RedirectView("initExpressConf.htm"));
        }
        ModelAndView mav = new ModelAndView();
        try {
            expressConf.setModifyDate(new Date());
            Long loginUserId = this.getLoginUserId(request);
            expressConf.setModifyId(loginUserId.intValue());
            if (this.expressConfBizImpl.updateExpressConf(expressConf) < 1) {
                mav.addObject(MSG, (Object)"\u4fee\u6539\u914d\u9001\u65b9\u5f0f\u8bbe\u7f6e\u5931\u8d25\uff01");
                return this.backUpdatePage(expressConf, mav);
            }
            String customerName = (String)request.getSession().getAttribute(NAME);
            OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u4fee\u6539\u914d\u9001\u65b9\u5f0f", (String)(request.getSession().getAttribute(OPERAPATH) + LOGGERINFO1 + customerName));
            mav.addObject(MSG, (Object)"\u4fee\u6539\u914d\u9001\u65b9\u5f0f\u8bbe\u7f6e\u6210\u529f\uff01");
            mav.setView((View)new RedirectView("initExpressConf.htm"));
        }
        catch (Exception e) {
            LOGGER.error("\u4fee\u6539\u914d\u9001\u65b9\u5f0f\u9519\u8bef\uff1a=>", (Throwable)e);
            mav.addObject(MSG, (Object)"\u4fee\u6539\u914d\u9001\u65b9\u5f0f\u8bbe\u7f6e\u5931\u8d25\uff01");
            return this.backUpdatePage(expressConf, mav);
        }
        return mav;
    }

    private ModelAndView backUpdatePage(ExpressConf expressConf, ModelAndView mav) {
        this.fullDictionarys(mav);
        mav.addObject(EXPRESSCONF, (Object)expressConf);
        mav.setViewName(UPDATE_EXPRESSCONF_JSP);
        return mav;
    }

    @RequestMapping(value={"/readExpressConf"})
    public ModelAndView readExpressConf(@RequestParam(value="deleteStatus", required=false, defaultValue="0") Integer deleteStatus, @RequestParam(value="id") Integer id) {
        ModelAndView mav = new ModelAndView();
        mav.addObject(DELETESTATUS, (Object)deleteStatus);
        if (id == 0) {
            mav.addObject(MSG, (Object)"\u914d\u9001\u65b9\u5f0f\u8bbe\u7f6e\u5bf9\u8c61id\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u6267\u884c\u67e5\u8be2\uff01");
            mav.setView((View)new RedirectView("initExpressConf.htm"));
        } else {
            mav.setViewName(READ_EXPRESSCONF_JSP);
            mav.addObject(EXPRESSCONF, (Object)this.expressConfBizImpl.getExpressConfById(id.intValue()));
        }
        this.fullDictionarys(mav);
        return mav;
    }

    @RequestMapping(value={"/deleteExpressConf"})
    public ModelAndView deleteExpressConf(@RequestParam(value="deleteStatus", required=false, defaultValue="0") Integer deleteStatus, @RequestParam(value="ids") String ids, HttpServletRequest request) {
        ModelAndView mav = new ModelAndView();
        mav.setView((View)new RedirectView("initExpressConf.htm"));
        if (ids == null || ids.trim().length() == 0) {
            mav.addObject(MSG, (Object)"\u5bf9\u8c61id\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u6267\u884c\u5220\u9664\u914d\u9001\u65b9\u5f0f\u8bbe\u7f6e\u64cd\u4f5c\uff01");
            return mav;
        }
        try {
            if (deleteStatus == 1) {
                if (this.expressConfBizImpl.deleteExpressConf(ids) >= 1) {
                    mav.addObject(MSG, (Object)"\u5220\u9664\u914d\u9001\u65b9\u5f0f\u8bbe\u7f6e\u6210\u529f\uff01");
                } else {
                    mav.addObject(MSG, (Object)"\u5220\u9664\u914d\u9001\u65b9\u5f0f\u8bbe\u7f6e\u5931\u8d25\uff01");
                }
            } else {
                HashMap<String, Object> pa = new HashMap<String, Object>(2);
                pa.put(DELETESTATUS, 1);
                pa.put(IDS, ids);
                if (this.expressConfBizImpl.updateExpressConfFieldById(pa) >= 1) {
                    String customerName = (String)request.getSession().getAttribute(NAME);
                    OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u5220\u9664\u914d\u9001\u65b9\u5f0f", (String)(request.getSession().getAttribute(OPERAPATH) + LOGGERINFO1 + customerName));
                    mav.addObject(MSG, (Object)"\u5220\u9664\u914d\u9001\u65b9\u5f0f\u8bbe\u7f6e\u5230\u56de\u6536\u7ad9\u6210\u529f\uff01");
                } else {
                    mav.addObject(MSG, (Object)"\u5220\u9664\u914d\u9001\u65b9\u5f0f\u8bbe\u7f6e\u5230\u56de\u6536\u7ad9\u5931\u8d25\uff01");
                }
            }
            mav.addObject(DELETESTATUS, (Object)deleteStatus);
        }
        catch (Exception e) {
            LOGGER.error("\u5220\u9664\u914d\u9001\u65b9\u5f0f\u9519\u8bef\uff1a=>", (Throwable)e);
            mav.addObject(MSG, (Object)"\u5220\u9664\u914d\u9001\u65b9\u5f0f\u8bbe\u7f6e\u5931\u8d25\uff01");
        }
        return mav;
    }

    @RequestMapping(value={"/restoreExpressConf"})
    public ModelAndView restoreExpressConf(@RequestParam(value="ids") String ids) {
        ModelAndView mav = new ModelAndView();
        mav.setView((View)new RedirectView("initExpressConf.htm"));
        mav.addObject(DELETESTATUS, (Object)1);
        if (ids == null || ids.trim().length() == 0) {
            mav.addObject(MSG, (Object)"\u5bf9\u8c61id\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u6267\u884c\u8fd8\u539f\u5220\u9664\u914d\u9001\u65b9\u5f0f\u8bbe\u7f6e\u64cd\u4f5c\uff01");
            return mav;
        }
        try {
            HashMap<String, Object> pa = new HashMap<String, Object>(2);
            pa.put(DELETESTATUS, 0);
            pa.put(IDS, ids);
            if (this.expressConfBizImpl.updateExpressConfFieldById(pa) >= 1) {
                mav.addObject(MSG, (Object)"\u5220\u9664\u914d\u9001\u65b9\u5f0f\u8bbe\u7f6e\u5230\u56de\u6536\u7ad9\u6210\u529f\uff01");
            } else {
                mav.addObject(MSG, (Object)"\u5220\u9664\u914d\u9001\u65b9\u5f0f\u8bbe\u7f6e\u5230\u56de\u6536\u7ad9\u5931\u8d25\uff01");
            }
        }
        catch (Exception e) {
            LOGGER.error("\u8fd8\u539f\u5220\u9664\u914d\u9001\u65b9\u5f0f\u8bbe\u7f6e\u5bf9\u8c61\u5f02\u5e38\uff01", (Throwable)e);
            mav.addObject(MSG, (Object)"\u8fd8\u539f\u5220\u9664\u914d\u9001\u65b9\u5f0f\u8bbe\u7f6e\u5931\u8d25\uff01");
        }
        return mav;
    }

    @RequestMapping(value={"/queryExpressConf"})
    public ModelAndView queryExpressConf(@RequestParam(value="deleteStatus", required=false, defaultValue="0") Integer deleteStatus, @RequestParam(value="price", required=false, defaultValue="0") Double price, String expressName, PageBean pageBean) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        ModelAndView mav = new ModelAndView();
        mav.setViewName(EXPRESSCONF_LIST_JSP);
        if (price != null && price > 0.0) {
            param.put("price", price);
            mav.addObject("price", (Object)price);
        }
        param.put(NAME, expressName);
        mav.addObject("expressName", (Object)expressName);
        param.put(DELETESTATUS, deleteStatus);
        mav.addObject(DELETESTATUS, (Object)deleteStatus);
        this.fullDictionarys(mav);
        try {
            mav.addObject("pageBean", (Object)this.expressConfBizImpl.getExpressConfByField(param, pageBean));
        }
        catch (Exception e) {
            LOGGER.error("\u67e5\u8be2\u914d\u9001\u65b9\u5f0f\u8bbe\u7f6e\u4fe1\u606f\u5f02\u5e38\uff01", (Throwable)e);
        }
        return mav;
    }

    @RequestMapping(value={"/changeUserdStatusForExpress"})
    public ModelAndView changeUserdStatusForExpress(Long expressId) {
        try {
            if (this.expressConfBizImpl.changeUserdStatus(expressId)) {
                LOGGER.debug("===============\u914d\u9001\u65b9\u5f0f\u542f\u7528\u72b6\u6001\u4fee\u6539\u6210\u529f");
            } else {
                LOGGER.debug("===============\u914d\u9001\u65b9\u5f0f\u542f\u7528\u72b6\u6001\u4fee\u6539\u5931\u8d25");
            }
        }
        catch (Exception e) {
            LOGGER.error("\u4fee\u6539\u914d\u9001\u65b9\u5f0f\u542f\u7528\u72b6\u6001\u9519\u8bef\uff1a=>", (Throwable)e);
        }
        return new ModelAndView((View)new RedirectView("initExpressConf.htm"));
    }

    private void fullDictionarys(ModelAndView mav) {
        for (String dep : DICTIONARYS_LIST) {
            try {
                mav.addObject(dep, this.dictionarysCache.getDictionaryByName(dep));
            }
            catch (Exception e) {
                LOGGER.error("\u83b7\u5f97\u5b57\u5178\u7f13\u5b58\u5f02\u5e38\uff0c\u5b57\u5178\u540d\uff1a" + dep, (Throwable)e);
            }
        }
        PageBean pg = new PageBean();
        pg.setPageSize(1000);
        HashMap<String, Integer> pa = new HashMap<String, Integer>(2);
        pa.put("usedStatus", 1);
        pa.put(DELETESTATUS, 0);
        try {
            mav.addObject("sysDicExpress", (Object)this.logisticsCompanyBizImpl.getLogisticsCompanyByField(pa, pg).getList());
        }
        catch (Exception e) {
            LOGGER.error("\u83b7\u5f97\u914d\u7f6e\u7684\u8d27\u8fd0\u516c\u5f02\u5e38\uff01", (Throwable)e);
        }
    }

    @RequestMapping(value={"/selectAllLogistics"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public List<LogisticsCompany> selectAllLogistics() {
        return this.logisticsCompanyBizImpl.queryAllLogisticsCompany();
    }

    @RequestMapping(value={"/deleteBatchExpressConf"})
    public ModelAndView deleteBatchExpressConf(Integer[] expressIds) {
        for (Integer expressId : expressIds) {
            this.expressConfBizImpl.deleteOneExpressConf(expressId);
        }
        ModelAndView mav = new ModelAndView();
        mav.setView((View)new RedirectView("initExpressConf.htm"));
        return mav;
    }

    @RequestMapping(value={"/deleteOneExpressConf"})
    public ModelAndView deleteOneExpressConf(Integer expressId) {
        this.expressConfBizImpl.deleteOneExpressConf(expressId);
        ModelAndView mav = new ModelAndView();
        mav.setView((View)new RedirectView("initExpressConf.htm"));
        return mav;
    }
}

