/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.system.controller;

import com.qianjiang.operlog.util.IPAddress;
import com.qianjiang.operlog.util.OperaLogUtil;
import com.qianjiang.system.bean.SeoConf;
import com.qianjiang.system.cache.IDictionarysCache;
import com.qianjiang.system.service.ISeoConfBiz;
import com.qianjiang.util.CreateSiteMap;
import com.qianjiang.util.HtmlParser;
import com.qianjiang.util.MyLogger;
import com.qianjiang.util.PageBean;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller(value="seoConfController")
public class SeoConfController {
    private static final MyLogger LOGGER = new MyLogger(SeoConfController.class);
    private static final String LOGGERINFO1 = ",\u7528\u6237\u540d:";
    private static final String[] DICTIONARYS_LIST = new String[0];
    private static final String INIT_SEOCONF = "initSeoConf.htm";
    private static final String ADD_SEOCONF_JSP = "jsp/system/seo/seoconf_add";
    private static final String SEOCONF_LIST_JSP = "jsp/system/seo/seoconf_list";
    private static final String UPDATE_SEOCONF_JSP = "jsp/system/seo/seoconf_update";
    private static final String UPDATE_WEBSITEMAP_JSP = "jsp/system/seo/websitemap_update";
    private static final String UPDATE_ROBOTS_JSP = "jsp/system/seo/robots_update";
    private static final String READ_SEOCONF_JSP = "jsp/system/seo/seoconf_read";
    private static final String DELETESTATUS = "deleteStatus";
    private static final String MSG = "msg";
    private static final String SEOCONF = "seoConf";
    private static final String IDS = "ids";
    private static final String SEOTITLE = "seoTitle";
    private static final String SEOCODE = "seoCode";
    public static final String NAME = "name";
    public static final String OPERAPATH = "operaPath";
    private SeoConf seoConf;
    private ISeoConfBiz seoConfBizImpl;
    private IDictionarysCache dictionarysCache;

    @RequestMapping(value={"/initSeoConf"})
    public ModelAndView initSeoConf(PageBean pageBean, HttpServletRequest request) {
        pageBean.setUrl(INIT_SEOCONF);
        ModelAndView mav = new ModelAndView();
        mav.setViewName(SEOCONF_LIST_JSP);
        HashMap pa = new HashMap(1);
        mav.addObject("pageBean", (Object)this.seoConfBizImpl.getSeoConfByField(pa, pageBean));
        mav.addObject(MSG, request.getAttribute(MSG));
        mav.addObject(MSG, (Object)request.getParameter(MSG));
        mav.addObject("deleteObjectSize", (Object)this.getDeleteObjectSize());
        return mav;
    }

    private int getDeleteObjectSize() {
        HashMap<String, Integer> pa = new HashMap<String, Integer>(1);
        pa.put(DELETESTATUS, 1);
        try {
            return this.seoConfBizImpl.getSeoConfByFieldTotal(pa);
        }
        catch (Exception e) {
            LOGGER.error("\u83b7\u5f97\u5220\u9664\u5bf9\u8c61\u7684\u6570\u91cf\u5f02\u5e38\uff01", (Throwable)e);
            return 0;
        }
    }

    @RequestMapping(value={"/openAddSeoConfPage"})
    public ModelAndView openAddSeoConfPage(HttpServletRequest request) {
        ModelAndView mav = new ModelAndView();
        mav.setViewName(ADD_SEOCONF_JSP);
        this.fullDictionarys(mav);
        return mav;
    }

    @RequestMapping(value={"/addSeoConf"})
    public ModelAndView addSeoConf(@Valid SeoConf seoConf, BindingResult bindingResult, HttpServletRequest request) {
        if (bindingResult.hasErrors()) {
            return new ModelAndView((View)new RedirectView(INIT_SEOCONF));
        }
        ModelAndView mav = new ModelAndView();
        try {
            seoConf.setInsertDate(new Date());
            seoConf.setInsertId(((Long)request.getSession().getAttribute("loginUserId")).intValue());
            seoConf.setDeleteStatus(0);
            boolean flag = this.seoConfBizImpl.saveSeoConf(seoConf);
            if (!flag) {
                mav.addObject(MSG, (Object)"\u4fdd\u5b58SEO\u8bbe\u7f6e\u5931\u8d25\uff01");
                return this.backAddPage(seoConf, mav);
            }
            String customerName = (String)request.getSession().getAttribute(NAME);
            OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u6dfb\u52a0SEO\u8bbe\u7f6e", (String)(request.getSession().getAttribute(OPERAPATH) + LOGGERINFO1 + customerName));
            mav.addObject(MSG, (Object)"\u4fdd\u5b58SEO\u8bbe\u7f6e\u6210\u529f\uff01");
            mav.setView((View)new RedirectView(INIT_SEOCONF));
        }
        catch (Exception e) {
            LOGGER.error("\u6dfb\u52a0SEO\u8bbe\u7f6e\u9519\u8bef\uff1a=>", (Throwable)e);
            mav.addObject(MSG, (Object)"\u4fdd\u5b58SEO\u8bbe\u7f6e\u5931\u8d25\uff01");
            return this.backAddPage(seoConf, mav);
        }
        return mav;
    }

    private ModelAndView backAddPage(SeoConf seoConf, ModelAndView mav) {
        this.fullDictionarys(mav);
        mav.addObject(SEOCONF, (Object)seoConf);
        mav.setViewName(ADD_SEOCONF_JSP);
        return mav;
    }

    @RequestMapping(value={"/openUpdateSeoConfPage"})
    public ModelAndView openUpdateSeoConfPage(@RequestParam(value="id") int id) {
        ModelAndView mav = new ModelAndView();
        try {
            this.fullDictionarys(mav);
            mav.addObject(SEOCONF, (Object)this.seoConfBizImpl.getSeoConfById(id));
            mav.setViewName(UPDATE_SEOCONF_JSP);
        }
        catch (Exception e) {
            LOGGER.error("\u52a0\u8f7dSEO\u8bbe\u7f6e\u5bf9\u8c61\u5931\u8d25\uff01", (Throwable)e);
            mav.addObject(MSG, (Object)"\u52a0\u8f7dSEO\u8bbe\u7f6e\u5bf9\u8c61\u5931\u8d25\uff01");
            mav.setView((View)new RedirectView(INIT_SEOCONF));
            return mav;
        }
        return mav;
    }

    @RequestMapping(value={"/openSeoWebsitemapPage"})
    public ModelAndView openSeoPcPage(@RequestParam(value="id") int id) {
        ModelAndView mav = new ModelAndView();
        try {
            this.fullDictionarys(mav);
            mav.addObject(SEOCONF, (Object)this.seoConfBizImpl.getSeoConfById(id));
            mav.setViewName(UPDATE_WEBSITEMAP_JSP);
        }
        catch (Exception e) {
            LOGGER.error("\u52a0\u8f7dSEO\u7f51\u7ad9\u5730\u56fe\u8bbe\u7f6e\u5bf9\u8c61\u5931\u8d25\uff01", (Throwable)e);
            mav.addObject(MSG, (Object)"\u52a0\u8f7dSEO\u7f51\u7ad9\u5730\u56fe\u8bbe\u7f6e\u5bf9\u8c61\u5931\u8d25\uff01");
            mav.setView((View)new RedirectView(INIT_SEOCONF));
            return mav;
        }
        return mav;
    }

    @RequestMapping(value={"/openSeoRobotsPage"})
    public ModelAndView openSeoRobotsPage(@RequestParam(value="id") int id) {
        ModelAndView mav = new ModelAndView();
        try {
            this.fullDictionarys(mav);
            mav.addObject(SEOCONF, (Object)this.seoConfBizImpl.getSeoConfById(id));
            mav.setViewName(UPDATE_ROBOTS_JSP);
        }
        catch (Exception e) {
            LOGGER.error("\u52a0\u8f7dSEORobots\u8bbe\u7f6e\u5bf9\u8c61\u5931\u8d25\uff01", (Throwable)e);
            mav.addObject(MSG, (Object)"\u52a0\u8f7dSEORobots\u8bbe\u7f6e\u5bf9\u8c61\u5931\u8d25\uff01");
            mav.setView((View)new RedirectView(INIT_SEOCONF));
            return mav;
        }
        return mav;
    }

    @RequestMapping(value={"/updateSeoConf"})
    public ModelAndView updateSeoConf(@Valid SeoConf seoConf, BindingResult bindingResult, HttpServletRequest request) {
        if (bindingResult.hasErrors()) {
            return new ModelAndView((View)new RedirectView(INIT_SEOCONF));
        }
        ModelAndView mav = new ModelAndView();
        try {
            seoConf.setModifyDate(new Date());
            seoConf.setModifyId(((Long)request.getSession().getAttribute("loginUserId")).intValue());
            this.seoConfBizImpl.updateSeoConf(seoConf);
            String customerName = (String)request.getSession().getAttribute(NAME);
            if ("1".equals(seoConf.getType())) {
                OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u4fee\u6539SEO\u8bbe\u7f6e", (String)(request.getSession().getAttribute(OPERAPATH) + LOGGERINFO1 + customerName));
            } else if ("2".equals(seoConf.getType())) {
                OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u4fee\u6539\u7f51\u7ad9\u5730\u56fe\u8bbe\u7f6e", (String)(request.getSession().getAttribute(OPERAPATH) + LOGGERINFO1 + customerName));
            } else if ("3".equals(seoConf.getType())) {
                OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u4fee\u6539Roborts\u6587\u4ef6\u8bbe\u7f6e", (String)(request.getSession().getAttribute(OPERAPATH) + LOGGERINFO1 + customerName));
                String path = request.getSession().getServletContext().getRealPath("/");
                String basePath = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + "/";
                this.seoConfBizImpl.createRoborts(seoConf, path, basePath);
            }
            mav.setView((View)new RedirectView(INIT_SEOCONF));
        }
        catch (Exception e) {
            LOGGER.error("\u4fee\u6539SEO\u8bbe\u7f6e\u9519\u8bef\uff1a=>", (Throwable)e);
            return this.backUpdatePage(seoConf, mav);
        }
        return mav;
    }

    @RequestMapping(value={"/createSitemap"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String createSitemap(SeoConf seoConf, HttpServletRequest request) {
        try {
            HtmlParser a = new HtmlParser(seoConf.getUrl());
            Collection s = a.getHrefList();
            String path = request.getSession().getServletContext().getRealPath("/");
            String mallpath = new File(path).getParent();
            File fl = new File(mallpath + "/site/sitemap.xml");
            if (!fl.exists()) {
                fl.createNewFile();
            }
            FileWriter wt = new FileWriter(fl);
            CreateSiteMap.writeUrlset((Writer)wt, s.iterator());
            ((Writer)wt).close();
            this.seoConfBizImpl.updateSeoConf(seoConf);
            String customerName = (String)request.getSession().getAttribute(NAME);
            OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u751f\u6210\u7f51\u7ad9\u5730\u56fe", (String)(request.getSession().getAttribute(OPERAPATH) + LOGGERINFO1 + customerName));
            return "1";
        }
        catch (Exception e) {
            LOGGER.error("\u751f\u6210\u7f51\u7ad9\u5730\u56fe\u5931\u8d25", (Throwable)e);
            return "0";
        }
    }

    private ModelAndView backUpdatePage(SeoConf seoConf, ModelAndView mav) {
        this.fullDictionarys(mav);
        mav.addObject(SEOCONF, (Object)seoConf);
        if ("1".equals(seoConf.getType())) {
            mav.setViewName(UPDATE_SEOCONF_JSP);
        } else if ("2".equals(seoConf.getType())) {
            mav.setViewName(UPDATE_WEBSITEMAP_JSP);
        } else {
            mav.setViewName(UPDATE_ROBOTS_JSP);
        }
        return mav;
    }

    @RequestMapping(value={"/readSeoConf"})
    public ModelAndView readSeoConf(@RequestParam(value="deleteStatus", required=false, defaultValue="0") Integer deleteStatus, @RequestParam(value="id") int id) {
        ModelAndView mav = new ModelAndView();
        mav.addObject(DELETESTATUS, (Object)deleteStatus);
        if (id == 0) {
            mav.addObject(MSG, (Object)"SEO\u8bbe\u7f6e\u5bf9\u8c61id\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u6267\u884c\u67e5\u8be2\uff01");
            mav.setView((View)new RedirectView(INIT_SEOCONF));
        } else {
            mav.setViewName(READ_SEOCONF_JSP);
            mav.addObject(SEOCONF, (Object)this.seoConfBizImpl.getSeoConfById(id));
        }
        return mav;
    }

    @RequestMapping(value={"/deleteSeoConf"})
    public ModelAndView deleteSeoConf(@RequestParam(value="deleteStatus", required=false, defaultValue="0") Integer deleteStatus, @RequestParam(value="ids") String ids, HttpServletRequest request) {
        ModelAndView mav = new ModelAndView();
        mav.setView((View)new RedirectView(INIT_SEOCONF));
        if (ids == null || ids.trim().length() == 0) {
            mav.addObject(MSG, (Object)"\u5bf9\u8c61id\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u6267\u884c\u5220\u9664SEO\u8bbe\u7f6e\u64cd\u4f5c\uff01");
            return mav;
        }
        try {
            if (deleteStatus == 1) {
                if (this.seoConfBizImpl.deleteSeoConf(ids) >= 1) {
                    String customerName = (String)request.getSession().getAttribute(NAME);
                    OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u5220\u9664SEO\u8bbe\u7f6e", (String)(request.getSession().getAttribute(OPERAPATH) + LOGGERINFO1 + customerName));
                    mav.addObject(MSG, (Object)"\u5220\u9664SEO\u8bbe\u7f6e\u6210\u529f\uff01");
                } else {
                    mav.addObject(MSG, (Object)"\u5220\u9664SEO\u8bbe\u7f6e\u5931\u8d25\uff01");
                }
            } else {
                HashMap<String, Object> pa = new HashMap<String, Object>(2);
                pa.put(DELETESTATUS, 1);
                pa.put(IDS, ids);
                if (this.seoConfBizImpl.updateSeoConfFieldById(pa) >= 1) {
                    mav.addObject(MSG, (Object)"\u5220\u9664SEO\u8bbe\u7f6e\u5230\u56de\u6536\u7ad9\u6210\u529f\uff01");
                } else {
                    mav.addObject(MSG, (Object)"\u5220\u9664SEO\u8bbe\u7f6e\u5230\u56de\u6536\u7ad9\u5931\u8d25\uff01");
                }
            }
            mav.addObject(DELETESTATUS, (Object)deleteStatus);
        }
        catch (Exception e) {
            LOGGER.error("\u5220\u9664SEO\u8bbe\u7f6e\u9519\u8bef\uff1a=>", (Throwable)e);
            mav.addObject(MSG, (Object)"\u5220\u9664SEO\u8bbe\u7f6e\u5931\u8d25\uff01");
        }
        return mav;
    }

    @RequestMapping(value={"/deleteSeoConfBatch"})
    public ModelAndView deleteSeoConf(Long[] seoIds, HttpServletRequest request) {
        ModelAndView mav = new ModelAndView();
        mav.setView((View)new RedirectView(INIT_SEOCONF));
        for (Long seoId : seoIds) {
            this.seoConfBizImpl.deleteSeoConf(seoId);
        }
        return mav;
    }

    @RequestMapping(value={"/restoreSeoConf"})
    public ModelAndView restoreSeoConf(@RequestParam(value="ids") String ids) {
        ModelAndView mav = new ModelAndView();
        mav.setView((View)new RedirectView(INIT_SEOCONF));
        mav.addObject(DELETESTATUS, (Object)1);
        if (ids == null || ids.trim().length() == 0) {
            mav.addObject(MSG, (Object)"\u5bf9\u8c61id\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u6267\u884c\u8fd8\u539f\u5220\u9664SEO\u8bbe\u7f6e\u64cd\u4f5c\uff01");
            return mav;
        }
        try {
            HashMap<String, Object> pa = new HashMap<String, Object>(2);
            pa.put(DELETESTATUS, 0);
            pa.put(IDS, ids);
            if (this.seoConfBizImpl.updateSeoConfFieldById(pa) >= 1) {
                mav.addObject(MSG, (Object)"\u5220\u9664SEO\u8bbe\u7f6e\u5230\u56de\u6536\u7ad9\u6210\u529f\uff01");
            } else {
                mav.addObject(MSG, (Object)"\u5220\u9664SEO\u8bbe\u7f6e\u5230\u56de\u6536\u7ad9\u5931\u8d25\uff01");
            }
        }
        catch (Exception e) {
            LOGGER.error("\u8fd8\u539f\u5220\u9664SEO\u8bbe\u7f6e\u5bf9\u8c61\u5f02\u5e38\uff01", (Throwable)e);
            mav.addObject(MSG, (Object)"\u8fd8\u539f\u5220\u9664SEO\u8bbe\u7f6e\u5931\u8d25\uff01");
        }
        return mav;
    }

    @RequestMapping(value={"/updateSeoByUsedStatus"})
    public ModelAndView updateSeoByUsedStatus(int seoId, HttpServletRequest request) {
        ModelAndView mav = new ModelAndView();
        try {
            mav.setView((View)new RedirectView(INIT_SEOCONF));
            SeoConf sc = this.seoConfBizImpl.getSeoConfById(seoId);
            sc.setUsedStatus("1");
            this.seoConfBizImpl.updateSeoConf(sc);
            String customerName = (String)request.getSession().getAttribute(NAME);
            OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u4fee\u6539SEO\u542f\u7528\u72b6\u6001", (String)(request.getSession().getAttribute(OPERAPATH) + LOGGERINFO1 + customerName));
        }
        catch (Exception e) {
            LOGGER.error("\u4fee\u6539SEO\u542f\u7528\u72b6\u6001\u9519\u8bef\uff1a=>", (Throwable)e);
        }
        return mav;
    }

    @RequestMapping(value={"/querySeoConf"})
    public ModelAndView querySeoConf(@RequestParam(value="deleteStatus", required=false, defaultValue="0") Integer deleteStatus, @RequestParam(value="seoTitle", required=false, defaultValue="") String seoTitle, @RequestParam(value="seoCode", required=false, defaultValue="") String seoCode, PageBean pageBean) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        HashMap<String, String> queryParam = new HashMap<String, String>();
        if (seoTitle != null && seoTitle.trim().length() != 0) {
            param.put(SEOTITLE, seoTitle);
            queryParam.put(SEOTITLE, seoTitle);
            queryParam.put("searchField", SEOTITLE);
            queryParam.put("searchValue", seoTitle);
            queryParam.put("searchName", "\u65b9\u6848\u6807\u9898");
        }
        if (seoCode != null && seoCode.trim().length() != 0) {
            param.put(SEOCODE, seoCode);
            queryParam.put(SEOCODE, seoCode);
            queryParam.put("searchField", SEOCODE);
            queryParam.put("searchValue", seoCode);
            queryParam.put("searchName", "\u65b9\u6848\u4ee3\u7801");
        }
        ModelAndView mav = new ModelAndView();
        mav.setViewName(SEOCONF_LIST_JSP);
        mav.addObject("queryParam", queryParam);
        param.put(DELETESTATUS, deleteStatus);
        mav.addObject(DELETESTATUS, (Object)deleteStatus);
        try {
            mav.addObject("pageBean", (Object)this.seoConfBizImpl.getSeoConfByField(param, pageBean));
        }
        catch (Exception e) {
            LOGGER.error("\u67e5\u8be2SEO\u8bbe\u7f6e\u4fe1\u606f\u5f02\u5e38\uff01", (Throwable)e);
        }
        return mav;
    }

    private void fullDictionarys(ModelAndView mav) {
        for (String dep : DICTIONARYS_LIST) {
            try {
                mav.addObject(dep, this.dictionarysCache.getDictionaryByName(dep));
            }
            catch (Exception e) {
                LOGGER.error("\u83b7\u5f97\u5b57\u5178\u7f13\u5b58\u5f02\u5e38\uff0c\u5b57\u5178\u540d\uff1a" + dep, (Throwable)e);
            }
        }
    }

    public final SeoConf getSeoConf() {
        return this.seoConf;
    }

    @Resource(name="seoConf")
    public final void setSeoConf(SeoConf seoConf) {
        this.seoConf = seoConf;
    }

    public final ISeoConfBiz getSeoConfBizImpl() {
        return this.seoConfBizImpl;
    }

    @Resource(name="seoConfBizImpl")
    public final void setSeoConfBizImpl(ISeoConfBiz seoConfBizImpl) {
        this.seoConfBizImpl = seoConfBizImpl;
    }

    public final IDictionarysCache getDictionarysCache() {
        return this.dictionarysCache;
    }

    @Resource(name="dictionarysCache")
    public final void setDictionarysCache(IDictionarysCache dictionarysCache) {
        this.dictionarysCache = dictionarysCache;
    }
}

