/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.temp.controller;

import com.qianjiang.channel.service.GoodsCateService;
import com.qianjiang.goods.service.GoodsBrandService;
import com.qianjiang.information.service.InfoOPTagService;
import com.qianjiang.information.service.InformationTypeService;
import com.qianjiang.operlog.util.IPAddress;
import com.qianjiang.operlog.util.OperaLogUtil;
import com.qianjiang.redis.RedisAdapter;
import com.qianjiang.system.bean.BasicSet;
import com.qianjiang.system.bean.HelpCate;
import com.qianjiang.system.bean.HelpCateBean;
import com.qianjiang.system.service.BasicSetService;
import com.qianjiang.system.service.HelpCateService;
import com.qianjiang.system.service.HelpCenterService;
import com.qianjiang.system.service.IStatisticsCodeBiz;
import com.qianjiang.temp.bean.SysTemp;
import com.qianjiang.temp.bean.TempToken;
import com.qianjiang.temp.service.TempService;
import com.qianjiang.temp.service.TempTokenService;
import com.qianjiang.util.MyLogger;
import com.qianjiang.util.UploadUtil;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller
public class TempController {
    public static final MyLogger LOGGER = new MyLogger(TempController.class);
    private static final String VARNAME = ",\u7528\u6237\u540d:";
    public static final String NAME = "name";
    public static final String OPERAPATH = "operaPath";
    private static final Long TEMPTYPE1 = 137L;
    private static final Long TEMPTYPE2 = 139L;
    private static final Long TEMPTYPE3 = 141L;
    @Resource(name="basicSetService")
    private BasicSetService basicSetService;
    @Resource(name="statisticsCodeBizImpl")
    private IStatisticsCodeBiz statisticsCodeBizImpl;
    @Resource(name="helpCateService")
    private HelpCateService helpCateService;
    @Resource(name="helpCenterService")
    private HelpCenterService helpCenterService;
    @Resource(name="TempService")
    private TempService tempService;
    @Resource(name="InformationTypeService")
    private InformationTypeService infoTypeService;
    @Resource(name="InfoOPTagService")
    private InfoOPTagService infoOPTagService;
    @Resource(name="TempTokenService")
    private TempTokenService tempTokenService;
    @Resource(name="GoodsBrandService")
    private GoodsBrandService goodsBrandService;
    @Resource(name="ChannelGoodsCateService")
    private GoodsCateService goodsCateService;
    @Resource
    private RedisAdapter redisAdapter;

    @RequestMapping(value={"/queryTempByType"})
    public ModelAndView queryTempByType(HttpServletRequest request) {
        HashMap<String, List> map = new HashMap<String, List>();
        List indexList = this.tempService.querySystempByType(TEMPTYPE1);
        List channelList = this.tempService.querySystempByType(TEMPTYPE2);
        List singleList = this.tempService.querySystempByType(TEMPTYPE3);
        BasicSet bs = this.basicSetService.findBasicSet();
        map.put("indexList", indexList);
        map.put("channelList", channelList);
        map.put("singleList", singleList);
        return new ModelAndView("jsp/temp/temp_list", "map", map).addObject("basicset", (Object)bs);
    }

    @RequestMapping(value={"/showTempInfo"})
    public ModelAndView showTempInfo(Long tempId, HttpServletRequest request, String status) {
        return new ModelAndView("jsp/temp/show_temp", "temp", (Object)this.tempService.getSystempById(tempId)).addObject("CSRFToken", (Object)request.getParameter("CSRFToken")).addObject("infoTypeList", (Object)this.infoTypeService.selectInfoTypeByAttrForTemp()).addObject("opTagList", (Object)this.infoOPTagService.findAllInfoOPTag(tempId.toString())).addObject("brand", (Object)this.goodsBrandService.queryAllBrand()).addObject("cate", (Object)this.goodsCateService.queryAllFirstGradeGoosCate()).addObject("status", (Object)status);
    }

    @RequestMapping(value={"/showTempEdit"})
    public ModelAndView showTempEdit(HttpServletRequest req, HttpServletResponse resp, Long tempId) {
        ModelAndView mav = new ModelAndView();
        try {
            SysTemp systempById = this.tempService.getSystempById(tempId);
            mav.addObject("temp", (Object)systempById);
            List infoTypeList = this.infoTypeService.selectInfoTypeByAttrForTemp();
            mav.addObject("infoTypeList", (Object)infoTypeList);
            List queryAllBrand = this.goodsBrandService.queryAllBrand();
            mav.addObject("brand", (Object)queryAllBrand);
            List queryAllFirstGradeGoosCate = this.goodsCateService.queryAllFirstGradeGoosCate();
            mav.addObject("cate", (Object)queryAllFirstGradeGoosCate);
            BasicSet findBasicSet = this.basicSetService.findBasicSet();
            mav.addObject("basicset", (Object)findBasicSet);
            List<HelpCateBean> helpCateList = this.getHelpCateList();
            mav.addObject("helpCates", helpCateList);
            List selectAllIsFoot = this.helpCenterService.selectAllIsFoot();
            mav.addObject("helpCenters", (Object)selectAllIsFoot);
            List currStatisticsCode = this.statisticsCodeBizImpl.getCurrStatisticsCode();
            mav.addObject("sCodeList", (Object)currStatisticsCode);
            mav.setViewName("jsp/temp/show_temp_edit");
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u521d\u59cb\u5316\u6a21\u677f\u7f16\u8f91\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return mav;
    }

    private List<HelpCateBean> getHelpCateList() {
        ArrayList<HelpCateBean> helpCateBeans = new ArrayList<HelpCateBean>();
        List helpcates = this.helpCateService.findAll();
        if (null != helpcates && !helpcates.isEmpty()) {
            for (HelpCate helpCate : helpcates) {
                HelpCateBean helpCateBean = new HelpCateBean();
                helpCateBean.setHelpcateId(helpCate.getHelpcateId());
                helpCateBean.setHelpcateName(helpCate.getHelpcateName());
                helpCateBean.setHelpcateImg(helpCate.getHelpcateImg());
                helpCateBean.setHelpCenters(this.helpCenterService.findByCateId(helpCate.getHelpcateId()));
                helpCateBeans.add(helpCateBean);
            }
        }
        return helpCateBeans;
    }

    @RequestMapping(value={"selectTempView"})
    public ModelAndView selectTempView(Long tempId) {
        HashMap<String, BasicSet> topmap = new HashMap<String, BasicSet>();
        topmap.put("systembase", this.basicSetService.findBasicSet());
        return new ModelAndView("jsp/temp/temp_view").addObject("tempId", (Object)tempId).addObject("topmap", topmap);
    }

    @RequestMapping(value={"/toUpdateTempInfo"})
    public ModelAndView toUpdateTempInfo(Long tempId) {
        return new ModelAndView("jsp/temp/update_temp", "temp", (Object)this.tempService.getSystempById(tempId));
    }

    @RequestMapping(value={"/toUpdateChannelInfo"})
    public ModelAndView toUpdateChannelInfo(Long tempId) {
        return new ModelAndView("jsp/channel/update_channel", "temp", (Object)this.tempService.getSystempById(tempId));
    }

    @RequestMapping(value={"/updateTempInfo"})
    public void updateTempInfo(MultipartHttpServletRequest request, HttpServletResponse response, SysTemp temp) {
        PrintWriter out = null;
        try {
            out = response.getWriter();
            MultipartFile imageFile = request.getFile("imgSrc");
            if (!imageFile.isEmpty()) {
                temp.setTempImageUrl((String)UploadUtil.uploadFile((MultipartFile)imageFile).get("oldimg"));
            }
            int result = this.tempService.updateSystemp(temp);
            String customerName = (String)request.getSession().getAttribute(NAME);
            OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u4fee\u6539\u6a21\u677f\u4fe1\u606f", (String)(request.getSession().getAttribute(OPERAPATH) + VARNAME + customerName));
            if (result > 0) {
                out.append("<script>parent.callReload()</script>");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            LOGGER.error("", (Throwable)e);
        }
    }

    @RequestMapping(value={"/uploadChannelShowImg"})
    public void uploadChannelShowImg(MultipartHttpServletRequest request, HttpServletResponse response) {
        PrintWriter out = null;
        try {
            out = response.getWriter();
            MultipartFile file = request.getFile("imgSrc");
            if (!file.isEmpty()) {
                String picPath = UploadUtil.uploadFileOne((MultipartFile)file, (HttpServletRequest)request);
                out.append("<script>parent.callback('" + picPath + "')</script>");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            LOGGER.error("", (Throwable)e);
        }
    }

    @RequestMapping(value={"/updateTempInfoType"})
    public ModelAndView updateTempInfoType(@Valid SysTemp temp, BindingResult bindingResult, HttpServletRequest request, HttpServletResponse response) throws IOException {
        PrintWriter pw = null;
        if (bindingResult.hasErrors()) {
            return new ModelAndView((View)new RedirectView("setTemp.htm?tempId=" + temp.getTempId() + "&CSRFToken=" + request.getParameter("CSRFToken")));
        }
        this.tempService.updateSystemp(temp);
        String customerName = (String)request.getSession().getAttribute(NAME);
        OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u4fee\u6539\u6a21\u677f\u65b0\u95fb\u516c\u544a", (String)(request.getSession().getAttribute(OPERAPATH) + VARNAME + customerName));
        pw = response.getWriter();
        pw.append("<script>parent.updateOk()</script>");
        pw.flush();
        return null;
    }

    @RequestMapping(value={"/updatetempinfotypeajax"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int updateTempInfoTypeAjax(@Valid SysTemp temp, BindingResult bindingResult, HttpServletRequest request) {
        if (bindingResult.hasErrors()) {
            return 0;
        }
        String customerName = (String)request.getSession().getAttribute(NAME);
        OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u4fee\u6539\u5206\u7c7b\u5bfc\u822a", (String)(request.getSession().getAttribute(OPERAPATH) + VARNAME + customerName));
        return this.tempService.updateSystemp(temp);
    }

    @RequestMapping(value={"/setTemp"})
    public ModelAndView setTemp(Long tempId) {
        List infoTypeList = this.infoTypeService.selectInfoTypeByAttrForTemp();
        List opTagList = this.infoOPTagService.findAllInfoOPTag(tempId.toString());
        return new ModelAndView("jsp/temp/set_temp", "temp", (Object)this.tempService.getSystempById(tempId)).addObject("infoTypeList", (Object)infoTypeList).addObject("opTagList", (Object)opTagList);
    }

    @RequestMapping(value={"/setUsedStatus"})
    public ModelAndView setUsedStatus(Long tempId, HttpServletRequest request) {
        this.tempService.setUserd(tempId);
        String customerName = (String)request.getSession().getAttribute(NAME);
        OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u4fee\u6539\u5f53\u524d\u4f7f\u7528\u6a21\u677f", (String)(request.getSession().getAttribute(OPERAPATH) + VARNAME + customerName));
        return new ModelAndView((View)new RedirectView("queryTempByType.htm"));
    }

    @RequestMapping(value={"/refurbish"})
    public ModelAndView refurbish(TempToken token) {
        this.tempTokenService.updateTokenValue(token);
        this.redisAdapter.deleteAll();
        return new ModelAndView((View)new RedirectView("queryTempByType.htm"));
    }

    @RequestMapping(value={"/getsystempdetailbyid"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public SysTemp getSysTempDetailById(Long tempId) {
        return this.tempService.getSystempById(tempId);
    }
}

