/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.goods.controller;

import com.alibaba.fastjson.JSON;
import com.qianjiang.goods.bean.PageBean;
import com.qianjiang.goods.service.GoodsAtteService;
import com.qianjiang.goods.util.SelectBean;
import com.qianjiang.operlog.util.IPAddress;
import com.qianjiang.operlog.util.OperaLogUtil;
import com.qianjiang.util.MyLogger;
import java.util.HashMap;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller
public class AttentionController {
    private GoodsAtteService goodsAtteService;
    private static final MyLogger LOGGER = new MyLogger(AttentionController.class);

    public GoodsAtteService getGoodsAtteService() {
        return this.goodsAtteService;
    }

    @Resource(name="GoodsAtteService")
    public void setGoodsAtteService(GoodsAtteService goodsAtteService) {
        this.goodsAtteService = goodsAtteService;
    }

    @RequestMapping(value={"/findallgoodsatte"})
    public ModelAndView findAllGoodsAtte(PageBean pageBean, SelectBean selectBean) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("pageBean", this.goodsAtteService.queryByPageAndParam(pageBean, selectBean));
        map.put("searchBean", selectBean);
        pageBean = (PageBean)JSON.parseObject((String)JSON.toJSONString(map.get("pageBean")), PageBean.class);
        LOGGER.info((Object)"\u67e5\u8be2\u6240\u6709\u7684\u5546\u54c1\u5173\u6ce8");
        return new ModelAndView("jsp/goods/goods_atte").addObject("map", map).addObject("pageBean", (Object)pageBean);
    }

    @RequestMapping(value={"/findAllGoodsArrival"})
    public ModelAndView findAllGoodsArrival(PageBean pageBean, SelectBean selectBean) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("pb", this.goodsAtteService.queryByPageAndParamArrival(pageBean, selectBean));
        map.put("searchBean", selectBean);
        LOGGER.info((Object)"\u67e5\u8be2\u6240\u6709\u7684\u5546\u54c1\u5173\u6ce8");
        return new ModelAndView("jsp/goods/goods_arrival_notice").addObject("map", map);
    }

    @RequestMapping(value={"/findGoodsAtteByProductId"})
    public ModelAndView findGoodsAtteByProductId(Long productId, PageBean pageBean) {
        LOGGER.info((Object)"\u6839\u636e\u8d27\u54c1ID\u67e5\u8be2\u5173\u6ce8\u4fe1\u606f");
        return new ModelAndView("jsp/goods/product_atte").addObject("pb", (Object)this.goodsAtteService.querybyProductId(pageBean, productId));
    }

    @RequestMapping(value={"/findGoodsAtteByProductIdArrival"})
    public ModelAndView findGoodsAtteByProductIdArrival(Long productId, PageBean pageBean) {
        LOGGER.info((Object)"\u6839\u636e\u8d27\u54c1ID\u67e5\u8be2\u5173\u6ce8\u4fe1\u606f");
        return new ModelAndView("jsp/goods/product_arrival_notice").addObject("pb", (Object)this.goodsAtteService.querybyProductIdArrival(pageBean, productId));
    }

    @RequestMapping(value={"/deletegoodsatte"})
    public ModelAndView deleteGoodsAtte(Long atteId, HttpServletRequest request) {
        this.goodsAtteService.deleteAtte(atteId);
        LOGGER.info((Object)("\u5220\u9664\u5546\u54c1\u5173\u6ce8\uff0c\u5220\u9664\u7684\u5173\u6ce8ID\u4e3a\uff1a" + atteId));
        OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)((String)request.getSession().getAttribute("name")), (String)"\u5220\u9664\u5546\u54c1\u5173\u6ce8", (String)((String)request.getSession().getAttribute("operaPath") + ",\u7528\u6237\u540d\uff1a" + request.getSession().getAttribute("name")));
        return new ModelAndView((View)new RedirectView("findallgoodsatte.htm"));
    }

    @RequestMapping(value={"/batchdeletegoodsatte"})
    public ModelAndView batchDeleteGoodsAtte(Long[] atteIds, HttpServletRequest request) {
        this.goodsAtteService.batchDelAtte(atteIds);
        LOGGER.info((Object)"\u6279\u91cf\u5220\u9664\u5546\u54c1\u5173\u6ce8\u4fe1\u606f");
        OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)((String)request.getSession().getAttribute("name")), (String)"\u6279\u91cf\u5220\u9664\u5546\u54c1\u5173\u6ce8\u4fe1\u606f", (String)((String)request.getSession().getAttribute("operaPath") + ",\u7528\u6237\u540d\uff1a" + (String)request.getSession().getAttribute("name")));
        return new ModelAndView((View)new RedirectView("findallgoodsatte.htm"));
    }

    @RequestMapping(value={"/sendMailToAtteCustomer"})
    public ModelAndView sendMailToAtteCustomer(Long productId) {
        return null;
    }

    @RequestMapping(value={"/selectGoodsAtteCount"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int selectGoodsAtteCount() {
        return this.goodsAtteService.selectGoodsAtteCount();
    }
}

