/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.mobile.controller;

import com.qianjiang.mobile.bean.MobHomePage;
import com.qianjiang.mobile.service.MobHomePageService;
import com.qianjiang.util.xml.XmlElementUtil;
import com.qianjiang.util.xml.XmlUtil;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.util.Date;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@Controller
public class MobHomeGoodsController {
    private static final Logger LOGGER = Logger.getLogger(MobHomeGoodsController.class);
    private static final String SETMOBHOMEPAGE_HTM = "setMobHomePage.htm";
    private static final String PRICE = "price";
    private static final String GOODSMOD = "goodsmod";
    XmlUtil xmlUtil = new XmlUtil();
    XmlElementUtil xmlElementUtil = new XmlElementUtil();
    static final String xmlFilePath = "templete_mobile/xml/9gdemo.xml";
    @Resource(name="MobHomePageService")
    private MobHomePageService mobHomePageService;

    @RequestMapping(value={"/saveGoodsMob"})
    public ModelAndView saveGoodsMob(Long merchantId, HttpServletRequest request) {
        String rsv = request.getParameter("rsv");
        if (null != rsv && !rsv.equals(request.getSession().getAttribute("rsv"))) {
            LOGGER.info((Object)"==========\u4fdd\u5b58\u5546\u54c1\u6a21\u5757\u91cd\u590d\u63d0\u4ea4===========");
            return new ModelAndView((View)new RedirectView(SETMOBHOMEPAGE_HTM));
        }
        request.getSession().setAttribute("rsv", (Object)this.mkRSV());
        String filepath = request.getSession().getServletContext().getRealPath("/") + "/";
        Long loginUserId = (Long)request.getAttribute("loginUserId");
        MobHomePage homePage = this.mobHomePageService.selectHomePageByMerchantId(merchantId, filepath, loginUserId);
        Document document = this.xmlUtil.str2Document(homePage.getDoc());
        Element root = document.getDocumentElement();
        String goodsmodId = request.getParameter("goodsmodId");
        String style = request.getParameter("style");
        String[] href = request.getParameterValues("href");
        String[] src = request.getParameterValues("src");
        String[] name = request.getParameterValues("name");
        String[] price = request.getParameterValues(PRICE);
        if (null != goodsmodId && !"".equals(goodsmodId)) {
            this.updateGoodsElement(root, goodsmodId, style, href, src, name, price);
        } else {
            this.createGoodsElement(root, style, href, src, name, price);
        }
        homePage.setDoc(this.xmlUtil.document2Str(document));
        homePage.setTemp1(this.mkToken());
        this.mobHomePageService.updateHomePage(homePage, loginUserId);
        return new ModelAndView((View)new RedirectView(SETMOBHOMEPAGE_HTM));
    }

    private void createGoodsElement(Element root, String style, String[] href, String[] src, String[] name, String[] price) {
        Element[] goodsmods = this.xmlElementUtil.getElementsByName(root, GOODSMOD);
        int max = 0;
        for (Element el : goodsmods) {
            int temp = Integer.valueOf(el.getAttribute("id"));
            if (temp <= max) continue;
            max = temp;
        }
        Element newGoodsmod = root.getOwnerDocument().createElement(GOODSMOD);
        this.xmlElementUtil.setElementAttr(newGoodsmod, "id", String.valueOf(max + 1));
        this.xmlElementUtil.setElementAttr(newGoodsmod, "class", style);
        root.appendChild(newGoodsmod);
        for (int i = 0; i < href.length; ++i) {
            Element newLi = newGoodsmod.getOwnerDocument().createElement("li");
            Element newA = newLi.getOwnerDocument().createElement("goods_a");
            this.xmlElementUtil.setElementAttr(newA, "href", href[i]);
            this.xmlElementUtil.setElementAttr(newA, "name", name[i]);
            this.xmlElementUtil.setElementAttr(newA, PRICE, price[i]);
            Element newImg = newA.getOwnerDocument().createElement("img");
            this.xmlElementUtil.setElementAttr(newImg, "src", src[i]);
            newA.appendChild(newImg);
            newLi.appendChild(newA);
            newGoodsmod.appendChild(newLi);
        }
    }

    private void updateGoodsElement(Element root, String goodsmodId, String style, String[] href, String[] src, String[] name, String[] price) {
        Element[] goodsmods;
        Element oldGoods = null;
        for (Element el : goodsmods = this.xmlElementUtil.getElementsByName(root, GOODSMOD)) {
            Element[] as;
            if (!el.getAttribute("id").equals(goodsmodId)) continue;
            oldGoods = el;
            for (Element a : as = this.xmlElementUtil.getElementsByName(el, "li")) {
                el.removeChild(a);
            }
        }
        this.xmlElementUtil.setElementAttr(oldGoods, "class", style);
        for (int i = 0; i < href.length; ++i) {
            Element newLi = oldGoods.getOwnerDocument().createElement("li");
            Element newA = newLi.getOwnerDocument().createElement("goods_a");
            this.xmlElementUtil.setElementAttr(newA, "href", href[i]);
            this.xmlElementUtil.setElementAttr(newA, "name", name[i]);
            this.xmlElementUtil.setElementAttr(newA, PRICE, price[i]);
            Element newImg = newA.getOwnerDocument().createElement("img");
            this.xmlElementUtil.setElementAttr(newImg, "src", src[i]);
            newA.appendChild(newImg);
            newLi.appendChild(newA);
            oldGoods.appendChild(newLi);
        }
    }

    @RequestMapping(value={"/deleteGoodsMob"})
    public ModelAndView deleteGoodsMob(Long merchantId, HttpServletRequest request) {
        Element[] goodsmods;
        String rsv = request.getParameter("rsv");
        if (null != rsv && !rsv.equals(request.getSession().getAttribute("rsv"))) {
            LOGGER.info((Object)"==========\u5220\u9664\u5546\u54c1\u6a21\u5757\u91cd\u590d\u63d0\u4ea4===========");
            return new ModelAndView((View)new RedirectView(SETMOBHOMEPAGE_HTM));
        }
        request.getSession().setAttribute("rsv", (Object)this.mkRSV());
        String filepath = request.getSession().getServletContext().getRealPath("/") + "/";
        Long loginUserId = (Long)request.getAttribute("loginUserId");
        MobHomePage homePage = this.mobHomePageService.selectHomePageByMerchantId(merchantId, filepath, loginUserId);
        Document document = this.xmlUtil.str2Document(homePage.getDoc());
        String id = request.getParameter("id");
        Element root = document.getDocumentElement();
        for (Element el : goodsmods = this.xmlElementUtil.getElementsByName(root, GOODSMOD)) {
            if (!this.xmlElementUtil.getElementAttr(el, "id").equals(id)) continue;
            root.removeChild(el);
        }
        homePage.setDoc(this.xmlUtil.document2Str(document));
        homePage.setTemp1(this.mkToken());
        this.mobHomePageService.updateHomePage(homePage, loginUserId);
        return new ModelAndView((View)new RedirectView(SETMOBHOMEPAGE_HTM));
    }

    private String mkToken() {
        String tokenValue = null;
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(new Date().toString().getBytes());
            tokenValue = new BigInteger(1, md.digest()).toString(16);
            LOGGER.debug((Object)("==========token\u7801\u4e3a" + tokenValue));
        }
        catch (Exception e) {
            LOGGER.error((Object)"\u751f\u6210token\u7801\u9519\u8bef\uff1a=>", (Throwable)e);
        }
        return tokenValue;
    }

    private String mkRSV() {
        String tokenValue = null;
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(new Date().toString().getBytes());
            tokenValue = new BigInteger(1, md.digest()).toString(16);
            LOGGER.debug((Object)("==========token\u7801\u4e3a" + tokenValue));
        }
        catch (Exception e) {
            LOGGER.error((Object)"\u751f\u6210token\u7801\u9519\u8bef\uff1a=>", (Throwable)e);
        }
        return tokenValue;
    }
}

