/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.system.controller;

import com.qianjiang.system.bean.CurrencyBase;
import com.qianjiang.system.bean.CurrencyInfo;
import com.qianjiang.system.service.CurrencyInfoService;
import com.qianjiang.system.vo.CurrencyInfoVo;
import com.qianjiang.util.PageBean;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller
public class CurrencyInfoController {
    private CurrencyInfoService currencyInfoService;

    public CurrencyInfoService getCurrencyInfoService() {
        return this.currencyInfoService;
    }

    @Resource(name="CurrencyInfoService")
    public void setCurrencyInfoService(CurrencyInfoService currencyInfoService) {
        this.currencyInfoService = currencyInfoService;
    }

    @RequestMapping(value={"/queryCurrencyInfoByPageBean"})
    public ModelAndView queryCurrencyInfoByPageBean(PageBean pb) {
        return new ModelAndView("jsp/system/currencyInfoList", "pb", (Object)this.currencyInfoService.queryCurrencyInfoByPageBean(pb));
    }

    @RequestMapping(value={"/showCurrencyInfo"})
    public ModelAndView showCurrencyInfo(Long currencyInfoId) {
        CurrencyInfoVo currencyInfoVo = new CurrencyInfoVo();
        if (null != currencyInfoId) {
            currencyInfoVo = this.currencyInfoService.getCurrencyInfo(currencyInfoId);
        }
        List currencyBaseList = this.currencyInfoService.findAllCurrencyBase();
        return new ModelAndView("jsp/system/showCurrencyInfo", "currencyInfoVo", (Object)currencyInfoVo).addObject("currencyBaseList", (Object)currencyBaseList);
    }

    @RequestMapping(value={"/addCurrencyInfo"})
    public ModelAndView addCurrencyInfo(CurrencyInfo currencyInfo) {
        currencyInfo.setDelflag("0");
        currencyInfo.setCreateUserId(Long.valueOf(1L));
        currencyInfo.setCreateDate(new Date());
        this.currencyInfoService.saveCurrencyInfo(currencyInfo);
        return new ModelAndView((View)new RedirectView("queryCurrencyInfoByPageBean.htm"));
    }

    @RequestMapping(value={"/updateCurrencyInfo"})
    public ModelAndView updateCurrencyInfo(CurrencyInfo currencyInfo) {
        currencyInfo.setUpdateUserId(Long.valueOf(1L));
        currencyInfo.setUpdateDate(new Date());
        this.currencyInfoService.updateCurrencyInfo(currencyInfo);
        return new ModelAndView((View)new RedirectView("queryCurrencyInfoByPageBean.htm"));
    }

    @RequestMapping(value={"/delCurrencyInfo"})
    public void delCurrencyInfo(HttpServletRequest request, HttpServletResponse response) {
        String[] ids = request.getParameterValues("currencyInfoIds[]");
        for (int i = 0; i < ids.length; ++i) {
            Long id = Long.valueOf(ids[i]);
            this.currencyInfoService.deleteCurrencyInfo(id);
        }
    }

    @RequestMapping(value={"/queryCurrencyBaseById"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public CurrencyBase queryCurrencyBaseById(Long currencyBaseId) {
        return this.currencyInfoService.getCurrencyBaseById(currencyBaseId);
    }
}

