/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.goods.controller;

import com.qianjiang.excel.FileBean;
import com.qianjiang.goods.bean.GoodsCate;
import com.qianjiang.goods.service.GoodsCateService;
import com.qianjiang.goods.service.GoodsTypeService;
import com.qianjiang.goods.vo.GoodsCateVo;
import com.qianjiang.util.MyLogger;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class CategoryController {
    private static final MyLogger LOGGER = new MyLogger(CategoryController.class);
    @Autowired
    private GoodsCateService goodsCateService;
    @Autowired
    private GoodsTypeService goodsTypeService;

    @RequestMapping(value={"/findAllCate"})
    public ModelAndView findAllGoodsCate(HttpServletRequest req, HttpServletResponse resp) {
        ModelAndView mav = new ModelAndView();
        List goodType = new ArrayList();
        try {
            goodType = this.goodsTypeService.queryAllType();
            mav.setViewName("jsp/goods/goods_cate");
            mav.addObject("typeList", goodType);
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u521d\u59cb\u5316\u5546\u54c1\u5206\u7c7b\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return mav;
    }

    @RequestMapping(value={"/queryAllCate"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public List<GoodsCateVo> queryGoodsCateVo(HttpServletRequest request) {
        String queryType = request.getParameter("queryType");
        Date date = new Date();
        ArrayList<GoodsCateVo> list = new ArrayList();
        HashMap<String, Integer> paramMap = new HashMap<String, Integer>();
        try {
            if (!"all".equals(queryType)) {
                paramMap.put("catParentId", 0);
            }
            list = this.goodsCateService.findAllGoodsCate(paramMap);
            System.out.println("\u67e5\u8be2\u8017\u65f6:" + (new Date().getTime() - date.getTime()));
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u9012\u5f52\u67e5\u8be2\u5546\u54c1\u5206\u7c7b\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return list;
    }

    @RequestMapping(value={"/queryallgoodcateMix"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public List<GoodsCate> queryAllGoodCate(HttpServletRequest request) {
        ArrayList<GoodsCate> list = new ArrayList();
        try {
            LOGGER.info((Object)"AJAX\u67e5\u8be2\u6240\u6709\u7684\u5546\u54c1\u5206\u7c7b");
            list = this.goodsCateService.queryAllGoodCate();
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u9009\u62e9\u53c2\u52a0\u4fc3\u9500\u7684\u7c7b\u76ee\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return list;
    }

    @RequestMapping(value={"/addGoodsCate"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public Map<String, Object> addGoodsCate(HttpServletRequest req, HttpServletResponse resp, @Valid GoodsCate goodsCate, BindingResult result) {
        Map<String, Object> resultMap = new HashMap<String, Object>();
        String userName = (String)req.getSession().getAttribute("name");
        try {
            goodsCate.setCatGrade(Integer.valueOf(goodsCate.getCatGrade() + 1));
            goodsCate.setCatCreateName(userName);
            goodsCate.setCatDelflag("0");
            resultMap = this.goodsCateService.insertGoodsCate(goodsCate);
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u6dfb\u52a0\u5206\u7c7b\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return resultMap;
    }

    @RequestMapping(value={"/delGoodsCate"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public Map<String, Object> delGoodsCate(HttpServletRequest req, HttpServletResponse resp, Long catId) {
        Map<String, Object> resultMap = new HashMap<String, Object>();
        String userName = (String)req.getSession().getAttribute("name");
        try {
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            paramMap.put("catDelflag", "1");
            paramMap.put("catDelName", userName);
            paramMap.put("catId", catId);
            resultMap = this.goodsCateService.delGoodsCate(paramMap);
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u5220\u9664\u5546\u54c1\u5206\u7c7b\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return resultMap;
    }

    @RequestMapping(value={"/updateGoodsCate"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public Map<String, Object> updateGoodsCate(HttpServletRequest req, HttpServletResponse resp, GoodsCate goodsCate) {
        HashMap<String, Object> resultMap = new HashMap();
        String userName = (String)req.getSession().getAttribute("name");
        try {
            goodsCate.setCatGrade(Integer.valueOf(goodsCate.getCatGrade() + 1));
            goodsCate.setCatModifiedName(userName);
            resultMap = this.goodsCateService.updateGoodsCate(goodsCate);
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u66f4\u65b0\u5546\u54c1\u5206\u7c7b\u5931\u8d25" + e.getMessage());
        }
        return resultMap;
    }

    @RequestMapping(value={"/querySonCateByCatIdAndName"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public List<GoodsCate> querySonCateByParentIdAndName(HttpServletRequest req, HttpServletResponse resp, Long catId, String catName) {
        ArrayList<GoodsCate> list = new ArrayList();
        try {
            list = this.goodsCateService.querySonCateByParentIdAndName(catId, catName);
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u6839\u636e\u7236\u5206\u7c7b\u548c\u5206\u7c7b\u540d\u79f0\u67e5\u8be2\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return list;
    }

    @RequestMapping(value={"/checkCateIsFinal"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public Map<String, Object> checkCateIsFinal(HttpServletRequest req, HttpServletResponse resp, Long catId) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        try {
            GoodsCate goodsCate = this.goodsCateService.findGoodsCateById(catId);
            String catIsFinal = goodsCate.getCatIsFinal();
            if ("1".equals(catIsFinal)) {
                resultMap.put("result", true);
            } else {
                resultMap.put("result", false);
            }
        }
        catch (Exception e) {
            resultMap.put("result", false);
            e.printStackTrace();
            LOGGER.error("\u67e5\u8be2\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return resultMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"exportGoodsCate"})
    public void exportGoodsCate(HttpServletResponse response) {
        HSSFRow tempRow;
        GoodsCateVo cate = null;
        List cates = this.goodsCateService.queryAllCate();
        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFCellStyle style = wb.createCellStyle();
        style.setAlignment((short)2);
        HSSFSheet sheet1 = wb.createSheet("\u5546\u54c1\u5206\u7c7b\u5217\u8868");
        sheet1.createFreezePane(255, 1);
        HSSFRow headRow = sheet1.createRow(0);
        headRow.createCell(0).setCellValue("\u5206\u7c7bId");
        headRow.createCell(1).setCellValue("\u5206\u7c7b\u540d\u79f0");
        headRow.createCell(2).setCellValue("\u6240\u5c5e\u7c7b\u578b");
        headRow.createCell(3).setCellValue("\u7c7b\u578bId");
        headRow.createCell(4).setCellValue("\u5206\u7c7b\u6263\u7387");
        headRow.createCell(5).setCellValue("\u5206\u7c7b\u6392\u5e8f");
        headRow.createCell(6).setCellValue("\u5206\u7c7b\u7ea7\u522b");
        headRow.createCell(7).setCellValue("\u7236\u7c7bid");
        if (null != cates && !cates.isEmpty()) {
            for (int i = 0; i < cates.size(); ++i) {
                cate = (GoodsCateVo)cates.get(i);
                tempRow = sheet1.createRow(1 + i);
                tempRow.createCell(0).setCellValue((double)cate.getCatId().longValue());
                tempRow.createCell(1).setCellValue(cate.getCatName());
                tempRow.createCell(2).setCellValue(cate.getTypeName());
                tempRow.createCell(3).setCellValue(cate.getTypeId() == null ? "" : cate.getTypeId() + "");
                tempRow.createCell(4).setCellValue(cate.getCatRate().doubleValue());
                tempRow.createCell(5).setCellValue(cate.getCatSort() == null ? "" : cate.getCatSort() + "");
                tempRow.createCell(6).setCellValue(cate.getCatGrade() == null ? "" : cate.getCatGrade() + "");
                tempRow.createCell(7).setCellValue(cate.getCatParentId() == null ? "" : cate.getCatParentId() + "");
            }
        }
        response.setContentType("application/vnd.ms-excel");
        response.setHeader("Content-disposition", "attachment;filename=" + URLEncoder.encode("\u5546\u54c1\u5206\u7c7b\u5907\u4efd.xls"));
        try {
            ServletOutputStream ouputStream = response.getOutputStream();
            wb.write((OutputStream)ouputStream);
            ouputStream.flush();
            ouputStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            LOGGER.error("\u5bfc\u51fa\u5546\u54c1\u5206\u7c7b\u9519\u8bef" + e);
        }
        finally {
            cate = null;
            wb = null;
            Object ouputStream = null;
            style = null;
            tempRow = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"exportGoodsCateTemp"})
    public void exportGoodsCateTemp(HttpServletResponse response) {
        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFCellStyle style = wb.createCellStyle();
        style.setAlignment((short)2);
        HSSFSheet sheet1 = wb.createSheet("\u5206\u7c7b\u5bfc\u5165\u6a21\u677f");
        sheet1.createFreezePane(255, 1);
        HSSFRow headRow = sheet1.createRow(0);
        headRow.createCell(0).setCellValue("\u5206\u7c7bId\uff08\u5fc5\u586b\uff09");
        headRow.createCell(1).setCellValue("\u5206\u7c7b\u540d\u79f0\uff08\u5fc5\u586b\uff09");
        headRow.createCell(2).setCellValue("\u7c7b\u578bId\uff08\u5fc5\u586b\uff09");
        headRow.createCell(3).setCellValue("\u5206\u7c7b\u6263\u7387\uff08\u5fc5\u586b\uff09");
        headRow.createCell(4).setCellValue("\u5206\u7c7b\u6392\u5e8f\uff08\u5fc5\u586b\uff09");
        headRow.createCell(5).setCellValue("\u5206\u7c7b\u7ea7\u522b\uff08\u5fc5\u586b\uff09");
        headRow.createCell(6).setCellValue("\u7236\u7c7bid\uff08\u5fc5\u586b\uff09");
        response.setContentType("application/vnd.ms-excel");
        response.setHeader("Content-disposition", "attachment;filename=" + URLEncoder.encode("\u5546\u54c1\u5206\u7c7b\u6a21\u677f.xls"));
        try {
            ServletOutputStream ouputStream = response.getOutputStream();
            wb.write((OutputStream)ouputStream);
            ouputStream.flush();
            ouputStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            LOGGER.error("\u5bfc\u51fa\u5546\u54c1\u5206\u7c7b\u6a21\u677f" + e);
        }
        finally {
            wb = null;
            Object ouputStream = null;
            style = null;
        }
    }

    @RequestMapping(value={"/importGoodsCate"})
    public void importGoodsCate(HttpServletRequest request, HttpServletResponse response, Long goodsCateId, MultipartHttpServletRequest multiRequest) {
        String result = "200";
        try {
            MultipartFile file = multiRequest.getFile("importExcel");
            FileBean fileBean = new FileBean();
            fileBean.setOriginalFilename(file.getOriginalFilename());
            fileBean.setFileb(file.getBytes());
            result = this.goodsCateService.importGoodsCateByExcel(fileBean);
            PrintWriter out = response.getWriter();
            out.append("<script>parent.import_callback('" + result + "');</script>");
            out.flush();
        }
        catch (Exception e) {
            LOGGER.error("" + e);
            result = null;
        }
    }
}

