/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.auth.controller;

import com.qianjiang.auth.bean.Auth;
import com.qianjiang.auth.oauth.AbstractOAuth;
import com.qianjiang.auth.oauth.OAuthFactory;
import com.qianjiang.auth.service.AuthService;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller
public class AuthController {
    @Resource(name="AuthService")
    private AuthService authService;

    @RequestMapping(value={"/auth"}, params={"id"})
    public ModelAndView oauth(@RequestParam(value="id") String provider) {
        if (null == provider || "".equals(provider)) {
            return null;
        }
        Auth auth = this.authService.findAuthByName(provider);
        AbstractOAuth oauth = OAuthFactory.getInstance().buildOAuth(auth);
        if (oauth != null) {
            return new ModelAndView((View)new RedirectView(oauth.getAuthorizeUrl()));
        }
        return null;
    }

    @RequestMapping(value={"/auth/callback"})
    public ModelAndView callback(String id, String code, HttpServletRequest request, HttpServletResponse response) {
        if (null == id || "".equals(id)) {
            return null;
        }
        Auth auth = this.authService.findAuthByName(id);
        AbstractOAuth oauth = OAuthFactory.getInstance().buildOAuth(auth);
        if (oauth != null) {
            Map userinfo = oauth.getUserInfoByCode(code);
            ModelAndView view = new ModelAndView("../jsp/auth/auth");
            view.addObject("userinfo", (Object)userinfo);
            return view;
        }
        return null;
    }
}

