/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.hotsearch.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.qianjiang.hotsearch.bean.HotSearch;
import com.qianjiang.hotsearch.service.HotSearchService;
import com.qianjiang.operlog.util.IPAddress;
import com.qianjiang.operlog.util.OperaLogUtil;
import com.qianjiang.util.MyLogger;
import com.qianjiang.util.PageBean;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller
public class HotSearchController {
    private static final MyLogger LOGGER = new MyLogger(HotSearchController.class);
    public static final String NAME = "name";
    public static final String OPERAPATH = "operaPath";
    private static final String ERRORVIEW = "jsp/hotsearch/error";
    private static final String LOGGERINFO1 = ",\u7528\u6237\u540d:";
    private static final String QUERYHOTPAGESIZE_TEMPID = "queryHotPageSize.htm?tempId=";
    private static final String QUERYHOTPAGESIZE_CHANNELID = "queryHotPageSize.htm?channelId=";
    @Resource
    private HotSearchService hotSearchService;

    @RequestMapping(value={"/queryHotPageSize"})
    public ModelAndView queryHotPageSize(PageBean pb, Long channelId, Long tempId, String keyword) {
        ModelAndView mv = new ModelAndView("jsp/hotsearch/hot_search");
        mv.addObject("pb", (Object)this.hotSearchService.queryHotBySelectivePageSize(keyword, tempId, channelId, pb));
        mv.addObject("tempId", (Object)tempId);
        mv.addObject("channelId", (Object)channelId);
        return mv;
    }

    @RequestMapping(value={"/queryhotpagesizeajax"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public Map<String, Object> queryHotPageSizeAjax(PageBean pb, Long channelId, Long tempId, String keyword) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("pb", this.hotSearchService.queryHotBySelectivePageSize(keyword, tempId, channelId, pb));
        return map;
    }

    @RequestMapping(value={"/createhotselectiveajax"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int createHotSelectiveAjax(@Valid HotSearch hotSearch, BindingResult bindingResult, HttpServletRequest request) {
        if (bindingResult.hasErrors()) {
            return 0;
        }
        int count = this.hotSearchService.addHotSearchSelective(hotSearch);
        if (count > 0) {
            String customerName = (String)request.getSession().getAttribute(NAME);
            OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u6dfb\u52a0\u70ed\u95e8\u641c\u7d22", (String)(request.getSession().getAttribute(OPERAPATH) + LOGGERINFO1 + customerName));
        }
        return count;
    }

    @RequestMapping(value={"/createHotSelective"})
    public ModelAndView createHotSelective(@Valid HotSearch hotSearch, BindingResult bindingResult, HttpServletRequest request) {
        if (bindingResult.hasErrors()) {
            if (null == hotSearch.getChannelid()) {
                return new ModelAndView((View)new RedirectView(QUERYHOTPAGESIZE_TEMPID + hotSearch.getTempid() + "&CSRFToken=" + request.getParameter("CSRFToken")));
            }
            return new ModelAndView((View)new RedirectView(QUERYHOTPAGESIZE_CHANNELID + hotSearch.getChannelid() + "&CSRFToken=" + request.getParameter("CSRFToken")));
        }
        int count = this.hotSearchService.addHotSearchSelective(hotSearch);
        if (count > 0) {
            String customerName = (String)request.getSession().getAttribute(NAME);
            OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u6dfb\u52a0\u70ed\u95e8\u641c\u7d22", (String)(request.getSession().getAttribute(OPERAPATH) + LOGGERINFO1 + customerName));
            if (null == hotSearch.getChannelid()) {
                return new ModelAndView((View)new RedirectView(QUERYHOTPAGESIZE_TEMPID + hotSearch.getTempid() + "&CSRFToken=" + request.getParameter("CSRFToken")));
            }
            return new ModelAndView((View)new RedirectView(QUERYHOTPAGESIZE_CHANNELID + hotSearch.getChannelid() + "&CSRFToken=" + request.getParameter("CSRFToken")));
        }
        return new ModelAndView(ERRORVIEW);
    }

    @RequestMapping(value={"/modifyHot"})
    public ModelAndView modifyHotSelective(@Valid HotSearch hotSearch, BindingResult bindingResult, HttpServletRequest request) {
        if (bindingResult.hasErrors()) {
            if (null == hotSearch.getChannelid()) {
                return new ModelAndView((View)new RedirectView(QUERYHOTPAGESIZE_TEMPID + hotSearch.getTempid() + "&CSRFToken=" + request.getParameter("CSRFToken")));
            }
            return new ModelAndView((View)new RedirectView(QUERYHOTPAGESIZE_CHANNELID + hotSearch.getChannelid() + "&CSRFToken=" + request.getParameter("CSRFToken")));
        }
        int count = this.hotSearchService.modifyHostSearchSelectiveById(hotSearch);
        if (count > 0) {
            String customerName = (String)request.getSession().getAttribute(NAME);
            OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u4fee\u6539\u70ed\u95e8\u641c\u7d22", (String)(request.getSession().getAttribute(OPERAPATH) + LOGGERINFO1 + customerName));
            if (null == hotSearch.getChannelid()) {
                return new ModelAndView((View)new RedirectView(QUERYHOTPAGESIZE_TEMPID + hotSearch.getTempid() + "&CSRFToken=" + request.getParameter("CSRFToken")));
            }
            return new ModelAndView((View)new RedirectView(QUERYHOTPAGESIZE_CHANNELID + hotSearch.getChannelid() + "&CSRFToken=" + request.getParameter("CSRFToken")));
        }
        return new ModelAndView(ERRORVIEW);
    }

    @RequestMapping(value={"/modifyhotajax"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int modifyHotSelectiveAjax(@Valid HotSearch hotSearch, BindingResult bindingResult, HttpServletRequest request) {
        if (bindingResult.hasErrors()) {
            return 0;
        }
        int count = this.hotSearchService.modifyHostSearchSelectiveById(hotSearch);
        if (count > 0) {
            String customerName = (String)request.getSession().getAttribute(NAME);
            OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u4fee\u6539\u70ed\u95e8\u641c\u7d22", (String)(request.getSession().getAttribute(OPERAPATH) + LOGGERINFO1 + customerName));
        }
        return count;
    }

    @RequestMapping(value={"/removeHotByKey"})
    public ModelAndView removeHotByKey(Long hotSearchId, Long tempId, Long channelId, HttpServletRequest request) {
        int count = this.hotSearchService.removeHotSearchById(hotSearchId);
        if (count > 0) {
            String customerName = (String)request.getSession().getAttribute(NAME);
            OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u5220\u9664\u70ed\u95e8\u641c\u7d22", (String)(request.getSession().getAttribute(OPERAPATH) + LOGGERINFO1 + customerName));
            if (null == channelId) {
                return new ModelAndView((View)new RedirectView(QUERYHOTPAGESIZE_TEMPID + tempId + "&CSRFToken=" + request.getParameter("CSRFToken")));
            }
            return new ModelAndView((View)new RedirectView(QUERYHOTPAGESIZE_CHANNELID + channelId + "&CSRFToken=" + request.getParameter("CSRFToken")));
        }
        return new ModelAndView(ERRORVIEW);
    }

    @RequestMapping(value={"/removehotbykeyajax"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int removeHotByKeyAjax(Long hotSearchId, HttpServletRequest request) {
        int count = this.hotSearchService.removeHotSearchById(hotSearchId);
        if (count > 0) {
            String customerName = (String)request.getSession().getAttribute(NAME);
            OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u5220\u9664\u70ed\u95e8\u641c\u7d22", (String)(request.getSession().getAttribute(OPERAPATH) + LOGGERINFO1 + customerName));
        }
        return count;
    }

    @RequestMapping(value={"/batchDelHot"})
    public ModelAndView batchRemoveHot(Long[] hots, HttpServletRequest request) {
        int count = this.hotSearchService.batchDelHotSearch(hots);
        if (count > 0) {
            String customerName = (String)request.getSession().getAttribute(NAME);
            OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u6279\u91cf\u5220\u9664\u70ed\u95e8\u641c\u7d22", (String)(request.getSession().getAttribute(OPERAPATH) + LOGGERINFO1 + customerName));
            return new ModelAndView((View)new RedirectView("queryHotPageSize.htm?CSRFToken=" + request.getParameter("CSRFToken")));
        }
        return new ModelAndView(ERRORVIEW);
    }

    @RequestMapping(value={"/batchdelhotajax"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int batchRemoveHotAjax(Long[] hots, HttpServletRequest request) {
        int count = this.hotSearchService.batchDelHotSearch(hots);
        if (count > 0) {
            String customerName = (String)request.getSession().getAttribute(NAME);
            OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u6279\u91cf\u5220\u9664\u70ed\u95e8\u641c\u7d22", (String)(request.getSession().getAttribute(OPERAPATH) + LOGGERINFO1 + customerName));
        }
        return count;
    }

    @RequestMapping(value={"/servehotselectiveajax"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int servehotselectiveajax(HttpServletRequest req, HttpServletResponse resp, @RequestBody JSONObject obj) {
        int i;
        int count = 0;
        int countAddHotSearch = 0;
        int countEditHotSearch = 0;
        LOGGER.info((Object)("hot search data:" + obj.toJSONString()));
        String data = obj.toJSONString();
        JSONObject json = JSON.parseObject((String)data);
        String createArr = json.getString("createArr");
        String modifyArr = json.getString("modifyArr");
        if (StringUtils.isNotEmpty((String)createArr)) {
            JSONArray createArray = JSONArray.parseArray((String)createArr);
            for (i = 0; i < createArray.size(); ++i) {
                Long tempId = JSONObject.parseObject((String)JSONObject.toJSONString((Object)createArray.get(i))).getLong("tempId");
                String keyword = JSONObject.parseObject((String)JSONObject.toJSONString((Object)createArray.get(i))).getString("keyword");
                Integer sort = JSONObject.parseObject((String)JSONObject.toJSONString((Object)createArray.get(i))).getInteger("sort");
                HotSearch hotSearch = new HotSearch();
                hotSearch.setTempid(tempId);
                hotSearch.setKeyword(keyword);
                hotSearch.setSort(sort);
                hotSearch.setCreateDate(new Date());
                hotSearch.setDelFlag("0");
                countAddHotSearch = this.hotSearchService.addHotSearchSelective(hotSearch);
            }
        }
        if (StringUtils.isNotEmpty((String)modifyArr)) {
            JSONArray modifyArray = JSONArray.parseArray((String)modifyArr);
            for (i = 0; i < modifyArray.size(); ++i) {
                Long hotSearchId = JSONObject.parseObject((String)JSONObject.toJSONString((Object)modifyArray.get(i))).getLong("id");
                Long tempId = JSONObject.parseObject((String)JSONObject.toJSONString((Object)modifyArray.get(i))).getLong("tempId");
                String keyword = JSONObject.parseObject((String)JSONObject.toJSONString((Object)modifyArray.get(i))).getString("keyword");
                Integer sort = JSONObject.parseObject((String)JSONObject.toJSONString((Object)modifyArray.get(i))).getInteger("sort");
                HotSearch hotSearch = new HotSearch();
                hotSearch.setHotSearchId(hotSearchId);
                hotSearch.setTempid(tempId);
                hotSearch.setKeyword(keyword);
                hotSearch.setSort(sort);
                countEditHotSearch = this.hotSearchService.modifyHostSearchSelectiveById(hotSearch);
            }
        }
        if (countAddHotSearch > 0 || countEditHotSearch > 0) {
            count = 1;
        }
        return count;
    }
}

