/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.manager.controller;

import com.qianjiang.manager.bean.Authority;
import com.qianjiang.manager.bean.AuthorityPage;
import com.qianjiang.manager.bean.ManagerAuthority;
import com.qianjiang.manager.service.AuthorityServiceInterface;
import com.qianjiang.util.MyLogger;
import com.qianjiang.util.PageBean;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller(value="authorityController")
public class AuthorityController {
    private static final MyLogger LOGGER = new MyLogger(AuthorityController.class);
    private static final String LOGINUSERID = "loginUserId";
    private static final String INITAUTHORITY_HTM = "initAuthority.htm";
    private AuthorityServiceInterface authorityServiceInterface;

    @RequestMapping(value={"/queryAllAuthority"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public List<Authority> queryAllAuthority(HttpServletRequest request) {
        Long createId = null;
        if ((Integer)request.getSession().getAttribute("managerFlag") != 1) {
            createId = (Long)request.getSession().getAttribute(LOGINUSERID);
        }
        return this.authorityServiceInterface.queryAuthoerityList(createId);
    }

    @RequestMapping(value={"/queryAuthorByManagerId"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public ManagerAuthority queryAuthorByManagerId(Long mid) {
        return this.authorityServiceInterface.queryAuthorByManagerId(mid);
    }

    @RequestMapping(value={"/initAuthority"})
    public ModelAndView initAuthority(PageBean pageBean, HttpServletRequest request, Authority authority) {
        Integer flag = (Integer)request.getSession().getAttribute("managerFlag");
        Long createId = null;
        if (flag != null && flag != 1) {
            createId = (Long)request.getSession().getAttribute(LOGINUSERID);
        }
        pageBean.setUrl(INITAUTHORITY_HTM);
        return new ModelAndView("jsp/core/manager/authoritylist").addObject("pageBean", (Object)this.authorityServiceInterface.queryAuthoerityList(authority, pageBean, createId));
    }

    @RequestMapping(value={"/checkManagerExist"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public Authority checkManagerExist(String username) {
        if (null != username) {
            LOGGER.info((Object)("\u9a8c\u8bc1\u6743\u9650\u540d\u79f0\u3010" + username + "\u3011\u662f\u5426\u5b58\u5728\uff01"));
        }
        return this.authorityServiceInterface.checkManagerExist(username);
    }

    @RequestMapping(value={"/queryAuthority"})
    public ModelAndView queryAuthority(Authority authority, PageBean pageBean, String[] attr) throws UnsupportedEncodingException {
        pageBean.setUrl("queryAuthority.htm");
        return new ModelAndView("jsp/core/manager/authoritylist").addObject("pageBean", (Object)this.authorityServiceInterface.queryAuthoerityList(authority, pageBean, null)).addObject("authority", (Object)authority).addObject("attr", (Object)attr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/deleteAuthority"})
    public ModelAndView deleteAuthority(HttpServletRequest request, HttpServletResponse response, Long authorid) {
        PrintWriter pr = null;
        try {
            pr = response.getWriter();
            if (authorid != null) {
                String[] strArray = new String[]{authorid + ""};
                pr.print(this.authorityServiceInterface.deleteAuthority(strArray));
            } else {
                pr.print(this.authorityServiceInterface.deleteAuthority(request.getParameterValues("parameterIds[]")));
            }
        }
        catch (IOException e) {
            LOGGER.error("", (Throwable)e);
            pr = null;
        }
        finally {
            pr = null;
        }
        return null;
    }

    @RequestMapping(value={"/deleteAllAuthority"})
    public ModelAndView deleteAllAuthority(HttpServletRequest request, HttpServletResponse response) {
        this.authorityServiceInterface.deleteAuthority(request.getParameterValues("authorid"));
        return new ModelAndView((View)new RedirectView(INITAUTHORITY_HTM));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/addAuthority"})
    public ModelAndView addAuthority(HttpServletRequest request, HttpServletResponse response, Authority authority, String catId) {
        PrintWriter pr = null;
        Long createId = (Long)request.getSession().getAttribute(LOGINUSERID);
        try {
            pr = response.getWriter();
            pr.print(this.authorityServiceInterface.insertAuthorities(catId, authority, createId));
        }
        catch (IOException e) {
            LOGGER.error("\u6dfb\u52a0\u6743\u9650\u9519\u8bef\uff1a" + e);
        }
        finally {
            pr = null;
        }
        return new ModelAndView((View)new RedirectView(INITAUTHORITY_HTM));
    }

    @RequestMapping(value={"/updateAuthority"})
    public ModelAndView updateAuthority(Authority authority, String catId) {
        if (null != authority.getDesignation()) {
            LOGGER.info((Object)("\u4fee\u6539\u6743\u9650,\u6743\u9650\u540d\u79f0\u4e3a\uff1a" + authority.getDesignation()));
        }
        this.authorityServiceInterface.deleteAuthorityPage(authority.getId());
        authority.setFlag("0");
        this.authorityServiceInterface.mergeAuthority(catId, authority);
        return new ModelAndView((View)new RedirectView(INITAUTHORITY_HTM));
    }

    @RequestMapping(value={"/queryAuthorityById"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public Authority queryAuthorityById(Long id) {
        Authority authority = this.authorityServiceInterface.queryAuthorId(id);
        if (null != authority.getDesignation()) {
            LOGGER.info((Object)("\u6839\u636e\u6743\u9650\u7f16\u53f7\u67e5\u627e\u6743\u9650,\u6743\u9650\u540d\u79f0\u4e3a\uff1a" + authority.getDesignation()));
        }
        return authority;
    }

    @RequestMapping(value={"/queryAuthorityByAId"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public List<AuthorityPage> queryAuthorityByAId(Long id) {
        return this.authorityServiceInterface.queryAuthorityByAId(id);
    }

    @RequestMapping(value={"/checkauthexist"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public Long checkAuthExist(String authName) {
        if (null != authName) {
            LOGGER.info((Object)("\u9a8c\u8bc1\u6743\u9650\u540d\u79f0\u3010" + authName + "\u3011\u662f\u5426\u5b58\u5728\uff01"));
        }
        return this.authorityServiceInterface.checkAuthExist(authName);
    }

    @RequestMapping(value={"/isauthcandelete"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int isAuthCanDelete(String[] authorid) {
        return this.authorityServiceInterface.isAuthCanDelete(authorid);
    }

    public AuthorityServiceInterface getAuthorityServiceInterface() {
        return this.authorityServiceInterface;
    }

    @Resource(name="authorityService")
    public void setAuthorityServiceInterface(AuthorityServiceInterface authorityServiceInterface) {
        this.authorityServiceInterface = authorityServiceInterface;
    }
}

