/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.channel.controller;

import com.qianjiang.channel.bean.ChannelStorey;
import com.qianjiang.channel.bean.ChannelStoreyGoods;
import com.qianjiang.channel.bean.ChannelStoreyTag;
import com.qianjiang.channel.service.ChannelStoreyGoodsService;
import com.qianjiang.channel.service.ChannelStoreyService;
import com.qianjiang.channel.service.ChannelStoreyTagService;
import com.qianjiang.channel.service.SysChannelService;
import com.qianjiang.operlog.util.IPAddress;
import com.qianjiang.operlog.util.OperaLogUtil;
import com.qianjiang.util.MyLogger;
import com.qianjiang.util.PageBean;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller
public class ChannelStoreyTagGoodsController {
    private static final MyLogger LOGGER = new MyLogger(ChannelStoreyTagGoodsController.class);
    private static final String LOGINUSERID = "loginUserId";
    public static final String NAME = "name";
    public static final String OPERAPATH = "operaPath";
    public static final String QUERYSTOREYTAGGOODSBYPAGEBEAN_HTM = "queryStoreyTagGoodsByPageBean.htm?storeyTagId=";
    public static final String LOGGERINFO1 = ",\u7528\u6237\u540d:";
    @Resource(name="SysChannelService")
    private SysChannelService channelService;
    @Resource(name="ChannelStoreyService")
    private ChannelStoreyService storeyService;
    @Resource(name="ChannelStoreyTagService")
    private ChannelStoreyTagService storeyTagService;
    @Resource(name="ChannelStoreyGoodsService")
    private ChannelStoreyGoodsService storeyGoodsService;

    @RequestMapping(value={"/queryStoreyTagGoodsByPageBean"})
    public ModelAndView queryStoreyTagGoodsByPageBean(PageBean pb, Long storeyTagId) {
        ChannelStoreyTag storeyTag = this.storeyTagService.getChannelStoreyTagById(storeyTagId);
        ChannelStorey channelStorey = this.storeyService.getChannelStoreyById(storeyTag.getStoreyId());
        return new ModelAndView("jsp/channel/channel_storey_tag_goods_list", "pb", (Object)this.storeyGoodsService.selectchannelStoreyGoodsByParam(pb, null, storeyTagId, null)).addObject("storeyTag", (Object)storeyTag).addObject("channelStorey", (Object)channelStorey);
    }

    @RequestMapping(value={"/showStoreyTagGoods"})
    public ModelAndView showStoreyTagGoods(Long storeyGoodsproductId, Long storeyTagId) {
        ModelAndView mav = new ModelAndView();
        ChannelStoreyTag storeyTag = this.storeyTagService.getChannelStoreyTagById(storeyTagId);
        ChannelStorey channelStorey = this.storeyService.getChannelStoreyById(storeyTag.getStoreyId());
        if (null != storeyGoodsproductId) {
            ChannelStoreyGoods channelStoreyGoods = this.storeyGoodsService.getChannelStoreyGoodsById(storeyGoodsproductId);
            mav.addObject("channelStoreyGoods", (Object)channelStoreyGoods);
        }
        mav.addObject("storeyTag", (Object)storeyTag);
        mav.addObject("channelStorey", (Object)channelStorey);
        mav.setViewName("jsp/channel/showChannelStoreyTagGoods");
        return mav;
    }

    @RequestMapping(value={"/createStoreyTagGoods"})
    public ModelAndView createStoreyTagGoods(HttpServletRequest request, HttpServletResponse response, @Valid ChannelStoreyGoods channelStoreyGoods, BindingResult bindingResult, Long storeyTagId) {
        if (bindingResult.hasErrors()) {
            return new ModelAndView((View)new RedirectView(QUERYSTOREYTAGGOODSBYPAGEBEAN_HTM + storeyTagId + "&CSRFToken=" + request.getParameter("CSRFToken")));
        }
        Long loginUserId = (Long)request.getSession().getAttribute(LOGINUSERID);
        ModelAndView mav = new ModelAndView();
        try {
            if (null == loginUserId) {
                loginUserId = 1L;
            }
            channelStoreyGoods.setCreateUserId(loginUserId);
            int n = this.storeyGoodsService.saveChannelStoreyGoods(channelStoreyGoods);
            if (n > 0) {
                String customerName = (String)request.getSession().getAttribute(NAME);
                OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u6dfb\u52a0\u697c\u5c42\u6807\u7b7e\u5546\u54c1", (String)(request.getSession().getAttribute(OPERAPATH) + LOGGERINFO1 + customerName));
                LOGGER.debug("\u4fdd\u5b58\u9891\u9053\u697c\u5c42\u5546\u54c1\u6210\u529f\uff01");
            } else {
                LOGGER.debug("\u4fdd\u5b58\u9891\u9053\u697c\u5c42\u5546\u54c1\u5931\u8d25\uff01");
            }
        }
        catch (Exception e) {
            LOGGER.error("\u4fdd\u5b58\u9891\u9053\u697c\u5c42\u5546\u54c1\u5f02\u5e38\uff01", (Throwable)e);
        }
        mav.setView((View)new RedirectView(QUERYSTOREYTAGGOODSBYPAGEBEAN_HTM + storeyTagId + "&CSRFToken=" + request.getParameter("CSRFToken")));
        return mav;
    }

    @RequestMapping(value={"/updateStoreyTagGoods"})
    public ModelAndView updateStoreyTagGoods(HttpServletRequest request, HttpServletResponse response, @Valid ChannelStoreyGoods channelStoreyGoods, BindingResult bindingResult, Long storeyTagId) {
        if (bindingResult.hasErrors()) {
            return new ModelAndView((View)new RedirectView(QUERYSTOREYTAGGOODSBYPAGEBEAN_HTM + storeyTagId + "&CSRFToken=" + request.getParameter("CSRFToken")));
        }
        Long loginUserId = (Long)request.getSession().getAttribute(LOGINUSERID);
        ModelAndView mav = new ModelAndView();
        try {
            if (null == loginUserId) {
                loginUserId = 1L;
            }
            channelStoreyGoods.setUpdateUserId(loginUserId);
            int n = this.storeyGoodsService.updateChannelStoreyGoods(channelStoreyGoods);
            if (n > 0) {
                String customerName = (String)request.getSession().getAttribute(NAME);
                OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u4fee\u6539\u697c\u5c42\u6807\u7b7e\u5546\u54c1", (String)(request.getSession().getAttribute(OPERAPATH) + LOGGERINFO1 + customerName));
                LOGGER.debug("\u4fdd\u5b58\u9891\u9053\u697c\u5c42\u5546\u54c1\u6210\u529f\uff01");
            } else {
                LOGGER.debug("\u4fdd\u5b58\u9891\u9053\u697c\u5c42\u5546\u54c1\u5931\u8d25\uff01");
            }
        }
        catch (Exception e) {
            LOGGER.error("\u4fdd\u5b58\u9891\u9053\u697c\u5c42\u5546\u54c1\u5f02\u5e38\uff01", (Throwable)e);
        }
        mav.setView((View)new RedirectView(QUERYSTOREYTAGGOODSBYPAGEBEAN_HTM + storeyTagId + "&CSRFToken=" + request.getParameter("CSRFToken")));
        return mav;
    }

    @RequestMapping(value={"/deleteStoreyTagGoods"})
    public void deleteStoreyTagGoods(HttpServletRequest request, HttpServletResponse response) {
        Long loginUserId = (Long)request.getSession().getAttribute(LOGINUSERID);
        if (null == loginUserId) {
            loginUserId = 1L;
        }
        String[] storeyGoodsIds = request.getParameterValues("storeyGoodsIds[]");
        for (int i = 0; i < storeyGoodsIds.length; ++i) {
            this.storeyGoodsService.deleteChannelStoreyGoods(Long.valueOf(storeyGoodsIds[i]), loginUserId);
        }
        String customerName = (String)request.getSession().getAttribute(NAME);
        OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u5220\u9664\u697c\u5c42\u6807\u7b7e\u5546\u54c1", (String)(request.getSession().getAttribute(OPERAPATH) + LOGGERINFO1 + customerName));
    }
}

